<?php

namespace PHPMaker2024\fibre;

// Page object
$WoolImportCalculator1Search = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { wool_import_calculator1: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fwool_import_calculator1search, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fwool_import_calculator1search")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["rid", [ew.Validators.integer], fields.rid.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["godown_arrival_date", [ew.Validators.datetime(fields.godown_arrival_date.clientFormatPattern)], fields.godown_arrival_date.isInvalid],
            ["net_weight", [ew.Validators.float], fields.net_weight.isInvalid],
            ["containers", [ew.Validators.float], fields.containers.isInvalid],
            ["packets", [ew.Validators.integer], fields.packets.isInvalid],
            ["purchase_amount", [ew.Validators.float], fields.purchase_amount.isInvalid],
            ["purchase_custom_duty", [], fields.purchase_custom_duty.isInvalid],
            ["s_custom_duty", [], fields.s_custom_duty.isInvalid],
            ["port_clearing_charge", [], fields.port_clearing_charge.isInvalid],
            ["s_port_clearing_charge", [], fields.s_port_clearing_charge.isInvalid],
            ["cha_commission", [], fields.cha_commission.isInvalid],
            ["s_cha_commission", [], fields.s_cha_commission.isInvalid],
            ["transportation_charges", [], fields.transportation_charges.isInvalid],
            ["s_transportation_charges", [], fields.s_transportation_charges.isInvalid],
            ["unloading_charges", [], fields.unloading_charges.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fwool_import_calculator1search" id="fwool_import_calculator1search" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="wool_import_calculator1">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label for="x_rid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_rid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rid->getInputTextType() ?>" name="x_rid" id="x_rid" data-table="wool_import_calculator1" data-field="x_rid" value="<?= $Page->rid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="wool_import_calculator1" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="300" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown_arrival_date->Visible) { // godown_arrival_date ?>
    <div id="r_godown_arrival_date" class="row"<?= $Page->godown_arrival_date->rowAttributes() ?>>
        <label for="x_godown_arrival_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_godown_arrival_date"><?= $Page->godown_arrival_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown_arrival_date" id="z_godown_arrival_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown_arrival_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_godown_arrival_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->godown_arrival_date->getInputTextType() ?>" name="x_godown_arrival_date" id="x_godown_arrival_date" data-table="wool_import_calculator1" data-field="x_godown_arrival_date" value="<?= $Page->godown_arrival_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->godown_arrival_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->godown_arrival_date->formatPattern()) ?>"<?= $Page->godown_arrival_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->godown_arrival_date->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->net_weight->Visible) { // net_weight ?>
    <div id="r_net_weight" class="row"<?= $Page->net_weight->rowAttributes() ?>>
        <label for="x_net_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_net_weight"><?= $Page->net_weight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_net_weight" id="z_net_weight" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->net_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_net_weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->net_weight->getInputTextType() ?>" name="x_net_weight" id="x_net_weight" data-table="wool_import_calculator1" data-field="x_net_weight" value="<?= $Page->net_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->net_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->net_weight->formatPattern()) ?>"<?= $Page->net_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->net_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->containers->Visible) { // containers ?>
    <div id="r_containers" class="row"<?= $Page->containers->rowAttributes() ?>>
        <label for="x_containers" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_containers"><?= $Page->containers->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_containers" id="z_containers" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->containers->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_containers" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->containers->getInputTextType() ?>" name="x_containers" id="x_containers" data-table="wool_import_calculator1" data-field="x_containers" value="<?= $Page->containers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->containers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->containers->formatPattern()) ?>"<?= $Page->containers->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->containers->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_packets"><?= $Page->packets->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packets" id="z_packets" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="wool_import_calculator1" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->purchase_amount->Visible) { // purchase_amount ?>
    <div id="r_purchase_amount" class="row"<?= $Page->purchase_amount->rowAttributes() ?>>
        <label for="x_purchase_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_purchase_amount"><?= $Page->purchase_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_purchase_amount" id="z_purchase_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->purchase_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_purchase_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->purchase_amount->getInputTextType() ?>" name="x_purchase_amount" id="x_purchase_amount" data-table="wool_import_calculator1" data-field="x_purchase_amount" value="<?= $Page->purchase_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->purchase_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->purchase_amount->formatPattern()) ?>"<?= $Page->purchase_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->purchase_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->purchase_custom_duty->Visible) { // purchase_custom_duty ?>
    <div id="r_purchase_custom_duty" class="row"<?= $Page->purchase_custom_duty->rowAttributes() ?>>
        <label for="x_purchase_custom_duty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_purchase_custom_duty"><?= $Page->purchase_custom_duty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_purchase_custom_duty" id="z_purchase_custom_duty" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->purchase_custom_duty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_purchase_custom_duty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->purchase_custom_duty->getInputTextType() ?>" name="x_purchase_custom_duty" id="x_purchase_custom_duty" data-table="wool_import_calculator1" data-field="x_purchase_custom_duty" value="<?= $Page->purchase_custom_duty->EditValue ?>" size="30" maxlength="26" placeholder="<?= HtmlEncode($Page->purchase_custom_duty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->purchase_custom_duty->formatPattern()) ?>"<?= $Page->purchase_custom_duty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->purchase_custom_duty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_custom_duty->Visible) { // s_custom_duty ?>
    <div id="r_s_custom_duty" class="row"<?= $Page->s_custom_duty->rowAttributes() ?>>
        <label for="x_s_custom_duty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_s_custom_duty"><?= $Page->s_custom_duty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_s_custom_duty" id="z_s_custom_duty" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_custom_duty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_s_custom_duty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->s_custom_duty->getInputTextType() ?>" name="x_s_custom_duty" id="x_s_custom_duty" data-table="wool_import_calculator1" data-field="x_s_custom_duty" value="<?= $Page->s_custom_duty->EditValue ?>" size="30" maxlength="26" placeholder="<?= HtmlEncode($Page->s_custom_duty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->s_custom_duty->formatPattern()) ?>"<?= $Page->s_custom_duty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->s_custom_duty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->port_clearing_charge->Visible) { // port_clearing_charge ?>
    <div id="r_port_clearing_charge" class="row"<?= $Page->port_clearing_charge->rowAttributes() ?>>
        <label for="x_port_clearing_charge" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_port_clearing_charge"><?= $Page->port_clearing_charge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_port_clearing_charge" id="z_port_clearing_charge" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->port_clearing_charge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_port_clearing_charge" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->port_clearing_charge->getInputTextType() ?>" name="x_port_clearing_charge" id="x_port_clearing_charge" data-table="wool_import_calculator1" data-field="x_port_clearing_charge" value="<?= $Page->port_clearing_charge->EditValue ?>" size="30" maxlength="26" placeholder="<?= HtmlEncode($Page->port_clearing_charge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_clearing_charge->formatPattern()) ?>"<?= $Page->port_clearing_charge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->port_clearing_charge->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_port_clearing_charge->Visible) { // s_port_clearing_charge ?>
    <div id="r_s_port_clearing_charge" class="row"<?= $Page->s_port_clearing_charge->rowAttributes() ?>>
        <label for="x_s_port_clearing_charge" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_s_port_clearing_charge"><?= $Page->s_port_clearing_charge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_s_port_clearing_charge" id="z_s_port_clearing_charge" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_port_clearing_charge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_s_port_clearing_charge" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->s_port_clearing_charge->getInputTextType() ?>" name="x_s_port_clearing_charge" id="x_s_port_clearing_charge" data-table="wool_import_calculator1" data-field="x_s_port_clearing_charge" value="<?= $Page->s_port_clearing_charge->EditValue ?>" size="30" maxlength="26" placeholder="<?= HtmlEncode($Page->s_port_clearing_charge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->s_port_clearing_charge->formatPattern()) ?>"<?= $Page->s_port_clearing_charge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->s_port_clearing_charge->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cha_commission->Visible) { // cha_commission ?>
    <div id="r_cha_commission" class="row"<?= $Page->cha_commission->rowAttributes() ?>>
        <label for="x_cha_commission" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_cha_commission"><?= $Page->cha_commission->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_cha_commission" id="z_cha_commission" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cha_commission->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_cha_commission" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cha_commission->getInputTextType() ?>" name="x_cha_commission" id="x_cha_commission" data-table="wool_import_calculator1" data-field="x_cha_commission" value="<?= $Page->cha_commission->EditValue ?>" size="30" maxlength="26" placeholder="<?= HtmlEncode($Page->cha_commission->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cha_commission->formatPattern()) ?>"<?= $Page->cha_commission->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cha_commission->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_cha_commission->Visible) { // s_cha_commission ?>
    <div id="r_s_cha_commission" class="row"<?= $Page->s_cha_commission->rowAttributes() ?>>
        <label for="x_s_cha_commission" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_s_cha_commission"><?= $Page->s_cha_commission->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_s_cha_commission" id="z_s_cha_commission" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_cha_commission->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_s_cha_commission" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->s_cha_commission->getInputTextType() ?>" name="x_s_cha_commission" id="x_s_cha_commission" data-table="wool_import_calculator1" data-field="x_s_cha_commission" value="<?= $Page->s_cha_commission->EditValue ?>" size="30" maxlength="26" placeholder="<?= HtmlEncode($Page->s_cha_commission->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->s_cha_commission->formatPattern()) ?>"<?= $Page->s_cha_commission->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->s_cha_commission->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->transportation_charges->Visible) { // transportation_charges ?>
    <div id="r_transportation_charges" class="row"<?= $Page->transportation_charges->rowAttributes() ?>>
        <label for="x_transportation_charges" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_transportation_charges"><?= $Page->transportation_charges->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_transportation_charges" id="z_transportation_charges" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->transportation_charges->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_transportation_charges" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->transportation_charges->getInputTextType() ?>" name="x_transportation_charges" id="x_transportation_charges" data-table="wool_import_calculator1" data-field="x_transportation_charges" value="<?= $Page->transportation_charges->EditValue ?>" size="30" maxlength="26" placeholder="<?= HtmlEncode($Page->transportation_charges->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->transportation_charges->formatPattern()) ?>"<?= $Page->transportation_charges->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->transportation_charges->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_transportation_charges->Visible) { // s_transportation_charges ?>
    <div id="r_s_transportation_charges" class="row"<?= $Page->s_transportation_charges->rowAttributes() ?>>
        <label for="x_s_transportation_charges" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_s_transportation_charges"><?= $Page->s_transportation_charges->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_s_transportation_charges" id="z_s_transportation_charges" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_transportation_charges->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_s_transportation_charges" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->s_transportation_charges->getInputTextType() ?>" name="x_s_transportation_charges" id="x_s_transportation_charges" data-table="wool_import_calculator1" data-field="x_s_transportation_charges" value="<?= $Page->s_transportation_charges->EditValue ?>" size="30" maxlength="26" placeholder="<?= HtmlEncode($Page->s_transportation_charges->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->s_transportation_charges->formatPattern()) ?>"<?= $Page->s_transportation_charges->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->s_transportation_charges->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unloading_charges->Visible) { // unloading_charges ?>
    <div id="r_unloading_charges" class="row"<?= $Page->unloading_charges->rowAttributes() ?>>
        <label for="x_unloading_charges" class="<?= $Page->LeftColumnClass ?>"><span id="elh_wool_import_calculator1_unloading_charges"><?= $Page->unloading_charges->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_unloading_charges" id="z_unloading_charges" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unloading_charges->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_wool_import_calculator1_unloading_charges" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->unloading_charges->getInputTextType() ?>" name="x_unloading_charges" id="x_unloading_charges" data-table="wool_import_calculator1" data-field="x_unloading_charges" value="<?= $Page->unloading_charges->EditValue ?>" size="30" maxlength="26" placeholder="<?= HtmlEncode($Page->unloading_charges->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unloading_charges->formatPattern()) ?>"<?= $Page->unloading_charges->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unloading_charges->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fwool_import_calculator1search"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fwool_import_calculator1search"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fwool_import_calculator1search" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("wool_import_calculator1");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
