<?php

namespace PHPMaker2024\fibre;

// Page object
$WhatsappSetupEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fwhatsapp_setupedit" id="fwhatsapp_setupedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { whatsapp_setup: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fwhatsapp_setupedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fwhatsapp_setupedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["whatsapp_message", [fields.whatsapp_message.visible && fields.whatsapp_message.required ? ew.Validators.required(fields.whatsapp_message.caption) : null], fields.whatsapp_message.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="whatsapp_setup">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->whatsapp_message->Visible) { // whatsapp_message ?>
    <div id="r_whatsapp_message"<?= $Page->whatsapp_message->rowAttributes() ?>>
        <label id="elh_whatsapp_setup_whatsapp_message" for="x_whatsapp_message" class="<?= $Page->LeftColumnClass ?>"><?= $Page->whatsapp_message->caption() ?><?= $Page->whatsapp_message->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->whatsapp_message->cellAttributes() ?>>
<span id="el_whatsapp_setup_whatsapp_message">
<input type="<?= $Page->whatsapp_message->getInputTextType() ?>" name="x_whatsapp_message" id="x_whatsapp_message" data-table="whatsapp_setup" data-field="x_whatsapp_message" value="<?= $Page->whatsapp_message->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->whatsapp_message->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->whatsapp_message->formatPattern()) ?>"<?= $Page->whatsapp_message->editAttributes() ?> aria-describedby="x_whatsapp_message_help">
<?= $Page->whatsapp_message->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->whatsapp_message->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
    <input type="hidden" data-table="whatsapp_setup" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fwhatsapp_setupedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fwhatsapp_setupedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("whatsapp_setup");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
