<?php

namespace PHPMaker2024\fibre;

// Page object
$WhatsappSetupAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { whatsapp_setup: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fwhatsapp_setupadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fwhatsapp_setupadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null], fields.mobile.isInvalid],
            ["url", [fields.url.visible && fields.url.required ? ew.Validators.required(fields.url.caption) : null], fields.url.isInvalid],
            ["instance_id", [fields.instance_id.visible && fields.instance_id.required ? ew.Validators.required(fields.instance_id.caption) : null], fields.instance_id.isInvalid],
            ["_token", [fields._token.visible && fields._token.required ? ew.Validators.required(fields._token.caption) : null], fields._token.isInvalid],
            ["company", [fields.company.visible && fields.company.required ? ew.Validators.required(fields.company.caption) : null], fields.company.isInvalid],
            ["direct_whatsapp", [fields.direct_whatsapp.visible && fields.direct_whatsapp.required ? ew.Validators.required(fields.direct_whatsapp.caption) : null, ew.Validators.integer], fields.direct_whatsapp.isInvalid],
            ["whatsapp_message", [fields.whatsapp_message.visible && fields.whatsapp_message.required ? ew.Validators.required(fields.whatsapp_message.caption) : null], fields.whatsapp_message.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company": <?= $Page->company->toClientList($Page) ?>,
            "direct_whatsapp": <?= $Page->direct_whatsapp->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fwhatsapp_setupadd" id="fwhatsapp_setupadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="whatsapp_setup">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_whatsapp_setup_mobile" for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_whatsapp_setup_mobile">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="whatsapp_setup" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <div id="r_url"<?= $Page->url->rowAttributes() ?>>
        <label id="elh_whatsapp_setup_url" for="x_url" class="<?= $Page->LeftColumnClass ?>"><?= $Page->url->caption() ?><?= $Page->url->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->url->cellAttributes() ?>>
<span id="el_whatsapp_setup_url">
<input type="<?= $Page->url->getInputTextType() ?>" name="x_url" id="x_url" data-table="whatsapp_setup" data-field="x_url" value="<?= $Page->url->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url->formatPattern()) ?>"<?= $Page->url->editAttributes() ?> aria-describedby="x_url_help">
<?= $Page->url->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->url->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->instance_id->Visible) { // instance_id ?>
    <div id="r_instance_id"<?= $Page->instance_id->rowAttributes() ?>>
        <label id="elh_whatsapp_setup_instance_id" for="x_instance_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->instance_id->caption() ?><?= $Page->instance_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->instance_id->cellAttributes() ?>>
<span id="el_whatsapp_setup_instance_id">
<input type="<?= $Page->instance_id->getInputTextType() ?>" name="x_instance_id" id="x_instance_id" data-table="whatsapp_setup" data-field="x_instance_id" value="<?= $Page->instance_id->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->instance_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->instance_id->formatPattern()) ?>"<?= $Page->instance_id->editAttributes() ?> aria-describedby="x_instance_id_help">
<?= $Page->instance_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->instance_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_token->Visible) { // token ?>
    <div id="r__token"<?= $Page->_token->rowAttributes() ?>>
        <label id="elh_whatsapp_setup__token" for="x__token" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_token->caption() ?><?= $Page->_token->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_token->cellAttributes() ?>>
<span id="el_whatsapp_setup__token">
<input type="<?= $Page->_token->getInputTextType() ?>" name="x__token" id="x__token" data-table="whatsapp_setup" data-field="x__token" value="<?= $Page->_token->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->_token->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_token->formatPattern()) ?>"<?= $Page->_token->editAttributes() ?> aria-describedby="x__token_help">
<?= $Page->_token->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_token->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->company->Visible) { // company ?>
    <div id="r_company"<?= $Page->company->rowAttributes() ?>>
        <label id="elh_whatsapp_setup_company" for="x_company" class="<?= $Page->LeftColumnClass ?>"><?= $Page->company->caption() ?><?= $Page->company->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->company->cellAttributes() ?>>
<span id="el_whatsapp_setup_company">
    <select
        id="x_company[]"
        name="x_company[]"
        class="form-select ew-select<?= $Page->company->isInvalidClass() ?>"
        <?php if (!$Page->company->IsNativeSelect) { ?>
        data-select2-id="fwhatsapp_setupadd_x_company[]"
        <?php } ?>
        data-table="whatsapp_setup"
        data-field="x_company"
        multiple
        size="1"
        data-value-separator="<?= $Page->company->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company->getPlaceHolder()) ?>"
        <?= $Page->company->editAttributes() ?>>
        <?= $Page->company->selectOptionListHtml("x_company[]") ?>
    </select>
    <?= $Page->company->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->company->getErrorMessage() ?></div>
<?= $Page->company->Lookup->getParamTag($Page, "p_x_company") ?>
<?php if (!$Page->company->IsNativeSelect) { ?>
<script>
loadjs.ready("fwhatsapp_setupadd", function() {
    var options = { name: "x_company[]", selectId: "fwhatsapp_setupadd_x_company[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fwhatsapp_setupadd.lists.company?.lookupOptions.length) {
        options.data = { id: "x_company[]", form: "fwhatsapp_setupadd" };
    } else {
        options.ajax = { id: "x_company[]", form: "fwhatsapp_setupadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.whatsapp_setup.fields.company.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->direct_whatsapp->Visible) { // direct_whatsapp ?>
    <div id="r_direct_whatsapp"<?= $Page->direct_whatsapp->rowAttributes() ?>>
        <label id="elh_whatsapp_setup_direct_whatsapp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->direct_whatsapp->caption() ?><?= $Page->direct_whatsapp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->direct_whatsapp->cellAttributes() ?>>
<span id="el_whatsapp_setup_direct_whatsapp">
<?php
if (IsRTL()) {
    $Page->direct_whatsapp->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_direct_whatsapp" class="ew-auto-suggest">
    <input type="<?= $Page->direct_whatsapp->getInputTextType() ?>" class="form-control" name="sv_x_direct_whatsapp" id="sv_x_direct_whatsapp" value="<?= RemoveHtml($Page->direct_whatsapp->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->direct_whatsapp->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->direct_whatsapp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->direct_whatsapp->formatPattern()) ?>"<?= $Page->direct_whatsapp->editAttributes() ?> aria-describedby="x_direct_whatsapp_help">
</span>
<selection-list hidden class="form-control" data-table="whatsapp_setup" data-field="x_direct_whatsapp" data-input="sv_x_direct_whatsapp" data-value-separator="<?= $Page->direct_whatsapp->displayValueSeparatorAttribute() ?>" name="x_direct_whatsapp" id="x_direct_whatsapp" value="<?= HtmlEncode($Page->direct_whatsapp->CurrentValue) ?>"></selection-list>
<?= $Page->direct_whatsapp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->direct_whatsapp->getErrorMessage() ?></div>
<script>
loadjs.ready("fwhatsapp_setupadd", function() {
    fwhatsapp_setupadd.createAutoSuggest(Object.assign({"id":"x_direct_whatsapp","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->direct_whatsapp->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.whatsapp_setup.fields.direct_whatsapp.autoSuggestOptions));
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->whatsapp_message->Visible) { // whatsapp_message ?>
    <div id="r_whatsapp_message"<?= $Page->whatsapp_message->rowAttributes() ?>>
        <label id="elh_whatsapp_setup_whatsapp_message" for="x_whatsapp_message" class="<?= $Page->LeftColumnClass ?>"><?= $Page->whatsapp_message->caption() ?><?= $Page->whatsapp_message->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->whatsapp_message->cellAttributes() ?>>
<span id="el_whatsapp_setup_whatsapp_message">
<input type="<?= $Page->whatsapp_message->getInputTextType() ?>" name="x_whatsapp_message" id="x_whatsapp_message" data-table="whatsapp_setup" data-field="x_whatsapp_message" value="<?= $Page->whatsapp_message->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->whatsapp_message->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->whatsapp_message->formatPattern()) ?>"<?= $Page->whatsapp_message->editAttributes() ?> aria-describedby="x_whatsapp_message_help">
<?= $Page->whatsapp_message->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->whatsapp_message->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fwhatsapp_setupadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fwhatsapp_setupadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("whatsapp_setup");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
