<?php

namespace PHPMaker2024\fibre;

// Page object
$WeightComparisionSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { weight_comparision: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fweight_comparisionsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fweight_comparisionsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["_barcode", [ew.Validators.integer], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["design", [], fields.design.isInvalid],
            ["size", [], fields.size.isInvalid],
            ["size_actual", [], fields.size_actual.isInvalid],
            ["s_weight", [ew.Validators.float], fields.s_weight.isInvalid],
            ["y_s_weight", [ew.Validators.between], false],
            ["a_weight", [ew.Validators.float], fields.a_weight.isInvalid],
            ["y_a_weight", [ew.Validators.between], false],
            ["diff_p", [ew.Validators.float], fields.diff_p.isInvalid],
            ["y_diff_p", [ew.Validators.between], false],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["buyers_id", [ew.Validators.integer], fields.buyers_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fweight_comparisionsearch" id="fweight_comparisionsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="weight_comparision">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_weight_comparision__barcode"><?= $Page->_barcode->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_weight_comparision__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="weight_comparision" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_weight_comparision__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="weight_comparision" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
    <div id="r_design" class="row"<?= $Page->design->rowAttributes() ?>>
        <label for="x_design" class="<?= $Page->LeftColumnClass ?>"><span id="elh_weight_comparision_design"><?= $Page->design->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design" id="z_design" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_weight_comparision_design" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design->getInputTextType() ?>" name="x_design" id="x_design" data-table="weight_comparision" data-field="x_design" value="<?= $Page->design->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design->formatPattern()) ?>"<?= $Page->design->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
    <div id="r_size" class="row"<?= $Page->size->rowAttributes() ?>>
        <label for="x_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_weight_comparision_size"><?= $Page->size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size" id="z_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_weight_comparision_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size->getInputTextType() ?>" name="x_size" id="x_size" data-table="weight_comparision" data-field="x_size" value="<?= $Page->size->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size->formatPattern()) ?>"<?= $Page->size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_actual->Visible) { // size_actual ?>
    <div id="r_size_actual" class="row"<?= $Page->size_actual->rowAttributes() ?>>
        <label for="x_size_actual" class="<?= $Page->LeftColumnClass ?>"><span id="elh_weight_comparision_size_actual"><?= $Page->size_actual->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_actual" id="z_size_actual" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_actual->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_weight_comparision_size_actual" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_actual->getInputTextType() ?>" name="x_size_actual" id="x_size_actual" data-table="weight_comparision" data-field="x_size_actual" value="<?= $Page->size_actual->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->size_actual->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_actual->formatPattern()) ?>"<?= $Page->size_actual->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_actual->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_weight->Visible) { // s_weight ?>
    <div id="r_s_weight" class="row"<?= $Page->s_weight->rowAttributes() ?>>
        <label for="x_s_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_weight_comparision_s_weight"><?= $Page->s_weight->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_s_weight" id="z_s_weight" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->s_weight->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->s_weight->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_weight_comparision_s_weight" class="ew-search-field">
<input type="<?= $Page->s_weight->getInputTextType() ?>" name="x_s_weight" id="x_s_weight" data-table="weight_comparision" data-field="x_s_weight" value="<?= $Page->s_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->s_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->s_weight->formatPattern()) ?>"<?= $Page->s_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->s_weight->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_weight_comparision_s_weight" class="ew-search-field2 d-none">
<input type="<?= $Page->s_weight->getInputTextType() ?>" name="y_s_weight" id="y_s_weight" data-table="weight_comparision" data-field="x_s_weight" value="<?= $Page->s_weight->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->s_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->s_weight->formatPattern()) ?>"<?= $Page->s_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->s_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_weight->Visible) { // a_weight ?>
    <div id="r_a_weight" class="row"<?= $Page->a_weight->rowAttributes() ?>>
        <label for="x_a_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_weight_comparision_a_weight"><?= $Page->a_weight->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_a_weight" id="z_a_weight" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->a_weight->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->a_weight->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_weight_comparision_a_weight" class="ew-search-field">
<input type="<?= $Page->a_weight->getInputTextType() ?>" name="x_a_weight" id="x_a_weight" data-table="weight_comparision" data-field="x_a_weight" value="<?= $Page->a_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->a_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_weight->formatPattern()) ?>"<?= $Page->a_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->a_weight->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_weight_comparision_a_weight" class="ew-search-field2 d-none">
<input type="<?= $Page->a_weight->getInputTextType() ?>" name="y_a_weight" id="y_a_weight" data-table="weight_comparision" data-field="x_a_weight" value="<?= $Page->a_weight->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->a_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_weight->formatPattern()) ?>"<?= $Page->a_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->a_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->diff_p->Visible) { // diff_p ?>
    <div id="r_diff_p" class="row"<?= $Page->diff_p->rowAttributes() ?>>
        <label for="x_diff_p" class="<?= $Page->LeftColumnClass ?>"><span id="elh_weight_comparision_diff_p"><?= $Page->diff_p->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->diff_p->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_diff_p" id="z_diff_p" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->diff_p->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->diff_p->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_weight_comparision_diff_p" class="ew-search-field">
<input type="<?= $Page->diff_p->getInputTextType() ?>" name="x_diff_p" id="x_diff_p" data-table="weight_comparision" data-field="x_diff_p" value="<?= $Page->diff_p->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->diff_p->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diff_p->formatPattern()) ?>"<?= $Page->diff_p->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->diff_p->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_weight_comparision_diff_p" class="ew-search-field2 d-none">
<input type="<?= $Page->diff_p->getInputTextType() ?>" name="y_diff_p" id="y_diff_p" data-table="weight_comparision" data-field="x_diff_p" value="<?= $Page->diff_p->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->diff_p->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diff_p->formatPattern()) ?>"<?= $Page->diff_p->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->diff_p->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_weight_comparision_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_weight_comparision_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="weight_comparision" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fweight_comparisionsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fweight_comparisionsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_weight_comparision_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="weight_comparision" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fweight_comparisionsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fweight_comparisionsearch", "y_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_weight_comparision_po"><?= $Page->po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po" id="z_po" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_weight_comparision_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="weight_comparision" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id" class="row"<?= $Page->buyers_id->rowAttributes() ?>>
        <label for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_weight_comparision_buyers_id"><?= $Page->buyers_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyers_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_weight_comparision_buyers_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyers_id->getInputTextType() ?>" name="x_buyers_id" id="x_buyers_id" data-table="weight_comparision" data-field="x_buyers_id" value="<?= $Page->buyers_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyers_id->formatPattern()) ?>"<?= $Page->buyers_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fweight_comparisionsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fweight_comparisionsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fweight_comparisionsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("weight_comparision");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
