<?php

namespace PHPMaker2024\fibre;

// Page object
$VehicleInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { vehicle_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fvehicle_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fvehicle_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["type", [], fields.type.isInvalid],
            ["vehicle_owner", [], fields.vehicle_owner.isInvalid],
            ["no", [], fields.no.isInvalid],
            ["driver", [], fields.driver.isInvalid],
            ["driver_name", [], fields.driver_name.isInvalid],
            ["dor", [ew.Validators.datetime(fields.dor.clientFormatPattern)], fields.dor.isInvalid],
            ["km_hour", [ew.Validators.float], fields.km_hour.isInvalid],
            ["chassis_no", [], fields.chassis_no.isInvalid],
            ["engine_no", [], fields.engine_no.isInvalid],
            ["load_average", [ew.Validators.float], fields.load_average.isInvalid],
            ["unload_average", [ew.Validators.float], fields.unload_average.isInvalid],
            ["load_expenses", [ew.Validators.float], fields.load_expenses.isInvalid],
            ["unload_expenses", [ew.Validators.float], fields.unload_expenses.isInvalid],
            ["insurance", [ew.Validators.datetime(fields.insurance.clientFormatPattern)], fields.insurance.isInvalid],
            ["state_tax", [ew.Validators.datetime(fields.state_tax.clientFormatPattern)], fields.state_tax.isInvalid],
            ["national_permit", [ew.Validators.datetime(fields.national_permit.clientFormatPattern)], fields.national_permit.isInvalid],
            ["pollution", [ew.Validators.datetime(fields.pollution.clientFormatPattern)], fields.pollution.isInvalid],
            ["fitness", [ew.Validators.datetime(fields.fitness.clientFormatPattern)], fields.fitness.isInvalid],
            ["other_due", [ew.Validators.datetime(fields.other_due.clientFormatPattern)], fields.other_due.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["running_status", [], fields.running_status.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "type": <?= $Page->type->toClientList($Page) ?>,
            "vehicle_owner": <?= $Page->vehicle_owner->toClientList($Page) ?>,
            "driver": <?= $Page->driver->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "running_status": <?= $Page->running_status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fvehicle_infosearch" id="fvehicle_infosearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="vehicle_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="vehicle_info" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type" class="row"<?= $Page->type->rowAttributes() ?>>
        <label for="x_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_type"><?= $Page->type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_type" id="z_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="fvehicle_infosearch_x_type"
        <?php } ?>
        data-table="vehicle_info"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fvehicle_infosearch", function() {
    var options = { name: "x_type", selectId: "fvehicle_infosearch_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvehicle_infosearch.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "fvehicle_infosearch" };
    } else {
        options.ajax = { id: "x_type", form: "fvehicle_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.vehicle_info.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_owner->Visible) { // vehicle_owner ?>
    <div id="r_vehicle_owner" class="row"<?= $Page->vehicle_owner->rowAttributes() ?>>
        <label for="x_vehicle_owner" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_vehicle_owner"><?= $Page->vehicle_owner->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_owner" id="z_vehicle_owner" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_owner->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_vehicle_owner" class="ew-search-field ew-search-field-single">
    <select
        id="x_vehicle_owner"
        name="x_vehicle_owner"
        class="form-select ew-select<?= $Page->vehicle_owner->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_owner->IsNativeSelect) { ?>
        data-select2-id="fvehicle_infosearch_x_vehicle_owner"
        <?php } ?>
        data-table="vehicle_info"
        data-field="x_vehicle_owner"
        data-value-separator="<?= $Page->vehicle_owner->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_owner->getPlaceHolder()) ?>"
        <?= $Page->vehicle_owner->editAttributes() ?>>
        <?= $Page->vehicle_owner->selectOptionListHtml("x_vehicle_owner") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle_owner->getErrorMessage(false) ?></div>
<?= $Page->vehicle_owner->Lookup->getParamTag($Page, "p_x_vehicle_owner") ?>
<?php if (!$Page->vehicle_owner->IsNativeSelect) { ?>
<script>
loadjs.ready("fvehicle_infosearch", function() {
    var options = { name: "x_vehicle_owner", selectId: "fvehicle_infosearch_x_vehicle_owner" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvehicle_infosearch.lists.vehicle_owner?.lookupOptions.length) {
        options.data = { id: "x_vehicle_owner", form: "fvehicle_infosearch" };
    } else {
        options.ajax = { id: "x_vehicle_owner", form: "fvehicle_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.vehicle_info.fields.vehicle_owner.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->no->Visible) { // no ?>
    <div id="r_no" class="row"<?= $Page->no->rowAttributes() ?>>
        <label for="x_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_no"><?= $Page->no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_no" id="z_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->no->getInputTextType() ?>" name="x_no" id="x_no" data-table="vehicle_info" data-field="x_no" value="<?= $Page->no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no->formatPattern()) ?>"<?= $Page->no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
    <div id="r_driver" class="row"<?= $Page->driver->rowAttributes() ?>>
        <label for="x_driver" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_driver"><?= $Page->driver->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_driver" id="z_driver" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->driver->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_driver" class="ew-search-field ew-search-field-single">
    <select
        id="x_driver"
        name="x_driver"
        class="form-select ew-select<?= $Page->driver->isInvalidClass() ?>"
        <?php if (!$Page->driver->IsNativeSelect) { ?>
        data-select2-id="fvehicle_infosearch_x_driver"
        <?php } ?>
        data-table="vehicle_info"
        data-field="x_driver"
        data-value-separator="<?= $Page->driver->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>"
        <?= $Page->driver->editAttributes() ?>>
        <?= $Page->driver->selectOptionListHtml("x_driver") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->driver->getErrorMessage(false) ?></div>
<?= $Page->driver->Lookup->getParamTag($Page, "p_x_driver") ?>
<?php if (!$Page->driver->IsNativeSelect) { ?>
<script>
loadjs.ready("fvehicle_infosearch", function() {
    var options = { name: "x_driver", selectId: "fvehicle_infosearch_x_driver" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvehicle_infosearch.lists.driver?.lookupOptions.length) {
        options.data = { id: "x_driver", form: "fvehicle_infosearch" };
    } else {
        options.ajax = { id: "x_driver", form: "fvehicle_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.vehicle_info.fields.driver.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->driver_name->Visible) { // driver_name ?>
    <div id="r_driver_name" class="row"<?= $Page->driver_name->rowAttributes() ?>>
        <label for="x_driver_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_driver_name"><?= $Page->driver_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_driver_name" id="z_driver_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->driver_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_driver_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->driver_name->getInputTextType() ?>" name="x_driver_name" id="x_driver_name" data-table="vehicle_info" data-field="x_driver_name" value="<?= $Page->driver_name->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->driver_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->driver_name->formatPattern()) ?>"<?= $Page->driver_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->driver_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dor->Visible) { // dor ?>
    <div id="r_dor" class="row"<?= $Page->dor->rowAttributes() ?>>
        <label for="x_dor" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_dor"><?= $Page->dor->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dor" id="z_dor" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dor->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_dor" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dor->getInputTextType() ?>" name="x_dor" id="x_dor" data-table="vehicle_info" data-field="x_dor" value="<?= $Page->dor->EditValue ?>" placeholder="<?= HtmlEncode($Page->dor->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dor->formatPattern()) ?>"<?= $Page->dor->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dor->getErrorMessage(false) ?></div>
<?php if (!$Page->dor->ReadOnly && !$Page->dor->Disabled && !isset($Page->dor->EditAttrs["readonly"]) && !isset($Page->dor->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infosearch", "x_dor", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->km_hour->Visible) { // km_hour ?>
    <div id="r_km_hour" class="row"<?= $Page->km_hour->rowAttributes() ?>>
        <label for="x_km_hour" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_km_hour"><?= $Page->km_hour->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_km_hour" id="z_km_hour" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->km_hour->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_km_hour" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->km_hour->getInputTextType() ?>" name="x_km_hour" id="x_km_hour" data-table="vehicle_info" data-field="x_km_hour" value="<?= $Page->km_hour->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->km_hour->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->km_hour->formatPattern()) ?>"<?= $Page->km_hour->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->km_hour->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->chassis_no->Visible) { // chassis_no ?>
    <div id="r_chassis_no" class="row"<?= $Page->chassis_no->rowAttributes() ?>>
        <label for="x_chassis_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_chassis_no"><?= $Page->chassis_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_chassis_no" id="z_chassis_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->chassis_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_chassis_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->chassis_no->getInputTextType() ?>" name="x_chassis_no" id="x_chassis_no" data-table="vehicle_info" data-field="x_chassis_no" value="<?= $Page->chassis_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->chassis_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->chassis_no->formatPattern()) ?>"<?= $Page->chassis_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->chassis_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->engine_no->Visible) { // engine_no ?>
    <div id="r_engine_no" class="row"<?= $Page->engine_no->rowAttributes() ?>>
        <label for="x_engine_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_engine_no"><?= $Page->engine_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_engine_no" id="z_engine_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->engine_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_engine_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->engine_no->getInputTextType() ?>" name="x_engine_no" id="x_engine_no" data-table="vehicle_info" data-field="x_engine_no" value="<?= $Page->engine_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->engine_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->engine_no->formatPattern()) ?>"<?= $Page->engine_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->engine_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->load_average->Visible) { // load_average ?>
    <div id="r_load_average" class="row"<?= $Page->load_average->rowAttributes() ?>>
        <label for="x_load_average" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_load_average"><?= $Page->load_average->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_average" id="z_load_average" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->load_average->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_load_average" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->load_average->getInputTextType() ?>" name="x_load_average" id="x_load_average" data-table="vehicle_info" data-field="x_load_average" value="<?= $Page->load_average->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->load_average->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_average->formatPattern()) ?>"<?= $Page->load_average->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_average->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unload_average->Visible) { // unload_average ?>
    <div id="r_unload_average" class="row"<?= $Page->unload_average->rowAttributes() ?>>
        <label for="x_unload_average" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_unload_average"><?= $Page->unload_average->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unload_average" id="z_unload_average" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unload_average->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_unload_average" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->unload_average->getInputTextType() ?>" name="x_unload_average" id="x_unload_average" data-table="vehicle_info" data-field="x_unload_average" value="<?= $Page->unload_average->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->unload_average->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_average->formatPattern()) ?>"<?= $Page->unload_average->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_average->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->load_expenses->Visible) { // load_expenses ?>
    <div id="r_load_expenses" class="row"<?= $Page->load_expenses->rowAttributes() ?>>
        <label for="x_load_expenses" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_load_expenses"><?= $Page->load_expenses->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_expenses" id="z_load_expenses" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->load_expenses->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_load_expenses" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->load_expenses->getInputTextType() ?>" name="x_load_expenses" id="x_load_expenses" data-table="vehicle_info" data-field="x_load_expenses" value="<?= $Page->load_expenses->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->load_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_expenses->formatPattern()) ?>"<?= $Page->load_expenses->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_expenses->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unload_expenses->Visible) { // unload_expenses ?>
    <div id="r_unload_expenses" class="row"<?= $Page->unload_expenses->rowAttributes() ?>>
        <label for="x_unload_expenses" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_unload_expenses"><?= $Page->unload_expenses->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unload_expenses" id="z_unload_expenses" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unload_expenses->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_unload_expenses" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->unload_expenses->getInputTextType() ?>" name="x_unload_expenses" id="x_unload_expenses" data-table="vehicle_info" data-field="x_unload_expenses" value="<?= $Page->unload_expenses->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->unload_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_expenses->formatPattern()) ?>"<?= $Page->unload_expenses->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_expenses->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->insurance->Visible) { // insurance ?>
    <div id="r_insurance" class="row"<?= $Page->insurance->rowAttributes() ?>>
        <label for="x_insurance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_insurance"><?= $Page->insurance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_insurance" id="z_insurance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->insurance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_insurance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->insurance->getInputTextType() ?>" name="x_insurance" id="x_insurance" data-table="vehicle_info" data-field="x_insurance" value="<?= $Page->insurance->EditValue ?>" placeholder="<?= HtmlEncode($Page->insurance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->insurance->formatPattern()) ?>"<?= $Page->insurance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->insurance->getErrorMessage(false) ?></div>
<?php if (!$Page->insurance->ReadOnly && !$Page->insurance->Disabled && !isset($Page->insurance->EditAttrs["readonly"]) && !isset($Page->insurance->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infosearch", "x_insurance", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->state_tax->Visible) { // state_tax ?>
    <div id="r_state_tax" class="row"<?= $Page->state_tax->rowAttributes() ?>>
        <label for="x_state_tax" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_state_tax"><?= $Page->state_tax->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_state_tax" id="z_state_tax" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->state_tax->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_state_tax" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->state_tax->getInputTextType() ?>" name="x_state_tax" id="x_state_tax" data-table="vehicle_info" data-field="x_state_tax" value="<?= $Page->state_tax->EditValue ?>" placeholder="<?= HtmlEncode($Page->state_tax->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->state_tax->formatPattern()) ?>"<?= $Page->state_tax->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->state_tax->getErrorMessage(false) ?></div>
<?php if (!$Page->state_tax->ReadOnly && !$Page->state_tax->Disabled && !isset($Page->state_tax->EditAttrs["readonly"]) && !isset($Page->state_tax->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infosearch", "x_state_tax", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->national_permit->Visible) { // national_permit ?>
    <div id="r_national_permit" class="row"<?= $Page->national_permit->rowAttributes() ?>>
        <label for="x_national_permit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_national_permit"><?= $Page->national_permit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_national_permit" id="z_national_permit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->national_permit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_national_permit" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->national_permit->getInputTextType() ?>" name="x_national_permit" id="x_national_permit" data-table="vehicle_info" data-field="x_national_permit" value="<?= $Page->national_permit->EditValue ?>" placeholder="<?= HtmlEncode($Page->national_permit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->national_permit->formatPattern()) ?>"<?= $Page->national_permit->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->national_permit->getErrorMessage(false) ?></div>
<?php if (!$Page->national_permit->ReadOnly && !$Page->national_permit->Disabled && !isset($Page->national_permit->EditAttrs["readonly"]) && !isset($Page->national_permit->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infosearch", "x_national_permit", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pollution->Visible) { // pollution ?>
    <div id="r_pollution" class="row"<?= $Page->pollution->rowAttributes() ?>>
        <label for="x_pollution" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_pollution"><?= $Page->pollution->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pollution" id="z_pollution" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pollution->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_pollution" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pollution->getInputTextType() ?>" name="x_pollution" id="x_pollution" data-table="vehicle_info" data-field="x_pollution" value="<?= $Page->pollution->EditValue ?>" placeholder="<?= HtmlEncode($Page->pollution->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pollution->formatPattern()) ?>"<?= $Page->pollution->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pollution->getErrorMessage(false) ?></div>
<?php if (!$Page->pollution->ReadOnly && !$Page->pollution->Disabled && !isset($Page->pollution->EditAttrs["readonly"]) && !isset($Page->pollution->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infosearch", "x_pollution", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fitness->Visible) { // fitness ?>
    <div id="r_fitness" class="row"<?= $Page->fitness->rowAttributes() ?>>
        <label for="x_fitness" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_fitness"><?= $Page->fitness->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_fitness" id="z_fitness" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fitness->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_fitness" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->fitness->getInputTextType() ?>" name="x_fitness" id="x_fitness" data-table="vehicle_info" data-field="x_fitness" value="<?= $Page->fitness->EditValue ?>" placeholder="<?= HtmlEncode($Page->fitness->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fitness->formatPattern()) ?>"<?= $Page->fitness->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->fitness->getErrorMessage(false) ?></div>
<?php if (!$Page->fitness->ReadOnly && !$Page->fitness->Disabled && !isset($Page->fitness->EditAttrs["readonly"]) && !isset($Page->fitness->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infosearch", "x_fitness", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other_due->Visible) { // other_due ?>
    <div id="r_other_due" class="row"<?= $Page->other_due->rowAttributes() ?>>
        <label for="x_other_due" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_other_due"><?= $Page->other_due->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_other_due" id="z_other_due" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other_due->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_other_due" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->other_due->getInputTextType() ?>" name="x_other_due" id="x_other_due" data-table="vehicle_info" data-field="x_other_due" value="<?= $Page->other_due->EditValue ?>" placeholder="<?= HtmlEncode($Page->other_due->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_due->formatPattern()) ?>"<?= $Page->other_due->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->other_due->getErrorMessage(false) ?></div>
<?php if (!$Page->other_due->ReadOnly && !$Page->other_due->Disabled && !isset($Page->other_due->EditAttrs["readonly"]) && !isset($Page->other_due->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infosearch", "x_other_due", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fvehicle_infosearch_x_status"
        <?php } ?>
        data-table="vehicle_info"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fvehicle_infosearch", function() {
    var options = { name: "x_status", selectId: "fvehicle_infosearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvehicle_infosearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fvehicle_infosearch" };
    } else {
        options.ajax = { id: "x_status", form: "fvehicle_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.vehicle_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fvehicle_infosearch_x_operator"
        <?php } ?>
        data-table="vehicle_info"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fvehicle_infosearch", function() {
    var options = { name: "x_operator", selectId: "fvehicle_infosearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvehicle_infosearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fvehicle_infosearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fvehicle_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.vehicle_info.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="vehicle_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infosearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->running_status->Visible) { // running_status ?>
    <div id="r_running_status" class="row"<?= $Page->running_status->rowAttributes() ?>>
        <label for="x_running_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vehicle_info_running_status"><?= $Page->running_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_running_status" id="z_running_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->running_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vehicle_info_running_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_running_status"
        name="x_running_status"
        class="form-select ew-select<?= $Page->running_status->isInvalidClass() ?>"
        <?php if (!$Page->running_status->IsNativeSelect) { ?>
        data-select2-id="fvehicle_infosearch_x_running_status"
        <?php } ?>
        data-table="vehicle_info"
        data-field="x_running_status"
        data-value-separator="<?= $Page->running_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->running_status->getPlaceHolder()) ?>"
        <?= $Page->running_status->editAttributes() ?>>
        <?= $Page->running_status->selectOptionListHtml("x_running_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->running_status->getErrorMessage(false) ?></div>
<?php if (!$Page->running_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fvehicle_infosearch", function() {
    var options = { name: "x_running_status", selectId: "fvehicle_infosearch_x_running_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvehicle_infosearch.lists.running_status?.lookupOptions.length) {
        options.data = { id: "x_running_status", form: "fvehicle_infosearch" };
    } else {
        options.ajax = { id: "x_running_status", form: "fvehicle_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.vehicle_info.fields.running_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fvehicle_infosearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fvehicle_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fvehicle_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("vehicle_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
