<?php

namespace PHPMaker2024\fibre;

// Page object
$VehicleInfoAddopt = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { vehicle_info: currentTable } });
var currentPageID = ew.PAGE_ID = "addopt";
var currentForm;
var fvehicle_infoaddopt;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fvehicle_infoaddopt")
        .setPageId("addopt")

        // Add fields
        .setFields([
            ["no", [fields.no.visible && fields.no.required ? ew.Validators.required(fields.no.caption) : null], fields.no.isInvalid],
            ["driver_name", [fields.driver_name.visible && fields.driver_name.required ? ew.Validators.required(fields.driver_name.caption) : null], fields.driver_name.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<form name="fvehicle_infoaddopt" id="fvehicle_infoaddopt" class="ew-form" action="<?= HtmlEncode(GetUrl(Config("API_URL"))) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="<?= Config("API_ACTION_NAME") ?>" id="<?= Config("API_ACTION_NAME") ?>" value="<?= Config("API_ADD_ACTION") ?>">
<input type="hidden" name="<?= Config("API_OBJECT_NAME") ?>" id="<?= Config("API_OBJECT_NAME") ?>" value="vehicle_info">
<input type="hidden" name="addopt" id="addopt" value="1">
<?php if ($Page->no->Visible) { // no ?>
    <div id="r_no"<?= $Page->no->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_no"><?= $Page->no->caption() ?><?= $Page->no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->no->cellAttributes() ?>>
<input type="<?= $Page->no->getInputTextType() ?>" name="x_no" id="x_no" data-table="vehicle_info" data-field="x_no" value="<?= $Page->no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no->formatPattern()) ?>"<?= $Page->no->editAttributes() ?> aria-describedby="x_no_help">
<?= $Page->no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->no->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->driver_name->Visible) { // driver_name ?>
    <div id="r_driver_name"<?= $Page->driver_name->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_driver_name"><?= $Page->driver_name->caption() ?><?= $Page->driver_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->driver_name->cellAttributes() ?>>
<input type="<?= $Page->driver_name->getInputTextType() ?>" name="x_driver_name" id="x_driver_name" data-table="vehicle_info" data-field="x_driver_name" value="<?= $Page->driver_name->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->driver_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->driver_name->formatPattern()) ?>"<?= $Page->driver_name->editAttributes() ?> aria-describedby="x_driver_name_help">
<?= $Page->driver_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->driver_name->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <input type="hidden" data-table="vehicle_info" data-field="x_operator" data-hidden="1" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <input type="hidden" data-table="vehicle_info" data-field="x_datetime" data-hidden="1" name="x_datetime" id="x_datetime" value="<?= HtmlEncode($Page->datetime->CurrentValue) ?>">
<?php } ?>
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("vehicle_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
