<?php

namespace PHPMaker2024\fibre;

// Page object
$VehicleInfoAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { vehicle_info: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fvehicle_infoadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fvehicle_infoadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["vehicle_owner", [fields.vehicle_owner.visible && fields.vehicle_owner.required ? ew.Validators.required(fields.vehicle_owner.caption) : null], fields.vehicle_owner.isInvalid],
            ["no", [fields.no.visible && fields.no.required ? ew.Validators.required(fields.no.caption) : null], fields.no.isInvalid],
            ["driver", [fields.driver.visible && fields.driver.required ? ew.Validators.required(fields.driver.caption) : null], fields.driver.isInvalid],
            ["driver_name", [fields.driver_name.visible && fields.driver_name.required ? ew.Validators.required(fields.driver_name.caption) : null], fields.driver_name.isInvalid],
            ["dor", [fields.dor.visible && fields.dor.required ? ew.Validators.required(fields.dor.caption) : null, ew.Validators.datetime(fields.dor.clientFormatPattern)], fields.dor.isInvalid],
            ["km_hour", [fields.km_hour.visible && fields.km_hour.required ? ew.Validators.required(fields.km_hour.caption) : null, ew.Validators.float], fields.km_hour.isInvalid],
            ["chassis_no", [fields.chassis_no.visible && fields.chassis_no.required ? ew.Validators.required(fields.chassis_no.caption) : null], fields.chassis_no.isInvalid],
            ["engine_no", [fields.engine_no.visible && fields.engine_no.required ? ew.Validators.required(fields.engine_no.caption) : null], fields.engine_no.isInvalid],
            ["load_average", [fields.load_average.visible && fields.load_average.required ? ew.Validators.required(fields.load_average.caption) : null, ew.Validators.float], fields.load_average.isInvalid],
            ["unload_average", [fields.unload_average.visible && fields.unload_average.required ? ew.Validators.required(fields.unload_average.caption) : null, ew.Validators.float], fields.unload_average.isInvalid],
            ["load_expenses", [fields.load_expenses.visible && fields.load_expenses.required ? ew.Validators.required(fields.load_expenses.caption) : null, ew.Validators.float], fields.load_expenses.isInvalid],
            ["unload_expenses", [fields.unload_expenses.visible && fields.unload_expenses.required ? ew.Validators.required(fields.unload_expenses.caption) : null, ew.Validators.float], fields.unload_expenses.isInvalid],
            ["insurance", [fields.insurance.visible && fields.insurance.required ? ew.Validators.required(fields.insurance.caption) : null, ew.Validators.datetime(fields.insurance.clientFormatPattern)], fields.insurance.isInvalid],
            ["state_tax", [fields.state_tax.visible && fields.state_tax.required ? ew.Validators.required(fields.state_tax.caption) : null, ew.Validators.datetime(fields.state_tax.clientFormatPattern)], fields.state_tax.isInvalid],
            ["national_permit", [fields.national_permit.visible && fields.national_permit.required ? ew.Validators.required(fields.national_permit.caption) : null, ew.Validators.datetime(fields.national_permit.clientFormatPattern)], fields.national_permit.isInvalid],
            ["pollution", [fields.pollution.visible && fields.pollution.required ? ew.Validators.required(fields.pollution.caption) : null, ew.Validators.datetime(fields.pollution.clientFormatPattern)], fields.pollution.isInvalid],
            ["fitness", [fields.fitness.visible && fields.fitness.required ? ew.Validators.required(fields.fitness.caption) : null, ew.Validators.datetime(fields.fitness.clientFormatPattern)], fields.fitness.isInvalid],
            ["other_due", [fields.other_due.visible && fields.other_due.required ? ew.Validators.required(fields.other_due.caption) : null, ew.Validators.datetime(fields.other_due.clientFormatPattern)], fields.other_due.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "type": <?= $Page->type->toClientList($Page) ?>,
            "vehicle_owner": <?= $Page->vehicle_owner->toClientList($Page) ?>,
            "driver": <?= $Page->driver->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fvehicle_infoadd" id="fvehicle_infoadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="vehicle_info">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type"<?= $Page->type->rowAttributes() ?>>
        <label id="elh_vehicle_info_type" for="x_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->type->caption() ?><?= $Page->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->type->cellAttributes() ?>>
<span id="el_vehicle_info_type">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="fvehicle_infoadd_x_type"
        <?php } ?>
        data-table="vehicle_info"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <?= $Page->type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage() ?></div>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fvehicle_infoadd", function() {
    var options = { name: "x_type", selectId: "fvehicle_infoadd_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvehicle_infoadd.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "fvehicle_infoadd" };
    } else {
        options.ajax = { id: "x_type", form: "fvehicle_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.vehicle_info.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_owner->Visible) { // vehicle_owner ?>
    <div id="r_vehicle_owner"<?= $Page->vehicle_owner->rowAttributes() ?>>
        <label id="elh_vehicle_info_vehicle_owner" for="x_vehicle_owner" class="<?= $Page->LeftColumnClass ?>"><?= $Page->vehicle_owner->caption() ?><?= $Page->vehicle_owner->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->vehicle_owner->cellAttributes() ?>>
<span id="el_vehicle_info_vehicle_owner">
    <select
        id="x_vehicle_owner"
        name="x_vehicle_owner"
        class="form-select ew-select<?= $Page->vehicle_owner->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_owner->IsNativeSelect) { ?>
        data-select2-id="fvehicle_infoadd_x_vehicle_owner"
        <?php } ?>
        data-table="vehicle_info"
        data-field="x_vehicle_owner"
        data-value-separator="<?= $Page->vehicle_owner->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_owner->getPlaceHolder()) ?>"
        <?= $Page->vehicle_owner->editAttributes() ?>>
        <?= $Page->vehicle_owner->selectOptionListHtml("x_vehicle_owner") ?>
    </select>
    <?= $Page->vehicle_owner->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->vehicle_owner->getErrorMessage() ?></div>
<?= $Page->vehicle_owner->Lookup->getParamTag($Page, "p_x_vehicle_owner") ?>
<?php if (!$Page->vehicle_owner->IsNativeSelect) { ?>
<script>
loadjs.ready("fvehicle_infoadd", function() {
    var options = { name: "x_vehicle_owner", selectId: "fvehicle_infoadd_x_vehicle_owner" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvehicle_infoadd.lists.vehicle_owner?.lookupOptions.length) {
        options.data = { id: "x_vehicle_owner", form: "fvehicle_infoadd" };
    } else {
        options.ajax = { id: "x_vehicle_owner", form: "fvehicle_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.vehicle_info.fields.vehicle_owner.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->no->Visible) { // no ?>
    <div id="r_no"<?= $Page->no->rowAttributes() ?>>
        <label id="elh_vehicle_info_no" for="x_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->no->caption() ?><?= $Page->no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->no->cellAttributes() ?>>
<span id="el_vehicle_info_no">
<input type="<?= $Page->no->getInputTextType() ?>" name="x_no" id="x_no" data-table="vehicle_info" data-field="x_no" value="<?= $Page->no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no->formatPattern()) ?>"<?= $Page->no->editAttributes() ?> aria-describedby="x_no_help">
<?= $Page->no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
    <div id="r_driver"<?= $Page->driver->rowAttributes() ?>>
        <label id="elh_vehicle_info_driver" for="x_driver" class="<?= $Page->LeftColumnClass ?>"><?= $Page->driver->caption() ?><?= $Page->driver->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->driver->cellAttributes() ?>>
<span id="el_vehicle_info_driver">
<div class="input-group flex-nowrap">
    <select
        id="x_driver"
        name="x_driver"
        class="form-select ew-select<?= $Page->driver->isInvalidClass() ?>"
        <?php if (!$Page->driver->IsNativeSelect) { ?>
        data-select2-id="fvehicle_infoadd_x_driver"
        <?php } ?>
        data-table="vehicle_info"
        data-field="x_driver"
        data-value-separator="<?= $Page->driver->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>"
        <?= $Page->driver->editAttributes() ?>>
        <?= $Page->driver->selectOptionListHtml("x_driver") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "t_driver_info") && !$Page->driver->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_driver" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->driver->caption() ?>" data-title="<?= $Page->driver->caption() ?>" data-ew-action="add-option" data-el="x_driver" data-url="<?= GetUrl("tdriverinfoaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->driver->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->driver->getErrorMessage() ?></div>
<?= $Page->driver->Lookup->getParamTag($Page, "p_x_driver") ?>
<?php if (!$Page->driver->IsNativeSelect) { ?>
<script>
loadjs.ready("fvehicle_infoadd", function() {
    var options = { name: "x_driver", selectId: "fvehicle_infoadd_x_driver" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvehicle_infoadd.lists.driver?.lookupOptions.length) {
        options.data = { id: "x_driver", form: "fvehicle_infoadd" };
    } else {
        options.ajax = { id: "x_driver", form: "fvehicle_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.vehicle_info.fields.driver.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->driver_name->Visible) { // driver_name ?>
    <div id="r_driver_name"<?= $Page->driver_name->rowAttributes() ?>>
        <label id="elh_vehicle_info_driver_name" for="x_driver_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->driver_name->caption() ?><?= $Page->driver_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->driver_name->cellAttributes() ?>>
<span id="el_vehicle_info_driver_name">
<input type="<?= $Page->driver_name->getInputTextType() ?>" name="x_driver_name" id="x_driver_name" data-table="vehicle_info" data-field="x_driver_name" value="<?= $Page->driver_name->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->driver_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->driver_name->formatPattern()) ?>"<?= $Page->driver_name->editAttributes() ?> aria-describedby="x_driver_name_help">
<?= $Page->driver_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->driver_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dor->Visible) { // dor ?>
    <div id="r_dor"<?= $Page->dor->rowAttributes() ?>>
        <label id="elh_vehicle_info_dor" for="x_dor" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dor->caption() ?><?= $Page->dor->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dor->cellAttributes() ?>>
<span id="el_vehicle_info_dor">
<input type="<?= $Page->dor->getInputTextType() ?>" name="x_dor" id="x_dor" data-table="vehicle_info" data-field="x_dor" value="<?= $Page->dor->EditValue ?>" placeholder="<?= HtmlEncode($Page->dor->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dor->formatPattern()) ?>"<?= $Page->dor->editAttributes() ?> aria-describedby="x_dor_help">
<?= $Page->dor->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dor->getErrorMessage() ?></div>
<?php if (!$Page->dor->ReadOnly && !$Page->dor->Disabled && !isset($Page->dor->EditAttrs["readonly"]) && !isset($Page->dor->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infoadd", "x_dor", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->km_hour->Visible) { // km_hour ?>
    <div id="r_km_hour"<?= $Page->km_hour->rowAttributes() ?>>
        <label id="elh_vehicle_info_km_hour" for="x_km_hour" class="<?= $Page->LeftColumnClass ?>"><?= $Page->km_hour->caption() ?><?= $Page->km_hour->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->km_hour->cellAttributes() ?>>
<span id="el_vehicle_info_km_hour">
<input type="<?= $Page->km_hour->getInputTextType() ?>" name="x_km_hour" id="x_km_hour" data-table="vehicle_info" data-field="x_km_hour" value="<?= $Page->km_hour->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->km_hour->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->km_hour->formatPattern()) ?>"<?= $Page->km_hour->editAttributes() ?> aria-describedby="x_km_hour_help">
<?= $Page->km_hour->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->km_hour->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->chassis_no->Visible) { // chassis_no ?>
    <div id="r_chassis_no"<?= $Page->chassis_no->rowAttributes() ?>>
        <label id="elh_vehicle_info_chassis_no" for="x_chassis_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->chassis_no->caption() ?><?= $Page->chassis_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->chassis_no->cellAttributes() ?>>
<span id="el_vehicle_info_chassis_no">
<input type="<?= $Page->chassis_no->getInputTextType() ?>" name="x_chassis_no" id="x_chassis_no" data-table="vehicle_info" data-field="x_chassis_no" value="<?= $Page->chassis_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->chassis_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->chassis_no->formatPattern()) ?>"<?= $Page->chassis_no->editAttributes() ?> aria-describedby="x_chassis_no_help">
<?= $Page->chassis_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->chassis_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->engine_no->Visible) { // engine_no ?>
    <div id="r_engine_no"<?= $Page->engine_no->rowAttributes() ?>>
        <label id="elh_vehicle_info_engine_no" for="x_engine_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->engine_no->caption() ?><?= $Page->engine_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->engine_no->cellAttributes() ?>>
<span id="el_vehicle_info_engine_no">
<input type="<?= $Page->engine_no->getInputTextType() ?>" name="x_engine_no" id="x_engine_no" data-table="vehicle_info" data-field="x_engine_no" value="<?= $Page->engine_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->engine_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->engine_no->formatPattern()) ?>"<?= $Page->engine_no->editAttributes() ?> aria-describedby="x_engine_no_help">
<?= $Page->engine_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->engine_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->load_average->Visible) { // load_average ?>
    <div id="r_load_average"<?= $Page->load_average->rowAttributes() ?>>
        <label id="elh_vehicle_info_load_average" for="x_load_average" class="<?= $Page->LeftColumnClass ?>"><?= $Page->load_average->caption() ?><?= $Page->load_average->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->load_average->cellAttributes() ?>>
<span id="el_vehicle_info_load_average">
<input type="<?= $Page->load_average->getInputTextType() ?>" name="x_load_average" id="x_load_average" data-table="vehicle_info" data-field="x_load_average" value="<?= $Page->load_average->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->load_average->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_average->formatPattern()) ?>"<?= $Page->load_average->editAttributes() ?> aria-describedby="x_load_average_help">
<?= $Page->load_average->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->load_average->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->unload_average->Visible) { // unload_average ?>
    <div id="r_unload_average"<?= $Page->unload_average->rowAttributes() ?>>
        <label id="elh_vehicle_info_unload_average" for="x_unload_average" class="<?= $Page->LeftColumnClass ?>"><?= $Page->unload_average->caption() ?><?= $Page->unload_average->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->unload_average->cellAttributes() ?>>
<span id="el_vehicle_info_unload_average">
<input type="<?= $Page->unload_average->getInputTextType() ?>" name="x_unload_average" id="x_unload_average" data-table="vehicle_info" data-field="x_unload_average" value="<?= $Page->unload_average->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->unload_average->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_average->formatPattern()) ?>"<?= $Page->unload_average->editAttributes() ?> aria-describedby="x_unload_average_help">
<?= $Page->unload_average->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->unload_average->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->load_expenses->Visible) { // load_expenses ?>
    <div id="r_load_expenses"<?= $Page->load_expenses->rowAttributes() ?>>
        <label id="elh_vehicle_info_load_expenses" for="x_load_expenses" class="<?= $Page->LeftColumnClass ?>"><?= $Page->load_expenses->caption() ?><?= $Page->load_expenses->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->load_expenses->cellAttributes() ?>>
<span id="el_vehicle_info_load_expenses">
<input type="<?= $Page->load_expenses->getInputTextType() ?>" name="x_load_expenses" id="x_load_expenses" data-table="vehicle_info" data-field="x_load_expenses" value="<?= $Page->load_expenses->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->load_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_expenses->formatPattern()) ?>"<?= $Page->load_expenses->editAttributes() ?> aria-describedby="x_load_expenses_help">
<?= $Page->load_expenses->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->load_expenses->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->unload_expenses->Visible) { // unload_expenses ?>
    <div id="r_unload_expenses"<?= $Page->unload_expenses->rowAttributes() ?>>
        <label id="elh_vehicle_info_unload_expenses" for="x_unload_expenses" class="<?= $Page->LeftColumnClass ?>"><?= $Page->unload_expenses->caption() ?><?= $Page->unload_expenses->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->unload_expenses->cellAttributes() ?>>
<span id="el_vehicle_info_unload_expenses">
<input type="<?= $Page->unload_expenses->getInputTextType() ?>" name="x_unload_expenses" id="x_unload_expenses" data-table="vehicle_info" data-field="x_unload_expenses" value="<?= $Page->unload_expenses->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->unload_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_expenses->formatPattern()) ?>"<?= $Page->unload_expenses->editAttributes() ?> aria-describedby="x_unload_expenses_help">
<?= $Page->unload_expenses->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->unload_expenses->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->insurance->Visible) { // insurance ?>
    <div id="r_insurance"<?= $Page->insurance->rowAttributes() ?>>
        <label id="elh_vehicle_info_insurance" for="x_insurance" class="<?= $Page->LeftColumnClass ?>"><?= $Page->insurance->caption() ?><?= $Page->insurance->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->insurance->cellAttributes() ?>>
<span id="el_vehicle_info_insurance">
<input type="<?= $Page->insurance->getInputTextType() ?>" name="x_insurance" id="x_insurance" data-table="vehicle_info" data-field="x_insurance" value="<?= $Page->insurance->EditValue ?>" placeholder="<?= HtmlEncode($Page->insurance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->insurance->formatPattern()) ?>"<?= $Page->insurance->editAttributes() ?> aria-describedby="x_insurance_help">
<?= $Page->insurance->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->insurance->getErrorMessage() ?></div>
<?php if (!$Page->insurance->ReadOnly && !$Page->insurance->Disabled && !isset($Page->insurance->EditAttrs["readonly"]) && !isset($Page->insurance->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infoadd", "x_insurance", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->state_tax->Visible) { // state_tax ?>
    <div id="r_state_tax"<?= $Page->state_tax->rowAttributes() ?>>
        <label id="elh_vehicle_info_state_tax" for="x_state_tax" class="<?= $Page->LeftColumnClass ?>"><?= $Page->state_tax->caption() ?><?= $Page->state_tax->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->state_tax->cellAttributes() ?>>
<span id="el_vehicle_info_state_tax">
<input type="<?= $Page->state_tax->getInputTextType() ?>" name="x_state_tax" id="x_state_tax" data-table="vehicle_info" data-field="x_state_tax" value="<?= $Page->state_tax->EditValue ?>" placeholder="<?= HtmlEncode($Page->state_tax->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->state_tax->formatPattern()) ?>"<?= $Page->state_tax->editAttributes() ?> aria-describedby="x_state_tax_help">
<?= $Page->state_tax->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->state_tax->getErrorMessage() ?></div>
<?php if (!$Page->state_tax->ReadOnly && !$Page->state_tax->Disabled && !isset($Page->state_tax->EditAttrs["readonly"]) && !isset($Page->state_tax->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infoadd", "x_state_tax", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->national_permit->Visible) { // national_permit ?>
    <div id="r_national_permit"<?= $Page->national_permit->rowAttributes() ?>>
        <label id="elh_vehicle_info_national_permit" for="x_national_permit" class="<?= $Page->LeftColumnClass ?>"><?= $Page->national_permit->caption() ?><?= $Page->national_permit->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->national_permit->cellAttributes() ?>>
<span id="el_vehicle_info_national_permit">
<input type="<?= $Page->national_permit->getInputTextType() ?>" name="x_national_permit" id="x_national_permit" data-table="vehicle_info" data-field="x_national_permit" value="<?= $Page->national_permit->EditValue ?>" placeholder="<?= HtmlEncode($Page->national_permit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->national_permit->formatPattern()) ?>"<?= $Page->national_permit->editAttributes() ?> aria-describedby="x_national_permit_help">
<?= $Page->national_permit->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->national_permit->getErrorMessage() ?></div>
<?php if (!$Page->national_permit->ReadOnly && !$Page->national_permit->Disabled && !isset($Page->national_permit->EditAttrs["readonly"]) && !isset($Page->national_permit->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infoadd", "x_national_permit", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pollution->Visible) { // pollution ?>
    <div id="r_pollution"<?= $Page->pollution->rowAttributes() ?>>
        <label id="elh_vehicle_info_pollution" for="x_pollution" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pollution->caption() ?><?= $Page->pollution->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pollution->cellAttributes() ?>>
<span id="el_vehicle_info_pollution">
<input type="<?= $Page->pollution->getInputTextType() ?>" name="x_pollution" id="x_pollution" data-table="vehicle_info" data-field="x_pollution" value="<?= $Page->pollution->EditValue ?>" placeholder="<?= HtmlEncode($Page->pollution->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pollution->formatPattern()) ?>"<?= $Page->pollution->editAttributes() ?> aria-describedby="x_pollution_help">
<?= $Page->pollution->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->pollution->getErrorMessage() ?></div>
<?php if (!$Page->pollution->ReadOnly && !$Page->pollution->Disabled && !isset($Page->pollution->EditAttrs["readonly"]) && !isset($Page->pollution->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infoadd", "x_pollution", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->fitness->Visible) { // fitness ?>
    <div id="r_fitness"<?= $Page->fitness->rowAttributes() ?>>
        <label id="elh_vehicle_info_fitness" for="x_fitness" class="<?= $Page->LeftColumnClass ?>"><?= $Page->fitness->caption() ?><?= $Page->fitness->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->fitness->cellAttributes() ?>>
<span id="el_vehicle_info_fitness">
<input type="<?= $Page->fitness->getInputTextType() ?>" name="x_fitness" id="x_fitness" data-table="vehicle_info" data-field="x_fitness" value="<?= $Page->fitness->EditValue ?>" placeholder="<?= HtmlEncode($Page->fitness->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fitness->formatPattern()) ?>"<?= $Page->fitness->editAttributes() ?> aria-describedby="x_fitness_help">
<?= $Page->fitness->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->fitness->getErrorMessage() ?></div>
<?php if (!$Page->fitness->ReadOnly && !$Page->fitness->Disabled && !isset($Page->fitness->EditAttrs["readonly"]) && !isset($Page->fitness->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infoadd", "x_fitness", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other_due->Visible) { // other_due ?>
    <div id="r_other_due"<?= $Page->other_due->rowAttributes() ?>>
        <label id="elh_vehicle_info_other_due" for="x_other_due" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other_due->caption() ?><?= $Page->other_due->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other_due->cellAttributes() ?>>
<span id="el_vehicle_info_other_due">
<input type="<?= $Page->other_due->getInputTextType() ?>" name="x_other_due" id="x_other_due" data-table="vehicle_info" data-field="x_other_due" value="<?= $Page->other_due->EditValue ?>" placeholder="<?= HtmlEncode($Page->other_due->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_due->formatPattern()) ?>"<?= $Page->other_due->editAttributes() ?> aria-describedby="x_other_due_help">
<?= $Page->other_due->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other_due->getErrorMessage() ?></div>
<?php if (!$Page->other_due->ReadOnly && !$Page->other_due->Disabled && !isset($Page->other_due->EditAttrs["readonly"]) && !isset($Page->other_due->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fvehicle_infoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fvehicle_infoadd", "x_other_due", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_vehicle_info_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_vehicle_info_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fvehicle_infoadd_x_status"
        <?php } ?>
        data-table="vehicle_info"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fvehicle_infoadd", function() {
    var options = { name: "x_status", selectId: "fvehicle_infoadd_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvehicle_infoadd.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fvehicle_infoadd" };
    } else {
        options.ajax = { id: "x_status", form: "fvehicle_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.vehicle_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fvehicle_infoadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fvehicle_infoadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("vehicle_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    $("#r_vehicle_owner").hide();
});
</script>
