<?php

namespace PHPMaker2024\fibre;

// Page object
$UserSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { user: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fusersearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fusersearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["mobile", [], fields.mobile.isInvalid],
            ["user_name", [], fields.user_name.isInvalid],
            ["_password", [], fields._password.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["_email", [], fields._email.isInvalid],
            ["gst_number", [], fields.gst_number.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["last_login", [ew.Validators.datetime(fields.last_login.clientFormatPattern)], fields.last_login.isInvalid],
            ["reg_date", [ew.Validators.datetime(fields.reg_date.clientFormatPattern)], fields.reg_date.isInvalid],
            ["reg_device", [ew.Validators.integer], fields.reg_device.isInvalid],
            ["app_version", [ew.Validators.integer], fields.app_version.isInvalid],
            ["device_id", [], fields.device_id.isInvalid],
            ["device_token_id", [], fields.device_token_id.isInvalid],
            ["cart_number", [ew.Validators.integer], fields.cart_number.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["max_discount", [ew.Validators.float], fields.max_discount.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "mobile": <?= $Page->mobile->toClientList($Page) ?>,
            "name": <?= $Page->name->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fusersearch" id="fusersearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="user">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_mobile" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->mobile->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_mobile" class="ew-auto-suggest">
    <input type="<?= $Page->mobile->getInputTextType() ?>" class="form-control" name="sv_x_mobile" id="sv_x_mobile" value="<?= RemoveHtml($Page->mobile->EditValue) ?>" autocomplete="off" size="30" maxlength="22" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="user" data-field="x_mobile" data-input="sv_x_mobile" data-value-separator="<?= $Page->mobile->displayValueSeparatorAttribute() ?>" name="x_mobile" id="x_mobile" value="<?= HtmlEncode($Page->mobile->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fusersearch", function() {
    fusersearch.createAutoSuggest(Object.assign({"id":"x_mobile","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->mobile->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.user.fields.mobile.autoSuggestOptions));
});
</script>
<?= $Page->mobile->Lookup->getParamTag($Page, "p_x_mobile") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->user_name->Visible) { // user_name ?>
    <div id="r_user_name" class="row"<?= $Page->user_name->rowAttributes() ?>>
        <label for="x_user_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_user_name"><?= $Page->user_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_user_name" id="z_user_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->user_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_user_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->user_name->getInputTextType() ?>" name="x_user_name" id="x_user_name" data-table="user" data-field="x_user_name" value="<?= $Page->user_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->user_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user_name->formatPattern()) ?>"<?= $Page->user_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->user_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_password->Visible) { // password ?>
    <div id="r__password" class="row"<?= $Page->_password->rowAttributes() ?>>
        <label for="x__password" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user__password"><?= $Page->_password->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__password" id="z__password" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_password->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user__password" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_password->getInputTextType() ?>" name="x__password" id="x__password" data-table="user" data-field="x__password" value="<?= $Page->_password->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->_password->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_password->formatPattern()) ?>"<?= $Page->_password->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_password->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_name" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->name->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_name" class="ew-auto-suggest">
    <input type="<?= $Page->name->getInputTextType() ?>" class="form-control" name="sv_x_name" id="sv_x_name" value="<?= RemoveHtml($Page->name->EditValue) ?>" autocomplete="off" size="30" maxlength="1000" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="user" data-field="x_name" data-input="sv_x_name" data-value-separator="<?= $Page->name->displayValueSeparatorAttribute() ?>" name="x_name" id="x_name" value="<?= HtmlEncode($Page->name->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fusersearch", function() {
    fusersearch.createAutoSuggest(Object.assign({"id":"x_name","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->name->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.user.fields.name.autoSuggestOptions));
});
</script>
<?= $Page->name->Lookup->getParamTag($Page, "p_x_name") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email" class="row"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user__email"><?= $Page->_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__email" id="z__email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="user" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gst_number->Visible) { // gst_number ?>
    <div id="r_gst_number" class="row"<?= $Page->gst_number->rowAttributes() ?>>
        <label for="x_gst_number" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_gst_number"><?= $Page->gst_number->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_gst_number" id="z_gst_number" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gst_number->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_gst_number" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gst_number->getInputTextType() ?>" name="x_gst_number" id="x_gst_number" data-table="user" data-field="x_gst_number" value="<?= $Page->gst_number->EditValue ?>" size="30" maxlength="16" placeholder="<?= HtmlEncode($Page->gst_number->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gst_number->formatPattern()) ?>"<?= $Page->gst_number->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gst_number->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_category" id="z_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_category" class="ew-search-field ew-search-field-single">
<template id="tp_x_category">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="user" data-field="x_category" name="x_category" id="x_category"<?= $Page->category->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_category" class="ew-item-list"></div>
<selection-list hidden
    id="x_category[]"
    name="x_category[]"
    value="<?= HtmlEncode($Page->category->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_category"
    data-target="dsl_x_category"
    data-repeatcolumn="3"
    class="form-control<?= $Page->category->isInvalidClass() ?>"
    data-table="user"
    data-field="x_category"
    data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
    <?= $Page->category->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->last_login->Visible) { // last_login ?>
    <div id="r_last_login" class="row"<?= $Page->last_login->rowAttributes() ?>>
        <label for="x_last_login" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_last_login"><?= $Page->last_login->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_last_login" id="z_last_login" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->last_login->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_last_login" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->last_login->getInputTextType() ?>" name="x_last_login" id="x_last_login" data-table="user" data-field="x_last_login" value="<?= $Page->last_login->EditValue ?>" placeholder="<?= HtmlEncode($Page->last_login->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->last_login->formatPattern()) ?>"<?= $Page->last_login->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->last_login->getErrorMessage(false) ?></div>
<?php if (!$Page->last_login->ReadOnly && !$Page->last_login->Disabled && !isset($Page->last_login->EditAttrs["readonly"]) && !isset($Page->last_login->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fusersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fusersearch", "x_last_login", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reg_date->Visible) { // reg_date ?>
    <div id="r_reg_date" class="row"<?= $Page->reg_date->rowAttributes() ?>>
        <label for="x_reg_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_reg_date"><?= $Page->reg_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_reg_date" id="z_reg_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reg_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_reg_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->reg_date->getInputTextType() ?>" name="x_reg_date" id="x_reg_date" data-table="user" data-field="x_reg_date" value="<?= $Page->reg_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->reg_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reg_date->formatPattern()) ?>"<?= $Page->reg_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->reg_date->getErrorMessage(false) ?></div>
<?php if (!$Page->reg_date->ReadOnly && !$Page->reg_date->Disabled && !isset($Page->reg_date->EditAttrs["readonly"]) && !isset($Page->reg_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fusersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fusersearch", "x_reg_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reg_device->Visible) { // reg_device ?>
    <div id="r_reg_device" class="row"<?= $Page->reg_device->rowAttributes() ?>>
        <label for="x_reg_device" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_reg_device"><?= $Page->reg_device->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_reg_device" id="z_reg_device" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reg_device->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_reg_device" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->reg_device->getInputTextType() ?>" name="x_reg_device" id="x_reg_device" data-table="user" data-field="x_reg_device" value="<?= $Page->reg_device->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->reg_device->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reg_device->formatPattern()) ?>"<?= $Page->reg_device->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->reg_device->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->app_version->Visible) { // app_version ?>
    <div id="r_app_version" class="row"<?= $Page->app_version->rowAttributes() ?>>
        <label for="x_app_version" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_app_version"><?= $Page->app_version->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_app_version" id="z_app_version" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->app_version->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_app_version" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->app_version->getInputTextType() ?>" name="x_app_version" id="x_app_version" data-table="user" data-field="x_app_version" value="<?= $Page->app_version->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->app_version->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->app_version->formatPattern()) ?>"<?= $Page->app_version->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->app_version->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->device_id->Visible) { // device_id ?>
    <div id="r_device_id" class="row"<?= $Page->device_id->rowAttributes() ?>>
        <label for="x_device_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_device_id"><?= $Page->device_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_device_id" id="z_device_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->device_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_device_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->device_id->getInputTextType() ?>" name="x_device_id" id="x_device_id" data-table="user" data-field="x_device_id" value="<?= $Page->device_id->EditValue ?>" size="30" maxlength="30" placeholder="<?= HtmlEncode($Page->device_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->device_id->formatPattern()) ?>"<?= $Page->device_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->device_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->device_token_id->Visible) { // device_token_id ?>
    <div id="r_device_token_id" class="row"<?= $Page->device_token_id->rowAttributes() ?>>
        <label for="x_device_token_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_device_token_id"><?= $Page->device_token_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_device_token_id" id="z_device_token_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->device_token_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_device_token_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->device_token_id->getInputTextType() ?>" name="x_device_token_id" id="x_device_token_id" data-table="user" data-field="x_device_token_id" value="<?= $Page->device_token_id->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->device_token_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->device_token_id->formatPattern()) ?>"<?= $Page->device_token_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->device_token_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cart_number->Visible) { // cart_number ?>
    <div id="r_cart_number" class="row"<?= $Page->cart_number->rowAttributes() ?>>
        <label for="x_cart_number" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_cart_number"><?= $Page->cart_number->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cart_number" id="z_cart_number" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cart_number->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_cart_number" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cart_number->getInputTextType() ?>" name="x_cart_number" id="x_cart_number" data-table="user" data-field="x_cart_number" value="<?= $Page->cart_number->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cart_number->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_number->formatPattern()) ?>"<?= $Page->cart_number->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cart_number->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_status" id="z_status" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fusersearch_x_status"
        <?php } ?>
        data-table="user"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fusersearch", function() {
    var options = { name: "x_status", selectId: "fusersearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fusersearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fusersearch" };
    } else {
        options.ajax = { id: "x_status", form: "fusersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.user.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_operator" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->operator->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_operator" class="ew-auto-suggest">
    <input type="<?= $Page->operator->getInputTextType() ?>" class="form-control" name="sv_x_operator" id="sv_x_operator" value="<?= RemoveHtml($Page->operator->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="user" data-field="x_operator" data-input="sv_x_operator" data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fusersearch", function() {
    fusersearch.createAutoSuggest(Object.assign({"id":"x_operator","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->operator->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.user.fields.operator.autoSuggestOptions));
});
</script>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="user" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fusersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fusersearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="user" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->max_discount->Visible) { // max_discount ?>
    <div id="r_max_discount" class="row"<?= $Page->max_discount->rowAttributes() ?>>
        <label for="x_max_discount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_user_max_discount"><?= $Page->max_discount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_max_discount" id="z_max_discount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->max_discount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_user_max_discount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->max_discount->getInputTextType() ?>" name="x_max_discount" id="x_max_discount" data-table="user" data-field="x_max_discount" value="<?= $Page->max_discount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->max_discount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->max_discount->formatPattern()) ?>"<?= $Page->max_discount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->max_discount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fusersearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fusersearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fusersearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("user");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
