<?php

namespace PHPMaker2024\fibre;

// Page object
$UserEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fuseredit" id="fuseredit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { user: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fuseredit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fuseredit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null], fields.mobile.isInvalid],
            ["user_name", [fields.user_name.visible && fields.user_name.required ? ew.Validators.required(fields.user_name.caption) : null], fields.user_name.isInvalid],
            ["_password", [fields._password.visible && fields._password.required ? ew.Validators.required(fields._password.caption) : null], fields._password.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null], fields._email.isInvalid],
            ["gst_number", [fields.gst_number.visible && fields.gst_number.required ? ew.Validators.required(fields.gst_number.caption) : null], fields.gst_number.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["max_discount", [fields.max_discount.visible && fields.max_discount.required ? ew.Validators.required(fields.max_discount.caption) : null, ew.Validators.float], fields.max_discount.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "mobile": <?= $Page->mobile->toClientList($Page) ?>,
            "name": <?= $Page->name->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="user">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_user_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_user_mobile">
<?php
if (IsRTL()) {
    $Page->mobile->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_mobile" class="ew-auto-suggest">
    <input type="<?= $Page->mobile->getInputTextType() ?>" class="form-control" name="sv_x_mobile" id="sv_x_mobile" value="<?= RemoveHtml($Page->mobile->EditValue) ?>" autocomplete="off" size="30" maxlength="22" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
</span>
<selection-list hidden class="form-control" data-table="user" data-field="x_mobile" data-input="sv_x_mobile" data-value-separator="<?= $Page->mobile->displayValueSeparatorAttribute() ?>" name="x_mobile" id="x_mobile" value="<?= HtmlEncode($Page->mobile->CurrentValue) ?>"></selection-list>
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
<script>
loadjs.ready("fuseredit", function() {
    fuseredit.createAutoSuggest(Object.assign({"id":"x_mobile","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->mobile->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.user.fields.mobile.autoSuggestOptions));
});
</script>
<?= $Page->mobile->Lookup->getParamTag($Page, "p_x_mobile") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->user_name->Visible) { // user_name ?>
    <div id="r_user_name"<?= $Page->user_name->rowAttributes() ?>>
        <label id="elh_user_user_name" for="x_user_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->user_name->caption() ?><?= $Page->user_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->user_name->cellAttributes() ?>>
<span id="el_user_user_name">
<input type="<?= $Page->user_name->getInputTextType() ?>" name="x_user_name" id="x_user_name" data-table="user" data-field="x_user_name" value="<?= $Page->user_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->user_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user_name->formatPattern()) ?>"<?= $Page->user_name->editAttributes() ?> aria-describedby="x_user_name_help">
<?= $Page->user_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->user_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_password->Visible) { // password ?>
    <div id="r__password"<?= $Page->_password->rowAttributes() ?>>
        <label id="elh_user__password" for="x__password" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_password->caption() ?><?= $Page->_password->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_password->cellAttributes() ?>>
<span id="el_user__password">
<input type="<?= $Page->_password->getInputTextType() ?>" name="x__password" id="x__password" data-table="user" data-field="x__password" value="<?= $Page->_password->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->_password->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_password->formatPattern()) ?>"<?= $Page->_password->editAttributes() ?> aria-describedby="x__password_help">
<?= $Page->_password->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_password->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name"<?= $Page->name->rowAttributes() ?>>
        <label id="elh_user_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->name->caption() ?><?= $Page->name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->name->cellAttributes() ?>>
<span id="el_user_name">
<?php
if (IsRTL()) {
    $Page->name->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_name" class="ew-auto-suggest">
    <input type="<?= $Page->name->getInputTextType() ?>" class="form-control" name="sv_x_name" id="sv_x_name" value="<?= RemoveHtml($Page->name->EditValue) ?>" autocomplete="off" size="30" maxlength="1000" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?> aria-describedby="x_name_help">
</span>
<selection-list hidden class="form-control" data-table="user" data-field="x_name" data-input="sv_x_name" data-value-separator="<?= $Page->name->displayValueSeparatorAttribute() ?>" name="x_name" id="x_name" value="<?= HtmlEncode($Page->name->CurrentValue) ?>"></selection-list>
<?= $Page->name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage() ?></div>
<script>
loadjs.ready("fuseredit", function() {
    fuseredit.createAutoSuggest(Object.assign({"id":"x_name","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->name->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.user.fields.name.autoSuggestOptions));
});
</script>
<?= $Page->name->Lookup->getParamTag($Page, "p_x_name") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label id="elh_user__email" for="x__email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_email->caption() ?><?= $Page->_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_email->cellAttributes() ?>>
<span id="el_user__email">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="user" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
<?= $Page->_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gst_number->Visible) { // gst_number ?>
    <div id="r_gst_number"<?= $Page->gst_number->rowAttributes() ?>>
        <label id="elh_user_gst_number" for="x_gst_number" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gst_number->caption() ?><?= $Page->gst_number->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gst_number->cellAttributes() ?>>
<span id="el_user_gst_number">
<input type="<?= $Page->gst_number->getInputTextType() ?>" name="x_gst_number" id="x_gst_number" data-table="user" data-field="x_gst_number" value="<?= $Page->gst_number->EditValue ?>" size="30" maxlength="16" placeholder="<?= HtmlEncode($Page->gst_number->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gst_number->formatPattern()) ?>"<?= $Page->gst_number->editAttributes() ?> aria-describedby="x_gst_number_help">
<?= $Page->gst_number->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->gst_number->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_user_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_user_category">
<template id="tp_x_category">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="user" data-field="x_category" name="x_category" id="x_category"<?= $Page->category->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_category" class="ew-item-list"></div>
<selection-list hidden
    id="x_category[]"
    name="x_category[]"
    value="<?= HtmlEncode($Page->category->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_category"
    data-target="dsl_x_category"
    data-repeatcolumn="3"
    class="form-control<?= $Page->category->isInvalidClass() ?>"
    data-table="user"
    data-field="x_category"
    data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
    <?= $Page->category->editAttributes() ?>></selection-list>
<?= $Page->category->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_user_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_user_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fuseredit_x_status"
        <?php } ?>
        data-table="user"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fuseredit", function() {
    var options = { name: "x_status", selectId: "fuseredit_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fuseredit.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fuseredit" };
    } else {
        options.ajax = { id: "x_status", form: "fuseredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.user.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_user_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_user_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="user" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->max_discount->Visible) { // max_discount ?>
    <div id="r_max_discount"<?= $Page->max_discount->rowAttributes() ?>>
        <label id="elh_user_max_discount" for="x_max_discount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->max_discount->caption() ?><?= $Page->max_discount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->max_discount->cellAttributes() ?>>
<span id="el_user_max_discount">
<input type="<?= $Page->max_discount->getInputTextType() ?>" name="x_max_discount" id="x_max_discount" data-table="user" data-field="x_max_discount" value="<?= $Page->max_discount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->max_discount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->max_discount->formatPattern()) ?>"<?= $Page->max_discount->editAttributes() ?> aria-describedby="x_max_discount_help">
<?= $Page->max_discount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->max_discount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fuseredit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fuseredit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("user");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
