<?php

namespace PHPMaker2024\fibre;

// Page object
$UpdateEvent = &$Page;
?>
<?php
$Page->showMessage();
?>
<?php
// Fetch dropdown data - fetch full event IDs matching family_info.event storage
$eventList = ExecuteRows("SELECT id, event_name as `event` FROM family_event_list WHERE event_type = 0 AND status = 1 ORDER BY event_name");
$catList = ExecuteRows("SELECT `id`, `item` as `cat` FROM `family_misc` WHERE `grp` = 4 AND `status` = 1 ORDER BY `item`");
$subEventList = [];
// Read selected filters
$selectedCatCsv = $_GET['cat_id'] ?? '';
$selectedEventCsv = $_GET['event_id'] ?? '';
$selectedSubEventCsv = $_GET['sub_event_id'] ?? '';
$selectedQuantityFilter = $_GET['quantity_filter'] ?? 'all';
$selectedCatId = $selectedCatCsv !== '' ? explode(',', $selectedCatCsv) : [];
$selectedEventId = $selectedEventCsv !== '' ? explode(',', $selectedEventCsv) : [];
$selectedSubEventId = $selectedSubEventCsv !== '' ? explode(',', $selectedSubEventCsv) : [];
$selectedCatId = array_filter($selectedCatId, fn($v) => trim($v) !== '');
$selectedEventId = array_filter($selectedEventId, fn($v) => trim($v) !== '');
$selectedSubEventId = array_filter($selectedSubEventId, fn($v) => trim($v) !== '');
$selectedCatId = array_map('intval', $selectedCatId);
$selectedEventId = array_map('intval', $selectedEventId);
$selectedSubEventId = array_map('intval', $selectedSubEventId);
// Keep only single selection for event ID (first one only)
if (count($selectedEventId) > 1)
{
    $selectedEventId = [$selectedEventId[0]];
}
// Only single selection for All Category
$isAllSelected = in_array(-1, $selectedCatId);
if ($isAllSelected && count($selectedCatId) > 1)
{
    $selectedCatId = [-1];
}
if (in_array(0, $selectedCatId) && count($selectedCatId) > 1)
{
    $selectedCatId = [0];
}
if (count($selectedEventId) > 0 && $selectedEventId[0] > 0)
{
    $subEventList = ExecuteRows("SELECT CAST(RIGHT(CAST(event_id AS CHAR), 2) AS UNSIGNED) as id, sub_event FROM family_event_list WHERE event_name = " . intval($selectedEventId[0]) . " AND status = 1 ORDER BY sub_event");
}
// Handle POST update (incl. Update Participation Counts)
if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    // Batch Participation Counts logic
    if (isset($_POST['participation']) && isset($_POST['current_event']))
    {
        $eventId = (int)$_POST['current_event'];
        $participation = $_POST['participation'];
        foreach ($participation as $familyId => $subevents)
        {
            // Build update part for subevents
            $updateCols = [];
            $insertCols = ['family_id', 'event_id'];
            $insertVals = [$familyId, $eventId];
            foreach ($subevents as $subId => $val)
            {
                $cnt = intval($val);
                $colName = 'event_' . intval($subId);
                $updateCols[] = "$colName = $cnt";
                $insertCols[] = $colName;
                $insertVals[] = $cnt;
            }
            // Check if already exists
            $exists = ExecuteScalar("SELECT id FROM family_event_estimate WHERE family_id = $familyId AND event_id = $eventId");
            if ($exists)
            {
                // Update only subevent columns
                $updateColsString = implode(', ', $updateCols);
                ExecuteStatement("UPDATE family_event_estimate SET $updateColsString WHERE id = $exists");
            }
            else
            {
                // Insert new row with subevent columns
                $insertColsString = implode(', ', $insertCols);
                $insertValsQuoted = array_map(function ($v)
                {
                    return is_int($v) ? $v : "'" . addslashes($v) . "'";
                }
                , $insertVals);
                $insertValsString = implode(', ', $insertValsQuoted);
                ExecuteStatement("INSERT INTO family_event_estimate ($insertColsString) VALUES ($insertValsString)");
            }
        }
        echo '<p style="color:green; font-weight:bold;">Participation counts updated successfully.</p>';
    }
    // Updated "Update Event Membership" logic using JSON checkbox states from client
    elseif (isset($_POST['checkbox_states_json'], $_POST['current_event'], $_POST['cat_event']))
    {
        // Decode JSON containing all visible checkboxes states (checked=true, unchecked=false)
        $checkboxStates = json_decode($_POST['checkbox_states_json'], true);
        $eventId = (int)$_POST['current_event'];
        if ($checkboxStates !== null && $eventId > 0)
        {
            $selectedIds = [];
            $unselectedIds = [];
            // Separate selected and unselected IDs from JSON
            foreach ($checkboxStates as $fid => $isChecked)
            {
                $fidInt = (int)$fid;
                if ($isChecked)
                {
                    $selectedIds[] = $fidInt;
                }
                else
                {
                    $unselectedIds[] = $fidInt;
                }
            }
            if (!empty($selectedIds))
            {
                $fid = implode(',', $selectedIds);
                echo "UPDATE `family_info` SET `event` = concat_ws(',', `event`, '$eventId') WHERE `id` IN ($fid)";
                ExecuteStatement("UPDATE `family_info` SET `event` = concat_ws(',', `event`, '$eventId') WHERE `id` IN ($fid)");
            }
            if (!empty($unselectedIds))
            {
                $unfid = implode(',', $unselectedIds);
                ExecuteStatement("UPDATE `family_info` SET `event` = REPLACE(CONCAT(',', `event`, ','), ',$eventId,', ',') WHERE `id` IN ($unfid)");
                ExecuteStatement("UPDATE `family_info` SET `event` = TRIM(BOTH ',' FROM `event`) WHERE `id` IN ($unfid)");
            }
            echo '<p style="color:green; font-weight:bold;">Selected family members updated successfully.</p>';
        }
        else
        {
            echo '<p style="color:red; font-weight:bold;">Invalid data received.</p>';
        }
    }
}
$familyId = $pid = isset($_GET['pid']) ? (int)$_GET['pid'] : 1000;
/* ---------- FUNCTIONS ---------- */
function fetchFamilyMembersFlatView($selectedCatId, $selectedSubEventId, $selectedEventId, $selectedQuantityFilter)
{
    $isAllSelected = in_array(-1, $selectedCatId);
    $useFlatViewAllRecords = false;
    if (!empty($selectedSubEventId) && (in_array(0, $selectedCatId) || $isAllSelected))
    {
        $useFlatViewAllRecords = true;
    }
    $catFilter = $useFlatViewAllRecords ? [] : $selectedCatId;
    if ($isAllSelected) $catFilter = [];
    if (in_array(0, $catFilter)) return '';
    if (empty($selectedSubEventId))
    {
        return '<p>No Sub Events selected.</p>';
    }
    $eventIdInt = intval($selectedEventId[0] ?? 0);
    $EventwhereClause = " AND FIND_IN_SET($eventIdInt, `family_info`.`event`) ";
    if (!empty($catFilter))
    {
        $whereClause = "`category` IN (" . implode(',', array_map('intval', $catFilter)) . ")";
    }
    else
    {
        $whereClause = "1=1";
    }
    $rows = ExecuteRows("
        SELECT 
            `family_info`.`id`, ifnull(`mobile`,0) as `mobile`, ifnull(`mobile_spouse`,0) as `mobile_s`, `name`, `sequence`, `category`,
            `name` AS `fullname`, `city_name` as `city`, group_concat(distinct `family_misc`.`item`) as `category` 
        FROM `family_info` left join `family_misc` on FIND_IN_SET(`family_misc`.`id`, `family_info`.`category`)
        WHERE $whereClause $EventwhereClause AND `family_info`.`id` > 1000 group by `family_info`.`id`
        ORDER BY `sort_order` ASC
    ");
    if (!$rows)
    {
        return '<p>No family members found for the selected categories.</p>';
    }
    $ids = implode(',', array_map('intval', $selectedSubEventId));
    $subEvents = ExecuteRows("SELECT CAST(RIGHT(CAST(event_id AS CHAR), 2) AS UNSIGNED) as id, sub_event FROM family_event_list WHERE  event_name = " . intval($selectedEventId[0]) . " AND CAST(RIGHT(CAST(event_id AS CHAR), 2) AS UNSIGNED) IN ($ids) ORDER BY FIELD(CAST(RIGHT(CAST(event_id AS CHAR), 2) AS UNSIGNED), $ids)");
    $familyIds = array_column($rows, 'id');
    $eventId = $selectedEventId[0];
    $estimates = [];
    if ($familyIds)
    {
        $familyIdsList = implode(',', array_map('intval', $familyIds));
        $eventCols = array_map(fn($subId) => 'event_' . intval($subId) , $selectedSubEventId);
        $eventColsList = implode(', ', $eventCols);
        $selectedSubEventId = array_map('intval', $selectedSubEventId); // ensure integer
        $quantityCondition = '';
        if (!empty($selectedSubEventId))
        {
            switch ($selectedQuantityFilter)
            {
                case 'gt0' : $ors = [];
                foreach ($selectedSubEventId as $subId)
                {
                    $ors[] = "event_{$subId} > 0";
                }
                $quantityCondition = $ors ? ' AND (' . implode(' OR ', $ors) . ') ' : '';
            break;
            case 'eq0' : $ands = [];
            foreach ($selectedSubEventId as $subId)
            {
                $ands[] = "event_{$subId} = 0";
            }
            $quantityCondition = $ands ? ' AND (' . implode(' AND ', $ands) . ') ' : '';
        break;
        default : $quantityCondition = '';
}
}
$sql = "SELECT * FROM family_event_estimate WHERE event_id = $eventId $quantityCondition";
$estimateRows = ExecuteRows($sql);
if ($selectedQuantityFilter !== 'all')
{
    $filteredEstimateRows = [];
    foreach ($estimateRows as $row)
    {
        $eventQtys = [];
        foreach ($selectedSubEventId as $subId)
        {
            $colName = 'event_' . intval($subId);
            $eventQtys[] = isset($row[$colName]) ? intval($row[$colName]) : 0;
        }
        // Apply filter
        if ($selectedQuantityFilter === 'gt0' && max($eventQtys) > 0)
        {
            $filteredEstimateRows[] = $row;
        }
        if ($selectedQuantityFilter === 'eq0' && max($eventQtys) === 0)
        {
            $filteredEstimateRows[] = $row;
        }
    }
    $estimateRows = $filteredEstimateRows;
    $familyIds = array_column($estimateRows, 'family_id');
    $rows = array_filter($rows, function ($member) use ($familyIds)
    {
        return in_array($member['id'], $familyIds);
    });
}
foreach ($estimateRows as $row)
{
    foreach ($selectedSubEventId as $subId)
    {
        $colName = 'event_' . intval($subId);
        $estimates[$row['family_id']][$subId] = isset($row[$colName]) ? intval($row[$colName]) : 0;
    }
}
}
$totalPerSubEvent = [];
foreach ($subEvents as $sub)
{
    $sid = $sub['id'];
    $total = 0;
    foreach ($rows as $member)
    {
        $total += isset($estimates[$member['id']][$sid]) ? intval($estimates[$member['id']][$sid]) : 0;
    }
    $totalPerSubEvent[$sid] = $total;
}
$html = '<table border="1" cellpadding="5" cellspacing="0" style="border-collapse: collapse; width: 100%;">';
$html .= '<thead><tr><th style="text-align:left;">Family Member</th>';
foreach ($subEvents as $sub)
{
    $t = time();
    $sid = $sub['id'];
    $total = $totalPerSubEvent[$sid] ?? 0;
    $html .= '<th style="text-align:left;">' . htmlspecialchars($sub['sub_event']) . ' <span style="color:red">(' . $total . ')</span>' . ' <a id="exposeid' . $sub['id'] . '" href="#" class="export-icon" title="Export ' . htmlspecialchars($sub['sub_event']) . '" onclick="exportSubEvent(' . $sub['id'] . ', \'' . htmlspecialchars(addslashes($sub['sub_event'])) . '\', \'' . $t . '\');">' . '<i class="fa fa-sign-out"></i>' . '</a>' . '<a id="downseid' . $sub['id'] . '" href=".p_uploads/CSV_Files/' . $sub['sub_event'] . $t . $sub['id'] . '.csv" download="" style="display:none">' . '<i class="fa fa-download" style="color: red"></i>' . '</a>' . '</th>';
}

$html .= '</tr></thead><tbody>';
foreach ($rows as $member)
{
    $phoneLink = '';
    $whatsappLink = '';
    $mobile = trim($member['mobile']);
    $mobile_s = trim($member['mobile_s']);
    
    $EditLink = '<a href="familyinfoview2edit/' . $member['id'] . '" target="_blank" style="margin-left:8px; color:#28a745;" title="Edit"><i class="fa fa-pencil fa-sm"></i></a>';
    if ($mobile)
    {
        $phoneLink = '<br><a href="tel:' . htmlspecialchars($mobile) . '" style="margin-left:0px; color:#28a745;" title="Call"><i class="fa fa-phone"></i></a>';
        $phoneLink_2 = '<br><a href="tel:' . htmlspecialchars($mobile_s) . '" style="margin-left:0px; color:#f84e02" title="Call Spouse"><i class="fa fa-phone"></i></a>';
        $whatsappNumber = preg_replace('/\D+/', '', $mobile);
        $whatsappNumber_s = preg_replace('/\D+/', '', $mobile_s);

        if ($whatsappNumber && strpos($whatsappNumber, '91') !== 0)
        {
            $whatsappNumber = '91' . $whatsappNumber;
        }
        if ($whatsappNumber_s && strpos($whatsappNumber_s, '91') !== 0)
        {
            $whatsappNumber_s = '91' . $whatsappNumber_s;
        }

        $whatsappLink = '<a href="https://wa.me/' . $whatsappNumber . '" target="_blank" style="margin-left:8px; color:#25d366;" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>';
        $whatsappLink_s = '<a href="https://wa.me/' . $whatsappNumber_s . '" target="_blank" style="margin-left:8px; color:#f84e02" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>';
    }
    $html .= '<tr>';
    $html .= '<td style="text-align:left;">' . htmlspecialchars($member['fullname']) . '<span style="font-size:8px; color:red">' . '<br>' . htmlspecialchars($member['city']) . '<br>' . htmlspecialchars($member['category']) . '</span>' . $phoneLink . $phoneLink_s . $whatsappLink . $whatsappLink_s . $EditLink . '</td>';
    foreach ($subEvents as $sub)
    {
        $inputId = 'input_' . $member['id'] . '_' . $sub['id'];
        $defaultVal = $estimates[$member['id']][$sub['id']] ?? 0;
        $html .= '
                <td style="text-align:left;">
                    <div class="quantity">
                        <button type="button" onclick="changeInputVal(\'' . $inputId . '\', 1)">+</button>
                        <input id="' . $inputId . '" name="participation[' . $member['id'] . '][' . $sub['id'] . ']" value="' . $defaultVal . '" min="0" class="input-box">
                        <button type="button" onclick="changeInputVal(\'' . $inputId . '\', -1)">−</button>
                    </div>
                </td>
            ';
    }
    $html .= '</tr>';
}
$html .= '</tbody></table>';
return $html;
}
function fetchFamilyMembers($familyId, $level = 1, $selectedEventId = [], $selectedCatId = [])
{
    $isAllSelected = in_array(-1, $selectedCatId);
    ($_GET['cat_id'] ?? 0 > 0) ? $l = 1 : $l = 15;
    if ($level > $l) return '';
    $html = '';
    // All: Show all records, ignore hierarchy
    if ($isAllSelected)
    {
        $whereClause = '`family_info`.`id` > 1000';
    }
    elseif ($level === 1 && in_array(0, $selectedCatId))
    {
        $whereClause = "`family_id` = $familyId";
    }
    elseif (in_array(0, $selectedCatId))
    {
        $whereClause = "`family_id` = $familyId";
    }
    else
    {
        $whereClause = !empty($selectedCatId) ? "`category` IN (" . implode(',', array_map('intval', $selectedCatId)) . ")" : "0=1";
    }
    $rows = ExecuteRows("
        SELECT 
            `family_info`.`id`, `event`, ifnull(`mobile`,0) as `mobile`,
            ifnull(`mobile_spouse`,0) as `mobile_s`, CONCAT_WS(' ', CONCAT(`sequence`, '.'), if(`family_info`.`lifecycle` = 'Live', NULL, `lifecycle`), `title`, `name`, ' - ',
              IFNULL(`spouse_name`, 'NA')) AS `fullname`, `city_name` as `city`, group_concat(`category`.`item`) as `category`, if(`family_id` is NULL , concat('<a href=\"familyinfoview2edit/',`family_info`.`id`,'\" target=\"_blank\" style=\"margin-left:0px; margin-right:1px; color:#28a745;\" title=\"Edit\"><i class=\"fa fa-pencil fa-sm\"></i></a>'), concat('<a href=\"familyinfoedit/',`family_info`.`id`,'\" target=\"_blank\" style=\"margin-left:0px; margin-right:1px; color:#A52A2A;\" title=\"Edit\"><i class=\"fa fa-pencil fa-sm\"></i></a>')) as `editlink`
        FROM `family_info`
        left join `family_misc` `category` on FIND_IN_SET(`category`.`id`, `family_info`.`category`)
        WHERE $whereClause AND `family_info`.`id` > 1000 group by `family_info`.`id`
        ORDER BY `sort_order` ASC
    ");
    foreach ($rows as $r)
    {
        $checkboxId = 'cb' . $r['id'];
        $spanHtml = '';
        for ($i = 1;$i < $level;$i++)
        {
            $spanHtml .= '<span class="radio-custom" style="font-size:6px;">' . $i . '</span>';
        }
        $spanHtml .= '<span class="radio-custom-checked" style="font-size:6px; cursor:pointer;">' . $level . '</span>';
        $marginLeft = 0;
        $isChecked = false;
        if (!empty($selectedEventId) && !empty($r['event']))
        {
            $memberEvents = array_map('intval', explode(',', $r['event']));
            $isChecked = in_array(intval($selectedEventId[0]) , $memberEvents);
        }
        $nameDisplay = htmlspecialchars($r['fullname']) . ',<span style="font-size:8px; color:red"> ' . htmlspecialchars($r['city']) . ' (' . htmlspecialchars($r['category']) . ')</span>';
        $mobile = trim($r['mobile']);
        $mobile_s = trim($r['mobile_s']);
        $phoneLink = $mobile ? '<a href="tel:' . htmlspecialchars($mobile) . '" style="margin-left:8px; color:#28a745;" title="Call"><i class="fa fa-phone"></i></a>' : '';
        $phoneLink_s = $mobile_s ? '<a href="tel:' . htmlspecialchars($mobile_s) . '" style="margin-left:8px; color:#f84e02" title="Call"><i class="fa fa-phone"></i></a>' : '';
        $whatsappNumber = preg_replace('/\D+/', '', $mobile);
        $whatsappNumber_s = preg_replace('/\D+/', '', $mobile_s);

        if ($whatsappNumber && strpos($whatsappNumber, '91') !== 0)
        {
            $whatsappNumber = '91' . $whatsappNumber;
        }

        if ($whatsappNumber_s && strpos($whatsappNumber_s, '91') !== 0)
        {
            $whatsappNumber_s = '91' . $whatsappNumber_s;
        }
        $whatsappLink = $whatsappNumber ? '<a href="https://wa.me/' . $whatsappNumber . '" target="_blank" style="margin-left:8px; color:#28a745;" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>' : '';
        $whatsappLink_s = $whatsappNumber_s ? '<a href="https://wa.me/' . $whatsappNumber_s . '" target="_blank" style="margin-left:8px; color:#f84e02" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>' : '';
        $html .= '
            <div style="margin-left:' . $marginLeft . 'px;">
                ' . $spanHtml . ' 
                <input type="checkbox" id="' . $checkboxId . '" name="selected_ids[]" value="' . $r['id'] . '"' . ($isChecked ? ' checked' : '') . '>
                <label for="' . $checkboxId . '">' . $r['editlink'] . $nameDisplay . $phoneLink . $phoneLink_s . $whatsappLink . $whatsappLink_s . '</label><br>
            </div>
        ';
        // Don't recurse if all is selected
        if (!$isAllSelected && in_array(0, $selectedCatId))
        {
            $html .= fetchFamilyMembers($r['id'], $level + 1, $selectedEventId, $selectedCatId);
        }
    }
    return $html;
}
function collectFamilyIds($familyId, &$acc, $level = 1)
{
    if ($level > 15) return;
    $whereClause = $level === 1 ? "`id` = $familyId" : "`family_id` = $familyId";
    $rows = ExecuteRows("SELECT `id` FROM `family_info` WHERE $whereClause ORDER BY `sort_order`");
    foreach ($rows as $r)
    {
        $acc[] = $r['id'];
        collectFamilyIds($r['id'], $acc, $level + 1);
    }
}
$familyIds = [];
collectFamilyIds($pid, $familyIds);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Family Event Management</title>
<!-- FontAwesome -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
body { font-family: Arial, sans-serif; padding: 0px; }
h2 { margin-bottom: 0px; }
.radio-custom, .radio-custom-checked {
    display:inline-flex; justify-content:center; align-items:center;
    width:9px; height:15px; border-radius:10%;
    margin-right:0; font-size:6px; font-weight:bold; color:#555;
}
.radio-custom { border:1px solid #555; background:#fff;}
.radio-custom-checked { border:1px solid #555; background:#0dcaf038; cursor:pointer;}
input[type="checkbox"] {
    position:relative; top:6px; left:-3px; width:15.5px; height:15.5px;
    accent-color:#ffc107; border-radius:3px; border:1px solid #ccc; cursor:pointer;
}
select {
    padding:8px 12px; font-size:15px; border:1px solid #ccc; border-radius:6px;
    background:#fff; margin-bottom:10px;
}
table { border-collapse: collapse; width: 100%; table-layout: fixed; }
table th, table td {
    border: 1px solid #ccc;
    padding: 8px;
    text-align: left;
    vertical-align: middle;
    word-wrap: break-word;
}
.quantity { display: inline-grid; border: 2px solid #3498db; border-radius: 4px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); gap: 2px; }
.quantity button {
  background-color: #3498db; color: #fff; border: none; cursor: pointer;
  font-size: 20px; width: 30px; height: 30px;
}
.quantity button:hover { background-color: #2980b9; }
.input-box { width: 30px; text-align: center; border: none; font-size: 16px; outline: none; }
.select2-selection__choice {
  background-color: #3498db !important;
  border: 1px solid #2980b9 !important;
  color: white !important;
  border-radius: 4px !important;
}
.select2-selection__choice__remove {
  color: white !important;
}
#filterPanel {
  background: #f8f9fa;
  border: 1px solid #ddd;
  border-radius: 6px;
  margin-bottom: 15px;
}
#filterHeader {
  cursor: pointer;
  padding: 12px 16px;
  font-weight: bold;
  user-select: none;
  background: #3498db;
  color: white;
  border-radius: 6px 6px 0 0;
}
#filterContent {
  padding: 15px 20px;
  display: none;
}
.scrollable-table-container {
  max-height: 400px; /* Adjust height as needed */
  overflow-y: auto;
  border: 1px solid #ccc;
  border-radius: 6px;
}
table th {
  position: sticky;
  top: 0;
  background: white;
  z-index: 10;
  box-shadow: 0 2px 2px -1px rgba(0,0,0,0.1);
}
#eventForm button[type="submit"] {
  display: block;
  width: 100%;
  background-color: #3498db;
  color: #fff;
  font-size: 16px;
  padding: 10px;
  border: none;
  border-radius: 6px;
  margin-top: 10px;
  cursor: pointer;
}
#eventForm button[type="submit"]:hover {
  background-color: #2980b9;
}
#familyForm button[type="submit"] {
  display: block;
  width: 100%;
  background-color: #2ecc71;
  color: #fff;
  font-size: 16px;
  padding: 12px;
  border: none;
  border-radius: 6px;
  margin-top: 15px;
  cursor: pointer;
}
#familyForm button[type="submit"]:hover {
  background-color: #27ae60;
}
.input[type=number] {
  -moz-appearance: textfield;
}
</style>
</head>
<body>
<div id="filterPanel">
<div id="filterHeader" style="display:flex;align-items:center;justify-content:space-between;gap:10px;">
  <span style="flex:1;cursor:pointer;" onclick="toggleFilterPanel()">Filter / Search ▼</span>
  <button id="updateSortOrderBtn" type="button" style="background:#ffc107;color:#222;font-weight:bold;border:none;border-radius:6px;padding:6px 14px;cursor:pointer;">
    Update Sort Order
  </button>
</div>
<div id="filterContent">
    <form method="get" id="eventForm" autocomplete="off">
      <div style="display:flex; flex-wrap:wrap; gap:16px; align-items:flex-start;">
        <div style="flex:1; min-width:160px;">
          <label><strong>Select Category(s):</strong></label><br>
          <select name="cat_id" id="catSelect" multiple style="width:100%;">
            <option value="-1" <?=in_array(-1, $selectedCatId) ? 'selected' : '' ?>>All</option>
            <option value="0" <?=in_array(0, $selectedCatId) ? 'selected' : '' ?>>Family Hierarchy</option>
            <?php foreach ($catList as $cat) : ?>
                <option value="<?=htmlspecialchars($cat['id']) ?>" <?=in_array($cat['id'], $selectedCatId) ? 'selected' : '' ?>><?=htmlspecialchars($cat['cat']) ?></option>
            <?php
endforeach; ?>
          </select>
        </div>
        <div style="flex:1; min-width:160px;">
          <label><strong>Select Event(s):</strong></label><br>
          <select name="event_id" id="eventSelect" multiple style="width:100%;">
            <?php foreach ($eventList as $event) : ?>
                <option value="<?=htmlspecialchars($event['id']) ?>" <?=in_array($event['id'], $selectedEventId) ? 'selected' : '' ?>><?=htmlspecialchars($event['event']) ?></option>
            <?php
endforeach; ?>
          </select>
        </div>
        <?php if (!empty($selectedEventId)) : ?>
        <div id="subEventContainer" style="flex:1; min-width:160px;">
          <label><strong>Select Sub Event(s):</strong></label><br>
          <select name="sub_event_id" id="subEventSelect" multiple style="width:100%;">
            <?php foreach ($subEventList as $subEvent) : ?>
                <option value="<?=htmlspecialchars($subEvent['id']) ?>" <?=in_array($subEvent['id'], $selectedSubEventId) ? 'selected' : '' ?>><?=htmlspecialchars($subEvent['sub_event']) ?></option>
            <?php
endforeach; ?>
          </select>
        </div>
        <div style="flex:1; min-width:160px;">
          <label><strong>Participation Filter:</strong></label><br>
          <select name="quantity_filter" id="quantityFilterSelect" multiple style="width:100%;">
            <option value="all" <?=$selectedQuantityFilter === 'all' ? 'selected' : '' ?>>Show All</option>
            <option value="gt0" <?=$selectedQuantityFilter === 'gt0' ? 'selected' : '' ?>>Participation &gt; 0</option>
            <option value="eq0" <?=$selectedQuantityFilter === 'eq0' ? 'selected' : '' ?>>Participation = 0</option>
          </select>
        </div>
        <?php
endif; ?>
        <input type="hidden" name="pid" value="<?=htmlspecialchars($pid) ?>">
      </div>
      <button type="submit" id="applyFiltersBtn">Apply Filters</button>
    </form>
  </div>
</div>
<?php if (!empty($selectedEventId)) : ?>
<form method="post" id="familyForm" autocomplete="off">
  <input type="hidden" name="current_event" value="<?=htmlspecialchars($selectedEventId[0] ?? 0) ?>">
  <input type="hidden" name="cat_event" value="<?=htmlspecialchars(implode(',', $selectedCatId)) ?>">
  <input type="hidden" name="checkbox_states_json" id="checkbox_states_json" value="">
  <div class="scrollable-table-container">
    <?php
$isAllSelected = in_array(-1, $selectedCatId);
if (!empty($selectedSubEventId) && ($isAllSelected || in_array(0, $selectedCatId)))
{
    echo fetchFamilyMembersFlatView([], $selectedSubEventId, $selectedEventId, $selectedQuantityFilter);
}
elseif (!empty($selectedSubEventId))
{
    echo fetchFamilyMembersFlatView($selectedCatId, $selectedSubEventId, $selectedEventId, $selectedQuantityFilter);
}
else
{
    echo fetchFamilyMembers($pid, 1, $selectedEventId, $selectedCatId);
}
?>
  </div>
  <button type="submit"><?=!empty($selectedSubEventId) ? 'Update Participation Counts' : 'Update Event Membership' ?></button>
</form>
<?php
else : ?>
<p>Please select an event from the dropdown above to see family members.</p>
<?php
endif; ?>

<script>
function toggleFilterPanel() {
  var content = document.getElementById("filterContent");
  var header = document.getElementById("filterHeader");
  if (content.style.display === "block") {
    content.style.display = "none";
    header.innerText = "Filter / Search ▼";
  } else {
    content.style.display = "block";
    header.innerText = "Filter / Search ▲";
  }
}
$(function () {
    $('#catSelect, #eventSelect, #subEventSelect').select2({
        placeholder: "Select options",
        allowClear: true,
        width: '100%'
    });
    $('#quantityFilterSelect').select2({
        width: '100%',
        minimumResultsForSearch: Infinity
    }).on('select2:select', function(e) {
        var lastSelected = e.params.data.id;
        $(this).val([lastSelected]).trigger('change.select2');
    });
});
document.getElementById('eventForm').addEventListener('submit', function(e) {
    e.preventDefault();
    var form = e.target;
    var params = [];
    // Handle cat_id multi-select with All (-1) control
    var catSelect = form.querySelector('#catSelect');
    if (catSelect) {
        var values = Array.from(catSelect.selectedOptions).map(opt => opt.value).filter(Boolean);
        if (values.includes("-1")) {
            values = ["-1"];
        } else if (values.includes("0") && values.length > 1) {
            values = values.filter(v => v !== "0");
        }
        if (values.length > 0) params.push('cat_id=' + values.join(','));
    }
    var eventSelect = form.querySelector('#eventSelect');
    if (eventSelect) {
        var values = Array.from(eventSelect.selectedOptions).map(opt => opt.value).filter(Boolean);
        if (values.length > 0) params.push('event_id=' + values[0]);
    }
    var subEventSelect = form.querySelector('#subEventSelect');
    if (subEventSelect) {
        var values = Array.from(subEventSelect.selectedOptions).map(opt => opt.value).filter(Boolean);
        if (values.length > 0) params.push('sub_event_id=' + values.join(','));
    }
    var qtySelect = form.querySelector('#quantityFilterSelect');
    if (qtySelect) {
        var value = qtySelect.value;
        if (value) params.push('quantity_filter=' + encodeURIComponent(value));
    }
    var pidInput = form.querySelector('[name="pid"]');
    if (pidInput && pidInput.value) params.push('pid=' + encodeURIComponent(pidInput.value));
    var url = form.action.split('?')[0] + '?' + params.join('&');
    window.location.href = url;
});
function updateCheckboxStatesJson() {
    const checkboxes = document.querySelectorAll('input[type="checkbox"][name="selected_ids[]"]');
    const states = {};
    checkboxes.forEach(cb => {
        states[cb.value] = cb.checked;
    });
    document.getElementById('checkbox_states_json').value = JSON.stringify(states);
}
document.getElementById('familyForm')?.addEventListener('submit', function(e) {
    updateCheckboxStatesJson();
});

function changeInputVal(id, delta) {
    var input = document.getElementById(id);
    if (!input) return;
    var currentVal = parseInt(input.value) || 0;
    var newVal = currentVal + delta;
    if (newVal < 0) newVal = 0;
    input.value = newVal;
}


function exportSubEvent(subEventId, subEventName, dt) {
    const params = new URLSearchParams(window.location.search);
    $.getJSON("apcajaxfm?seid=" + subEventId + "&sena=" + subEventName + '&dt=' + dt + '&' + params.toString());
    $("#exposeid" + subEventId).hide();
    $("#downseid" + subEventId).show();
}

document.getElementById('updateSortOrderBtn').onclick = function() {
  // Adjust the path if your updateevent endpoint is different
  $.getJSON("apcajaxfm?usorder=usorder");
  setTimeout(function() { location.reload(); }, 4000);
};

$(function () {
    $('#catSelect').select2({
        placeholder: "Select options",
        allowClear: true,
        width: '100%',
        closeOnSelect: false
    }).on('change', function(e) {
        var selected = $(this).val();
        if (selected && selected.includes('-1')) {
            $(this).val(['-1']).trigger('change.select2');
        }
    });
    $('#eventSelect').select2({
        placeholder: "Select an event",
        allowClear: true,
        width: '100%',
    }).on('select2:select', function(e) {
        var lastSelected = e.params.data.id;
        $(this).val([lastSelected]).trigger('change.select2');
        $('#subEventSelect').val(null).trigger('change.select2');
        document.getElementById('applyFiltersBtn').click();
    });
    $('#subEventSelect').select2({
        placeholder: "Select sub events",
        allowClear: true,
        width: '100%',
        closeOnSelect: false
    });
});
</script>
</body>
</html>
<?= GetDebugMessage() ?>
