<?php

namespace PHPMaker2024\fibre;

// Page object
$TmpNotesBcSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { tmp_notes_bc: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ftmp_notes_bcsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ftmp_notes_bcsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["buyer", [ew.Validators.integer], fields.buyer.isInvalid],
            ["design", [], fields.design.isInvalid],
            ["size", [], fields.size.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["delivery_date_new", [ew.Validators.datetime(fields.delivery_date_new.clientFormatPattern)], fields.delivery_date_new.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
            "design": <?= $Page->design->toClientList($Page) ?>,
            "size": <?= $Page->size->toClientList($Page) ?>,
            "_barcode": <?= $Page->_barcode->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ftmp_notes_bcsearch" id="ftmp_notes_bcsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="tmp_notes_bc">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_tmp_notes_bc_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="tmp_notes_bc" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
    <div id="r_buyer" class="row"<?= $Page->buyer->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_buyer"><?= $Page->buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer" id="z_buyer" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_tmp_notes_bc_buyer" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer"
        name="x_buyer"
        class="form-control ew-select<?= $Page->buyer->isInvalidClass() ?>"
        data-select2-id="ftmp_notes_bcsearch_x_buyer"
        data-table="tmp_notes_bc"
        data-field="x_buyer"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyer->editAttributes() ?>>
        <?= $Page->buyer->selectOptionListHtml("x_buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer->getErrorMessage(false) ?></div>
<?= $Page->buyer->Lookup->getParamTag($Page, "p_x_buyer") ?>
<script>
loadjs.ready("ftmp_notes_bcsearch", function() {
    var options = { name: "x_buyer", selectId: "ftmp_notes_bcsearch_x_buyer" };
    if (ftmp_notes_bcsearch.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x_buyer", form: "ftmp_notes_bcsearch" };
    } else {
        options.ajax = { id: "x_buyer", form: "ftmp_notes_bcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.tmp_notes_bc.fields.buyer.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
    <div id="r_design" class="row"<?= $Page->design->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_design"><?= $Page->design->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design" id="z_design" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_tmp_notes_bc_design" class="ew-search-field ew-search-field-single">
<template id="tp_x_design">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="tmp_notes_bc" data-field="x_design" name="x_design" id="x_design"<?= $Page->design->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_design" class="ew-item-list"></div>
<selection-list hidden
    id="x_design[]"
    name="x_design[]"
    value="<?= HtmlEncode($Page->design->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_design"
    data-target="dsl_x_design"
    data-repeatcolumn="1"
    class="form-control<?= $Page->design->isInvalidClass() ?>"
    data-table="tmp_notes_bc"
    data-field="x_design"
    data-ew-action="update-options"
    data-value-separator="<?= $Page->design->displayValueSeparatorAttribute() ?>"
    <?= $Page->design->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
<?= $Page->design->Lookup->getParamTag($Page, "p_x_design") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
    <div id="r_size" class="row"<?= $Page->size->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_size"><?= $Page->size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size" id="z_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_tmp_notes_bc_size" class="ew-search-field ew-search-field-single">
<template id="tp_x_size">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="tmp_notes_bc" data-field="x_size" name="x_size" id="x_size"<?= $Page->size->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_size" class="ew-item-list"></div>
<selection-list hidden
    id="x_size[]"
    name="x_size[]"
    value="<?= HtmlEncode($Page->size->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_size"
    data-target="dsl_x_size"
    data-repeatcolumn="3"
    class="form-control<?= $Page->size->isInvalidClass() ?>"
    data-table="tmp_notes_bc"
    data-field="x_size"
    data-ew-action="update-options"
    data-value-separator="<?= $Page->size->displayValueSeparatorAttribute() ?>"
    <?= $Page->size->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage(false) ?></div>
<?= $Page->size->Lookup->getParamTag($Page, "p_x_size") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_tmp_notes_bc__barcode"><?= $Page->_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__barcode" id="z__barcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_tmp_notes_bc__barcode" class="ew-search-field ew-search-field-single">
<template id="tp_x__barcode">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="tmp_notes_bc" data-field="x__barcode" name="x__barcode" id="x__barcode"<?= $Page->_barcode->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x__barcode" class="ew-item-list"></div>
<selection-list hidden
    id="x__barcode[]"
    name="x__barcode[]"
    value="<?= HtmlEncode($Page->_barcode->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x__barcode"
    data-target="dsl_x__barcode"
    data-repeatcolumn="1"
    class="form-control<?= $Page->_barcode->isInvalidClass() ?>"
    data-table="tmp_notes_bc"
    data-field="x__barcode"
    data-value-separator="<?= $Page->_barcode->displayValueSeparatorAttribute() ?>"
    <?= $Page->_barcode->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
<?= $Page->_barcode->Lookup->getParamTag($Page, "p_x__barcode") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delivery_date_new->Visible) { // delivery_date_new ?>
    <div id="r_delivery_date_new" class="row"<?= $Page->delivery_date_new->rowAttributes() ?>>
        <label for="x_delivery_date_new" class="<?= $Page->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_delivery_date_new"><?= $Page->delivery_date_new->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_delivery_date_new" id="z_delivery_date_new" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delivery_date_new->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_tmp_notes_bc_delivery_date_new" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->delivery_date_new->getInputTextType() ?>" name="x_delivery_date_new" id="x_delivery_date_new" data-table="tmp_notes_bc" data-field="x_delivery_date_new" value="<?= $Page->delivery_date_new->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->delivery_date_new->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->delivery_date_new->formatPattern()) ?>"<?= $Page->delivery_date_new->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->delivery_date_new->getErrorMessage(false) ?></div>
<?php if (!$Page->delivery_date_new->ReadOnly && !$Page->delivery_date_new->Disabled && !isset($Page->delivery_date_new->EditAttrs["readonly"]) && !isset($Page->delivery_date_new->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftmp_notes_bcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ftmp_notes_bcsearch", "x_delivery_date_new", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_tmp_notes_bc_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="tmp_notes_bc" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_tmp_notes_bc_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="tmp_notes_bc" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_tmp_notes_bc_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="tmp_notes_bc" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftmp_notes_bcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ftmp_notes_bcsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ftmp_notes_bcsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ftmp_notes_bcsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ftmp_notes_bcsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("tmp_notes_bc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
