<?php

namespace PHPMaker2024\fibre;

// Page object
$TmpNotesBcAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { tmp_notes_bc: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ftmp_notes_bcadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ftmp_notes_bcadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["buyer", [fields.buyer.visible && fields.buyer.required ? ew.Validators.required(fields.buyer.caption) : null, ew.Validators.integer], fields.buyer.isInvalid],
            ["design", [fields.design.visible && fields.design.required ? ew.Validators.required(fields.design.caption) : null], fields.design.isInvalid],
            ["size", [fields.size.visible && fields.size.required ? ew.Validators.required(fields.size.caption) : null], fields.size.isInvalid],
            ["_barcode", [fields._barcode.visible && fields._barcode.required ? ew.Validators.required(fields._barcode.caption) : null], fields._barcode.isInvalid],
            ["delivery_date_new", [fields.delivery_date_new.visible && fields.delivery_date_new.required ? ew.Validators.required(fields.delivery_date_new.caption) : null, ew.Validators.datetime(fields.delivery_date_new.clientFormatPattern)], fields.delivery_date_new.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
            "design": <?= $Page->design->toClientList($Page) ?>,
            "size": <?= $Page->size->toClientList($Page) ?>,
            "_barcode": <?= $Page->_barcode->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ftmp_notes_bcadd" id="ftmp_notes_bcadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="tmp_notes_bc">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->buyer->Visible) { // buyer ?>
    <div id="r_buyer"<?= $Page->buyer->rowAttributes() ?>>
        <label id="elh_tmp_notes_bc_buyer" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer->caption() ?><?= $Page->buyer->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer->cellAttributes() ?>>
<span id="el_tmp_notes_bc_buyer">
    <select
        id="x_buyer"
        name="x_buyer"
        class="form-control ew-select<?= $Page->buyer->isInvalidClass() ?>"
        data-select2-id="ftmp_notes_bcadd_x_buyer"
        data-table="tmp_notes_bc"
        data-field="x_buyer"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyer->editAttributes() ?>>
        <?= $Page->buyer->selectOptionListHtml("x_buyer") ?>
    </select>
    <?= $Page->buyer->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->buyer->getErrorMessage() ?></div>
<?= $Page->buyer->Lookup->getParamTag($Page, "p_x_buyer") ?>
<script>
loadjs.ready("ftmp_notes_bcadd", function() {
    var options = { name: "x_buyer", selectId: "ftmp_notes_bcadd_x_buyer" };
    if (ftmp_notes_bcadd.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x_buyer", form: "ftmp_notes_bcadd" };
    } else {
        options.ajax = { id: "x_buyer", form: "ftmp_notes_bcadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.tmp_notes_bc.fields.buyer.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
    <div id="r_design"<?= $Page->design->rowAttributes() ?>>
        <label id="elh_tmp_notes_bc_design" class="<?= $Page->LeftColumnClass ?>"><?= $Page->design->caption() ?><?= $Page->design->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->design->cellAttributes() ?>>
<span id="el_tmp_notes_bc_design">
<template id="tp_x_design">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="tmp_notes_bc" data-field="x_design" name="x_design" id="x_design"<?= $Page->design->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_design" class="ew-item-list"></div>
<selection-list hidden
    id="x_design[]"
    name="x_design[]"
    value="<?= HtmlEncode($Page->design->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_design"
    data-target="dsl_x_design"
    data-repeatcolumn="1"
    class="form-control<?= $Page->design->isInvalidClass() ?>"
    data-table="tmp_notes_bc"
    data-field="x_design"
    data-ew-action="update-options"
    data-value-separator="<?= $Page->design->displayValueSeparatorAttribute() ?>"
    <?= $Page->design->editAttributes() ?>></selection-list>
<?= $Page->design->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->design->getErrorMessage() ?></div>
<?= $Page->design->Lookup->getParamTag($Page, "p_x_design") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
    <div id="r_size"<?= $Page->size->rowAttributes() ?>>
        <label id="elh_tmp_notes_bc_size" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size->caption() ?><?= $Page->size->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size->cellAttributes() ?>>
<span id="el_tmp_notes_bc_size">
<template id="tp_x_size">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="tmp_notes_bc" data-field="x_size" name="x_size" id="x_size"<?= $Page->size->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_size" class="ew-item-list"></div>
<selection-list hidden
    id="x_size[]"
    name="x_size[]"
    value="<?= HtmlEncode($Page->size->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_size"
    data-target="dsl_x_size"
    data-repeatcolumn="3"
    class="form-control<?= $Page->size->isInvalidClass() ?>"
    data-table="tmp_notes_bc"
    data-field="x_size"
    data-ew-action="update-options"
    data-value-separator="<?= $Page->size->displayValueSeparatorAttribute() ?>"
    <?= $Page->size->editAttributes() ?>></selection-list>
<?= $Page->size->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage() ?></div>
<?= $Page->size->Lookup->getParamTag($Page, "p_x_size") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode"<?= $Page->_barcode->rowAttributes() ?>>
        <label id="elh_tmp_notes_bc__barcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_barcode->caption() ?><?= $Page->_barcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_barcode->cellAttributes() ?>>
<span id="el_tmp_notes_bc__barcode">
<template id="tp_x__barcode">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="tmp_notes_bc" data-field="x__barcode" name="x__barcode" id="x__barcode"<?= $Page->_barcode->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x__barcode" class="ew-item-list"></div>
<selection-list hidden
    id="x__barcode[]"
    name="x__barcode[]"
    value="<?= HtmlEncode($Page->_barcode->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x__barcode"
    data-target="dsl_x__barcode"
    data-repeatcolumn="1"
    class="form-control<?= $Page->_barcode->isInvalidClass() ?>"
    data-table="tmp_notes_bc"
    data-field="x__barcode"
    data-value-separator="<?= $Page->_barcode->displayValueSeparatorAttribute() ?>"
    <?= $Page->_barcode->editAttributes() ?>></selection-list>
<?= $Page->_barcode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage() ?></div>
<?= $Page->_barcode->Lookup->getParamTag($Page, "p_x__barcode") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->delivery_date_new->Visible) { // delivery_date_new ?>
    <div id="r_delivery_date_new"<?= $Page->delivery_date_new->rowAttributes() ?>>
        <label id="elh_tmp_notes_bc_delivery_date_new" for="x_delivery_date_new" class="<?= $Page->LeftColumnClass ?>"><?= $Page->delivery_date_new->caption() ?><?= $Page->delivery_date_new->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->delivery_date_new->cellAttributes() ?>>
<span id="el_tmp_notes_bc_delivery_date_new">
<input type="<?= $Page->delivery_date_new->getInputTextType() ?>" name="x_delivery_date_new" id="x_delivery_date_new" data-table="tmp_notes_bc" data-field="x_delivery_date_new" value="<?= $Page->delivery_date_new->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->delivery_date_new->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->delivery_date_new->formatPattern()) ?>"<?= $Page->delivery_date_new->editAttributes() ?> aria-describedby="x_delivery_date_new_help">
<?= $Page->delivery_date_new->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->delivery_date_new->getErrorMessage() ?></div>
<?php if (!$Page->delivery_date_new->ReadOnly && !$Page->delivery_date_new->Disabled && !isset($Page->delivery_date_new->EditAttrs["readonly"]) && !isset($Page->delivery_date_new->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftmp_notes_bcadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ftmp_notes_bcadd", "x_delivery_date_new", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_tmp_notes_bc_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_tmp_notes_bc_remarks">
<textarea data-table="tmp_notes_bc" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ftmp_notes_bcadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ftmp_notes_bcadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("tmp_notes_bc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
