<?php

namespace PHPMaker2024\fibre;

// Page object
$TestReportSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { test_report: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ftest_reportsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ftest_reportsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["ref", [], fields.ref.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["d_01", [], fields.d_01.isInvalid],
            ["d_02", [], fields.d_02.isInvalid],
            ["d_03", [], fields.d_03.isInvalid],
            ["d_04", [], fields.d_04.isInvalid],
            ["d_05", [], fields.d_05.isInvalid],
            ["d_06", [], fields.d_06.isInvalid],
            ["d_07", [], fields.d_07.isInvalid],
            ["d_08", [], fields.d_08.isInvalid],
            ["d_09", [], fields.d_09.isInvalid],
            ["d_10", [], fields.d_10.isInvalid],
            ["d_11", [], fields.d_11.isInvalid],
            ["d_12", [], fields.d_12.isInvalid],
            ["d_13", [], fields.d_13.isInvalid],
            ["d_14", [], fields.d_14.isInvalid],
            ["d_15", [], fields.d_15.isInvalid],
            ["d_16", [], fields.d_16.isInvalid],
            ["d_17", [], fields.d_17.isInvalid],
            ["d_18", [], fields.d_18.isInvalid],
            ["d_19", [], fields.d_19.isInvalid],
            ["d_20", [], fields.d_20.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "ref": <?= $Page->ref->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ftest_reportsearch" id="ftest_reportsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="test_report">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="test_report" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="ftest_reportsearch_x_grp"
        <?php } ?>
        data-table="test_report"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("ftest_reportsearch", function() {
    var options = { name: "x_grp", selectId: "ftest_reportsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftest_reportsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "ftest_reportsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "ftest_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.test_report.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="ftest_reportsearch_x_s_grp"
        <?php } ?>
        data-table="test_report"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("ftest_reportsearch", function() {
    var options = { name: "x_s_grp", selectId: "ftest_reportsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftest_reportsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "ftest_reportsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "ftest_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.test_report.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="ftest_reportsearch_x_product"
        <?php } ?>
        data-table="test_report"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("ftest_reportsearch", function() {
    var options = { name: "x_product", selectId: "ftest_reportsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftest_reportsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "ftest_reportsearch" };
    } else {
        options.ajax = { id: "x_product", form: "ftest_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.test_report.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref" class="row"<?= $Page->ref->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_ref"><?= $Page->ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ref" id="z_ref" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_ref" class="ew-search-field ew-search-field-single">
<template id="tp_x_ref">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="test_report" data-field="x_ref" name="x_ref" id="x_ref"<?= $Page->ref->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_ref" class="ew-item-list"></div>
<selection-list hidden
    id="x_ref"
    name="x_ref"
    value="<?= HtmlEncode($Page->ref->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_ref"
    data-target="dsl_x_ref"
    data-repeatcolumn="1"
    class="form-control<?= $Page->ref->isInvalidClass() ?>"
    data-table="test_report"
    data-field="x_ref"
    data-value-separator="<?= $Page->ref->displayValueSeparatorAttribute() ?>"
    <?= $Page->ref->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
<?= $Page->ref->Lookup->getParamTag($Page, "p_x_ref") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_lot_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="test_report" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_dated"><?= $Page->dated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_dated" id="z_dated" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_dated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="test_report" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftest_reportsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ftest_reportsearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_01->Visible) { // d_01 ?>
    <div id="r_d_01" class="row"<?= $Page->d_01->rowAttributes() ?>>
        <label for="x_d_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_01"><?= $Page->d_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_01" id="z_d_01" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_01->getInputTextType() ?>" name="x_d_01" id="x_d_01" data-table="test_report" data-field="x_d_01" value="<?= $Page->d_01->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_01->formatPattern()) ?>"<?= $Page->d_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_02->Visible) { // d_02 ?>
    <div id="r_d_02" class="row"<?= $Page->d_02->rowAttributes() ?>>
        <label for="x_d_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_02"><?= $Page->d_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_02" id="z_d_02" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_02->getInputTextType() ?>" name="x_d_02" id="x_d_02" data-table="test_report" data-field="x_d_02" value="<?= $Page->d_02->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_02->formatPattern()) ?>"<?= $Page->d_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_03->Visible) { // d_03 ?>
    <div id="r_d_03" class="row"<?= $Page->d_03->rowAttributes() ?>>
        <label for="x_d_03" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_03"><?= $Page->d_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_03" id="z_d_03" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_03" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_03->getInputTextType() ?>" name="x_d_03" id="x_d_03" data-table="test_report" data-field="x_d_03" value="<?= $Page->d_03->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_03->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_03->formatPattern()) ?>"<?= $Page->d_03->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_03->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_04->Visible) { // d_04 ?>
    <div id="r_d_04" class="row"<?= $Page->d_04->rowAttributes() ?>>
        <label for="x_d_04" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_04"><?= $Page->d_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_04" id="z_d_04" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_04" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_04->getInputTextType() ?>" name="x_d_04" id="x_d_04" data-table="test_report" data-field="x_d_04" value="<?= $Page->d_04->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_04->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_04->formatPattern()) ?>"<?= $Page->d_04->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_04->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_05->Visible) { // d_05 ?>
    <div id="r_d_05" class="row"<?= $Page->d_05->rowAttributes() ?>>
        <label for="x_d_05" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_05"><?= $Page->d_05->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_05" id="z_d_05" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_05->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_05" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_05->getInputTextType() ?>" name="x_d_05" id="x_d_05" data-table="test_report" data-field="x_d_05" value="<?= $Page->d_05->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_05->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_05->formatPattern()) ?>"<?= $Page->d_05->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_05->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_06->Visible) { // d_06 ?>
    <div id="r_d_06" class="row"<?= $Page->d_06->rowAttributes() ?>>
        <label for="x_d_06" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_06"><?= $Page->d_06->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_06" id="z_d_06" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_06->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_06" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_06->getInputTextType() ?>" name="x_d_06" id="x_d_06" data-table="test_report" data-field="x_d_06" value="<?= $Page->d_06->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_06->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_06->formatPattern()) ?>"<?= $Page->d_06->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_06->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_07->Visible) { // d_07 ?>
    <div id="r_d_07" class="row"<?= $Page->d_07->rowAttributes() ?>>
        <label for="x_d_07" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_07"><?= $Page->d_07->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_07" id="z_d_07" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_07->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_07" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_07->getInputTextType() ?>" name="x_d_07" id="x_d_07" data-table="test_report" data-field="x_d_07" value="<?= $Page->d_07->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_07->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_07->formatPattern()) ?>"<?= $Page->d_07->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_07->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_08->Visible) { // d_08 ?>
    <div id="r_d_08" class="row"<?= $Page->d_08->rowAttributes() ?>>
        <label for="x_d_08" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_08"><?= $Page->d_08->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_08" id="z_d_08" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_08->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_08" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_08->getInputTextType() ?>" name="x_d_08" id="x_d_08" data-table="test_report" data-field="x_d_08" value="<?= $Page->d_08->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_08->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_08->formatPattern()) ?>"<?= $Page->d_08->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_08->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_09->Visible) { // d_09 ?>
    <div id="r_d_09" class="row"<?= $Page->d_09->rowAttributes() ?>>
        <label for="x_d_09" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_09"><?= $Page->d_09->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_09" id="z_d_09" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_09->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_09" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_09->getInputTextType() ?>" name="x_d_09" id="x_d_09" data-table="test_report" data-field="x_d_09" value="<?= $Page->d_09->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_09->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_09->formatPattern()) ?>"<?= $Page->d_09->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_09->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_10->Visible) { // d_10 ?>
    <div id="r_d_10" class="row"<?= $Page->d_10->rowAttributes() ?>>
        <label for="x_d_10" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_10"><?= $Page->d_10->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_10" id="z_d_10" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_10->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_10" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_10->getInputTextType() ?>" name="x_d_10" id="x_d_10" data-table="test_report" data-field="x_d_10" value="<?= $Page->d_10->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_10->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_10->formatPattern()) ?>"<?= $Page->d_10->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_10->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_11->Visible) { // d_11 ?>
    <div id="r_d_11" class="row"<?= $Page->d_11->rowAttributes() ?>>
        <label for="x_d_11" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_11"><?= $Page->d_11->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_11" id="z_d_11" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_11->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_11" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_11->getInputTextType() ?>" name="x_d_11" id="x_d_11" data-table="test_report" data-field="x_d_11" value="<?= $Page->d_11->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_11->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_11->formatPattern()) ?>"<?= $Page->d_11->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_11->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_12->Visible) { // d_12 ?>
    <div id="r_d_12" class="row"<?= $Page->d_12->rowAttributes() ?>>
        <label for="x_d_12" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_12"><?= $Page->d_12->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_12" id="z_d_12" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_12->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_12" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_12->getInputTextType() ?>" name="x_d_12" id="x_d_12" data-table="test_report" data-field="x_d_12" value="<?= $Page->d_12->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_12->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_12->formatPattern()) ?>"<?= $Page->d_12->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_12->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_13->Visible) { // d_13 ?>
    <div id="r_d_13" class="row"<?= $Page->d_13->rowAttributes() ?>>
        <label for="x_d_13" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_13"><?= $Page->d_13->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_13" id="z_d_13" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_13->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_13" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_13->getInputTextType() ?>" name="x_d_13" id="x_d_13" data-table="test_report" data-field="x_d_13" value="<?= $Page->d_13->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_13->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_13->formatPattern()) ?>"<?= $Page->d_13->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_13->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_14->Visible) { // d_14 ?>
    <div id="r_d_14" class="row"<?= $Page->d_14->rowAttributes() ?>>
        <label for="x_d_14" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_14"><?= $Page->d_14->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_14" id="z_d_14" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_14->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_14" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_14->getInputTextType() ?>" name="x_d_14" id="x_d_14" data-table="test_report" data-field="x_d_14" value="<?= $Page->d_14->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_14->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_14->formatPattern()) ?>"<?= $Page->d_14->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_14->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_15->Visible) { // d_15 ?>
    <div id="r_d_15" class="row"<?= $Page->d_15->rowAttributes() ?>>
        <label for="x_d_15" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_15"><?= $Page->d_15->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_15" id="z_d_15" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_15->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_15" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_15->getInputTextType() ?>" name="x_d_15" id="x_d_15" data-table="test_report" data-field="x_d_15" value="<?= $Page->d_15->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_15->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_15->formatPattern()) ?>"<?= $Page->d_15->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_15->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_16->Visible) { // d_16 ?>
    <div id="r_d_16" class="row"<?= $Page->d_16->rowAttributes() ?>>
        <label for="x_d_16" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_16"><?= $Page->d_16->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_16" id="z_d_16" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_16->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_16" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_16->getInputTextType() ?>" name="x_d_16" id="x_d_16" data-table="test_report" data-field="x_d_16" value="<?= $Page->d_16->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_16->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_16->formatPattern()) ?>"<?= $Page->d_16->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_16->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_17->Visible) { // d_17 ?>
    <div id="r_d_17" class="row"<?= $Page->d_17->rowAttributes() ?>>
        <label for="x_d_17" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_17"><?= $Page->d_17->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_17" id="z_d_17" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_17->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_17" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_17->getInputTextType() ?>" name="x_d_17" id="x_d_17" data-table="test_report" data-field="x_d_17" value="<?= $Page->d_17->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_17->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_17->formatPattern()) ?>"<?= $Page->d_17->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_17->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_18->Visible) { // d_18 ?>
    <div id="r_d_18" class="row"<?= $Page->d_18->rowAttributes() ?>>
        <label for="x_d_18" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_18"><?= $Page->d_18->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_18" id="z_d_18" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_18->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_18" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_18->getInputTextType() ?>" name="x_d_18" id="x_d_18" data-table="test_report" data-field="x_d_18" value="<?= $Page->d_18->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_18->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_18->formatPattern()) ?>"<?= $Page->d_18->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_18->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_19->Visible) { // d_19 ?>
    <div id="r_d_19" class="row"<?= $Page->d_19->rowAttributes() ?>>
        <label for="x_d_19" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_19"><?= $Page->d_19->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_19" id="z_d_19" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_19->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_19" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_19->getInputTextType() ?>" name="x_d_19" id="x_d_19" data-table="test_report" data-field="x_d_19" value="<?= $Page->d_19->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_19->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_19->formatPattern()) ?>"<?= $Page->d_19->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_19->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_20->Visible) { // d_20 ?>
    <div id="r_d_20" class="row"<?= $Page->d_20->rowAttributes() ?>>
        <label for="x_d_20" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_d_20"><?= $Page->d_20->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_20" id="z_d_20" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_20->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_d_20" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_20->getInputTextType() ?>" name="x_d_20" id="x_d_20" data-table="test_report" data-field="x_d_20" value="<?= $Page->d_20->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->d_20->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_20->formatPattern()) ?>"<?= $Page->d_20->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_20->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="ftest_reportsearch_x_operator"
        <?php } ?>
        data-table="test_report"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("ftest_reportsearch", function() {
    var options = { name: "x_operator", selectId: "ftest_reportsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftest_reportsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "ftest_reportsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "ftest_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.test_report.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_test_report_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_test_report_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="test_report" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftest_reportsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ftest_reportsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ftest_reportsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ftest_reportsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ftest_reportsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("test_report");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
