<?php

namespace PHPMaker2024\fibre;

// Page object
$TTyreMaintenanceSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_tyre_maintenance: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ft_tyre_maintenancesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_tyre_maintenancesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["vehicle_no", [], fields.vehicle_no.isInvalid],
            ["driver", [], fields.driver.isInvalid],
            ["tyre_id", [], fields.tyre_id.isInvalid],
            ["type", [], fields.type.isInvalid],
            ["no", [ew.Validators.integer], fields.no.isInvalid],
            ["old_puncture", [ew.Validators.integer], fields.old_puncture.isInvalid],
            ["puncture_date", [ew.Validators.datetime(fields.puncture_date.clientFormatPattern)], fields.puncture_date.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "vehicle_no": <?= $Page->vehicle_no->toClientList($Page) ?>,
            "driver": <?= $Page->driver->toClientList($Page) ?>,
            "tyre_id": <?= $Page->tyre_id->toClientList($Page) ?>,
            "type": <?= $Page->type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_tyre_maintenancesearch" id="ft_tyre_maintenancesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_tyre_maintenance">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_maintenance_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="t_tyre_maintenance" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_no->Visible) { // vehicle_no ?>
    <div id="r_vehicle_no" class="row"<?= $Page->vehicle_no->rowAttributes() ?>>
        <label for="x_vehicle_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_vehicle_no"><?= $Page->vehicle_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_no" id="z_vehicle_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_maintenance_vehicle_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_vehicle_no"
        name="x_vehicle_no"
        class="form-select ew-select<?= $Page->vehicle_no->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_no->IsNativeSelect) { ?>
        data-select2-id="ft_tyre_maintenancesearch_x_vehicle_no"
        <?php } ?>
        data-table="t_tyre_maintenance"
        data-field="x_vehicle_no"
        data-value-separator="<?= $Page->vehicle_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_no->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->vehicle_no->editAttributes() ?>>
        <?= $Page->vehicle_no->selectOptionListHtml("x_vehicle_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle_no->getErrorMessage(false) ?></div>
<?= $Page->vehicle_no->Lookup->getParamTag($Page, "p_x_vehicle_no") ?>
<?php if (!$Page->vehicle_no->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_tyre_maintenancesearch", function() {
    var options = { name: "x_vehicle_no", selectId: "ft_tyre_maintenancesearch_x_vehicle_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_tyre_maintenancesearch.lists.vehicle_no?.lookupOptions.length) {
        options.data = { id: "x_vehicle_no", form: "ft_tyre_maintenancesearch" };
    } else {
        options.ajax = { id: "x_vehicle_no", form: "ft_tyre_maintenancesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_tyre_maintenance.fields.vehicle_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
    <div id="r_driver" class="row"<?= $Page->driver->rowAttributes() ?>>
        <label for="x_driver" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_driver"><?= $Page->driver->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_driver" id="z_driver" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->driver->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_maintenance_driver" class="ew-search-field ew-search-field-single">
    <select
        id="x_driver"
        name="x_driver"
        class="form-select ew-select<?= $Page->driver->isInvalidClass() ?>"
        <?php if (!$Page->driver->IsNativeSelect) { ?>
        data-select2-id="ft_tyre_maintenancesearch_x_driver"
        <?php } ?>
        data-table="t_tyre_maintenance"
        data-field="x_driver"
        data-value-separator="<?= $Page->driver->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>"
        <?= $Page->driver->editAttributes() ?>>
        <?= $Page->driver->selectOptionListHtml("x_driver") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->driver->getErrorMessage(false) ?></div>
<?= $Page->driver->Lookup->getParamTag($Page, "p_x_driver") ?>
<?php if (!$Page->driver->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_tyre_maintenancesearch", function() {
    var options = { name: "x_driver", selectId: "ft_tyre_maintenancesearch_x_driver" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_tyre_maintenancesearch.lists.driver?.lookupOptions.length) {
        options.data = { id: "x_driver", form: "ft_tyre_maintenancesearch" };
    } else {
        options.ajax = { id: "x_driver", form: "ft_tyre_maintenancesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_tyre_maintenance.fields.driver.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tyre_id->Visible) { // tyre_id ?>
    <div id="r_tyre_id" class="row"<?= $Page->tyre_id->rowAttributes() ?>>
        <label for="x_tyre_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_tyre_id"><?= $Page->tyre_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_tyre_id" id="z_tyre_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tyre_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_maintenance_tyre_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_tyre_id"
        name="x_tyre_id"
        class="form-select ew-select<?= $Page->tyre_id->isInvalidClass() ?>"
        <?php if (!$Page->tyre_id->IsNativeSelect) { ?>
        data-select2-id="ft_tyre_maintenancesearch_x_tyre_id"
        <?php } ?>
        data-table="t_tyre_maintenance"
        data-field="x_tyre_id"
        data-value-separator="<?= $Page->tyre_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->tyre_id->getPlaceHolder()) ?>"
        <?= $Page->tyre_id->editAttributes() ?>>
        <?= $Page->tyre_id->selectOptionListHtml("x_tyre_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->tyre_id->getErrorMessage(false) ?></div>
<?= $Page->tyre_id->Lookup->getParamTag($Page, "p_x_tyre_id") ?>
<?php if (!$Page->tyre_id->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_tyre_maintenancesearch", function() {
    var options = { name: "x_tyre_id", selectId: "ft_tyre_maintenancesearch_x_tyre_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_tyre_maintenancesearch.lists.tyre_id?.lookupOptions.length) {
        options.data = { id: "x_tyre_id", form: "ft_tyre_maintenancesearch" };
    } else {
        options.ajax = { id: "x_tyre_id", form: "ft_tyre_maintenancesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_tyre_maintenance.fields.tyre_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type" class="row"<?= $Page->type->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_type"><?= $Page->type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_type" id="z_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_maintenance_type" class="ew-search-field ew-search-field-single">
<template id="tp_x_type">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="t_tyre_maintenance" data-field="x_type" name="x_type" id="x_type"<?= $Page->type->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_type" class="ew-item-list"></div>
<selection-list hidden
    id="x_type"
    name="x_type"
    value="<?= HtmlEncode($Page->type->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_type"
    data-target="dsl_x_type"
    data-repeatcolumn="5"
    class="form-control<?= $Page->type->isInvalidClass() ?>"
    data-table="t_tyre_maintenance"
    data-field="x_type"
    data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
    <?= $Page->type->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->no->Visible) { // no ?>
    <div id="r_no" class="row"<?= $Page->no->rowAttributes() ?>>
        <label for="x_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_no"><?= $Page->no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_no" id="z_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_maintenance_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->no->getInputTextType() ?>" name="x_no" id="x_no" data-table="t_tyre_maintenance" data-field="x_no" value="<?= $Page->no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no->formatPattern()) ?>"<?= $Page->no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->old_puncture->Visible) { // old_puncture ?>
    <div id="r_old_puncture" class="row"<?= $Page->old_puncture->rowAttributes() ?>>
        <label for="x_old_puncture" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_old_puncture"><?= $Page->old_puncture->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_old_puncture" id="z_old_puncture" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->old_puncture->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_maintenance_old_puncture" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->old_puncture->getInputTextType() ?>" name="x_old_puncture" id="x_old_puncture" data-table="t_tyre_maintenance" data-field="x_old_puncture" value="<?= $Page->old_puncture->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->old_puncture->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->old_puncture->formatPattern()) ?>"<?= $Page->old_puncture->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->old_puncture->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->puncture_date->Visible) { // puncture_date ?>
    <div id="r_puncture_date" class="row"<?= $Page->puncture_date->rowAttributes() ?>>
        <label for="x_puncture_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_puncture_date"><?= $Page->puncture_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_puncture_date" id="z_puncture_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->puncture_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_maintenance_puncture_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->puncture_date->getInputTextType() ?>" name="x_puncture_date" id="x_puncture_date" data-table="t_tyre_maintenance" data-field="x_puncture_date" value="<?= $Page->puncture_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->puncture_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->puncture_date->formatPattern()) ?>"<?= $Page->puncture_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->puncture_date->getErrorMessage(false) ?></div>
<?php if (!$Page->puncture_date->ReadOnly && !$Page->puncture_date->Disabled && !isset($Page->puncture_date->EditAttrs["readonly"]) && !isset($Page->puncture_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_tyre_maintenancesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_tyre_maintenancesearch", "x_puncture_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_maintenance_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="t_tyre_maintenance" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" maxlength="192" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_maintenance_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="t_tyre_maintenance" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_maintenance_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="t_tyre_maintenance" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_tyre_maintenancesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_tyre_maintenancesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_tyre_maintenancesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_tyre_maintenancesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ft_tyre_maintenancesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_tyre_maintenance");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
