<?php

namespace PHPMaker2024\fibre;

// Page object
$TTyreInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_tyre_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ft_tyre_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_tyre_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["vehicle_no", [], fields.vehicle_no.isInvalid],
            ["head", [], fields.head.isInvalid],
            ["sub_head", [], fields.sub_head.isInvalid],
            ["s_no", [], fields.s_no.isInvalid],
            ["km", [ew.Validators.integer], fields.km.isInvalid],
            ["life_km", [ew.Validators.integer], fields.life_km.isInvalid],
            ["recycle_after_km", [ew.Validators.integer], fields.recycle_after_km.isInvalid],
            ["next_km", [ew.Validators.integer], fields.next_km.isInvalid],
            ["recycle_next_km", [ew.Validators.integer], fields.recycle_next_km.isInvalid],
            ["puncture", [ew.Validators.integer], fields.puncture.isInvalid],
            ["current_km", [ew.Validators.integer], fields.current_km.isInvalid],
            ["remaining_km", [ew.Validators.integer], fields.remaining_km.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "vehicle_no": <?= $Page->vehicle_no->toClientList($Page) ?>,
            "head": <?= $Page->head->toClientList($Page) ?>,
            "sub_head": <?= $Page->sub_head->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_tyre_infosearch" id="ft_tyre_infosearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_tyre_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="t_tyre_info" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_no->Visible) { // vehicle_no ?>
    <div id="r_vehicle_no" class="row"<?= $Page->vehicle_no->rowAttributes() ?>>
        <label for="x_vehicle_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_vehicle_no"><?= $Page->vehicle_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_no" id="z_vehicle_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_vehicle_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_vehicle_no"
        name="x_vehicle_no"
        class="form-select ew-select<?= $Page->vehicle_no->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_no->IsNativeSelect) { ?>
        data-select2-id="ft_tyre_infosearch_x_vehicle_no"
        <?php } ?>
        data-table="t_tyre_info"
        data-field="x_vehicle_no"
        data-value-separator="<?= $Page->vehicle_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_no->getPlaceHolder()) ?>"
        <?= $Page->vehicle_no->editAttributes() ?>>
        <?= $Page->vehicle_no->selectOptionListHtml("x_vehicle_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle_no->getErrorMessage(false) ?></div>
<?= $Page->vehicle_no->Lookup->getParamTag($Page, "p_x_vehicle_no") ?>
<?php if (!$Page->vehicle_no->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_tyre_infosearch", function() {
    var options = { name: "x_vehicle_no", selectId: "ft_tyre_infosearch_x_vehicle_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_tyre_infosearch.lists.vehicle_no?.lookupOptions.length) {
        options.data = { id: "x_vehicle_no", form: "ft_tyre_infosearch" };
    } else {
        options.ajax = { id: "x_vehicle_no", form: "ft_tyre_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_tyre_info.fields.vehicle_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->head->Visible) { // head ?>
    <div id="r_head" class="row"<?= $Page->head->rowAttributes() ?>>
        <label for="x_head" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_head"><?= $Page->head->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_head" id="z_head" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->head->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_head" class="ew-search-field ew-search-field-single">
    <select
        id="x_head"
        name="x_head"
        class="form-select ew-select<?= $Page->head->isInvalidClass() ?>"
        <?php if (!$Page->head->IsNativeSelect) { ?>
        data-select2-id="ft_tyre_infosearch_x_head"
        <?php } ?>
        data-table="t_tyre_info"
        data-field="x_head"
        data-value-separator="<?= $Page->head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->head->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->head->editAttributes() ?>>
        <?= $Page->head->selectOptionListHtml("x_head") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->head->getErrorMessage(false) ?></div>
<?= $Page->head->Lookup->getParamTag($Page, "p_x_head") ?>
<?php if (!$Page->head->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_tyre_infosearch", function() {
    var options = { name: "x_head", selectId: "ft_tyre_infosearch_x_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_tyre_infosearch.lists.head?.lookupOptions.length) {
        options.data = { id: "x_head", form: "ft_tyre_infosearch" };
    } else {
        options.ajax = { id: "x_head", form: "ft_tyre_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_tyre_info.fields.head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sub_head->Visible) { // sub_head ?>
    <div id="r_sub_head" class="row"<?= $Page->sub_head->rowAttributes() ?>>
        <label for="x_sub_head" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_sub_head"><?= $Page->sub_head->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sub_head" id="z_sub_head" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sub_head->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_sub_head" class="ew-search-field ew-search-field-single">
    <select
        id="x_sub_head"
        name="x_sub_head"
        class="form-select ew-select<?= $Page->sub_head->isInvalidClass() ?>"
        <?php if (!$Page->sub_head->IsNativeSelect) { ?>
        data-select2-id="ft_tyre_infosearch_x_sub_head"
        <?php } ?>
        data-table="t_tyre_info"
        data-field="x_sub_head"
        data-value-separator="<?= $Page->sub_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sub_head->getPlaceHolder()) ?>"
        <?= $Page->sub_head->editAttributes() ?>>
        <?= $Page->sub_head->selectOptionListHtml("x_sub_head") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->sub_head->getErrorMessage(false) ?></div>
<?= $Page->sub_head->Lookup->getParamTag($Page, "p_x_sub_head") ?>
<?php if (!$Page->sub_head->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_tyre_infosearch", function() {
    var options = { name: "x_sub_head", selectId: "ft_tyre_infosearch_x_sub_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_tyre_infosearch.lists.sub_head?.lookupOptions.length) {
        options.data = { id: "x_sub_head", form: "ft_tyre_infosearch" };
    } else {
        options.ajax = { id: "x_sub_head", form: "ft_tyre_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_tyre_info.fields.sub_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_no->Visible) { // s_no ?>
    <div id="r_s_no" class="row"<?= $Page->s_no->rowAttributes() ?>>
        <label for="x_s_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_s_no"><?= $Page->s_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_s_no" id="z_s_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_s_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->s_no->getInputTextType() ?>" name="x_s_no" id="x_s_no" data-table="t_tyre_info" data-field="x_s_no" value="<?= $Page->s_no->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->s_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->s_no->formatPattern()) ?>"<?= $Page->s_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->s_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->km->Visible) { // km ?>
    <div id="r_km" class="row"<?= $Page->km->rowAttributes() ?>>
        <label for="x_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_km"><?= $Page->km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_km" id="z_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->km->getInputTextType() ?>" name="x_km" id="x_km" data-table="t_tyre_info" data-field="x_km" value="<?= $Page->km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->km->formatPattern()) ?>"<?= $Page->km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->life_km->Visible) { // life_km ?>
    <div id="r_life_km" class="row"<?= $Page->life_km->rowAttributes() ?>>
        <label for="x_life_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_life_km"><?= $Page->life_km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_life_km" id="z_life_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->life_km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_life_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->life_km->getInputTextType() ?>" name="x_life_km" id="x_life_km" data-table="t_tyre_info" data-field="x_life_km" value="<?= $Page->life_km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->life_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->life_km->formatPattern()) ?>"<?= $Page->life_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->life_km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->recycle_after_km->Visible) { // recycle_after_km ?>
    <div id="r_recycle_after_km" class="row"<?= $Page->recycle_after_km->rowAttributes() ?>>
        <label for="x_recycle_after_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_recycle_after_km"><?= $Page->recycle_after_km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_recycle_after_km" id="z_recycle_after_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->recycle_after_km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_recycle_after_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->recycle_after_km->getInputTextType() ?>" name="x_recycle_after_km" id="x_recycle_after_km" data-table="t_tyre_info" data-field="x_recycle_after_km" value="<?= $Page->recycle_after_km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->recycle_after_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->recycle_after_km->formatPattern()) ?>"<?= $Page->recycle_after_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->recycle_after_km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->next_km->Visible) { // next_km ?>
    <div id="r_next_km" class="row"<?= $Page->next_km->rowAttributes() ?>>
        <label for="x_next_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_next_km"><?= $Page->next_km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_next_km" id="z_next_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->next_km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_next_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->next_km->getInputTextType() ?>" name="x_next_km" id="x_next_km" data-table="t_tyre_info" data-field="x_next_km" value="<?= $Page->next_km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->next_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->next_km->formatPattern()) ?>"<?= $Page->next_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->next_km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->recycle_next_km->Visible) { // recycle_next_km ?>
    <div id="r_recycle_next_km" class="row"<?= $Page->recycle_next_km->rowAttributes() ?>>
        <label for="x_recycle_next_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_recycle_next_km"><?= $Page->recycle_next_km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_recycle_next_km" id="z_recycle_next_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->recycle_next_km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_recycle_next_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->recycle_next_km->getInputTextType() ?>" name="x_recycle_next_km" id="x_recycle_next_km" data-table="t_tyre_info" data-field="x_recycle_next_km" value="<?= $Page->recycle_next_km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->recycle_next_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->recycle_next_km->formatPattern()) ?>"<?= $Page->recycle_next_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->recycle_next_km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->puncture->Visible) { // puncture ?>
    <div id="r_puncture" class="row"<?= $Page->puncture->rowAttributes() ?>>
        <label for="x_puncture" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_puncture"><?= $Page->puncture->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_puncture" id="z_puncture" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->puncture->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_puncture" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->puncture->getInputTextType() ?>" name="x_puncture" id="x_puncture" data-table="t_tyre_info" data-field="x_puncture" value="<?= $Page->puncture->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->puncture->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->puncture->formatPattern()) ?>"<?= $Page->puncture->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->puncture->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->current_km->Visible) { // current_km ?>
    <div id="r_current_km" class="row"<?= $Page->current_km->rowAttributes() ?>>
        <label for="x_current_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_current_km"><?= $Page->current_km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_current_km" id="z_current_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->current_km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_current_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->current_km->getInputTextType() ?>" name="x_current_km" id="x_current_km" data-table="t_tyre_info" data-field="x_current_km" value="<?= $Page->current_km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->current_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->current_km->formatPattern()) ?>"<?= $Page->current_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->current_km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remaining_km->Visible) { // remaining_km ?>
    <div id="r_remaining_km" class="row"<?= $Page->remaining_km->rowAttributes() ?>>
        <label for="x_remaining_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_remaining_km"><?= $Page->remaining_km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_remaining_km" id="z_remaining_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remaining_km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_remaining_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remaining_km->getInputTextType() ?>" name="x_remaining_km" id="x_remaining_km" data-table="t_tyre_info" data-field="x_remaining_km" value="<?= $Page->remaining_km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->remaining_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remaining_km->formatPattern()) ?>"<?= $Page->remaining_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remaining_km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="t_tyre_info" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="ft_tyre_infosearch_x_status"
        <?php } ?>
        data-table="t_tyre_info"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_tyre_infosearch", function() {
    var options = { name: "x_status", selectId: "ft_tyre_infosearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_tyre_infosearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "ft_tyre_infosearch" };
    } else {
        options.ajax = { id: "x_status", form: "ft_tyre_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_tyre_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="ft_tyre_infosearch_x_operator"
        <?php } ?>
        data-table="t_tyre_info"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_tyre_infosearch", function() {
    var options = { name: "x_operator", selectId: "ft_tyre_infosearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_tyre_infosearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "ft_tyre_infosearch" };
    } else {
        options.ajax = { id: "x_operator", form: "ft_tyre_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_tyre_info.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_tyre_info_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_tyre_info_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="t_tyre_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_tyre_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_tyre_infosearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_tyre_infosearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_tyre_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ft_tyre_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_tyre_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
