<?php

namespace PHPMaker2024\fibre;

// Page object
$TTripStartSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_start: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ft_trip_startsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_trip_startsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["vehicle_type", [], fields.vehicle_type.isInvalid],
            ["vehicle", [ew.Validators.integer], fields.vehicle.isInvalid],
            ["_route", [ew.Validators.integer], fields._route.isInvalid],
            ["reports_to", [], fields.reports_to.isInvalid],
            ["vehicle_freight_type", [], fields.vehicle_freight_type.isInvalid],
            ["vehicle_freight_amount", [ew.Validators.float], fields.vehicle_freight_amount.isInvalid],
            ["material", [], fields.material.isInvalid],
            ["_40", [ew.Validators.float], fields._40.isInvalid],
            ["buyer", [ew.Validators.integer], fields.buyer.isInvalid],
            ["agent", [ew.Validators.integer], fields.agent.isInvalid],
            ["comm", [ew.Validators.float], fields.comm.isInvalid],
            ["load_date", [ew.Validators.datetime(fields.load_date.clientFormatPattern)], fields.load_date.isInvalid],
            ["load_weight", [ew.Validators.integer], fields.load_weight.isInvalid],
            ["load_km", [ew.Validators.integer], fields.load_km.isInvalid],
            ["gst_percent", [ew.Validators.float], fields.gst_percent.isInvalid],
            ["driver", [], fields.driver.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["vehicle_freight_comm", [ew.Validators.float], fields.vehicle_freight_comm.isInvalid],
            ["freight_type", [], fields.freight_type.isInvalid],
            ["freight", [ew.Validators.float], fields.freight.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "vehicle_type": <?= $Page->vehicle_type->toClientList($Page) ?>,
            "vehicle": <?= $Page->vehicle->toClientList($Page) ?>,
            "_route": <?= $Page->_route->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "vehicle_freight_type": <?= $Page->vehicle_freight_type->toClientList($Page) ?>,
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
            "agent": <?= $Page->agent->toClientList($Page) ?>,
            "freight_type": <?= $Page->freight_type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_trip_startsearch" id="ft_trip_startsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_trip_start">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="t_trip_start" data-field="x_id" value="<?= $Page->id->EditValue ?>" data-page="0" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_type->Visible) { // vehicle_type ?>
    <div id="r_vehicle_type" class="row"<?= $Page->vehicle_type->rowAttributes() ?>>
        <label for="x_vehicle_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_vehicle_type"><?= $Page->vehicle_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_type" id="z_vehicle_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_vehicle_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_vehicle_type"
        name="x_vehicle_type"
        class="form-select ew-select<?= $Page->vehicle_type->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_type->IsNativeSelect) { ?>
        data-select2-id="ft_trip_startsearch_x_vehicle_type"
        <?php } ?>
        data-table="t_trip_start"
        data-field="x_vehicle_type"
        data-page="0"
        data-value-separator="<?= $Page->vehicle_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->vehicle_type->editAttributes() ?>>
        <?= $Page->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle_type->getErrorMessage(false) ?></div>
<?php if (!$Page->vehicle_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_startsearch", function() {
    var options = { name: "x_vehicle_type", selectId: "ft_trip_startsearch_x_vehicle_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_startsearch.lists.vehicle_type?.lookupOptions.length) {
        options.data = { id: "x_vehicle_type", form: "ft_trip_startsearch" };
    } else {
        options.ajax = { id: "x_vehicle_type", form: "ft_trip_startsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_start.fields.vehicle_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle->Visible) { // vehicle ?>
    <div id="r_vehicle" class="row"<?= $Page->vehicle->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_vehicle"><?= $Page->vehicle->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle" id="z_vehicle" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_vehicle" class="ew-search-field ew-search-field-single">
    <select
        id="x_vehicle"
        name="x_vehicle"
        class="form-control ew-select<?= $Page->vehicle->isInvalidClass() ?>"
        data-select2-id="ft_trip_startsearch_x_vehicle"
        data-table="t_trip_start"
        data-field="x_vehicle"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->vehicle->caption())) ?>"
        data-modal-lookup="true"
        data-page="0"
        data-value-separator="<?= $Page->vehicle->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle->getPlaceHolder()) ?>"
        <?= $Page->vehicle->editAttributes() ?>>
        <?= $Page->vehicle->selectOptionListHtml("x_vehicle") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle->getErrorMessage(false) ?></div>
<?= $Page->vehicle->Lookup->getParamTag($Page, "p_x_vehicle") ?>
<script>
loadjs.ready("ft_trip_startsearch", function() {
    var options = { name: "x_vehicle", selectId: "ft_trip_startsearch_x_vehicle" };
    if (ft_trip_startsearch.lists.vehicle?.lookupOptions.length) {
        options.data = { id: "x_vehicle", form: "ft_trip_startsearch" };
    } else {
        options.ajax = { id: "x_vehicle", form: "ft_trip_startsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_start.fields.vehicle.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_route->Visible) { // route ?>
    <div id="r__route" class="row"<?= $Page->_route->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start__route"><?= $Page->_route->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__route" id="z__route" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_route->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start__route" class="ew-search-field ew-search-field-single">
    <select
        id="x__route"
        name="x__route"
        class="form-control ew-select<?= $Page->_route->isInvalidClass() ?>"
        data-select2-id="ft_trip_startsearch_x__route"
        data-table="t_trip_start"
        data-field="x__route"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->_route->caption())) ?>"
        data-modal-lookup="true"
        data-page="0"
        data-value-separator="<?= $Page->_route->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_route->getPlaceHolder()) ?>"
        <?= $Page->_route->editAttributes() ?>>
        <?= $Page->_route->selectOptionListHtml("x__route") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_route->getErrorMessage(false) ?></div>
<?= $Page->_route->Lookup->getParamTag($Page, "p_x__route") ?>
<script>
loadjs.ready("ft_trip_startsearch", function() {
    var options = { name: "x__route", selectId: "ft_trip_startsearch_x__route" };
    if (ft_trip_startsearch.lists._route?.lookupOptions.length) {
        options.data = { id: "x__route", form: "ft_trip_startsearch" };
    } else {
        options.ajax = { id: "x__route", form: "ft_trip_startsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_start.fields._route.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
    <div id="r_vehicle_freight_type" class="row"<?= $Page->vehicle_freight_type->rowAttributes() ?>>
        <label for="x_vehicle_freight_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_vehicle_freight_type"><?= $Page->vehicle_freight_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_freight_type" id="z_vehicle_freight_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_freight_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_vehicle_freight_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_vehicle_freight_type"
        name="x_vehicle_freight_type"
        class="form-select ew-select<?= $Page->vehicle_freight_type->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_freight_type->IsNativeSelect) { ?>
        data-select2-id="ft_trip_startsearch_x_vehicle_freight_type"
        <?php } ?>
        data-table="t_trip_start"
        data-field="x_vehicle_freight_type"
        data-page="0"
        data-value-separator="<?= $Page->vehicle_freight_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_freight_type->getPlaceHolder()) ?>"
        <?= $Page->vehicle_freight_type->editAttributes() ?>>
        <?= $Page->vehicle_freight_type->selectOptionListHtml("x_vehicle_freight_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle_freight_type->getErrorMessage(false) ?></div>
<?php if (!$Page->vehicle_freight_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_startsearch", function() {
    var options = { name: "x_vehicle_freight_type", selectId: "ft_trip_startsearch_x_vehicle_freight_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_startsearch.lists.vehicle_freight_type?.lookupOptions.length) {
        options.data = { id: "x_vehicle_freight_type", form: "ft_trip_startsearch" };
    } else {
        options.ajax = { id: "x_vehicle_freight_type", form: "ft_trip_startsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_start.fields.vehicle_freight_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
    <div id="r_vehicle_freight_amount" class="row"<?= $Page->vehicle_freight_amount->rowAttributes() ?>>
        <label for="x_vehicle_freight_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_vehicle_freight_amount"><?= $Page->vehicle_freight_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_freight_amount" id="z_vehicle_freight_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_freight_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_vehicle_freight_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->vehicle_freight_amount->getInputTextType() ?>" name="x_vehicle_freight_amount" id="x_vehicle_freight_amount" data-table="t_trip_start" data-field="x_vehicle_freight_amount" value="<?= $Page->vehicle_freight_amount->EditValue ?>" data-page="0" size="30" placeholder="<?= HtmlEncode($Page->vehicle_freight_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->vehicle_freight_amount->formatPattern()) ?>"<?= $Page->vehicle_freight_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->vehicle_freight_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
    <div id="r_driver" class="row"<?= $Page->driver->rowAttributes() ?>>
        <label for="x_driver" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_driver"><?= $Page->driver->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_driver" id="z_driver" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->driver->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_driver" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->driver->getInputTextType() ?>" name="x_driver" id="x_driver" data-table="t_trip_start" data-field="x_driver" value="<?= $Page->driver->EditValue ?>" data-page="0" size="30" placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->driver->formatPattern()) ?>"<?= $Page->driver->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->driver->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
    <div id="r_vehicle_freight_comm" class="row"<?= $Page->vehicle_freight_comm->rowAttributes() ?>>
        <label for="x_vehicle_freight_comm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_vehicle_freight_comm"><?= $Page->vehicle_freight_comm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_freight_comm" id="z_vehicle_freight_comm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_freight_comm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_vehicle_freight_comm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->vehicle_freight_comm->getInputTextType() ?>" name="x_vehicle_freight_comm" id="x_vehicle_freight_comm" data-table="t_trip_start" data-field="x_vehicle_freight_comm" value="<?= $Page->vehicle_freight_comm->EditValue ?>" data-page="0" size="30" placeholder="<?= HtmlEncode($Page->vehicle_freight_comm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->vehicle_freight_comm->formatPattern()) ?>"<?= $Page->vehicle_freight_comm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->vehicle_freight_comm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_TTripStartSearch"><!-- multi-page accordion -->
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_start1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_start1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->reports_to->Visible) { // reports_to ?>
    <div id="r_reports_to" class="row"<?= $Page->reports_to->rowAttributes() ?>>
        <label for="x_reports_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_reports_to"><?= $Page->reports_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_reports_to" id="z_reports_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reports_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_reports_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_reports_to"
        name="x_reports_to"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="ft_trip_startsearch_x_reports_to"
        <?php } ?>
        data-table="t_trip_start"
        data-field="x_reports_to"
        data-page="1"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage(false) ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_startsearch", function() {
    var options = { name: "x_reports_to", selectId: "ft_trip_startsearch_x_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_startsearch.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to", form: "ft_trip_startsearch" };
    } else {
        options.ajax = { id: "x_reports_to", form: "ft_trip_startsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_start.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->material->Visible) { // material ?>
    <div id="r_material" class="row"<?= $Page->material->rowAttributes() ?>>
        <label for="x_material" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_material"><?= $Page->material->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_material" id="z_material" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->material->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_material" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->material->getInputTextType() ?>" name="x_material" id="x_material" data-table="t_trip_start" data-field="x_material" value="<?= $Page->material->EditValue ?>" data-page="1" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->material->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->material->formatPattern()) ?>"<?= $Page->material->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->material->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
    <div id="r__40" class="row"<?= $Page->_40->rowAttributes() ?>>
        <label for="x__40" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start__40"><?= $Page->_40->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__40" id="z__40" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_40->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start__40" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="t_trip_start" data-field="x__40" value="<?= $Page->_40->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
    <div id="r_buyer" class="row"<?= $Page->buyer->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_buyer"><?= $Page->buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer" id="z_buyer" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_buyer" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer"
        name="x_buyer"
        class="form-control ew-select<?= $Page->buyer->isInvalidClass() ?>"
        data-select2-id="ft_trip_startsearch_x_buyer"
        data-table="t_trip_start"
        data-field="x_buyer"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>"
        <?= $Page->buyer->editAttributes() ?>>
        <?= $Page->buyer->selectOptionListHtml("x_buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer->getErrorMessage(false) ?></div>
<?= $Page->buyer->Lookup->getParamTag($Page, "p_x_buyer") ?>
<script>
loadjs.ready("ft_trip_startsearch", function() {
    var options = { name: "x_buyer", selectId: "ft_trip_startsearch_x_buyer" };
    if (ft_trip_startsearch.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x_buyer", form: "ft_trip_startsearch" };
    } else {
        options.ajax = { id: "x_buyer", form: "ft_trip_startsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_start.fields.buyer.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
    <div id="r_agent" class="row"<?= $Page->agent->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_agent"><?= $Page->agent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_agent" id="z_agent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->agent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_agent" class="ew-search-field ew-search-field-single">
    <select
        id="x_agent"
        name="x_agent"
        class="form-control ew-select<?= $Page->agent->isInvalidClass() ?>"
        data-select2-id="ft_trip_startsearch_x_agent"
        data-table="t_trip_start"
        data-field="x_agent"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->agent->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
        <?= $Page->agent->editAttributes() ?>>
        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->agent->getErrorMessage(false) ?></div>
<?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
<script>
loadjs.ready("ft_trip_startsearch", function() {
    var options = { name: "x_agent", selectId: "ft_trip_startsearch_x_agent" };
    if (ft_trip_startsearch.lists.agent?.lookupOptions.length) {
        options.data = { id: "x_agent", form: "ft_trip_startsearch" };
    } else {
        options.ajax = { id: "x_agent", form: "ft_trip_startsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_start.fields.agent.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->comm->Visible) { // comm ?>
    <div id="r_comm" class="row"<?= $Page->comm->rowAttributes() ?>>
        <label for="x_comm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_comm"><?= $Page->comm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_comm" id="z_comm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->comm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_comm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->comm->getInputTextType() ?>" name="x_comm" id="x_comm" data-table="t_trip_start" data-field="x_comm" value="<?= $Page->comm->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->comm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->comm->formatPattern()) ?>"<?= $Page->comm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->comm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="t_trip_start" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" data-page="1" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_start2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_start2"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->gst_percent->Visible) { // gst_percent ?>
    <div id="r_gst_percent" class="row"<?= $Page->gst_percent->rowAttributes() ?>>
        <label for="x_gst_percent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_gst_percent"><?= $Page->gst_percent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gst_percent" id="z_gst_percent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gst_percent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_gst_percent" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gst_percent->getInputTextType() ?>" name="x_gst_percent" id="x_gst_percent" data-table="t_trip_start" data-field="x_gst_percent" value="<?= $Page->gst_percent->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->gst_percent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gst_percent->formatPattern()) ?>"<?= $Page->gst_percent->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gst_percent->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->freight_type->Visible) { // freight_type ?>
    <div id="r_freight_type" class="row"<?= $Page->freight_type->rowAttributes() ?>>
        <label for="x_freight_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_freight_type"><?= $Page->freight_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_freight_type" id="z_freight_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->freight_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_freight_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_freight_type"
        name="x_freight_type"
        class="form-select ew-select<?= $Page->freight_type->isInvalidClass() ?>"
        <?php if (!$Page->freight_type->IsNativeSelect) { ?>
        data-select2-id="ft_trip_startsearch_x_freight_type"
        <?php } ?>
        data-table="t_trip_start"
        data-field="x_freight_type"
        data-page="2"
        data-value-separator="<?= $Page->freight_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->freight_type->getPlaceHolder()) ?>"
        <?= $Page->freight_type->editAttributes() ?>>
        <?= $Page->freight_type->selectOptionListHtml("x_freight_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->freight_type->getErrorMessage(false) ?></div>
<?php if (!$Page->freight_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_startsearch", function() {
    var options = { name: "x_freight_type", selectId: "ft_trip_startsearch_x_freight_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_startsearch.lists.freight_type?.lookupOptions.length) {
        options.data = { id: "x_freight_type", form: "ft_trip_startsearch" };
    } else {
        options.ajax = { id: "x_freight_type", form: "ft_trip_startsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_start.fields.freight_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->freight->Visible) { // freight ?>
    <div id="r_freight" class="row"<?= $Page->freight->rowAttributes() ?>>
        <label for="x_freight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_freight"><?= $Page->freight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_freight" id="z_freight" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->freight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_freight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->freight->getInputTextType() ?>" name="x_freight" id="x_freight" data-table="t_trip_start" data-field="x_freight" value="<?= $Page->freight->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->freight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->freight->formatPattern()) ?>"<?= $Page->freight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->freight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(3)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_start3"><?= $Page->pageCaption(3) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(3)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_start3"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->load_date->Visible) { // load_date ?>
    <div id="r_load_date" class="row"<?= $Page->load_date->rowAttributes() ?>>
        <label for="x_load_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_load_date"><?= $Page->load_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_date" id="z_load_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->load_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_load_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->load_date->getInputTextType() ?>" name="x_load_date" id="x_load_date" data-table="t_trip_start" data-field="x_load_date" value="<?= $Page->load_date->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->load_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_date->formatPattern()) ?>"<?= $Page->load_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_date->getErrorMessage(false) ?></div>
<?php if (!$Page->load_date->ReadOnly && !$Page->load_date->Disabled && !isset($Page->load_date->EditAttrs["readonly"]) && !isset($Page->load_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_startsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_startsearch", "x_load_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->load_weight->Visible) { // load_weight ?>
    <div id="r_load_weight" class="row"<?= $Page->load_weight->rowAttributes() ?>>
        <label for="x_load_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_load_weight"><?= $Page->load_weight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_weight" id="z_load_weight" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->load_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_load_weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->load_weight->getInputTextType() ?>" name="x_load_weight" id="x_load_weight" data-table="t_trip_start" data-field="x_load_weight" value="<?= $Page->load_weight->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->load_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_weight->formatPattern()) ?>"<?= $Page->load_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->load_km->Visible) { // load_km ?>
    <div id="r_load_km" class="row"<?= $Page->load_km->rowAttributes() ?>>
        <label for="x_load_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_start_load_km"><?= $Page->load_km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_km" id="z_load_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->load_km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_start_load_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->load_km->getInputTextType() ?>" name="x_load_km" id="x_load_km" data-table="t_trip_start" data-field="x_load_km" value="<?= $Page->load_km->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->load_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_km->formatPattern()) ?>"<?= $Page->load_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_trip_startsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_trip_startsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ft_trip_startsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_trip_start");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
