<?php

namespace PHPMaker2024\fibre;

// Page object
$TTripLoadslipSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_loadslip: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ft_trip_loadslipsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_trip_loadslipsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["vehicle_type", [], fields.vehicle_type.isInvalid],
            ["vehicle", [ew.Validators.integer], fields.vehicle.isInvalid],
            ["_route", [ew.Validators.integer], fields._route.isInvalid],
            ["route_name", [], fields.route_name.isInvalid],
            ["driver", [], fields.driver.isInvalid],
            ["driver_name", [ew.Validators.integer], fields.driver_name.isInvalid],
            ["reports_to", [], fields.reports_to.isInvalid],
            ["buyer", [ew.Validators.integer], fields.buyer.isInvalid],
            ["b_consignor", [], fields.b_consignor.isInvalid],
            ["b_consignee", [], fields.b_consignee.isInvalid],
            ["agent", [ew.Validators.integer], fields.agent.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "vehicle_type": <?= $Page->vehicle_type->toClientList($Page) ?>,
            "vehicle": <?= $Page->vehicle->toClientList($Page) ?>,
            "_route": <?= $Page->_route->toClientList($Page) ?>,
            "driver": <?= $Page->driver->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
            "b_consignor": <?= $Page->b_consignor->toClientList($Page) ?>,
            "b_consignee": <?= $Page->b_consignee->toClientList($Page) ?>,
            "agent": <?= $Page->agent->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_trip_loadslipsearch" id="ft_trip_loadslipsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_trip_loadslip">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="t_trip_loadslip" data-field="x_id" value="<?= $Page->id->EditValue ?>" data-page="0" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_type->Visible) { // vehicle_type ?>
    <div id="r_vehicle_type" class="row"<?= $Page->vehicle_type->rowAttributes() ?>>
        <label for="x_vehicle_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_vehicle_type"><?= $Page->vehicle_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_type" id="z_vehicle_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip_vehicle_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_vehicle_type"
        name="x_vehicle_type"
        class="form-select ew-select<?= $Page->vehicle_type->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_type->IsNativeSelect) { ?>
        data-select2-id="ft_trip_loadslipsearch_x_vehicle_type"
        <?php } ?>
        data-table="t_trip_loadslip"
        data-field="x_vehicle_type"
        data-page="0"
        data-value-separator="<?= $Page->vehicle_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->vehicle_type->editAttributes() ?>>
        <?= $Page->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle_type->getErrorMessage(false) ?></div>
<?php if (!$Page->vehicle_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_loadslipsearch", function() {
    var options = { name: "x_vehicle_type", selectId: "ft_trip_loadslipsearch_x_vehicle_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_loadslipsearch.lists.vehicle_type?.lookupOptions.length) {
        options.data = { id: "x_vehicle_type", form: "ft_trip_loadslipsearch" };
    } else {
        options.ajax = { id: "x_vehicle_type", form: "ft_trip_loadslipsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_loadslip.fields.vehicle_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle->Visible) { // vehicle ?>
    <div id="r_vehicle" class="row"<?= $Page->vehicle->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_vehicle"><?= $Page->vehicle->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle" id="z_vehicle" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip_vehicle" class="ew-search-field ew-search-field-single">
    <select
        id="x_vehicle"
        name="x_vehicle"
        class="form-control ew-select<?= $Page->vehicle->isInvalidClass() ?>"
        data-select2-id="ft_trip_loadslipsearch_x_vehicle"
        data-table="t_trip_loadslip"
        data-field="x_vehicle"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->vehicle->caption())) ?>"
        data-modal-lookup="true"
        data-page="0"
        data-value-separator="<?= $Page->vehicle->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle->getPlaceHolder()) ?>"
        <?= $Page->vehicle->editAttributes() ?>>
        <?= $Page->vehicle->selectOptionListHtml("x_vehicle") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle->getErrorMessage(false) ?></div>
<?= $Page->vehicle->Lookup->getParamTag($Page, "p_x_vehicle") ?>
<script>
loadjs.ready("ft_trip_loadslipsearch", function() {
    var options = { name: "x_vehicle", selectId: "ft_trip_loadslipsearch_x_vehicle" };
    if (ft_trip_loadslipsearch.lists.vehicle?.lookupOptions.length) {
        options.data = { id: "x_vehicle", form: "ft_trip_loadslipsearch" };
    } else {
        options.ajax = { id: "x_vehicle", form: "ft_trip_loadslipsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_loadslip.fields.vehicle.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_route->Visible) { // route ?>
    <div id="r__route" class="row"<?= $Page->_route->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip__route"><?= $Page->_route->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__route" id="z__route" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_route->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip__route" class="ew-search-field ew-search-field-single">
    <select
        id="x__route"
        name="x__route"
        class="form-control ew-select<?= $Page->_route->isInvalidClass() ?>"
        data-select2-id="ft_trip_loadslipsearch_x__route"
        data-table="t_trip_loadslip"
        data-field="x__route"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->_route->caption())) ?>"
        data-modal-lookup="true"
        data-page="0"
        data-value-separator="<?= $Page->_route->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_route->getPlaceHolder()) ?>"
        <?= $Page->_route->editAttributes() ?>>
        <?= $Page->_route->selectOptionListHtml("x__route") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_route->getErrorMessage(false) ?></div>
<?= $Page->_route->Lookup->getParamTag($Page, "p_x__route") ?>
<script>
loadjs.ready("ft_trip_loadslipsearch", function() {
    var options = { name: "x__route", selectId: "ft_trip_loadslipsearch_x__route" };
    if (ft_trip_loadslipsearch.lists._route?.lookupOptions.length) {
        options.data = { id: "x__route", form: "ft_trip_loadslipsearch" };
    } else {
        options.ajax = { id: "x__route", form: "ft_trip_loadslipsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_loadslip.fields._route.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->route_name->Visible) { // route_name ?>
    <div id="r_route_name" class="row"<?= $Page->route_name->rowAttributes() ?>>
        <label for="x_route_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_route_name"><?= $Page->route_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_route_name" id="z_route_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->route_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip_route_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->route_name->getInputTextType() ?>" name="x_route_name" id="x_route_name" data-table="t_trip_loadslip" data-field="x_route_name" value="<?= $Page->route_name->EditValue ?>" data-page="0" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->route_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->route_name->formatPattern()) ?>"<?= $Page->route_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->route_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
    <div id="r_driver" class="row"<?= $Page->driver->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_driver"><?= $Page->driver->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_driver" id="z_driver" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->driver->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip_driver" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->driver->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_driver" class="ew-auto-suggest">
    <input type="<?= $Page->driver->getInputTextType() ?>" class="form-control" name="sv_x_driver" id="sv_x_driver" value="<?= RemoveHtml($Page->driver->EditValue) ?>" autocomplete="off" size="50" placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->driver->formatPattern()) ?>"<?= $Page->driver->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="t_trip_loadslip" data-field="x_driver" data-input="sv_x_driver" data-page="0" data-value-separator="<?= $Page->driver->displayValueSeparatorAttribute() ?>" name="x_driver" id="x_driver" value="<?= HtmlEncode($Page->driver->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->driver->getErrorMessage(false) ?></div>
<script>
loadjs.ready("ft_trip_loadslipsearch", function() {
    ft_trip_loadslipsearch.createAutoSuggest(Object.assign({"id":"x_driver","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->driver->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.t_trip_loadslip.fields.driver.autoSuggestOptions));
});
</script>
<?= $Page->driver->Lookup->getParamTag($Page, "p_x_driver") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->driver_name->Visible) { // driver_name ?>
    <div id="r_driver_name" class="row"<?= $Page->driver_name->rowAttributes() ?>>
        <label for="x_driver_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_driver_name"><?= $Page->driver_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_driver_name" id="z_driver_name" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->driver_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip_driver_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->driver_name->getInputTextType() ?>" name="x_driver_name" id="x_driver_name" data-table="t_trip_loadslip" data-field="x_driver_name" value="<?= $Page->driver_name->EditValue ?>" data-page="0" size="30" maxlength="92" placeholder="<?= HtmlEncode($Page->driver_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->driver_name->formatPattern()) ?>"<?= $Page->driver_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->driver_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_TTripLoadslipSearch"><!-- multi-page accordion -->
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_loadslip1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_loadslip1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->reports_to->Visible) { // reports_to ?>
    <div id="r_reports_to" class="row"<?= $Page->reports_to->rowAttributes() ?>>
        <label for="x_reports_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_reports_to"><?= $Page->reports_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_reports_to" id="z_reports_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reports_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip_reports_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_reports_to"
        name="x_reports_to"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="ft_trip_loadslipsearch_x_reports_to"
        <?php } ?>
        data-table="t_trip_loadslip"
        data-field="x_reports_to"
        data-page="1"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage(false) ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_loadslipsearch", function() {
    var options = { name: "x_reports_to", selectId: "ft_trip_loadslipsearch_x_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_loadslipsearch.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to", form: "ft_trip_loadslipsearch" };
    } else {
        options.ajax = { id: "x_reports_to", form: "ft_trip_loadslipsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_loadslip.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
    <div id="r_buyer" class="row"<?= $Page->buyer->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_buyer"><?= $Page->buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer" id="z_buyer" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip_buyer" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer"
        name="x_buyer"
        class="form-control ew-select<?= $Page->buyer->isInvalidClass() ?>"
        data-select2-id="ft_trip_loadslipsearch_x_buyer"
        data-table="t_trip_loadslip"
        data-field="x_buyer"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>"
        <?= $Page->buyer->editAttributes() ?>>
        <?= $Page->buyer->selectOptionListHtml("x_buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer->getErrorMessage(false) ?></div>
<?= $Page->buyer->Lookup->getParamTag($Page, "p_x_buyer") ?>
<script>
loadjs.ready("ft_trip_loadslipsearch", function() {
    var options = { name: "x_buyer", selectId: "ft_trip_loadslipsearch_x_buyer" };
    if (ft_trip_loadslipsearch.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x_buyer", form: "ft_trip_loadslipsearch" };
    } else {
        options.ajax = { id: "x_buyer", form: "ft_trip_loadslipsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_loadslip.fields.buyer.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_consignor->Visible) { // b_consignor ?>
    <div id="r_b_consignor" class="row"<?= $Page->b_consignor->rowAttributes() ?>>
        <label for="x_b_consignor" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_b_consignor"><?= $Page->b_consignor->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_consignor" id="z_b_consignor" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_consignor->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip_b_consignor" class="ew-search-field ew-search-field-single">
    <select
        id="x_b_consignor"
        name="x_b_consignor"
        class="form-control ew-select<?= $Page->b_consignor->isInvalidClass() ?>"
        data-select2-id="ft_trip_loadslipsearch_x_b_consignor"
        data-table="t_trip_loadslip"
        data-field="x_b_consignor"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->b_consignor->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->b_consignor->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->b_consignor->getPlaceHolder()) ?>"
        <?= $Page->b_consignor->editAttributes() ?>>
        <?= $Page->b_consignor->selectOptionListHtml("x_b_consignor") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->b_consignor->getErrorMessage(false) ?></div>
<?= $Page->b_consignor->Lookup->getParamTag($Page, "p_x_b_consignor") ?>
<script>
loadjs.ready("ft_trip_loadslipsearch", function() {
    var options = { name: "x_b_consignor", selectId: "ft_trip_loadslipsearch_x_b_consignor" };
    if (ft_trip_loadslipsearch.lists.b_consignor?.lookupOptions.length) {
        options.data = { id: "x_b_consignor", form: "ft_trip_loadslipsearch" };
    } else {
        options.ajax = { id: "x_b_consignor", form: "ft_trip_loadslipsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_loadslip.fields.b_consignor.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_consignee->Visible) { // b_consignee ?>
    <div id="r_b_consignee" class="row"<?= $Page->b_consignee->rowAttributes() ?>>
        <label for="x_b_consignee" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_b_consignee"><?= $Page->b_consignee->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_consignee" id="z_b_consignee" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_consignee->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip_b_consignee" class="ew-search-field ew-search-field-single">
    <select
        id="x_b_consignee"
        name="x_b_consignee"
        class="form-control ew-select<?= $Page->b_consignee->isInvalidClass() ?>"
        data-select2-id="ft_trip_loadslipsearch_x_b_consignee"
        data-table="t_trip_loadslip"
        data-field="x_b_consignee"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->b_consignee->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->b_consignee->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->b_consignee->getPlaceHolder()) ?>"
        <?= $Page->b_consignee->editAttributes() ?>>
        <?= $Page->b_consignee->selectOptionListHtml("x_b_consignee") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->b_consignee->getErrorMessage(false) ?></div>
<?= $Page->b_consignee->Lookup->getParamTag($Page, "p_x_b_consignee") ?>
<script>
loadjs.ready("ft_trip_loadslipsearch", function() {
    var options = { name: "x_b_consignee", selectId: "ft_trip_loadslipsearch_x_b_consignee" };
    if (ft_trip_loadslipsearch.lists.b_consignee?.lookupOptions.length) {
        options.data = { id: "x_b_consignee", form: "ft_trip_loadslipsearch" };
    } else {
        options.ajax = { id: "x_b_consignee", form: "ft_trip_loadslipsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_loadslip.fields.b_consignee.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
    <div id="r_agent" class="row"<?= $Page->agent->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_agent"><?= $Page->agent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_agent" id="z_agent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->agent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip_agent" class="ew-search-field ew-search-field-single">
    <select
        id="x_agent"
        name="x_agent"
        class="form-control ew-select<?= $Page->agent->isInvalidClass() ?>"
        data-select2-id="ft_trip_loadslipsearch_x_agent"
        data-table="t_trip_loadslip"
        data-field="x_agent"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->agent->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
        <?= $Page->agent->editAttributes() ?>>
        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->agent->getErrorMessage(false) ?></div>
<?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
<script>
loadjs.ready("ft_trip_loadslipsearch", function() {
    var options = { name: "x_agent", selectId: "ft_trip_loadslipsearch_x_agent" };
    if (ft_trip_loadslipsearch.lists.agent?.lookupOptions.length) {
        options.data = { id: "x_agent", form: "ft_trip_loadslipsearch" };
    } else {
        options.ajax = { id: "x_agent", form: "ft_trip_loadslipsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_loadslip.fields.agent.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="t_trip_loadslip" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_loadslip_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="t_trip_loadslip" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_loadslipsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_loadslipsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_trip_loadslipsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_trip_loadslipsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ft_trip_loadslipsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_trip_loadslip");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
