<?php

namespace PHPMaker2024\fibre;

// Page object
$TTripLoadslipList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_loadslip: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ft_trip_loadslipsrch" id="ft_trip_loadslipsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="ft_trip_loadslipsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_loadslip: currentTable } });
var currentForm;
var ft_trip_loadslipsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_trip_loadslipsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["vehicle_type", [], fields.vehicle_type.isInvalid],
            ["vehicle", [ew.Validators.integer], fields.vehicle.isInvalid],
            ["buyer", [ew.Validators.integer], fields.buyer.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "vehicle_type": <?= $Page->vehicle_type->toClientList($Page) ?>,
            "vehicle": <?= $Page->vehicle->toClientList($Page) ?>,
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->vehicle_type->Visible) { // vehicle_type ?>
<?php
if (!$Page->vehicle_type->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_vehicle_type" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->vehicle_type->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_vehicle_type" class="ew-search-caption ew-label"><?= $Page->vehicle_type->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_type" id="z_vehicle_type" value="=">
</div>
        </div>
        <div id="el_t_trip_loadslip_vehicle_type" class="ew-search-field">
    <select
        id="x_vehicle_type"
        name="x_vehicle_type"
        class="form-select ew-select<?= $Page->vehicle_type->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_type->IsNativeSelect) { ?>
        data-select2-id="ft_trip_loadslipsrch_x_vehicle_type"
        <?php } ?>
        data-table="t_trip_loadslip"
        data-field="x_vehicle_type"
        data-value-separator="<?= $Page->vehicle_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->vehicle_type->editAttributes() ?>>
        <?= $Page->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle_type->getErrorMessage(false) ?></div>
<?php if (!$Page->vehicle_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_loadslipsrch", function() {
    var options = { name: "x_vehicle_type", selectId: "ft_trip_loadslipsrch_x_vehicle_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_loadslipsrch.lists.vehicle_type?.lookupOptions.length) {
        options.data = { id: "x_vehicle_type", form: "ft_trip_loadslipsrch" };
    } else {
        options.ajax = { id: "x_vehicle_type", form: "ft_trip_loadslipsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_loadslip.fields.vehicle_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->vehicle->Visible) { // vehicle ?>
<?php
if (!$Page->vehicle->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_vehicle" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->vehicle->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->vehicle->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle" id="z_vehicle" value="=">
</div>
        </div>
        <div id="el_t_trip_loadslip_vehicle" class="ew-search-field">
    <select
        id="x_vehicle"
        name="x_vehicle"
        class="form-control ew-select<?= $Page->vehicle->isInvalidClass() ?>"
        data-select2-id="ft_trip_loadslipsrch_x_vehicle"
        data-table="t_trip_loadslip"
        data-field="x_vehicle"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->vehicle->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->vehicle->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle->getPlaceHolder()) ?>"
        <?= $Page->vehicle->editAttributes() ?>>
        <?= $Page->vehicle->selectOptionListHtml("x_vehicle") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle->getErrorMessage(false) ?></div>
<?= $Page->vehicle->Lookup->getParamTag($Page, "p_x_vehicle") ?>
<script>
loadjs.ready("ft_trip_loadslipsrch", function() {
    var options = { name: "x_vehicle", selectId: "ft_trip_loadslipsrch_x_vehicle" };
    if (ft_trip_loadslipsrch.lists.vehicle?.lookupOptions.length) {
        options.data = { id: "x_vehicle", form: "ft_trip_loadslipsrch" };
    } else {
        options.ajax = { id: "x_vehicle", form: "ft_trip_loadslipsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_loadslip.fields.vehicle.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
<?php
if (!$Page->buyer->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->buyer->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer" id="z_buyer" value="=">
</div>
        </div>
        <div id="el_t_trip_loadslip_buyer" class="ew-search-field">
    <select
        id="x_buyer"
        name="x_buyer"
        class="form-control ew-select<?= $Page->buyer->isInvalidClass() ?>"
        data-select2-id="ft_trip_loadslipsrch_x_buyer"
        data-table="t_trip_loadslip"
        data-field="x_buyer"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>"
        <?= $Page->buyer->editAttributes() ?>>
        <?= $Page->buyer->selectOptionListHtml("x_buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer->getErrorMessage(false) ?></div>
<?= $Page->buyer->Lookup->getParamTag($Page, "p_x_buyer") ?>
<script>
loadjs.ready("ft_trip_loadslipsrch", function() {
    var options = { name: "x_buyer", selectId: "ft_trip_loadslipsrch_x_buyer" };
    if (ft_trip_loadslipsrch.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x_buyer", form: "ft_trip_loadslipsrch" };
    } else {
        options.ajax = { id: "x_buyer", form: "ft_trip_loadslipsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_loadslip.fields.buyer.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="ft_trip_loadslipsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="ft_trip_loadslipsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="ft_trip_loadslipsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ft_trip_loadslipsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ft_trip_loadslipsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ft_trip_loadslipsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ft_trip_loadslipsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_trip_loadslip">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_t_trip_loadslip" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_t_trip_loadsliplist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_t_trip_loadslip_id" class="t_trip_loadslip_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->vehicle_type->Visible) { // vehicle_type ?>
        <th data-name="vehicle_type" class="<?= $Page->vehicle_type->headerCellClass() ?>"><div id="elh_t_trip_loadslip_vehicle_type" class="t_trip_loadslip_vehicle_type"><?= $Page->renderFieldHeader($Page->vehicle_type) ?></div></th>
<?php } ?>
<?php if ($Page->vehicle->Visible) { // vehicle ?>
        <th data-name="vehicle" class="<?= $Page->vehicle->headerCellClass() ?>"><div id="elh_t_trip_loadslip_vehicle" class="t_trip_loadslip_vehicle"><?= $Page->renderFieldHeader($Page->vehicle) ?></div></th>
<?php } ?>
<?php if ($Page->route_name->Visible) { // route_name ?>
        <th data-name="route_name" class="<?= $Page->route_name->headerCellClass() ?>"><div id="elh_t_trip_loadslip_route_name" class="t_trip_loadslip_route_name"><?= $Page->renderFieldHeader($Page->route_name) ?></div></th>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
        <th data-name="driver" class="<?= $Page->driver->headerCellClass() ?>"><div id="elh_t_trip_loadslip_driver" class="t_trip_loadslip_driver"><?= $Page->renderFieldHeader($Page->driver) ?></div></th>
<?php } ?>
<?php if ($Page->driver_name->Visible) { // driver_name ?>
        <th data-name="driver_name" class="<?= $Page->driver_name->headerCellClass() ?>"><div id="elh_t_trip_loadslip_driver_name" class="t_trip_loadslip_driver_name"><?= $Page->renderFieldHeader($Page->driver_name) ?></div></th>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
        <th data-name="reports_to" class="<?= $Page->reports_to->headerCellClass() ?>"><div id="elh_t_trip_loadslip_reports_to" class="t_trip_loadslip_reports_to"><?= $Page->renderFieldHeader($Page->reports_to) ?></div></th>
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
        <th data-name="buyer" class="<?= $Page->buyer->headerCellClass() ?>"><div id="elh_t_trip_loadslip_buyer" class="t_trip_loadslip_buyer"><?= $Page->renderFieldHeader($Page->buyer) ?></div></th>
<?php } ?>
<?php if ($Page->b_consignor->Visible) { // b_consignor ?>
        <th data-name="b_consignor" class="<?= $Page->b_consignor->headerCellClass() ?>"><div id="elh_t_trip_loadslip_b_consignor" class="t_trip_loadslip_b_consignor"><?= $Page->renderFieldHeader($Page->b_consignor) ?></div></th>
<?php } ?>
<?php if ($Page->b_consignee->Visible) { // b_consignee ?>
        <th data-name="b_consignee" class="<?= $Page->b_consignee->headerCellClass() ?>"><div id="elh_t_trip_loadslip_b_consignee" class="t_trip_loadslip_b_consignee"><?= $Page->renderFieldHeader($Page->b_consignee) ?></div></th>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
        <th data-name="agent" class="<?= $Page->agent->headerCellClass() ?>"><div id="elh_t_trip_loadslip_agent" class="t_trip_loadslip_agent"><?= $Page->renderFieldHeader($Page->agent) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_t_trip_loadslip_operator" class="t_trip_loadslip_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_t_trip_loadslip_datetime" class="t_trip_loadslip_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_loadslip_id" class="el_t_trip_loadslip_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->vehicle_type->Visible) { // vehicle_type ?>
        <td data-name="vehicle_type"<?= $Page->vehicle_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_loadslip_vehicle_type" class="el_t_trip_loadslip_vehicle_type">
<span<?= $Page->vehicle_type->viewAttributes() ?>>
<?= $Page->vehicle_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->vehicle->Visible) { // vehicle ?>
        <td data-name="vehicle"<?= $Page->vehicle->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_loadslip_vehicle" class="el_t_trip_loadslip_vehicle">
<span<?= $Page->vehicle->viewAttributes() ?>>
<?= $Page->vehicle->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->route_name->Visible) { // route_name ?>
        <td data-name="route_name"<?= $Page->route_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_loadslip_route_name" class="el_t_trip_loadslip_route_name">
<span<?= $Page->route_name->viewAttributes() ?>>
<?= $Page->route_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->driver->Visible) { // driver ?>
        <td data-name="driver"<?= $Page->driver->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_loadslip_driver" class="el_t_trip_loadslip_driver">
<span<?= $Page->driver->viewAttributes() ?>>
<?= $Page->driver->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->driver_name->Visible) { // driver_name ?>
        <td data-name="driver_name"<?= $Page->driver_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_loadslip_driver_name" class="el_t_trip_loadslip_driver_name">
<span<?= $Page->driver_name->viewAttributes() ?>>
<?= $Page->driver_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->reports_to->Visible) { // reports_to ?>
        <td data-name="reports_to"<?= $Page->reports_to->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_loadslip_reports_to" class="el_t_trip_loadslip_reports_to">
<span<?= $Page->reports_to->viewAttributes() ?>>
<?= $Page->reports_to->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer->Visible) { // buyer ?>
        <td data-name="buyer"<?= $Page->buyer->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_loadslip_buyer" class="el_t_trip_loadslip_buyer">
<span<?= $Page->buyer->viewAttributes() ?>>
<?= $Page->buyer->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_consignor->Visible) { // b_consignor ?>
        <td data-name="b_consignor"<?= $Page->b_consignor->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_loadslip_b_consignor" class="el_t_trip_loadslip_b_consignor">
<span<?= $Page->b_consignor->viewAttributes() ?>>
<?= $Page->b_consignor->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_consignee->Visible) { // b_consignee ?>
        <td data-name="b_consignee"<?= $Page->b_consignee->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_loadslip_b_consignee" class="el_t_trip_loadslip_b_consignee">
<span<?= $Page->b_consignee->viewAttributes() ?>>
<?= $Page->b_consignee->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->agent->Visible) { // agent ?>
        <td data-name="agent"<?= $Page->agent->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_loadslip_agent" class="el_t_trip_loadslip_agent">
<span<?= $Page->agent->viewAttributes() ?>>
<?= $Page->agent->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_loadslip_operator" class="el_t_trip_loadslip_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_loadslip_datetime" class="el_t_trip_loadslip_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_trip_loadslip");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
