<?php

namespace PHPMaker2024\fibre;

// Page object
$TTripInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ft_trip_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_trip_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["vehicle_type", [], fields.vehicle_type.isInvalid],
            ["vehicle", [ew.Validators.integer], fields.vehicle.isInvalid],
            ["_route", [ew.Validators.integer], fields._route.isInvalid],
            ["route_name", [], fields.route_name.isInvalid],
            ["reports_to", [], fields.reports_to.isInvalid],
            ["buyer", [ew.Validators.integer], fields.buyer.isInvalid],
            ["b_consignor", [], fields.b_consignor.isInvalid],
            ["y_b_consignor", [ew.Validators.between], false],
            ["b_consignee", [], fields.b_consignee.isInvalid],
            ["y_b_consignee", [ew.Validators.between], false],
            ["load_date", [ew.Validators.datetime(fields.load_date.clientFormatPattern)], fields.load_date.isInvalid],
            ["load_weight", [ew.Validators.integer], fields.load_weight.isInvalid],
            ["unload_date", [ew.Validators.datetime(fields.unload_date.clientFormatPattern)], fields.unload_date.isInvalid],
            ["unload_weight", [ew.Validators.integer], fields.unload_weight.isInvalid],
            ["invoice_no", [ew.Validators.integer], fields.invoice_no.isInvalid],
            ["invoice_date", [ew.Validators.datetime(fields.invoice_date.clientFormatPattern)], fields.invoice_date.isInvalid],
            ["y_invoice_date", [ew.Validators.between], false],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["delivery_pod", [], fields.delivery_pod.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["days", [ew.Validators.integer], fields.days.isInvalid],
            ["driver", [], fields.driver.isInvalid],
            ["driver_name", [], fields.driver_name.isInvalid],
            ["agent", [ew.Validators.integer], fields.agent.isInvalid],
            ["comm", [ew.Validators.float], fields.comm.isInvalid],
            ["material", [], fields.material.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["m_hsn", [], fields.m_hsn.isInvalid],
            ["_40", [ew.Validators.float], fields._40.isInvalid],
            ["lr_no", [], fields.lr_no.isInvalid],
            ["km", [ew.Validators.float], fields.km.isInvalid],
            ["freight_type", [], fields.freight_type.isInvalid],
            ["freight", [ew.Validators.float], fields.freight.isInvalid],
            ["ded_det", [ew.Validators.float], fields.ded_det.isInvalid],
            ["ded_det_remarks", [], fields.ded_det_remarks.isInvalid],
            ["gst_percent", [ew.Validators.float], fields.gst_percent.isInvalid],
            ["gst_amount", [ew.Validators.float], fields.gst_amount.isInvalid],
            ["final_amount", [ew.Validators.float], fields.final_amount.isInvalid],
            ["load_km", [ew.Validators.integer], fields.load_km.isInvalid],
            ["unload_km", [ew.Validators.integer], fields.unload_km.isInvalid],
            ["delivery_receipt", [], fields.delivery_receipt.isInvalid],
            ["delivery_docket", [], fields.delivery_docket.isInvalid],
            ["diesal_op_b", [ew.Validators.float], fields.diesal_op_b.isInvalid],
            ["diesal_required", [ew.Validators.float], fields.diesal_required.isInvalid],
            ["diesal_fill", [ew.Validators.float], fields.diesal_fill.isInvalid],
            ["diesal_amount", [ew.Validators.float], fields.diesal_amount.isInvalid],
            ["diesal_cl_balance", [ew.Validators.float], fields.diesal_cl_balance.isInvalid],
            ["vehicle_average", [ew.Validators.float], fields.vehicle_average.isInvalid],
            ["cash_required", [ew.Validators.float], fields.cash_required.isInvalid],
            ["cash_op_b", [ew.Validators.float], fields.cash_op_b.isInvalid],
            ["cash_paid", [ew.Validators.float], fields.cash_paid.isInvalid],
            ["cash_expenses", [ew.Validators.float], fields.cash_expenses.isInvalid],
            ["cash_cl_balance", [ew.Validators.float], fields.cash_cl_balance.isInvalid],
            ["fasttag_op_b", [ew.Validators.float], fields.fasttag_op_b.isInvalid],
            ["fasttag_recharge", [ew.Validators.float], fields.fasttag_recharge.isInvalid],
            ["fasttag_expenses", [ew.Validators.float], fields.fasttag_expenses.isInvalid],
            ["toll_expenses_cash", [ew.Validators.float], fields.toll_expenses_cash.isInvalid],
            ["fasttag_cl_balance", [ew.Validators.float], fields.fasttag_cl_balance.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["uploads", [], fields.uploads.isInvalid],
            ["consignor", [ew.Validators.integer], fields.consignor.isInvalid],
            ["vehicle_freight_comm", [ew.Validators.float], fields.vehicle_freight_comm.isInvalid],
            ["vehicle_freight_type", [], fields.vehicle_freight_type.isInvalid],
            ["vehicle_freight_amount", [ew.Validators.float], fields.vehicle_freight_amount.isInvalid],
            ["vehicle_freight_final", [ew.Validators.float], fields.vehicle_freight_final.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "vehicle_type": <?= $Page->vehicle_type->toClientList($Page) ?>,
            "vehicle": <?= $Page->vehicle->toClientList($Page) ?>,
            "_route": <?= $Page->_route->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
            "b_consignor": <?= $Page->b_consignor->toClientList($Page) ?>,
            "b_consignee": <?= $Page->b_consignee->toClientList($Page) ?>,
            "delivery_pod": <?= $Page->delivery_pod->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "driver": <?= $Page->driver->toClientList($Page) ?>,
            "agent": <?= $Page->agent->toClientList($Page) ?>,
            "freight_type": <?= $Page->freight_type->toClientList($Page) ?>,
            "consignor": <?= $Page->consignor->toClientList($Page) ?>,
            "vehicle_freight_type": <?= $Page->vehicle_freight_type->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_trip_infosearch" id="ft_trip_infosearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_trip_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="t_trip_info" data-field="x_id" value="<?= $Page->id->EditValue ?>" data-page="0" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_type->Visible) { // vehicle_type ?>
    <div id="r_vehicle_type" class="row"<?= $Page->vehicle_type->rowAttributes() ?>>
        <label for="x_vehicle_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_type"><?= $Page->vehicle_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_type" id="z_vehicle_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_vehicle_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_vehicle_type"
        name="x_vehicle_type"
        class="form-select ew-select<?= $Page->vehicle_type->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_type->IsNativeSelect) { ?>
        data-select2-id="ft_trip_infosearch_x_vehicle_type"
        <?php } ?>
        data-table="t_trip_info"
        data-field="x_vehicle_type"
        data-page="0"
        data-value-separator="<?= $Page->vehicle_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->vehicle_type->editAttributes() ?>>
        <?= $Page->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle_type->getErrorMessage(false) ?></div>
<?php if (!$Page->vehicle_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "x_vehicle_type", selectId: "ft_trip_infosearch_x_vehicle_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_infosearch.lists.vehicle_type?.lookupOptions.length) {
        options.data = { id: "x_vehicle_type", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "x_vehicle_type", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info.fields.vehicle_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle->Visible) { // vehicle ?>
    <div id="r_vehicle" class="row"<?= $Page->vehicle->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle"><?= $Page->vehicle->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle" id="z_vehicle" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_vehicle" class="ew-search-field ew-search-field-single">
    <select
        id="x_vehicle"
        name="x_vehicle"
        class="form-control ew-select<?= $Page->vehicle->isInvalidClass() ?>"
        data-select2-id="ft_trip_infosearch_x_vehicle"
        data-table="t_trip_info"
        data-field="x_vehicle"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->vehicle->caption())) ?>"
        data-modal-lookup="true"
        data-page="0"
        data-value-separator="<?= $Page->vehicle->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle->getPlaceHolder()) ?>"
        <?= $Page->vehicle->editAttributes() ?>>
        <?= $Page->vehicle->selectOptionListHtml("x_vehicle") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle->getErrorMessage(false) ?></div>
<?= $Page->vehicle->Lookup->getParamTag($Page, "p_x_vehicle") ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "x_vehicle", selectId: "ft_trip_infosearch_x_vehicle" };
    if (ft_trip_infosearch.lists.vehicle?.lookupOptions.length) {
        options.data = { id: "x_vehicle", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "x_vehicle", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.vehicle.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_route->Visible) { // route ?>
    <div id="r__route" class="row"<?= $Page->_route->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info__route"><?= $Page->_route->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__route" id="z__route" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_route->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info__route" class="ew-search-field ew-search-field-single">
    <select
        id="x__route"
        name="x__route"
        class="form-control ew-select<?= $Page->_route->isInvalidClass() ?>"
        data-select2-id="ft_trip_infosearch_x__route"
        data-table="t_trip_info"
        data-field="x__route"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->_route->caption())) ?>"
        data-modal-lookup="true"
        data-page="0"
        data-value-separator="<?= $Page->_route->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_route->getPlaceHolder()) ?>"
        <?= $Page->_route->editAttributes() ?>>
        <?= $Page->_route->selectOptionListHtml("x__route") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_route->getErrorMessage(false) ?></div>
<?= $Page->_route->Lookup->getParamTag($Page, "p_x__route") ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "x__route", selectId: "ft_trip_infosearch_x__route" };
    if (ft_trip_infosearch.lists._route?.lookupOptions.length) {
        options.data = { id: "x__route", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "x__route", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields._route.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->route_name->Visible) { // route_name ?>
    <div id="r_route_name" class="row"<?= $Page->route_name->rowAttributes() ?>>
        <label for="x_route_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_route_name"><?= $Page->route_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_route_name" id="z_route_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->route_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_route_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->route_name->getInputTextType() ?>" name="x_route_name" id="x_route_name" data-table="t_trip_info" data-field="x_route_name" value="<?= $Page->route_name->EditValue ?>" data-page="0" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->route_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->route_name->formatPattern()) ?>"<?= $Page->route_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->route_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="ft_trip_infosearch_x_status"
        <?php } ?>
        data-table="t_trip_info"
        data-field="x_status"
        data-page="0"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "x_status", selectId: "ft_trip_infosearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_infosearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "x_status", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->days->Visible) { // days ?>
    <div id="r_days" class="row"<?= $Page->days->rowAttributes() ?>>
        <label for="x_days" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_days"><?= $Page->days->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_days" id="z_days" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->days->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_days" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->days->getInputTextType() ?>" name="x_days" id="x_days" data-table="t_trip_info" data-field="x_days" value="<?= $Page->days->EditValue ?>" data-page="0" size="30" placeholder="<?= HtmlEncode($Page->days->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->days->formatPattern()) ?>"<?= $Page->days->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->days->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
    <div id="r_driver" class="row"<?= $Page->driver->rowAttributes() ?>>
        <label for="x_driver" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_driver"><?= $Page->driver->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_driver" id="z_driver" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->driver->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_driver" class="ew-search-field ew-search-field-single">
    <select
        id="x_driver"
        name="x_driver"
        class="form-select ew-select<?= $Page->driver->isInvalidClass() ?>"
        <?php if (!$Page->driver->IsNativeSelect) { ?>
        data-select2-id="ft_trip_infosearch_x_driver"
        <?php } ?>
        data-table="t_trip_info"
        data-field="x_driver"
        data-page="0"
        data-value-separator="<?= $Page->driver->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>"
        <?= $Page->driver->editAttributes() ?>>
        <?= $Page->driver->selectOptionListHtml("x_driver") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->driver->getErrorMessage(false) ?></div>
<?= $Page->driver->Lookup->getParamTag($Page, "p_x_driver") ?>
<?php if (!$Page->driver->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "x_driver", selectId: "ft_trip_infosearch_x_driver" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_infosearch.lists.driver?.lookupOptions.length) {
        options.data = { id: "x_driver", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "x_driver", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info.fields.driver.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->driver_name->Visible) { // driver_name ?>
    <div id="r_driver_name" class="row"<?= $Page->driver_name->rowAttributes() ?>>
        <label for="x_driver_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_driver_name"><?= $Page->driver_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_driver_name" id="z_driver_name" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->driver_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_driver_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->driver_name->getInputTextType() ?>" name="x_driver_name" id="x_driver_name" data-table="t_trip_info" data-field="x_driver_name" value="<?= $Page->driver_name->EditValue ?>" data-page="0" size="30" maxlength="92" placeholder="<?= HtmlEncode($Page->driver_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->driver_name->formatPattern()) ?>"<?= $Page->driver_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->driver_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->consignor->Visible) { // consignor ?>
    <div id="r_consignor" class="row"<?= $Page->consignor->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_consignor"><?= $Page->consignor->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_consignor" id="z_consignor" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->consignor->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_consignor" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->consignor->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_consignor" class="ew-auto-suggest">
    <input type="<?= $Page->consignor->getInputTextType() ?>" class="form-control" name="sv_x_consignor" id="sv_x_consignor" value="<?= RemoveHtml($Page->consignor->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->consignor->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->consignor->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->consignor->formatPattern()) ?>"<?= $Page->consignor->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="t_trip_info" data-field="x_consignor" data-input="sv_x_consignor" data-page="0" data-value-separator="<?= $Page->consignor->displayValueSeparatorAttribute() ?>" name="x_consignor" id="x_consignor" value="<?= HtmlEncode($Page->consignor->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->consignor->getErrorMessage(false) ?></div>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    ft_trip_infosearch.createAutoSuggest(Object.assign({"id":"x_consignor","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->consignor->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.t_trip_info.fields.consignor.autoSuggestOptions));
});
</script>
<?= $Page->consignor->Lookup->getParamTag($Page, "p_x_consignor") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
    <div id="r_vehicle_freight_comm" class="row"<?= $Page->vehicle_freight_comm->rowAttributes() ?>>
        <label for="x_vehicle_freight_comm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_freight_comm"><?= $Page->vehicle_freight_comm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_freight_comm" id="z_vehicle_freight_comm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_freight_comm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_vehicle_freight_comm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->vehicle_freight_comm->getInputTextType() ?>" name="x_vehicle_freight_comm" id="x_vehicle_freight_comm" data-table="t_trip_info" data-field="x_vehicle_freight_comm" value="<?= $Page->vehicle_freight_comm->EditValue ?>" data-page="0" size="30" placeholder="<?= HtmlEncode($Page->vehicle_freight_comm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->vehicle_freight_comm->formatPattern()) ?>"<?= $Page->vehicle_freight_comm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->vehicle_freight_comm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
    <div id="r_vehicle_freight_type" class="row"<?= $Page->vehicle_freight_type->rowAttributes() ?>>
        <label for="x_vehicle_freight_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_freight_type"><?= $Page->vehicle_freight_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_freight_type" id="z_vehicle_freight_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_freight_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_vehicle_freight_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_vehicle_freight_type"
        name="x_vehicle_freight_type"
        class="form-select ew-select<?= $Page->vehicle_freight_type->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_freight_type->IsNativeSelect) { ?>
        data-select2-id="ft_trip_infosearch_x_vehicle_freight_type"
        <?php } ?>
        data-table="t_trip_info"
        data-field="x_vehicle_freight_type"
        data-page="0"
        data-value-separator="<?= $Page->vehicle_freight_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_freight_type->getPlaceHolder()) ?>"
        <?= $Page->vehicle_freight_type->editAttributes() ?>>
        <?= $Page->vehicle_freight_type->selectOptionListHtml("x_vehicle_freight_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle_freight_type->getErrorMessage(false) ?></div>
<?php if (!$Page->vehicle_freight_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "x_vehicle_freight_type", selectId: "ft_trip_infosearch_x_vehicle_freight_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_infosearch.lists.vehicle_freight_type?.lookupOptions.length) {
        options.data = { id: "x_vehicle_freight_type", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "x_vehicle_freight_type", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info.fields.vehicle_freight_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
    <div id="r_vehicle_freight_amount" class="row"<?= $Page->vehicle_freight_amount->rowAttributes() ?>>
        <label for="x_vehicle_freight_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_freight_amount"><?= $Page->vehicle_freight_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_freight_amount" id="z_vehicle_freight_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_freight_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_vehicle_freight_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->vehicle_freight_amount->getInputTextType() ?>" name="x_vehicle_freight_amount" id="x_vehicle_freight_amount" data-table="t_trip_info" data-field="x_vehicle_freight_amount" value="<?= $Page->vehicle_freight_amount->EditValue ?>" data-page="0" size="30" placeholder="<?= HtmlEncode($Page->vehicle_freight_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->vehicle_freight_amount->formatPattern()) ?>"<?= $Page->vehicle_freight_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->vehicle_freight_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_freight_final->Visible) { // vehicle_freight_final ?>
    <div id="r_vehicle_freight_final" class="row"<?= $Page->vehicle_freight_final->rowAttributes() ?>>
        <label for="x_vehicle_freight_final" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_freight_final"><?= $Page->vehicle_freight_final->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_freight_final" id="z_vehicle_freight_final" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_freight_final->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_vehicle_freight_final" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->vehicle_freight_final->getInputTextType() ?>" name="x_vehicle_freight_final" id="x_vehicle_freight_final" data-table="t_trip_info" data-field="x_vehicle_freight_final" value="<?= $Page->vehicle_freight_final->EditValue ?>" data-page="0" size="30" placeholder="<?= HtmlEncode($Page->vehicle_freight_final->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->vehicle_freight_final->formatPattern()) ?>"<?= $Page->vehicle_freight_final->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->vehicle_freight_final->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_TTripInfoSearch"><!-- multi-page accordion -->
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_info1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_info1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->reports_to->Visible) { // reports_to ?>
    <div id="r_reports_to" class="row"<?= $Page->reports_to->rowAttributes() ?>>
        <label for="x_reports_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_reports_to"><?= $Page->reports_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_reports_to" id="z_reports_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reports_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_reports_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_reports_to"
        name="x_reports_to"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="ft_trip_infosearch_x_reports_to"
        <?php } ?>
        data-table="t_trip_info"
        data-field="x_reports_to"
        data-page="1"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage(false) ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "x_reports_to", selectId: "ft_trip_infosearch_x_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_infosearch.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "x_reports_to", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
    <div id="r_buyer" class="row"<?= $Page->buyer->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_buyer"><?= $Page->buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer" id="z_buyer" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_buyer" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer"
        name="x_buyer"
        class="form-control ew-select<?= $Page->buyer->isInvalidClass() ?>"
        data-select2-id="ft_trip_infosearch_x_buyer"
        data-table="t_trip_info"
        data-field="x_buyer"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>"
        <?= $Page->buyer->editAttributes() ?>>
        <?= $Page->buyer->selectOptionListHtml("x_buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer->getErrorMessage(false) ?></div>
<?= $Page->buyer->Lookup->getParamTag($Page, "p_x_buyer") ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "x_buyer", selectId: "ft_trip_infosearch_x_buyer" };
    if (ft_trip_infosearch.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x_buyer", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "x_buyer", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.buyer.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_consignor->Visible) { // b_consignor ?>
    <div id="r_b_consignor" class="row"<?= $Page->b_consignor->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_b_consignor"><?= $Page->b_consignor->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_consignor->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_b_consignor" id="z_b_consignor" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->b_consignor->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->b_consignor->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_t_trip_info_b_consignor" class="ew-search-field">
    <select
        id="x_b_consignor"
        name="x_b_consignor"
        class="form-control ew-select<?= $Page->b_consignor->isInvalidClass() ?>"
        data-select2-id="ft_trip_infosearch_x_b_consignor"
        data-table="t_trip_info"
        data-field="x_b_consignor"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->b_consignor->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->b_consignor->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->b_consignor->getPlaceHolder()) ?>"
        <?= $Page->b_consignor->editAttributes() ?>>
        <?= $Page->b_consignor->selectOptionListHtml("x_b_consignor") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->b_consignor->getErrorMessage(false) ?></div>
<?= $Page->b_consignor->Lookup->getParamTag($Page, "p_x_b_consignor") ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "x_b_consignor", selectId: "ft_trip_infosearch_x_b_consignor" };
    if (ft_trip_infosearch.lists.b_consignor?.lookupOptions.length) {
        options.data = { id: "x_b_consignor", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "x_b_consignor", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.b_consignor.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_t_trip_info_b_consignor" class="ew-search-field2 d-none">
    <select
        id="y_b_consignor"
        name="y_b_consignor"
        class="form-control ew-select<?= $Page->b_consignor->isInvalidClass() ?>"
        data-select2-id="ft_trip_infosearch_y_b_consignor"
        data-table="t_trip_info"
        data-field="x_b_consignor"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->b_consignor->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->b_consignor->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->b_consignor->getPlaceHolder()) ?>"
        <?= $Page->b_consignor->editAttributes() ?>>
        <?= $Page->b_consignor->selectOptionListHtml("y_b_consignor") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->b_consignor->getErrorMessage(false) ?></div>
<?= $Page->b_consignor->Lookup->getParamTag($Page, "p_y_b_consignor") ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "y_b_consignor", selectId: "ft_trip_infosearch_y_b_consignor" };
    if (ft_trip_infosearch.lists.b_consignor?.lookupOptions.length) {
        options.data = { id: "y_b_consignor", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "y_b_consignor", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.b_consignor.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_consignee->Visible) { // b_consignee ?>
    <div id="r_b_consignee" class="row"<?= $Page->b_consignee->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_b_consignee"><?= $Page->b_consignee->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_consignee->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_b_consignee" id="z_b_consignee" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->b_consignee->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->b_consignee->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_t_trip_info_b_consignee" class="ew-search-field">
    <select
        id="x_b_consignee"
        name="x_b_consignee"
        class="form-control ew-select<?= $Page->b_consignee->isInvalidClass() ?>"
        data-select2-id="ft_trip_infosearch_x_b_consignee"
        data-table="t_trip_info"
        data-field="x_b_consignee"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->b_consignee->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->b_consignee->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->b_consignee->getPlaceHolder()) ?>"
        <?= $Page->b_consignee->editAttributes() ?>>
        <?= $Page->b_consignee->selectOptionListHtml("x_b_consignee") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->b_consignee->getErrorMessage(false) ?></div>
<?= $Page->b_consignee->Lookup->getParamTag($Page, "p_x_b_consignee") ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "x_b_consignee", selectId: "ft_trip_infosearch_x_b_consignee" };
    if (ft_trip_infosearch.lists.b_consignee?.lookupOptions.length) {
        options.data = { id: "x_b_consignee", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "x_b_consignee", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.b_consignee.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_t_trip_info_b_consignee" class="ew-search-field2 d-none">
    <select
        id="y_b_consignee"
        name="y_b_consignee"
        class="form-control ew-select<?= $Page->b_consignee->isInvalidClass() ?>"
        data-select2-id="ft_trip_infosearch_y_b_consignee"
        data-table="t_trip_info"
        data-field="x_b_consignee"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->b_consignee->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->b_consignee->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->b_consignee->getPlaceHolder()) ?>"
        <?= $Page->b_consignee->editAttributes() ?>>
        <?= $Page->b_consignee->selectOptionListHtml("y_b_consignee") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->b_consignee->getErrorMessage(false) ?></div>
<?= $Page->b_consignee->Lookup->getParamTag($Page, "p_y_b_consignee") ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "y_b_consignee", selectId: "ft_trip_infosearch_y_b_consignee" };
    if (ft_trip_infosearch.lists.b_consignee?.lookupOptions.length) {
        options.data = { id: "y_b_consignee", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "y_b_consignee", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.b_consignee.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
    <div id="r_agent" class="row"<?= $Page->agent->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_agent"><?= $Page->agent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_agent" id="z_agent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->agent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_agent" class="ew-search-field ew-search-field-single">
    <select
        id="x_agent"
        name="x_agent"
        class="form-control ew-select<?= $Page->agent->isInvalidClass() ?>"
        data-select2-id="ft_trip_infosearch_x_agent"
        data-table="t_trip_info"
        data-field="x_agent"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->agent->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
        <?= $Page->agent->editAttributes() ?>>
        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->agent->getErrorMessage(false) ?></div>
<?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "x_agent", selectId: "ft_trip_infosearch_x_agent" };
    if (ft_trip_infosearch.lists.agent?.lookupOptions.length) {
        options.data = { id: "x_agent", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "x_agent", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.agent.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->comm->Visible) { // comm ?>
    <div id="r_comm" class="row"<?= $Page->comm->rowAttributes() ?>>
        <label for="x_comm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_comm"><?= $Page->comm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_comm" id="z_comm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->comm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_comm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->comm->getInputTextType() ?>" name="x_comm" id="x_comm" data-table="t_trip_info" data-field="x_comm" value="<?= $Page->comm->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->comm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->comm->formatPattern()) ?>"<?= $Page->comm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->comm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->material->Visible) { // material ?>
    <div id="r_material" class="row"<?= $Page->material->rowAttributes() ?>>
        <label for="x_material" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_material"><?= $Page->material->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_material" id="z_material" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->material->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_material" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->material->getInputTextType() ?>" name="x_material" id="x_material" data-table="t_trip_info" data-field="x_material" value="<?= $Page->material->EditValue ?>" data-page="1" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->material->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->material->formatPattern()) ?>"<?= $Page->material->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->material->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_packing_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packing_type->getInputTextType() ?>" name="x_packing_type" id="x_packing_type" data-table="t_trip_info" data-field="x_packing_type" value="<?= $Page->packing_type->EditValue ?>" data-page="1" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packing_type->formatPattern()) ?>"<?= $Page->packing_type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->m_hsn->Visible) { // m_hsn ?>
    <div id="r_m_hsn" class="row"<?= $Page->m_hsn->rowAttributes() ?>>
        <label for="x_m_hsn" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_m_hsn"><?= $Page->m_hsn->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_m_hsn" id="z_m_hsn" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->m_hsn->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_m_hsn" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->m_hsn->getInputTextType() ?>" name="x_m_hsn" id="x_m_hsn" data-table="t_trip_info" data-field="x_m_hsn" value="<?= $Page->m_hsn->EditValue ?>" data-page="1" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->m_hsn->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->m_hsn->formatPattern()) ?>"<?= $Page->m_hsn->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->m_hsn->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
    <div id="r__40" class="row"<?= $Page->_40->rowAttributes() ?>>
        <label for="x__40" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info__40"><?= $Page->_40->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__40" id="z__40" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_40->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info__40" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="t_trip_info" data-field="x__40" value="<?= $Page->_40->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lr_no->Visible) { // lr_no ?>
    <div id="r_lr_no" class="row"<?= $Page->lr_no->rowAttributes() ?>>
        <label for="x_lr_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_lr_no"><?= $Page->lr_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lr_no" id="z_lr_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lr_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_lr_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lr_no->getInputTextType() ?>" name="x_lr_no" id="x_lr_no" data-table="t_trip_info" data-field="x_lr_no" value="<?= $Page->lr_no->EditValue ?>" data-page="1" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->lr_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lr_no->formatPattern()) ?>"<?= $Page->lr_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lr_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="t_trip_info" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" data-page="1" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_info2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_info2"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->invoice_no->Visible) { // invoice_no ?>
    <div id="r_invoice_no" class="row"<?= $Page->invoice_no->rowAttributes() ?>>
        <label for="x_invoice_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_invoice_no"><?= $Page->invoice_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_invoice_no" id="z_invoice_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_invoice_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice_no->getInputTextType() ?>" name="x_invoice_no" id="x_invoice_no" data-table="t_trip_info" data-field="x_invoice_no" value="<?= $Page->invoice_no->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->invoice_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_no->formatPattern()) ?>"<?= $Page->invoice_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
    <div id="r_invoice_date" class="row"<?= $Page->invoice_date->rowAttributes() ?>>
        <label for="x_invoice_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_invoice_date"><?= $Page->invoice_date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_invoice_date" id="z_invoice_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->invoice_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->invoice_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_t_trip_info_invoice_date" class="ew-search-field">
<input type="<?= $Page->invoice_date->getInputTextType() ?>" name="x_invoice_date" id="x_invoice_date" data-table="t_trip_info" data-field="x_invoice_date" value="<?= $Page->invoice_date->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->invoice_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_date->formatPattern()) ?>"<?= $Page->invoice_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_date->getErrorMessage(false) ?></div>
<?php if (!$Page->invoice_date->ReadOnly && !$Page->invoice_date->Disabled && !isset($Page->invoice_date->EditAttrs["readonly"]) && !isset($Page->invoice_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_infosearch", "x_invoice_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_t_trip_info_invoice_date" class="ew-search-field2 d-none">
<input type="<?= $Page->invoice_date->getInputTextType() ?>" name="y_invoice_date" id="y_invoice_date" data-table="t_trip_info" data-field="x_invoice_date" value="<?= $Page->invoice_date->EditValue2 ?>" data-page="2" placeholder="<?= HtmlEncode($Page->invoice_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_date->formatPattern()) ?>"<?= $Page->invoice_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_date->getErrorMessage(false) ?></div>
<?php if (!$Page->invoice_date->ReadOnly && !$Page->invoice_date->Disabled && !isset($Page->invoice_date->EditAttrs["readonly"]) && !isset($Page->invoice_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_infosearch", "y_invoice_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="t_trip_info" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->km->Visible) { // km ?>
    <div id="r_km" class="row"<?= $Page->km->rowAttributes() ?>>
        <label for="x_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_km"><?= $Page->km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_km" id="z_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->km->getInputTextType() ?>" name="x_km" id="x_km" data-table="t_trip_info" data-field="x_km" value="<?= $Page->km->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->km->formatPattern()) ?>"<?= $Page->km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->freight_type->Visible) { // freight_type ?>
    <div id="r_freight_type" class="row"<?= $Page->freight_type->rowAttributes() ?>>
        <label for="x_freight_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_freight_type"><?= $Page->freight_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_freight_type" id="z_freight_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->freight_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_freight_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_freight_type"
        name="x_freight_type"
        class="form-select ew-select<?= $Page->freight_type->isInvalidClass() ?>"
        <?php if (!$Page->freight_type->IsNativeSelect) { ?>
        data-select2-id="ft_trip_infosearch_x_freight_type"
        <?php } ?>
        data-table="t_trip_info"
        data-field="x_freight_type"
        data-page="2"
        data-value-separator="<?= $Page->freight_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->freight_type->getPlaceHolder()) ?>"
        <?= $Page->freight_type->editAttributes() ?>>
        <?= $Page->freight_type->selectOptionListHtml("x_freight_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->freight_type->getErrorMessage(false) ?></div>
<?php if (!$Page->freight_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "x_freight_type", selectId: "ft_trip_infosearch_x_freight_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_infosearch.lists.freight_type?.lookupOptions.length) {
        options.data = { id: "x_freight_type", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "x_freight_type", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info.fields.freight_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->freight->Visible) { // freight ?>
    <div id="r_freight" class="row"<?= $Page->freight->rowAttributes() ?>>
        <label for="x_freight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_freight"><?= $Page->freight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_freight" id="z_freight" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->freight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_freight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->freight->getInputTextType() ?>" name="x_freight" id="x_freight" data-table="t_trip_info" data-field="x_freight" value="<?= $Page->freight->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->freight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->freight->formatPattern()) ?>"<?= $Page->freight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->freight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ded_det->Visible) { // ded_det ?>
    <div id="r_ded_det" class="row"<?= $Page->ded_det->rowAttributes() ?>>
        <label for="x_ded_det" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_ded_det"><?= $Page->ded_det->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ded_det" id="z_ded_det" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ded_det->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_ded_det" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ded_det->getInputTextType() ?>" name="x_ded_det" id="x_ded_det" data-table="t_trip_info" data-field="x_ded_det" value="<?= $Page->ded_det->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->ded_det->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ded_det->formatPattern()) ?>"<?= $Page->ded_det->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ded_det->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ded_det_remarks->Visible) { // ded_det_remarks ?>
    <div id="r_ded_det_remarks" class="row"<?= $Page->ded_det_remarks->rowAttributes() ?>>
        <label for="x_ded_det_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_ded_det_remarks"><?= $Page->ded_det_remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ded_det_remarks" id="z_ded_det_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ded_det_remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_ded_det_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ded_det_remarks->getInputTextType() ?>" name="x_ded_det_remarks" id="x_ded_det_remarks" data-table="t_trip_info" data-field="x_ded_det_remarks" value="<?= $Page->ded_det_remarks->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->ded_det_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ded_det_remarks->formatPattern()) ?>"<?= $Page->ded_det_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ded_det_remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gst_percent->Visible) { // gst_percent ?>
    <div id="r_gst_percent" class="row"<?= $Page->gst_percent->rowAttributes() ?>>
        <label for="x_gst_percent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_gst_percent"><?= $Page->gst_percent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gst_percent" id="z_gst_percent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gst_percent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_gst_percent" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gst_percent->getInputTextType() ?>" name="x_gst_percent" id="x_gst_percent" data-table="t_trip_info" data-field="x_gst_percent" value="<?= $Page->gst_percent->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->gst_percent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gst_percent->formatPattern()) ?>"<?= $Page->gst_percent->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gst_percent->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gst_amount->Visible) { // gst_amount ?>
    <div id="r_gst_amount" class="row"<?= $Page->gst_amount->rowAttributes() ?>>
        <label for="x_gst_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_gst_amount"><?= $Page->gst_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gst_amount" id="z_gst_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gst_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_gst_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gst_amount->getInputTextType() ?>" name="x_gst_amount" id="x_gst_amount" data-table="t_trip_info" data-field="x_gst_amount" value="<?= $Page->gst_amount->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->gst_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gst_amount->formatPattern()) ?>"<?= $Page->gst_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gst_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->final_amount->Visible) { // final_amount ?>
    <div id="r_final_amount" class="row"<?= $Page->final_amount->rowAttributes() ?>>
        <label for="x_final_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_final_amount"><?= $Page->final_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_final_amount" id="z_final_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->final_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_final_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->final_amount->getInputTextType() ?>" name="x_final_amount" id="x_final_amount" data-table="t_trip_info" data-field="x_final_amount" value="<?= $Page->final_amount->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->final_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->final_amount->formatPattern()) ?>"<?= $Page->final_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->final_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(3)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_info3"><?= $Page->pageCaption(3) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(3)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_info3"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->load_date->Visible) { // load_date ?>
    <div id="r_load_date" class="row"<?= $Page->load_date->rowAttributes() ?>>
        <label for="x_load_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_load_date"><?= $Page->load_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_date" id="z_load_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->load_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_load_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->load_date->getInputTextType() ?>" name="x_load_date" id="x_load_date" data-table="t_trip_info" data-field="x_load_date" value="<?= $Page->load_date->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->load_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_date->formatPattern()) ?>"<?= $Page->load_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_date->getErrorMessage(false) ?></div>
<?php if (!$Page->load_date->ReadOnly && !$Page->load_date->Disabled && !isset($Page->load_date->EditAttrs["readonly"]) && !isset($Page->load_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_infosearch", "x_load_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->load_weight->Visible) { // load_weight ?>
    <div id="r_load_weight" class="row"<?= $Page->load_weight->rowAttributes() ?>>
        <label for="x_load_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_load_weight"><?= $Page->load_weight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_weight" id="z_load_weight" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->load_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_load_weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->load_weight->getInputTextType() ?>" name="x_load_weight" id="x_load_weight" data-table="t_trip_info" data-field="x_load_weight" value="<?= $Page->load_weight->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->load_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_weight->formatPattern()) ?>"<?= $Page->load_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unload_date->Visible) { // unload_date ?>
    <div id="r_unload_date" class="row"<?= $Page->unload_date->rowAttributes() ?>>
        <label for="x_unload_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_unload_date"><?= $Page->unload_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unload_date" id="z_unload_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unload_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_unload_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->unload_date->getInputTextType() ?>" name="x_unload_date" id="x_unload_date" data-table="t_trip_info" data-field="x_unload_date" value="<?= $Page->unload_date->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->unload_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_date->formatPattern()) ?>"<?= $Page->unload_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_date->getErrorMessage(false) ?></div>
<?php if (!$Page->unload_date->ReadOnly && !$Page->unload_date->Disabled && !isset($Page->unload_date->EditAttrs["readonly"]) && !isset($Page->unload_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_infosearch", "x_unload_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unload_weight->Visible) { // unload_weight ?>
    <div id="r_unload_weight" class="row"<?= $Page->unload_weight->rowAttributes() ?>>
        <label for="x_unload_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_unload_weight"><?= $Page->unload_weight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unload_weight" id="z_unload_weight" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unload_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_unload_weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->unload_weight->getInputTextType() ?>" name="x_unload_weight" id="x_unload_weight" data-table="t_trip_info" data-field="x_unload_weight" value="<?= $Page->unload_weight->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->unload_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_weight->formatPattern()) ?>"<?= $Page->unload_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delivery_pod->Visible) { // delivery_pod ?>
    <div id="r_delivery_pod" class="row"<?= $Page->delivery_pod->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_delivery_pod"><?= $Page->delivery_pod->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_delivery_pod" id="z_delivery_pod" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delivery_pod->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_delivery_pod" class="ew-search-field ew-search-field-single">
<template id="tp_x_delivery_pod">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="t_trip_info" data-field="x_delivery_pod" name="x_delivery_pod" id="x_delivery_pod"<?= $Page->delivery_pod->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_delivery_pod" class="ew-item-list"></div>
<selection-list hidden
    id="x_delivery_pod"
    name="x_delivery_pod"
    value="<?= HtmlEncode($Page->delivery_pod->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_delivery_pod"
    data-target="dsl_x_delivery_pod"
    data-repeatcolumn="5"
    class="form-control<?= $Page->delivery_pod->isInvalidClass() ?>"
    data-table="t_trip_info"
    data-field="x_delivery_pod"
    data-page="3"
    data-value-separator="<?= $Page->delivery_pod->displayValueSeparatorAttribute() ?>"
    <?= $Page->delivery_pod->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->delivery_pod->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->load_km->Visible) { // load_km ?>
    <div id="r_load_km" class="row"<?= $Page->load_km->rowAttributes() ?>>
        <label for="x_load_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_load_km"><?= $Page->load_km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_km" id="z_load_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->load_km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_load_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->load_km->getInputTextType() ?>" name="x_load_km" id="x_load_km" data-table="t_trip_info" data-field="x_load_km" value="<?= $Page->load_km->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->load_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_km->formatPattern()) ?>"<?= $Page->load_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unload_km->Visible) { // unload_km ?>
    <div id="r_unload_km" class="row"<?= $Page->unload_km->rowAttributes() ?>>
        <label for="x_unload_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_unload_km"><?= $Page->unload_km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unload_km" id="z_unload_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unload_km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_unload_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->unload_km->getInputTextType() ?>" name="x_unload_km" id="x_unload_km" data-table="t_trip_info" data-field="x_unload_km" value="<?= $Page->unload_km->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->unload_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_km->formatPattern()) ?>"<?= $Page->unload_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delivery_receipt->Visible) { // delivery_receipt ?>
    <div id="r_delivery_receipt" class="row"<?= $Page->delivery_receipt->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_delivery_receipt"><?= $Page->delivery_receipt->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_delivery_receipt" id="z_delivery_receipt" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delivery_receipt->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_delivery_receipt" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->delivery_receipt->getInputTextType() ?>" name="x_delivery_receipt" id="x_delivery_receipt" data-table="t_trip_info" data-field="x_delivery_receipt" value="<?= $Page->delivery_receipt->EditValue ?>" data-page="3" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->delivery_receipt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->delivery_receipt->formatPattern()) ?>"<?= $Page->delivery_receipt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->delivery_receipt->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delivery_docket->Visible) { // delivery_docket ?>
    <div id="r_delivery_docket" class="row"<?= $Page->delivery_docket->rowAttributes() ?>>
        <label for="x_delivery_docket" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_delivery_docket"><?= $Page->delivery_docket->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_delivery_docket" id="z_delivery_docket" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delivery_docket->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_delivery_docket" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->delivery_docket->getInputTextType() ?>" name="x_delivery_docket" id="x_delivery_docket" data-table="t_trip_info" data-field="x_delivery_docket" value="<?= $Page->delivery_docket->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->delivery_docket->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->delivery_docket->formatPattern()) ?>"<?= $Page->delivery_docket->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->delivery_docket->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(4)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(4)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_info4"><?= $Page->pageCaption(4) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(4)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_info4"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->diesal_op_b->Visible) { // diesal_op_b ?>
    <div id="r_diesal_op_b" class="row"<?= $Page->diesal_op_b->rowAttributes() ?>>
        <label for="x_diesal_op_b" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_diesal_op_b"><?= $Page->diesal_op_b->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_diesal_op_b" id="z_diesal_op_b" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->diesal_op_b->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_diesal_op_b" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->diesal_op_b->getInputTextType() ?>" name="x_diesal_op_b" id="x_diesal_op_b" data-table="t_trip_info" data-field="x_diesal_op_b" value="<?= $Page->diesal_op_b->EditValue ?>" data-page="4" size="30" placeholder="<?= HtmlEncode($Page->diesal_op_b->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diesal_op_b->formatPattern()) ?>"<?= $Page->diesal_op_b->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->diesal_op_b->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->diesal_required->Visible) { // diesal_required ?>
    <div id="r_diesal_required" class="row"<?= $Page->diesal_required->rowAttributes() ?>>
        <label for="x_diesal_required" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_diesal_required"><?= $Page->diesal_required->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_diesal_required" id="z_diesal_required" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->diesal_required->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_diesal_required" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->diesal_required->getInputTextType() ?>" name="x_diesal_required" id="x_diesal_required" data-table="t_trip_info" data-field="x_diesal_required" value="<?= $Page->diesal_required->EditValue ?>" data-page="4" size="30" placeholder="<?= HtmlEncode($Page->diesal_required->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diesal_required->formatPattern()) ?>"<?= $Page->diesal_required->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->diesal_required->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->diesal_fill->Visible) { // diesal_fill ?>
    <div id="r_diesal_fill" class="row"<?= $Page->diesal_fill->rowAttributes() ?>>
        <label for="x_diesal_fill" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_diesal_fill"><?= $Page->diesal_fill->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_diesal_fill" id="z_diesal_fill" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->diesal_fill->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_diesal_fill" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->diesal_fill->getInputTextType() ?>" name="x_diesal_fill" id="x_diesal_fill" data-table="t_trip_info" data-field="x_diesal_fill" value="<?= $Page->diesal_fill->EditValue ?>" data-page="4" size="30" placeholder="<?= HtmlEncode($Page->diesal_fill->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diesal_fill->formatPattern()) ?>"<?= $Page->diesal_fill->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->diesal_fill->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->diesal_amount->Visible) { // diesal_amount ?>
    <div id="r_diesal_amount" class="row"<?= $Page->diesal_amount->rowAttributes() ?>>
        <label for="x_diesal_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_diesal_amount"><?= $Page->diesal_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_diesal_amount" id="z_diesal_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->diesal_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_diesal_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->diesal_amount->getInputTextType() ?>" name="x_diesal_amount" id="x_diesal_amount" data-table="t_trip_info" data-field="x_diesal_amount" value="<?= $Page->diesal_amount->EditValue ?>" data-page="4" size="30" placeholder="<?= HtmlEncode($Page->diesal_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diesal_amount->formatPattern()) ?>"<?= $Page->diesal_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->diesal_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->diesal_cl_balance->Visible) { // diesal_cl_balance ?>
    <div id="r_diesal_cl_balance" class="row"<?= $Page->diesal_cl_balance->rowAttributes() ?>>
        <label for="x_diesal_cl_balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_diesal_cl_balance"><?= $Page->diesal_cl_balance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_diesal_cl_balance" id="z_diesal_cl_balance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->diesal_cl_balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_diesal_cl_balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->diesal_cl_balance->getInputTextType() ?>" name="x_diesal_cl_balance" id="x_diesal_cl_balance" data-table="t_trip_info" data-field="x_diesal_cl_balance" value="<?= $Page->diesal_cl_balance->EditValue ?>" data-page="4" size="30" placeholder="<?= HtmlEncode($Page->diesal_cl_balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diesal_cl_balance->formatPattern()) ?>"<?= $Page->diesal_cl_balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->diesal_cl_balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_average->Visible) { // vehicle_average ?>
    <div id="r_vehicle_average" class="row"<?= $Page->vehicle_average->rowAttributes() ?>>
        <label for="x_vehicle_average" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_average"><?= $Page->vehicle_average->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_average" id="z_vehicle_average" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle_average->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_vehicle_average" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->vehicle_average->getInputTextType() ?>" name="x_vehicle_average" id="x_vehicle_average" data-table="t_trip_info" data-field="x_vehicle_average" value="<?= $Page->vehicle_average->EditValue ?>" data-page="4" size="30" placeholder="<?= HtmlEncode($Page->vehicle_average->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->vehicle_average->formatPattern()) ?>"<?= $Page->vehicle_average->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->vehicle_average->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(5)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(5)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_info5"><?= $Page->pageCaption(5) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(5)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_info5"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->cash_required->Visible) { // cash_required ?>
    <div id="r_cash_required" class="row"<?= $Page->cash_required->rowAttributes() ?>>
        <label for="x_cash_required" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_cash_required"><?= $Page->cash_required->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cash_required" id="z_cash_required" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cash_required->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_cash_required" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cash_required->getInputTextType() ?>" name="x_cash_required" id="x_cash_required" data-table="t_trip_info" data-field="x_cash_required" value="<?= $Page->cash_required->EditValue ?>" data-page="5" size="30" placeholder="<?= HtmlEncode($Page->cash_required->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cash_required->formatPattern()) ?>"<?= $Page->cash_required->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cash_required->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cash_op_b->Visible) { // cash_op_b ?>
    <div id="r_cash_op_b" class="row"<?= $Page->cash_op_b->rowAttributes() ?>>
        <label for="x_cash_op_b" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_cash_op_b"><?= $Page->cash_op_b->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cash_op_b" id="z_cash_op_b" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cash_op_b->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_cash_op_b" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cash_op_b->getInputTextType() ?>" name="x_cash_op_b" id="x_cash_op_b" data-table="t_trip_info" data-field="x_cash_op_b" value="<?= $Page->cash_op_b->EditValue ?>" data-page="5" size="30" placeholder="<?= HtmlEncode($Page->cash_op_b->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cash_op_b->formatPattern()) ?>"<?= $Page->cash_op_b->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cash_op_b->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cash_paid->Visible) { // cash_paid ?>
    <div id="r_cash_paid" class="row"<?= $Page->cash_paid->rowAttributes() ?>>
        <label for="x_cash_paid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_cash_paid"><?= $Page->cash_paid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cash_paid" id="z_cash_paid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cash_paid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_cash_paid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cash_paid->getInputTextType() ?>" name="x_cash_paid" id="x_cash_paid" data-table="t_trip_info" data-field="x_cash_paid" value="<?= $Page->cash_paid->EditValue ?>" data-page="5" size="30" placeholder="<?= HtmlEncode($Page->cash_paid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cash_paid->formatPattern()) ?>"<?= $Page->cash_paid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cash_paid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cash_expenses->Visible) { // cash_expenses ?>
    <div id="r_cash_expenses" class="row"<?= $Page->cash_expenses->rowAttributes() ?>>
        <label for="x_cash_expenses" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_cash_expenses"><?= $Page->cash_expenses->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cash_expenses" id="z_cash_expenses" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cash_expenses->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_cash_expenses" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cash_expenses->getInputTextType() ?>" name="x_cash_expenses" id="x_cash_expenses" data-table="t_trip_info" data-field="x_cash_expenses" value="<?= $Page->cash_expenses->EditValue ?>" data-page="5" size="30" placeholder="<?= HtmlEncode($Page->cash_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cash_expenses->formatPattern()) ?>"<?= $Page->cash_expenses->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cash_expenses->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cash_cl_balance->Visible) { // cash_cl_balance ?>
    <div id="r_cash_cl_balance" class="row"<?= $Page->cash_cl_balance->rowAttributes() ?>>
        <label for="x_cash_cl_balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_cash_cl_balance"><?= $Page->cash_cl_balance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cash_cl_balance" id="z_cash_cl_balance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cash_cl_balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_cash_cl_balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cash_cl_balance->getInputTextType() ?>" name="x_cash_cl_balance" id="x_cash_cl_balance" data-table="t_trip_info" data-field="x_cash_cl_balance" value="<?= $Page->cash_cl_balance->EditValue ?>" data-page="5" size="30" placeholder="<?= HtmlEncode($Page->cash_cl_balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cash_cl_balance->formatPattern()) ?>"<?= $Page->cash_cl_balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cash_cl_balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(6)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(6)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_info6"><?= $Page->pageCaption(6) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(6)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_info6"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->fasttag_op_b->Visible) { // fasttag_op_b ?>
    <div id="r_fasttag_op_b" class="row"<?= $Page->fasttag_op_b->rowAttributes() ?>>
        <label for="x_fasttag_op_b" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_fasttag_op_b"><?= $Page->fasttag_op_b->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_fasttag_op_b" id="z_fasttag_op_b" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fasttag_op_b->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_fasttag_op_b" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->fasttag_op_b->getInputTextType() ?>" name="x_fasttag_op_b" id="x_fasttag_op_b" data-table="t_trip_info" data-field="x_fasttag_op_b" value="<?= $Page->fasttag_op_b->EditValue ?>" data-page="6" size="30" placeholder="<?= HtmlEncode($Page->fasttag_op_b->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fasttag_op_b->formatPattern()) ?>"<?= $Page->fasttag_op_b->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->fasttag_op_b->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fasttag_recharge->Visible) { // fasttag_recharge ?>
    <div id="r_fasttag_recharge" class="row"<?= $Page->fasttag_recharge->rowAttributes() ?>>
        <label for="x_fasttag_recharge" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_fasttag_recharge"><?= $Page->fasttag_recharge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_fasttag_recharge" id="z_fasttag_recharge" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fasttag_recharge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_fasttag_recharge" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->fasttag_recharge->getInputTextType() ?>" name="x_fasttag_recharge" id="x_fasttag_recharge" data-table="t_trip_info" data-field="x_fasttag_recharge" value="<?= $Page->fasttag_recharge->EditValue ?>" data-page="6" size="30" placeholder="<?= HtmlEncode($Page->fasttag_recharge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fasttag_recharge->formatPattern()) ?>"<?= $Page->fasttag_recharge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->fasttag_recharge->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fasttag_expenses->Visible) { // fasttag_expenses ?>
    <div id="r_fasttag_expenses" class="row"<?= $Page->fasttag_expenses->rowAttributes() ?>>
        <label for="x_fasttag_expenses" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_fasttag_expenses"><?= $Page->fasttag_expenses->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_fasttag_expenses" id="z_fasttag_expenses" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fasttag_expenses->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_fasttag_expenses" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->fasttag_expenses->getInputTextType() ?>" name="x_fasttag_expenses" id="x_fasttag_expenses" data-table="t_trip_info" data-field="x_fasttag_expenses" value="<?= $Page->fasttag_expenses->EditValue ?>" data-page="6" size="30" placeholder="<?= HtmlEncode($Page->fasttag_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fasttag_expenses->formatPattern()) ?>"<?= $Page->fasttag_expenses->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->fasttag_expenses->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->toll_expenses_cash->Visible) { // toll_expenses_cash ?>
    <div id="r_toll_expenses_cash" class="row"<?= $Page->toll_expenses_cash->rowAttributes() ?>>
        <label for="x_toll_expenses_cash" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_toll_expenses_cash"><?= $Page->toll_expenses_cash->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_toll_expenses_cash" id="z_toll_expenses_cash" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->toll_expenses_cash->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_toll_expenses_cash" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->toll_expenses_cash->getInputTextType() ?>" name="x_toll_expenses_cash" id="x_toll_expenses_cash" data-table="t_trip_info" data-field="x_toll_expenses_cash" value="<?= $Page->toll_expenses_cash->EditValue ?>" data-page="6" size="30" placeholder="<?= HtmlEncode($Page->toll_expenses_cash->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->toll_expenses_cash->formatPattern()) ?>"<?= $Page->toll_expenses_cash->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->toll_expenses_cash->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fasttag_cl_balance->Visible) { // fasttag_cl_balance ?>
    <div id="r_fasttag_cl_balance" class="row"<?= $Page->fasttag_cl_balance->rowAttributes() ?>>
        <label for="x_fasttag_cl_balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_fasttag_cl_balance"><?= $Page->fasttag_cl_balance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_fasttag_cl_balance" id="z_fasttag_cl_balance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fasttag_cl_balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_fasttag_cl_balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->fasttag_cl_balance->getInputTextType() ?>" name="x_fasttag_cl_balance" id="x_fasttag_cl_balance" data-table="t_trip_info" data-field="x_fasttag_cl_balance" value="<?= $Page->fasttag_cl_balance->EditValue ?>" data-page="6" size="30" placeholder="<?= HtmlEncode($Page->fasttag_cl_balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fasttag_cl_balance->formatPattern()) ?>"<?= $Page->fasttag_cl_balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->fasttag_cl_balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(7)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(7)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_info7"><?= $Page->pageCaption(7) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(7)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_info7"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads" class="row"<?= $Page->uploads->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_uploads"><?= $Page->uploads->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_uploads" id="z_uploads" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->uploads->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_uploads" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->uploads->getInputTextType() ?>" name="x_uploads" id="x_uploads" data-table="t_trip_info" data-field="x_uploads" value="<?= $Page->uploads->EditValue ?>" data-page="7" maxlength="500" placeholder="<?= HtmlEncode($Page->uploads->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uploads->formatPattern()) ?>"<?= $Page->uploads->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uploads->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="ft_trip_infosearch_x_operator"
        <?php } ?>
        data-table="t_trip_info"
        data-field="x_operator"
        data-page="7"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_infosearch", function() {
    var options = { name: "x_operator", selectId: "ft_trip_infosearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_infosearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "ft_trip_infosearch" };
    } else {
        options.ajax = { id: "x_operator", form: "ft_trip_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="t_trip_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" data-page="7" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_infosearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_trip_infosearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_trip_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ft_trip_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_trip_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
