<?php

namespace PHPMaker2024\fibre;

// Page object
$TTripInfoList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_info: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ft_trip_infosrch" id="ft_trip_infosrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="ft_trip_infosrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_info: currentTable } });
var currentForm;
var ft_trip_infosrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_trip_infosrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["vehicle_type", [], fields.vehicle_type.isInvalid],
            ["vehicle", [ew.Validators.integer], fields.vehicle.isInvalid],
            ["buyer", [ew.Validators.integer], fields.buyer.isInvalid],
            ["load_date", [ew.Validators.datetime(fields.load_date.clientFormatPattern)], fields.load_date.isInvalid],
            ["unload_date", [ew.Validators.datetime(fields.unload_date.clientFormatPattern)], fields.unload_date.isInvalid],
            ["invoice_date", [ew.Validators.datetime(fields.invoice_date.clientFormatPattern)], fields.invoice_date.isInvalid],
            ["y_invoice_date", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "vehicle_type": <?= $Page->vehicle_type->toClientList($Page) ?>,
            "vehicle": <?= $Page->vehicle->toClientList($Page) ?>,
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->vehicle_type->Visible) { // vehicle_type ?>
<?php
if (!$Page->vehicle_type->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_vehicle_type" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->vehicle_type->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_vehicle_type" class="ew-search-caption ew-label"><?= $Page->vehicle_type->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_type" id="z_vehicle_type" value="=">
</div>
        </div>
        <div id="el_t_trip_info_vehicle_type" class="ew-search-field">
    <select
        id="x_vehicle_type"
        name="x_vehicle_type"
        class="form-select ew-select<?= $Page->vehicle_type->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_type->IsNativeSelect) { ?>
        data-select2-id="ft_trip_infosrch_x_vehicle_type"
        <?php } ?>
        data-table="t_trip_info"
        data-field="x_vehicle_type"
        data-value-separator="<?= $Page->vehicle_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->vehicle_type->editAttributes() ?>>
        <?= $Page->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle_type->getErrorMessage(false) ?></div>
<?php if (!$Page->vehicle_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_infosrch", function() {
    var options = { name: "x_vehicle_type", selectId: "ft_trip_infosrch_x_vehicle_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_infosrch.lists.vehicle_type?.lookupOptions.length) {
        options.data = { id: "x_vehicle_type", form: "ft_trip_infosrch" };
    } else {
        options.ajax = { id: "x_vehicle_type", form: "ft_trip_infosrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info.fields.vehicle_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->vehicle->Visible) { // vehicle ?>
<?php
if (!$Page->vehicle->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_vehicle" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->vehicle->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->vehicle->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle" id="z_vehicle" value="=">
</div>
        </div>
        <div id="el_t_trip_info_vehicle" class="ew-search-field">
    <select
        id="x_vehicle"
        name="x_vehicle"
        class="form-control ew-select<?= $Page->vehicle->isInvalidClass() ?>"
        data-select2-id="ft_trip_infosrch_x_vehicle"
        data-table="t_trip_info"
        data-field="x_vehicle"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->vehicle->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->vehicle->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle->getPlaceHolder()) ?>"
        <?= $Page->vehicle->editAttributes() ?>>
        <?= $Page->vehicle->selectOptionListHtml("x_vehicle") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle->getErrorMessage(false) ?></div>
<?= $Page->vehicle->Lookup->getParamTag($Page, "p_x_vehicle") ?>
<script>
loadjs.ready("ft_trip_infosrch", function() {
    var options = { name: "x_vehicle", selectId: "ft_trip_infosrch_x_vehicle" };
    if (ft_trip_infosrch.lists.vehicle?.lookupOptions.length) {
        options.data = { id: "x_vehicle", form: "ft_trip_infosrch" };
    } else {
        options.ajax = { id: "x_vehicle", form: "ft_trip_infosrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.vehicle.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
<?php
if (!$Page->buyer->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->buyer->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer" id="z_buyer" value="=">
</div>
        </div>
        <div id="el_t_trip_info_buyer" class="ew-search-field">
    <select
        id="x_buyer"
        name="x_buyer"
        class="form-control ew-select<?= $Page->buyer->isInvalidClass() ?>"
        data-select2-id="ft_trip_infosrch_x_buyer"
        data-table="t_trip_info"
        data-field="x_buyer"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>"
        <?= $Page->buyer->editAttributes() ?>>
        <?= $Page->buyer->selectOptionListHtml("x_buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer->getErrorMessage(false) ?></div>
<?= $Page->buyer->Lookup->getParamTag($Page, "p_x_buyer") ?>
<script>
loadjs.ready("ft_trip_infosrch", function() {
    var options = { name: "x_buyer", selectId: "ft_trip_infosrch_x_buyer" };
    if (ft_trip_infosrch.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x_buyer", form: "ft_trip_infosrch" };
    } else {
        options.ajax = { id: "x_buyer", form: "ft_trip_infosrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.buyer.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->load_date->Visible) { // load_date ?>
<?php
if (!$Page->load_date->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_load_date" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->load_date->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_load_date" class="ew-search-caption ew-label"><?= $Page->load_date->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_date" id="z_load_date" value="=">
</div>
        </div>
        <div id="el_t_trip_info_load_date" class="ew-search-field">
<input type="<?= $Page->load_date->getInputTextType() ?>" name="x_load_date" id="x_load_date" data-table="t_trip_info" data-field="x_load_date" value="<?= $Page->load_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->load_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_date->formatPattern()) ?>"<?= $Page->load_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_date->getErrorMessage(false) ?></div>
<?php if (!$Page->load_date->ReadOnly && !$Page->load_date->Disabled && !isset($Page->load_date->EditAttrs["readonly"]) && !isset($Page->load_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_infosrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_infosrch", "x_load_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->unload_date->Visible) { // unload_date ?>
<?php
if (!$Page->unload_date->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_unload_date" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->unload_date->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_unload_date" class="ew-search-caption ew-label"><?= $Page->unload_date->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unload_date" id="z_unload_date" value="=">
</div>
        </div>
        <div id="el_t_trip_info_unload_date" class="ew-search-field">
<input type="<?= $Page->unload_date->getInputTextType() ?>" name="x_unload_date" id="x_unload_date" data-table="t_trip_info" data-field="x_unload_date" value="<?= $Page->unload_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->unload_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_date->formatPattern()) ?>"<?= $Page->unload_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_date->getErrorMessage(false) ?></div>
<?php if (!$Page->unload_date->ReadOnly && !$Page->unload_date->Disabled && !isset($Page->unload_date->EditAttrs["readonly"]) && !isset($Page->unload_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_infosrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_infosrch", "x_unload_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
<?php
if (!$Page->invoice_date->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_invoice_date" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->invoice_date->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_invoice_date" class="ew-search-caption ew-label"><?= $Page->invoice_date->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_invoice_date" id="z_invoice_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->invoice_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->invoice_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_t_trip_info_invoice_date" class="ew-search-field">
<input type="<?= $Page->invoice_date->getInputTextType() ?>" name="x_invoice_date" id="x_invoice_date" data-table="t_trip_info" data-field="x_invoice_date" value="<?= $Page->invoice_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->invoice_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_date->formatPattern()) ?>"<?= $Page->invoice_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_date->getErrorMessage(false) ?></div>
<?php if (!$Page->invoice_date->ReadOnly && !$Page->invoice_date->Disabled && !isset($Page->invoice_date->EditAttrs["readonly"]) && !isset($Page->invoice_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_infosrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_infosrch", "x_invoice_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_t_trip_info_invoice_date" class="ew-search-field2 d-none">
<input type="<?= $Page->invoice_date->getInputTextType() ?>" name="y_invoice_date" id="y_invoice_date" data-table="t_trip_info" data-field="x_invoice_date" value="<?= $Page->invoice_date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->invoice_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_date->formatPattern()) ?>"<?= $Page->invoice_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_date->getErrorMessage(false) ?></div>
<?php if (!$Page->invoice_date->ReadOnly && !$Page->invoice_date->Disabled && !isset($Page->invoice_date->EditAttrs["readonly"]) && !isset($Page->invoice_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_infosrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_infosrch", "y_invoice_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="ft_trip_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="ft_trip_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="ft_trip_infosrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ft_trip_infosrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ft_trip_infosrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ft_trip_infosrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ft_trip_infosrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_trip_info">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_t_trip_info" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_t_trip_infolist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_t_trip_info_id" class="t_trip_info_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->vehicle_type->Visible) { // vehicle_type ?>
        <th data-name="vehicle_type" class="<?= $Page->vehicle_type->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle_type" class="t_trip_info_vehicle_type"><?= $Page->renderFieldHeader($Page->vehicle_type) ?></div></th>
<?php } ?>
<?php if ($Page->vehicle->Visible) { // vehicle ?>
        <th data-name="vehicle" class="<?= $Page->vehicle->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle" class="t_trip_info_vehicle"><?= $Page->renderFieldHeader($Page->vehicle) ?></div></th>
<?php } ?>
<?php if ($Page->route_name->Visible) { // route_name ?>
        <th data-name="route_name" class="<?= $Page->route_name->headerCellClass() ?>"><div id="elh_t_trip_info_route_name" class="t_trip_info_route_name"><?= $Page->renderFieldHeader($Page->route_name) ?></div></th>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
        <th data-name="reports_to" class="<?= $Page->reports_to->headerCellClass() ?>"><div id="elh_t_trip_info_reports_to" class="t_trip_info_reports_to"><?= $Page->renderFieldHeader($Page->reports_to) ?></div></th>
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
        <th data-name="buyer" class="<?= $Page->buyer->headerCellClass() ?>"><div id="elh_t_trip_info_buyer" class="t_trip_info_buyer"><?= $Page->renderFieldHeader($Page->buyer) ?></div></th>
<?php } ?>
<?php if ($Page->b_consignor->Visible) { // b_consignor ?>
        <th data-name="b_consignor" class="<?= $Page->b_consignor->headerCellClass() ?>"><div id="elh_t_trip_info_b_consignor" class="t_trip_info_b_consignor"><?= $Page->renderFieldHeader($Page->b_consignor) ?></div></th>
<?php } ?>
<?php if ($Page->b_consignee->Visible) { // b_consignee ?>
        <th data-name="b_consignee" class="<?= $Page->b_consignee->headerCellClass() ?>"><div id="elh_t_trip_info_b_consignee" class="t_trip_info_b_consignee"><?= $Page->renderFieldHeader($Page->b_consignee) ?></div></th>
<?php } ?>
<?php if ($Page->load_date->Visible) { // load_date ?>
        <th data-name="load_date" class="<?= $Page->load_date->headerCellClass() ?>"><div id="elh_t_trip_info_load_date" class="t_trip_info_load_date"><?= $Page->renderFieldHeader($Page->load_date) ?></div></th>
<?php } ?>
<?php if ($Page->load_weight->Visible) { // load_weight ?>
        <th data-name="load_weight" class="<?= $Page->load_weight->headerCellClass() ?>"><div id="elh_t_trip_info_load_weight" class="t_trip_info_load_weight"><?= $Page->renderFieldHeader($Page->load_weight) ?></div></th>
<?php } ?>
<?php if ($Page->unload_date->Visible) { // unload_date ?>
        <th data-name="unload_date" class="<?= $Page->unload_date->headerCellClass() ?>"><div id="elh_t_trip_info_unload_date" class="t_trip_info_unload_date"><?= $Page->renderFieldHeader($Page->unload_date) ?></div></th>
<?php } ?>
<?php if ($Page->unload_weight->Visible) { // unload_weight ?>
        <th data-name="unload_weight" class="<?= $Page->unload_weight->headerCellClass() ?>"><div id="elh_t_trip_info_unload_weight" class="t_trip_info_unload_weight"><?= $Page->renderFieldHeader($Page->unload_weight) ?></div></th>
<?php } ?>
<?php if ($Page->invoice_no->Visible) { // invoice_no ?>
        <th data-name="invoice_no" class="<?= $Page->invoice_no->headerCellClass() ?>"><div id="elh_t_trip_info_invoice_no" class="t_trip_info_invoice_no"><?= $Page->renderFieldHeader($Page->invoice_no) ?></div></th>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
        <th data-name="invoice_date" class="<?= $Page->invoice_date->headerCellClass() ?>"><div id="elh_t_trip_info_invoice_date" class="t_trip_info_invoice_date"><?= $Page->renderFieldHeader($Page->invoice_date) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>"><div id="elh_t_trip_info_amount" class="t_trip_info_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php if ($Page->delivery_pod->Visible) { // delivery_pod ?>
        <th data-name="delivery_pod" class="<?= $Page->delivery_pod->headerCellClass() ?>"><div id="elh_t_trip_info_delivery_pod" class="t_trip_info_delivery_pod"><?= $Page->renderFieldHeader($Page->delivery_pod) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_t_trip_info_status" class="t_trip_info_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->days->Visible) { // days ?>
        <th data-name="days" class="<?= $Page->days->headerCellClass() ?>"><div id="elh_t_trip_info_days" class="t_trip_info_days"><?= $Page->renderFieldHeader($Page->days) ?></div></th>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
        <th data-name="driver" class="<?= $Page->driver->headerCellClass() ?>"><div id="elh_t_trip_info_driver" class="t_trip_info_driver"><?= $Page->renderFieldHeader($Page->driver) ?></div></th>
<?php } ?>
<?php if ($Page->driver_name->Visible) { // driver_name ?>
        <th data-name="driver_name" class="<?= $Page->driver_name->headerCellClass() ?>"><div id="elh_t_trip_info_driver_name" class="t_trip_info_driver_name"><?= $Page->renderFieldHeader($Page->driver_name) ?></div></th>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
        <th data-name="agent" class="<?= $Page->agent->headerCellClass() ?>"><div id="elh_t_trip_info_agent" class="t_trip_info_agent"><?= $Page->renderFieldHeader($Page->agent) ?></div></th>
<?php } ?>
<?php if ($Page->comm->Visible) { // comm ?>
        <th data-name="comm" class="<?= $Page->comm->headerCellClass() ?>"><div id="elh_t_trip_info_comm" class="t_trip_info_comm"><?= $Page->renderFieldHeader($Page->comm) ?></div></th>
<?php } ?>
<?php if ($Page->material->Visible) { // material ?>
        <th data-name="material" class="<?= $Page->material->headerCellClass() ?>"><div id="elh_t_trip_info_material" class="t_trip_info_material"><?= $Page->renderFieldHeader($Page->material) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_t_trip_info_packing_type" class="t_trip_info_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php if ($Page->m_hsn->Visible) { // m_hsn ?>
        <th data-name="m_hsn" class="<?= $Page->m_hsn->headerCellClass() ?>"><div id="elh_t_trip_info_m_hsn" class="t_trip_info_m_hsn"><?= $Page->renderFieldHeader($Page->m_hsn) ?></div></th>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
        <th data-name="_40" class="<?= $Page->_40->headerCellClass() ?>"><div id="elh_t_trip_info__40" class="t_trip_info__40"><?= $Page->renderFieldHeader($Page->_40) ?></div></th>
<?php } ?>
<?php if ($Page->lr_no->Visible) { // lr_no ?>
        <th data-name="lr_no" class="<?= $Page->lr_no->headerCellClass() ?>"><div id="elh_t_trip_info_lr_no" class="t_trip_info_lr_no"><?= $Page->renderFieldHeader($Page->lr_no) ?></div></th>
<?php } ?>
<?php if ($Page->km->Visible) { // km ?>
        <th data-name="km" class="<?= $Page->km->headerCellClass() ?>"><div id="elh_t_trip_info_km" class="t_trip_info_km"><?= $Page->renderFieldHeader($Page->km) ?></div></th>
<?php } ?>
<?php if ($Page->freight_type->Visible) { // freight_type ?>
        <th data-name="freight_type" class="<?= $Page->freight_type->headerCellClass() ?>"><div id="elh_t_trip_info_freight_type" class="t_trip_info_freight_type"><?= $Page->renderFieldHeader($Page->freight_type) ?></div></th>
<?php } ?>
<?php if ($Page->freight->Visible) { // freight ?>
        <th data-name="freight" class="<?= $Page->freight->headerCellClass() ?>"><div id="elh_t_trip_info_freight" class="t_trip_info_freight"><?= $Page->renderFieldHeader($Page->freight) ?></div></th>
<?php } ?>
<?php if ($Page->ded_det->Visible) { // ded_det ?>
        <th data-name="ded_det" class="<?= $Page->ded_det->headerCellClass() ?>"><div id="elh_t_trip_info_ded_det" class="t_trip_info_ded_det"><?= $Page->renderFieldHeader($Page->ded_det) ?></div></th>
<?php } ?>
<?php if ($Page->ded_det_remarks->Visible) { // ded_det_remarks ?>
        <th data-name="ded_det_remarks" class="<?= $Page->ded_det_remarks->headerCellClass() ?>"><div id="elh_t_trip_info_ded_det_remarks" class="t_trip_info_ded_det_remarks"><?= $Page->renderFieldHeader($Page->ded_det_remarks) ?></div></th>
<?php } ?>
<?php if ($Page->gst_percent->Visible) { // gst_percent ?>
        <th data-name="gst_percent" class="<?= $Page->gst_percent->headerCellClass() ?>"><div id="elh_t_trip_info_gst_percent" class="t_trip_info_gst_percent"><?= $Page->renderFieldHeader($Page->gst_percent) ?></div></th>
<?php } ?>
<?php if ($Page->gst_amount->Visible) { // gst_amount ?>
        <th data-name="gst_amount" class="<?= $Page->gst_amount->headerCellClass() ?>"><div id="elh_t_trip_info_gst_amount" class="t_trip_info_gst_amount"><?= $Page->renderFieldHeader($Page->gst_amount) ?></div></th>
<?php } ?>
<?php if ($Page->final_amount->Visible) { // final_amount ?>
        <th data-name="final_amount" class="<?= $Page->final_amount->headerCellClass() ?>"><div id="elh_t_trip_info_final_amount" class="t_trip_info_final_amount"><?= $Page->renderFieldHeader($Page->final_amount) ?></div></th>
<?php } ?>
<?php if ($Page->load_km->Visible) { // load_km ?>
        <th data-name="load_km" class="<?= $Page->load_km->headerCellClass() ?>"><div id="elh_t_trip_info_load_km" class="t_trip_info_load_km"><?= $Page->renderFieldHeader($Page->load_km) ?></div></th>
<?php } ?>
<?php if ($Page->unload_km->Visible) { // unload_km ?>
        <th data-name="unload_km" class="<?= $Page->unload_km->headerCellClass() ?>"><div id="elh_t_trip_info_unload_km" class="t_trip_info_unload_km"><?= $Page->renderFieldHeader($Page->unload_km) ?></div></th>
<?php } ?>
<?php if ($Page->delivery_receipt->Visible) { // delivery_receipt ?>
        <th data-name="delivery_receipt" class="<?= $Page->delivery_receipt->headerCellClass() ?>"><div id="elh_t_trip_info_delivery_receipt" class="t_trip_info_delivery_receipt"><?= $Page->renderFieldHeader($Page->delivery_receipt) ?></div></th>
<?php } ?>
<?php if ($Page->delivery_docket->Visible) { // delivery_docket ?>
        <th data-name="delivery_docket" class="<?= $Page->delivery_docket->headerCellClass() ?>"><div id="elh_t_trip_info_delivery_docket" class="t_trip_info_delivery_docket"><?= $Page->renderFieldHeader($Page->delivery_docket) ?></div></th>
<?php } ?>
<?php if ($Page->diesal_op_b->Visible) { // diesal_op_b ?>
        <th data-name="diesal_op_b" class="<?= $Page->diesal_op_b->headerCellClass() ?>"><div id="elh_t_trip_info_diesal_op_b" class="t_trip_info_diesal_op_b"><?= $Page->renderFieldHeader($Page->diesal_op_b) ?></div></th>
<?php } ?>
<?php if ($Page->diesal_required->Visible) { // diesal_required ?>
        <th data-name="diesal_required" class="<?= $Page->diesal_required->headerCellClass() ?>"><div id="elh_t_trip_info_diesal_required" class="t_trip_info_diesal_required"><?= $Page->renderFieldHeader($Page->diesal_required) ?></div></th>
<?php } ?>
<?php if ($Page->diesal_fill->Visible) { // diesal_fill ?>
        <th data-name="diesal_fill" class="<?= $Page->diesal_fill->headerCellClass() ?>"><div id="elh_t_trip_info_diesal_fill" class="t_trip_info_diesal_fill"><?= $Page->renderFieldHeader($Page->diesal_fill) ?></div></th>
<?php } ?>
<?php if ($Page->diesal_amount->Visible) { // diesal_amount ?>
        <th data-name="diesal_amount" class="<?= $Page->diesal_amount->headerCellClass() ?>"><div id="elh_t_trip_info_diesal_amount" class="t_trip_info_diesal_amount"><?= $Page->renderFieldHeader($Page->diesal_amount) ?></div></th>
<?php } ?>
<?php if ($Page->diesal_cl_balance->Visible) { // diesal_cl_balance ?>
        <th data-name="diesal_cl_balance" class="<?= $Page->diesal_cl_balance->headerCellClass() ?>"><div id="elh_t_trip_info_diesal_cl_balance" class="t_trip_info_diesal_cl_balance"><?= $Page->renderFieldHeader($Page->diesal_cl_balance) ?></div></th>
<?php } ?>
<?php if ($Page->vehicle_average->Visible) { // vehicle_average ?>
        <th data-name="vehicle_average" class="<?= $Page->vehicle_average->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle_average" class="t_trip_info_vehicle_average"><?= $Page->renderFieldHeader($Page->vehicle_average) ?></div></th>
<?php } ?>
<?php if ($Page->cash_required->Visible) { // cash_required ?>
        <th data-name="cash_required" class="<?= $Page->cash_required->headerCellClass() ?>"><div id="elh_t_trip_info_cash_required" class="t_trip_info_cash_required"><?= $Page->renderFieldHeader($Page->cash_required) ?></div></th>
<?php } ?>
<?php if ($Page->cash_op_b->Visible) { // cash_op_b ?>
        <th data-name="cash_op_b" class="<?= $Page->cash_op_b->headerCellClass() ?>"><div id="elh_t_trip_info_cash_op_b" class="t_trip_info_cash_op_b"><?= $Page->renderFieldHeader($Page->cash_op_b) ?></div></th>
<?php } ?>
<?php if ($Page->cash_paid->Visible) { // cash_paid ?>
        <th data-name="cash_paid" class="<?= $Page->cash_paid->headerCellClass() ?>"><div id="elh_t_trip_info_cash_paid" class="t_trip_info_cash_paid"><?= $Page->renderFieldHeader($Page->cash_paid) ?></div></th>
<?php } ?>
<?php if ($Page->cash_expenses->Visible) { // cash_expenses ?>
        <th data-name="cash_expenses" class="<?= $Page->cash_expenses->headerCellClass() ?>"><div id="elh_t_trip_info_cash_expenses" class="t_trip_info_cash_expenses"><?= $Page->renderFieldHeader($Page->cash_expenses) ?></div></th>
<?php } ?>
<?php if ($Page->cash_cl_balance->Visible) { // cash_cl_balance ?>
        <th data-name="cash_cl_balance" class="<?= $Page->cash_cl_balance->headerCellClass() ?>"><div id="elh_t_trip_info_cash_cl_balance" class="t_trip_info_cash_cl_balance"><?= $Page->renderFieldHeader($Page->cash_cl_balance) ?></div></th>
<?php } ?>
<?php if ($Page->fasttag_op_b->Visible) { // fasttag_op_b ?>
        <th data-name="fasttag_op_b" class="<?= $Page->fasttag_op_b->headerCellClass() ?>"><div id="elh_t_trip_info_fasttag_op_b" class="t_trip_info_fasttag_op_b"><?= $Page->renderFieldHeader($Page->fasttag_op_b) ?></div></th>
<?php } ?>
<?php if ($Page->fasttag_recharge->Visible) { // fasttag_recharge ?>
        <th data-name="fasttag_recharge" class="<?= $Page->fasttag_recharge->headerCellClass() ?>"><div id="elh_t_trip_info_fasttag_recharge" class="t_trip_info_fasttag_recharge"><?= $Page->renderFieldHeader($Page->fasttag_recharge) ?></div></th>
<?php } ?>
<?php if ($Page->fasttag_expenses->Visible) { // fasttag_expenses ?>
        <th data-name="fasttag_expenses" class="<?= $Page->fasttag_expenses->headerCellClass() ?>"><div id="elh_t_trip_info_fasttag_expenses" class="t_trip_info_fasttag_expenses"><?= $Page->renderFieldHeader($Page->fasttag_expenses) ?></div></th>
<?php } ?>
<?php if ($Page->toll_expenses_cash->Visible) { // toll_expenses_cash ?>
        <th data-name="toll_expenses_cash" class="<?= $Page->toll_expenses_cash->headerCellClass() ?>"><div id="elh_t_trip_info_toll_expenses_cash" class="t_trip_info_toll_expenses_cash"><?= $Page->renderFieldHeader($Page->toll_expenses_cash) ?></div></th>
<?php } ?>
<?php if ($Page->fasttag_cl_balance->Visible) { // fasttag_cl_balance ?>
        <th data-name="fasttag_cl_balance" class="<?= $Page->fasttag_cl_balance->headerCellClass() ?>"><div id="elh_t_trip_info_fasttag_cl_balance" class="t_trip_info_fasttag_cl_balance"><?= $Page->renderFieldHeader($Page->fasttag_cl_balance) ?></div></th>
<?php } ?>
<?php if ($Page->consignor->Visible) { // consignor ?>
        <th data-name="consignor" class="<?= $Page->consignor->headerCellClass() ?>"><div id="elh_t_trip_info_consignor" class="t_trip_info_consignor"><?= $Page->renderFieldHeader($Page->consignor) ?></div></th>
<?php } ?>
<?php if ($Page->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
        <th data-name="vehicle_freight_comm" class="<?= $Page->vehicle_freight_comm->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle_freight_comm" class="t_trip_info_vehicle_freight_comm"><?= $Page->renderFieldHeader($Page->vehicle_freight_comm) ?></div></th>
<?php } ?>
<?php if ($Page->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
        <th data-name="vehicle_freight_type" class="<?= $Page->vehicle_freight_type->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle_freight_type" class="t_trip_info_vehicle_freight_type"><?= $Page->renderFieldHeader($Page->vehicle_freight_type) ?></div></th>
<?php } ?>
<?php if ($Page->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
        <th data-name="vehicle_freight_amount" class="<?= $Page->vehicle_freight_amount->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle_freight_amount" class="t_trip_info_vehicle_freight_amount"><?= $Page->renderFieldHeader($Page->vehicle_freight_amount) ?></div></th>
<?php } ?>
<?php if ($Page->vehicle_freight_final->Visible) { // vehicle_freight_final ?>
        <th data-name="vehicle_freight_final" class="<?= $Page->vehicle_freight_final->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle_freight_final" class="t_trip_info_vehicle_freight_final"><?= $Page->renderFieldHeader($Page->vehicle_freight_final) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_t_trip_info_datetime" class="t_trip_info_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_id" class="el_t_trip_info_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->vehicle_type->Visible) { // vehicle_type ?>
        <td data-name="vehicle_type"<?= $Page->vehicle_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_vehicle_type" class="el_t_trip_info_vehicle_type">
<span<?= $Page->vehicle_type->viewAttributes() ?>>
<?= $Page->vehicle_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->vehicle->Visible) { // vehicle ?>
        <td data-name="vehicle"<?= $Page->vehicle->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_vehicle" class="el_t_trip_info_vehicle">
<span<?= $Page->vehicle->viewAttributes() ?>>
<?= $Page->vehicle->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->route_name->Visible) { // route_name ?>
        <td data-name="route_name"<?= $Page->route_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_route_name" class="el_t_trip_info_route_name">
<span<?= $Page->route_name->viewAttributes() ?>>
<?= $Page->route_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->reports_to->Visible) { // reports_to ?>
        <td data-name="reports_to"<?= $Page->reports_to->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_reports_to" class="el_t_trip_info_reports_to">
<span<?= $Page->reports_to->viewAttributes() ?>>
<?= $Page->reports_to->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer->Visible) { // buyer ?>
        <td data-name="buyer"<?= $Page->buyer->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_buyer" class="el_t_trip_info_buyer">
<span<?= $Page->buyer->viewAttributes() ?>>
<?= $Page->buyer->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_consignor->Visible) { // b_consignor ?>
        <td data-name="b_consignor"<?= $Page->b_consignor->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_b_consignor" class="el_t_trip_info_b_consignor">
<span<?= $Page->b_consignor->viewAttributes() ?>>
<?= $Page->b_consignor->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_consignee->Visible) { // b_consignee ?>
        <td data-name="b_consignee"<?= $Page->b_consignee->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_b_consignee" class="el_t_trip_info_b_consignee">
<span<?= $Page->b_consignee->viewAttributes() ?>>
<?= $Page->b_consignee->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->load_date->Visible) { // load_date ?>
        <td data-name="load_date"<?= $Page->load_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_load_date" class="el_t_trip_info_load_date">
<span<?= $Page->load_date->viewAttributes() ?>>
<?= $Page->load_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->load_weight->Visible) { // load_weight ?>
        <td data-name="load_weight"<?= $Page->load_weight->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_load_weight" class="el_t_trip_info_load_weight">
<span<?= $Page->load_weight->viewAttributes() ?>>
<?= $Page->load_weight->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->unload_date->Visible) { // unload_date ?>
        <td data-name="unload_date"<?= $Page->unload_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_unload_date" class="el_t_trip_info_unload_date">
<span<?= $Page->unload_date->viewAttributes() ?>>
<?= $Page->unload_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->unload_weight->Visible) { // unload_weight ?>
        <td data-name="unload_weight"<?= $Page->unload_weight->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_unload_weight" class="el_t_trip_info_unload_weight">
<span<?= $Page->unload_weight->viewAttributes() ?>>
<?= $Page->unload_weight->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->invoice_no->Visible) { // invoice_no ?>
        <td data-name="invoice_no"<?= $Page->invoice_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_invoice_no" class="el_t_trip_info_invoice_no">
<span<?= $Page->invoice_no->viewAttributes() ?>>
<?= $Page->invoice_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->invoice_date->Visible) { // invoice_date ?>
        <td data-name="invoice_date"<?= $Page->invoice_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_invoice_date" class="el_t_trip_info_invoice_date">
<span<?= $Page->invoice_date->viewAttributes() ?>>
<?= $Page->invoice_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_amount" class="el_t_trip_info_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?= $Page->amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->delivery_pod->Visible) { // delivery_pod ?>
        <td data-name="delivery_pod"<?= $Page->delivery_pod->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_delivery_pod" class="el_t_trip_info_delivery_pod">
<span<?= $Page->delivery_pod->viewAttributes() ?>>
<?= $Page->delivery_pod->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_status" class="el_t_trip_info_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->days->Visible) { // days ?>
        <td data-name="days"<?= $Page->days->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_days" class="el_t_trip_info_days">
<span<?= $Page->days->viewAttributes() ?>>
<?= $Page->days->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->driver->Visible) { // driver ?>
        <td data-name="driver"<?= $Page->driver->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_driver" class="el_t_trip_info_driver">
<span<?= $Page->driver->viewAttributes() ?>>
<?= $Page->driver->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->driver_name->Visible) { // driver_name ?>
        <td data-name="driver_name"<?= $Page->driver_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_driver_name" class="el_t_trip_info_driver_name">
<span<?= $Page->driver_name->viewAttributes() ?>>
<?= $Page->driver_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->agent->Visible) { // agent ?>
        <td data-name="agent"<?= $Page->agent->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_agent" class="el_t_trip_info_agent">
<span<?= $Page->agent->viewAttributes() ?>>
<?= $Page->agent->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->comm->Visible) { // comm ?>
        <td data-name="comm"<?= $Page->comm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_comm" class="el_t_trip_info_comm">
<span<?= $Page->comm->viewAttributes() ?>>
<?= $Page->comm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->material->Visible) { // material ?>
        <td data-name="material"<?= $Page->material->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_material" class="el_t_trip_info_material">
<span<?= $Page->material->viewAttributes() ?>>
<?= $Page->material->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_packing_type" class="el_t_trip_info_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?= $Page->packing_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_hsn->Visible) { // m_hsn ?>
        <td data-name="m_hsn"<?= $Page->m_hsn->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_m_hsn" class="el_t_trip_info_m_hsn">
<span<?= $Page->m_hsn->viewAttributes() ?>>
<?= $Page->m_hsn->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_40->Visible) { // @ ?>
        <td data-name="_40"<?= $Page->_40->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info__40" class="el_t_trip_info__40">
<span<?= $Page->_40->viewAttributes() ?>>
<?= $Page->_40->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lr_no->Visible) { // lr_no ?>
        <td data-name="lr_no"<?= $Page->lr_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_lr_no" class="el_t_trip_info_lr_no">
<span<?= $Page->lr_no->viewAttributes() ?>>
<?= $Page->lr_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->km->Visible) { // km ?>
        <td data-name="km"<?= $Page->km->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_km" class="el_t_trip_info_km">
<span<?= $Page->km->viewAttributes() ?>>
<?= $Page->km->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->freight_type->Visible) { // freight_type ?>
        <td data-name="freight_type"<?= $Page->freight_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_freight_type" class="el_t_trip_info_freight_type">
<span<?= $Page->freight_type->viewAttributes() ?>>
<?= $Page->freight_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->freight->Visible) { // freight ?>
        <td data-name="freight"<?= $Page->freight->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_freight" class="el_t_trip_info_freight">
<span<?= $Page->freight->viewAttributes() ?>>
<?= $Page->freight->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ded_det->Visible) { // ded_det ?>
        <td data-name="ded_det"<?= $Page->ded_det->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_ded_det" class="el_t_trip_info_ded_det">
<span<?= $Page->ded_det->viewAttributes() ?>>
<?= $Page->ded_det->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ded_det_remarks->Visible) { // ded_det_remarks ?>
        <td data-name="ded_det_remarks"<?= $Page->ded_det_remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_ded_det_remarks" class="el_t_trip_info_ded_det_remarks">
<span<?= $Page->ded_det_remarks->viewAttributes() ?>>
<?= $Page->ded_det_remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->gst_percent->Visible) { // gst_percent ?>
        <td data-name="gst_percent"<?= $Page->gst_percent->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_gst_percent" class="el_t_trip_info_gst_percent">
<span<?= $Page->gst_percent->viewAttributes() ?>>
<?= $Page->gst_percent->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->gst_amount->Visible) { // gst_amount ?>
        <td data-name="gst_amount"<?= $Page->gst_amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_gst_amount" class="el_t_trip_info_gst_amount">
<span<?= $Page->gst_amount->viewAttributes() ?>>
<?= $Page->gst_amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->final_amount->Visible) { // final_amount ?>
        <td data-name="final_amount"<?= $Page->final_amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_final_amount" class="el_t_trip_info_final_amount">
<span<?= $Page->final_amount->viewAttributes() ?>>
<?= $Page->final_amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->load_km->Visible) { // load_km ?>
        <td data-name="load_km"<?= $Page->load_km->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_load_km" class="el_t_trip_info_load_km">
<span<?= $Page->load_km->viewAttributes() ?>>
<?= $Page->load_km->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->unload_km->Visible) { // unload_km ?>
        <td data-name="unload_km"<?= $Page->unload_km->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_unload_km" class="el_t_trip_info_unload_km">
<span<?= $Page->unload_km->viewAttributes() ?>>
<?= $Page->unload_km->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->delivery_receipt->Visible) { // delivery_receipt ?>
        <td data-name="delivery_receipt"<?= $Page->delivery_receipt->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_delivery_receipt" class="el_t_trip_info_delivery_receipt">
<span>
<?= GetFileViewTag($Page->delivery_receipt, $Page->delivery_receipt->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->delivery_docket->Visible) { // delivery_docket ?>
        <td data-name="delivery_docket"<?= $Page->delivery_docket->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_delivery_docket" class="el_t_trip_info_delivery_docket">
<span<?= $Page->delivery_docket->viewAttributes() ?>>
<?= $Page->delivery_docket->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->diesal_op_b->Visible) { // diesal_op_b ?>
        <td data-name="diesal_op_b"<?= $Page->diesal_op_b->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_diesal_op_b" class="el_t_trip_info_diesal_op_b">
<span<?= $Page->diesal_op_b->viewAttributes() ?>>
<?= $Page->diesal_op_b->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->diesal_required->Visible) { // diesal_required ?>
        <td data-name="diesal_required"<?= $Page->diesal_required->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_diesal_required" class="el_t_trip_info_diesal_required">
<span<?= $Page->diesal_required->viewAttributes() ?>>
<?= $Page->diesal_required->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->diesal_fill->Visible) { // diesal_fill ?>
        <td data-name="diesal_fill"<?= $Page->diesal_fill->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_diesal_fill" class="el_t_trip_info_diesal_fill">
<span<?= $Page->diesal_fill->viewAttributes() ?>>
<?= $Page->diesal_fill->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->diesal_amount->Visible) { // diesal_amount ?>
        <td data-name="diesal_amount"<?= $Page->diesal_amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_diesal_amount" class="el_t_trip_info_diesal_amount">
<span<?= $Page->diesal_amount->viewAttributes() ?>>
<?= $Page->diesal_amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->diesal_cl_balance->Visible) { // diesal_cl_balance ?>
        <td data-name="diesal_cl_balance"<?= $Page->diesal_cl_balance->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_diesal_cl_balance" class="el_t_trip_info_diesal_cl_balance">
<span<?= $Page->diesal_cl_balance->viewAttributes() ?>>
<?= $Page->diesal_cl_balance->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->vehicle_average->Visible) { // vehicle_average ?>
        <td data-name="vehicle_average"<?= $Page->vehicle_average->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_vehicle_average" class="el_t_trip_info_vehicle_average">
<span<?= $Page->vehicle_average->viewAttributes() ?>>
<?= $Page->vehicle_average->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cash_required->Visible) { // cash_required ?>
        <td data-name="cash_required"<?= $Page->cash_required->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_cash_required" class="el_t_trip_info_cash_required">
<span<?= $Page->cash_required->viewAttributes() ?>>
<?= $Page->cash_required->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cash_op_b->Visible) { // cash_op_b ?>
        <td data-name="cash_op_b"<?= $Page->cash_op_b->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_cash_op_b" class="el_t_trip_info_cash_op_b">
<span<?= $Page->cash_op_b->viewAttributes() ?>>
<?= $Page->cash_op_b->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cash_paid->Visible) { // cash_paid ?>
        <td data-name="cash_paid"<?= $Page->cash_paid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_cash_paid" class="el_t_trip_info_cash_paid">
<span<?= $Page->cash_paid->viewAttributes() ?>>
<?= $Page->cash_paid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cash_expenses->Visible) { // cash_expenses ?>
        <td data-name="cash_expenses"<?= $Page->cash_expenses->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_cash_expenses" class="el_t_trip_info_cash_expenses">
<span<?= $Page->cash_expenses->viewAttributes() ?>>
<?= $Page->cash_expenses->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cash_cl_balance->Visible) { // cash_cl_balance ?>
        <td data-name="cash_cl_balance"<?= $Page->cash_cl_balance->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_cash_cl_balance" class="el_t_trip_info_cash_cl_balance">
<span<?= $Page->cash_cl_balance->viewAttributes() ?>>
<?= $Page->cash_cl_balance->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->fasttag_op_b->Visible) { // fasttag_op_b ?>
        <td data-name="fasttag_op_b"<?= $Page->fasttag_op_b->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_fasttag_op_b" class="el_t_trip_info_fasttag_op_b">
<span<?= $Page->fasttag_op_b->viewAttributes() ?>>
<?= $Page->fasttag_op_b->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->fasttag_recharge->Visible) { // fasttag_recharge ?>
        <td data-name="fasttag_recharge"<?= $Page->fasttag_recharge->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_fasttag_recharge" class="el_t_trip_info_fasttag_recharge">
<span<?= $Page->fasttag_recharge->viewAttributes() ?>>
<?= $Page->fasttag_recharge->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->fasttag_expenses->Visible) { // fasttag_expenses ?>
        <td data-name="fasttag_expenses"<?= $Page->fasttag_expenses->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_fasttag_expenses" class="el_t_trip_info_fasttag_expenses">
<span<?= $Page->fasttag_expenses->viewAttributes() ?>>
<?= $Page->fasttag_expenses->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->toll_expenses_cash->Visible) { // toll_expenses_cash ?>
        <td data-name="toll_expenses_cash"<?= $Page->toll_expenses_cash->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_toll_expenses_cash" class="el_t_trip_info_toll_expenses_cash">
<span<?= $Page->toll_expenses_cash->viewAttributes() ?>>
<?= $Page->toll_expenses_cash->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->fasttag_cl_balance->Visible) { // fasttag_cl_balance ?>
        <td data-name="fasttag_cl_balance"<?= $Page->fasttag_cl_balance->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_fasttag_cl_balance" class="el_t_trip_info_fasttag_cl_balance">
<span<?= $Page->fasttag_cl_balance->viewAttributes() ?>>
<?= $Page->fasttag_cl_balance->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->consignor->Visible) { // consignor ?>
        <td data-name="consignor"<?= $Page->consignor->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_consignor" class="el_t_trip_info_consignor">
<span<?= $Page->consignor->viewAttributes() ?>>
<?= $Page->consignor->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
        <td data-name="vehicle_freight_comm"<?= $Page->vehicle_freight_comm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_vehicle_freight_comm" class="el_t_trip_info_vehicle_freight_comm">
<span<?= $Page->vehicle_freight_comm->viewAttributes() ?>>
<?= $Page->vehicle_freight_comm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
        <td data-name="vehicle_freight_type"<?= $Page->vehicle_freight_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_vehicle_freight_type" class="el_t_trip_info_vehicle_freight_type">
<span<?= $Page->vehicle_freight_type->viewAttributes() ?>>
<?= $Page->vehicle_freight_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
        <td data-name="vehicle_freight_amount"<?= $Page->vehicle_freight_amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_vehicle_freight_amount" class="el_t_trip_info_vehicle_freight_amount">
<span<?= $Page->vehicle_freight_amount->viewAttributes() ?>>
<?= $Page->vehicle_freight_amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->vehicle_freight_final->Visible) { // vehicle_freight_final ?>
        <td data-name="vehicle_freight_final"<?= $Page->vehicle_freight_final->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_vehicle_freight_final" class="el_t_trip_info_vehicle_freight_final">
<span<?= $Page->vehicle_freight_final->viewAttributes() ?>>
<?= $Page->vehicle_freight_final->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_info_datetime" class="el_t_trip_info_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_trip_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
