<?php

namespace PHPMaker2024\fibre;

// Page object
$TTripInfoDUnloadSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_info_d_unload: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ft_trip_info_d_unloadsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_trip_info_d_unloadsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["load_date", [ew.Validators.datetime(fields.load_date.clientFormatPattern)], fields.load_date.isInvalid],
            ["trip_info", [], fields.trip_info.isInvalid],
            ["driver", [], fields.driver.isInvalid],
            ["unload_km", [ew.Validators.integer], fields.unload_km.isInvalid],
            ["load_weight", [ew.Validators.integer], fields.load_weight.isInvalid],
            ["unload_weight", [ew.Validators.integer], fields.unload_weight.isInvalid],
            ["unload_date", [ew.Validators.datetime(fields.unload_date.clientFormatPattern)], fields.unload_date.isInvalid],
            ["ded_det", [ew.Validators.float], fields.ded_det.isInvalid],
            ["ded_det_remarks", [], fields.ded_det_remarks.isInvalid],
            ["fasttag_cl_balance", [ew.Validators.float], fields.fasttag_cl_balance.isInvalid],
            ["delivery_receipt", [], fields.delivery_receipt.isInvalid],
            ["delivery_pod", [], fields.delivery_pod.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "trip_info": <?= $Page->trip_info->toClientList($Page) ?>,
            "driver": <?= $Page->driver->toClientList($Page) ?>,
            "delivery_pod": <?= $Page->delivery_pod->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_trip_info_d_unloadsearch" id="ft_trip_info_d_unloadsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_trip_info_d_unload">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="t_trip_info_d_unload" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->load_date->Visible) { // load_date ?>
    <div id="r_load_date" class="row"<?= $Page->load_date->rowAttributes() ?>>
        <label for="x_load_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_load_date"><?= $Page->load_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_date" id="z_load_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->load_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_load_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->load_date->getInputTextType() ?>" name="x_load_date" id="x_load_date" data-table="t_trip_info_d_unload" data-field="x_load_date" value="<?= $Page->load_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->load_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_date->formatPattern()) ?>"<?= $Page->load_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_date->getErrorMessage(false) ?></div>
<?php if (!$Page->load_date->ReadOnly && !$Page->load_date->Disabled && !isset($Page->load_date->EditAttrs["readonly"]) && !isset($Page->load_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_info_d_unloadsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_info_d_unloadsearch", "x_load_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->trip_info->Visible) { // trip_info ?>
    <div id="r_trip_info" class="row"<?= $Page->trip_info->rowAttributes() ?>>
        <label for="x_trip_info" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_trip_info"><?= $Page->trip_info->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_trip_info" id="z_trip_info" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->trip_info->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_trip_info" class="ew-search-field ew-search-field-single">
    <select
        id="x_trip_info"
        name="x_trip_info"
        class="form-select ew-select<?= $Page->trip_info->isInvalidClass() ?>"
        <?php if (!$Page->trip_info->IsNativeSelect) { ?>
        data-select2-id="ft_trip_info_d_unloadsearch_x_trip_info"
        <?php } ?>
        data-table="t_trip_info_d_unload"
        data-field="x_trip_info"
        data-value-separator="<?= $Page->trip_info->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->trip_info->getPlaceHolder()) ?>"
        <?= $Page->trip_info->editAttributes() ?>>
        <?= $Page->trip_info->selectOptionListHtml("x_trip_info") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->trip_info->getErrorMessage(false) ?></div>
<?= $Page->trip_info->Lookup->getParamTag($Page, "p_x_trip_info") ?>
<?php if (!$Page->trip_info->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_info_d_unloadsearch", function() {
    var options = { name: "x_trip_info", selectId: "ft_trip_info_d_unloadsearch_x_trip_info" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_info_d_unloadsearch.lists.trip_info?.lookupOptions.length) {
        options.data = { id: "x_trip_info", form: "ft_trip_info_d_unloadsearch" };
    } else {
        options.ajax = { id: "x_trip_info", form: "ft_trip_info_d_unloadsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info_d_unload.fields.trip_info.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
    <div id="r_driver" class="row"<?= $Page->driver->rowAttributes() ?>>
        <label for="x_driver" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_driver"><?= $Page->driver->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_driver" id="z_driver" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->driver->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_driver" class="ew-search-field ew-search-field-single">
    <select
        id="x_driver"
        name="x_driver"
        class="form-select ew-select<?= $Page->driver->isInvalidClass() ?>"
        <?php if (!$Page->driver->IsNativeSelect) { ?>
        data-select2-id="ft_trip_info_d_unloadsearch_x_driver"
        <?php } ?>
        data-table="t_trip_info_d_unload"
        data-field="x_driver"
        data-value-separator="<?= $Page->driver->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>"
        <?= $Page->driver->editAttributes() ?>>
        <?= $Page->driver->selectOptionListHtml("x_driver") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->driver->getErrorMessage(false) ?></div>
<?= $Page->driver->Lookup->getParamTag($Page, "p_x_driver") ?>
<?php if (!$Page->driver->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_info_d_unloadsearch", function() {
    var options = { name: "x_driver", selectId: "ft_trip_info_d_unloadsearch_x_driver" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_info_d_unloadsearch.lists.driver?.lookupOptions.length) {
        options.data = { id: "x_driver", form: "ft_trip_info_d_unloadsearch" };
    } else {
        options.ajax = { id: "x_driver", form: "ft_trip_info_d_unloadsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info_d_unload.fields.driver.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unload_km->Visible) { // unload_km ?>
    <div id="r_unload_km" class="row"<?= $Page->unload_km->rowAttributes() ?>>
        <label for="x_unload_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_unload_km"><?= $Page->unload_km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unload_km" id="z_unload_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unload_km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_unload_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->unload_km->getInputTextType() ?>" name="x_unload_km" id="x_unload_km" data-table="t_trip_info_d_unload" data-field="x_unload_km" value="<?= $Page->unload_km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->unload_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_km->formatPattern()) ?>"<?= $Page->unload_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->load_weight->Visible) { // load_weight ?>
    <div id="r_load_weight" class="row"<?= $Page->load_weight->rowAttributes() ?>>
        <label for="x_load_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_load_weight"><?= $Page->load_weight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_weight" id="z_load_weight" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->load_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_load_weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->load_weight->getInputTextType() ?>" name="x_load_weight" id="x_load_weight" data-table="t_trip_info_d_unload" data-field="x_load_weight" value="<?= $Page->load_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->load_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_weight->formatPattern()) ?>"<?= $Page->load_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unload_weight->Visible) { // unload_weight ?>
    <div id="r_unload_weight" class="row"<?= $Page->unload_weight->rowAttributes() ?>>
        <label for="x_unload_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_unload_weight"><?= $Page->unload_weight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unload_weight" id="z_unload_weight" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unload_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_unload_weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->unload_weight->getInputTextType() ?>" name="x_unload_weight" id="x_unload_weight" data-table="t_trip_info_d_unload" data-field="x_unload_weight" value="<?= $Page->unload_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->unload_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_weight->formatPattern()) ?>"<?= $Page->unload_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unload_date->Visible) { // unload_date ?>
    <div id="r_unload_date" class="row"<?= $Page->unload_date->rowAttributes() ?>>
        <label for="x_unload_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_unload_date"><?= $Page->unload_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unload_date" id="z_unload_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unload_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_unload_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->unload_date->getInputTextType() ?>" name="x_unload_date" id="x_unload_date" data-table="t_trip_info_d_unload" data-field="x_unload_date" value="<?= $Page->unload_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->unload_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_date->formatPattern()) ?>"<?= $Page->unload_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_date->getErrorMessage(false) ?></div>
<?php if (!$Page->unload_date->ReadOnly && !$Page->unload_date->Disabled && !isset($Page->unload_date->EditAttrs["readonly"]) && !isset($Page->unload_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_info_d_unloadsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_info_d_unloadsearch", "x_unload_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ded_det->Visible) { // ded_det ?>
    <div id="r_ded_det" class="row"<?= $Page->ded_det->rowAttributes() ?>>
        <label for="x_ded_det" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_ded_det"><?= $Page->ded_det->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ded_det" id="z_ded_det" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ded_det->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_ded_det" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ded_det->getInputTextType() ?>" name="x_ded_det" id="x_ded_det" data-table="t_trip_info_d_unload" data-field="x_ded_det" value="<?= $Page->ded_det->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ded_det->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ded_det->formatPattern()) ?>"<?= $Page->ded_det->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ded_det->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ded_det_remarks->Visible) { // ded_det_remarks ?>
    <div id="r_ded_det_remarks" class="row"<?= $Page->ded_det_remarks->rowAttributes() ?>>
        <label for="x_ded_det_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_ded_det_remarks"><?= $Page->ded_det_remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ded_det_remarks" id="z_ded_det_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ded_det_remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_ded_det_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ded_det_remarks->getInputTextType() ?>" name="x_ded_det_remarks" id="x_ded_det_remarks" data-table="t_trip_info_d_unload" data-field="x_ded_det_remarks" value="<?= $Page->ded_det_remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->ded_det_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ded_det_remarks->formatPattern()) ?>"<?= $Page->ded_det_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ded_det_remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fasttag_cl_balance->Visible) { // fasttag_cl_balance ?>
    <div id="r_fasttag_cl_balance" class="row"<?= $Page->fasttag_cl_balance->rowAttributes() ?>>
        <label for="x_fasttag_cl_balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_fasttag_cl_balance"><?= $Page->fasttag_cl_balance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_fasttag_cl_balance" id="z_fasttag_cl_balance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fasttag_cl_balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_fasttag_cl_balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->fasttag_cl_balance->getInputTextType() ?>" name="x_fasttag_cl_balance" id="x_fasttag_cl_balance" data-table="t_trip_info_d_unload" data-field="x_fasttag_cl_balance" value="<?= $Page->fasttag_cl_balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->fasttag_cl_balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fasttag_cl_balance->formatPattern()) ?>"<?= $Page->fasttag_cl_balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->fasttag_cl_balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delivery_receipt->Visible) { // delivery_receipt ?>
    <div id="r_delivery_receipt" class="row"<?= $Page->delivery_receipt->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_delivery_receipt"><?= $Page->delivery_receipt->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_delivery_receipt" id="z_delivery_receipt" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delivery_receipt->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_delivery_receipt" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->delivery_receipt->getInputTextType() ?>" name="x_delivery_receipt" id="x_delivery_receipt" data-table="t_trip_info_d_unload" data-field="x_delivery_receipt" value="<?= $Page->delivery_receipt->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->delivery_receipt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->delivery_receipt->formatPattern()) ?>"<?= $Page->delivery_receipt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->delivery_receipt->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delivery_pod->Visible) { // delivery_pod ?>
    <div id="r_delivery_pod" class="row"<?= $Page->delivery_pod->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_delivery_pod"><?= $Page->delivery_pod->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_delivery_pod" id="z_delivery_pod" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delivery_pod->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_delivery_pod" class="ew-search-field ew-search-field-single">
<template id="tp_x_delivery_pod">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="t_trip_info_d_unload" data-field="x_delivery_pod" name="x_delivery_pod" id="x_delivery_pod"<?= $Page->delivery_pod->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_delivery_pod" class="ew-item-list"></div>
<selection-list hidden
    id="x_delivery_pod"
    name="x_delivery_pod"
    value="<?= HtmlEncode($Page->delivery_pod->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_delivery_pod"
    data-target="dsl_x_delivery_pod"
    data-repeatcolumn="1"
    class="form-control<?= $Page->delivery_pod->isInvalidClass() ?>"
    data-table="t_trip_info_d_unload"
    data-field="x_delivery_pod"
    data-value-separator="<?= $Page->delivery_pod->displayValueSeparatorAttribute() ?>"
    <?= $Page->delivery_pod->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->delivery_pod->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="ft_trip_info_d_unloadsearch_x_operator"
        <?php } ?>
        data-table="t_trip_info_d_unload"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_info_d_unloadsearch", function() {
    var options = { name: "x_operator", selectId: "ft_trip_info_d_unloadsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_info_d_unloadsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "ft_trip_info_d_unloadsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "ft_trip_info_d_unloadsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info_d_unload.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_unload_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_unload_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="t_trip_info_d_unload" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_info_d_unloadsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_info_d_unloadsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_trip_info_d_unloadsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_trip_info_d_unloadsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ft_trip_info_d_unloadsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_trip_info_d_unload");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
