<?php

namespace PHPMaker2024\fibre;

// Page object
$TTripInfoDSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_info_d: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ft_trip_info_dsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_trip_info_dsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["_route", [], fields._route.isInvalid],
            ["load_km", [ew.Validators.integer], fields.load_km.isInvalid],
            ["load_weight", [ew.Validators.float], fields.load_weight.isInvalid],
            ["driver", [], fields.driver.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "_route": <?= $Page->_route->toClientList($Page) ?>,
            "driver": <?= $Page->driver->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_trip_info_dsearch" id="ft_trip_info_dsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_trip_info_d">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="t_trip_info_d" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_route->Visible) { // route ?>
    <div id="r__route" class="row"<?= $Page->_route->rowAttributes() ?>>
        <label for="x__route" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d__route"><?= $Page->_route->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__route" id="z__route" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_route->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d__route" class="ew-search-field ew-search-field-single">
    <select
        id="x__route"
        name="x__route"
        class="form-select ew-select<?= $Page->_route->isInvalidClass() ?>"
        <?php if (!$Page->_route->IsNativeSelect) { ?>
        data-select2-id="ft_trip_info_dsearch_x__route"
        <?php } ?>
        data-table="t_trip_info_d"
        data-field="x__route"
        data-value-separator="<?= $Page->_route->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_route->getPlaceHolder()) ?>"
        <?= $Page->_route->editAttributes() ?>>
        <?= $Page->_route->selectOptionListHtml("x__route") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_route->getErrorMessage(false) ?></div>
<?= $Page->_route->Lookup->getParamTag($Page, "p_x__route") ?>
<?php if (!$Page->_route->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_info_dsearch", function() {
    var options = { name: "x__route", selectId: "ft_trip_info_dsearch_x__route" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_info_dsearch.lists._route?.lookupOptions.length) {
        options.data = { id: "x__route", form: "ft_trip_info_dsearch" };
    } else {
        options.ajax = { id: "x__route", form: "ft_trip_info_dsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info_d.fields._route.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->load_km->Visible) { // load_km ?>
    <div id="r_load_km" class="row"<?= $Page->load_km->rowAttributes() ?>>
        <label for="x_load_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_load_km"><?= $Page->load_km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_km" id="z_load_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->load_km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_load_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->load_km->getInputTextType() ?>" name="x_load_km" id="x_load_km" data-table="t_trip_info_d" data-field="x_load_km" value="<?= $Page->load_km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->load_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_km->formatPattern()) ?>"<?= $Page->load_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->load_weight->Visible) { // load_weight ?>
    <div id="r_load_weight" class="row"<?= $Page->load_weight->rowAttributes() ?>>
        <label for="x_load_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_load_weight"><?= $Page->load_weight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_weight" id="z_load_weight" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->load_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_load_weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->load_weight->getInputTextType() ?>" name="x_load_weight" id="x_load_weight" data-table="t_trip_info_d" data-field="x_load_weight" value="<?= $Page->load_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->load_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_weight->formatPattern()) ?>"<?= $Page->load_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
    <div id="r_driver" class="row"<?= $Page->driver->rowAttributes() ?>>
        <label for="x_driver" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_driver"><?= $Page->driver->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_driver" id="z_driver" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->driver->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_driver" class="ew-search-field ew-search-field-single">
    <select
        id="x_driver"
        name="x_driver"
        class="form-select ew-select<?= $Page->driver->isInvalidClass() ?>"
        <?php if (!$Page->driver->IsNativeSelect) { ?>
        data-select2-id="ft_trip_info_dsearch_x_driver"
        <?php } ?>
        data-table="t_trip_info_d"
        data-field="x_driver"
        data-value-separator="<?= $Page->driver->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>"
        <?= $Page->driver->editAttributes() ?>>
        <?= $Page->driver->selectOptionListHtml("x_driver") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->driver->getErrorMessage(false) ?></div>
<?= $Page->driver->Lookup->getParamTag($Page, "p_x_driver") ?>
<?php if (!$Page->driver->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_info_dsearch", function() {
    var options = { name: "x_driver", selectId: "ft_trip_info_dsearch_x_driver" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_info_dsearch.lists.driver?.lookupOptions.length) {
        options.data = { id: "x_driver", form: "ft_trip_info_dsearch" };
    } else {
        options.ajax = { id: "x_driver", form: "ft_trip_info_dsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info_d.fields.driver.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="ft_trip_info_dsearch_x_operator"
        <?php } ?>
        data-table="t_trip_info_d"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_info_dsearch", function() {
    var options = { name: "x_operator", selectId: "ft_trip_info_dsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_info_dsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "ft_trip_info_dsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "ft_trip_info_dsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info_d.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_info_d_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_info_d_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="t_trip_info_d" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_info_dsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_info_dsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_trip_info_dsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_trip_info_dsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ft_trip_info_dsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_trip_info_d");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
