<?php

namespace PHPMaker2024\fibre;

// Page object
$TTripInfoAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_info: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ft_trip_infoadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_trip_infoadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["vehicle_type", [fields.vehicle_type.visible && fields.vehicle_type.required ? ew.Validators.required(fields.vehicle_type.caption) : null], fields.vehicle_type.isInvalid],
            ["vehicle", [fields.vehicle.visible && fields.vehicle.required ? ew.Validators.required(fields.vehicle.caption) : null, ew.Validators.integer], fields.vehicle.isInvalid],
            ["_route", [fields._route.visible && fields._route.required ? ew.Validators.required(fields._route.caption) : null, ew.Validators.integer], fields._route.isInvalid],
            ["reports_to", [fields.reports_to.visible && fields.reports_to.required ? ew.Validators.required(fields.reports_to.caption) : null], fields.reports_to.isInvalid],
            ["buyer", [fields.buyer.visible && fields.buyer.required ? ew.Validators.required(fields.buyer.caption) : null, ew.Validators.integer], fields.buyer.isInvalid],
            ["b_consignor", [fields.b_consignor.visible && fields.b_consignor.required ? ew.Validators.required(fields.b_consignor.caption) : null], fields.b_consignor.isInvalid],
            ["b_consignee", [fields.b_consignee.visible && fields.b_consignee.required ? ew.Validators.required(fields.b_consignee.caption) : null], fields.b_consignee.isInvalid],
            ["load_date", [fields.load_date.visible && fields.load_date.required ? ew.Validators.required(fields.load_date.caption) : null, ew.Validators.datetime(fields.load_date.clientFormatPattern)], fields.load_date.isInvalid],
            ["load_weight", [fields.load_weight.visible && fields.load_weight.required ? ew.Validators.required(fields.load_weight.caption) : null, ew.Validators.integer], fields.load_weight.isInvalid],
            ["driver", [fields.driver.visible && fields.driver.required ? ew.Validators.required(fields.driver.caption) : null], fields.driver.isInvalid],
            ["driver_name", [fields.driver_name.visible && fields.driver_name.required ? ew.Validators.required(fields.driver_name.caption) : null], fields.driver_name.isInvalid],
            ["agent", [fields.agent.visible && fields.agent.required ? ew.Validators.required(fields.agent.caption) : null, ew.Validators.integer], fields.agent.isInvalid],
            ["comm", [fields.comm.visible && fields.comm.required ? ew.Validators.required(fields.comm.caption) : null, ew.Validators.float], fields.comm.isInvalid],
            ["material", [fields.material.visible && fields.material.required ? ew.Validators.required(fields.material.caption) : null], fields.material.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["m_hsn", [fields.m_hsn.visible && fields.m_hsn.required ? ew.Validators.required(fields.m_hsn.caption) : null], fields.m_hsn.isInvalid],
            ["_40", [fields._40.visible && fields._40.required ? ew.Validators.required(fields._40.caption) : null, ew.Validators.float], fields._40.isInvalid],
            ["freight_type", [fields.freight_type.visible && fields.freight_type.required ? ew.Validators.required(fields.freight_type.caption) : null], fields.freight_type.isInvalid],
            ["freight", [fields.freight.visible && fields.freight.required ? ew.Validators.required(fields.freight.caption) : null, ew.Validators.float], fields.freight.isInvalid],
            ["gst_percent", [fields.gst_percent.visible && fields.gst_percent.required ? ew.Validators.required(fields.gst_percent.caption) : null, ew.Validators.float], fields.gst_percent.isInvalid],
            ["load_km", [fields.load_km.visible && fields.load_km.required ? ew.Validators.required(fields.load_km.caption) : null, ew.Validators.integer], fields.load_km.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["consignor", [fields.consignor.visible && fields.consignor.required ? ew.Validators.required(fields.consignor.caption) : null, ew.Validators.integer], fields.consignor.isInvalid],
            ["vehicle_freight_comm", [fields.vehicle_freight_comm.visible && fields.vehicle_freight_comm.required ? ew.Validators.required(fields.vehicle_freight_comm.caption) : null, ew.Validators.float], fields.vehicle_freight_comm.isInvalid],
            ["vehicle_freight_type", [fields.vehicle_freight_type.visible && fields.vehicle_freight_type.required ? ew.Validators.required(fields.vehicle_freight_type.caption) : null], fields.vehicle_freight_type.isInvalid],
            ["vehicle_freight_amount", [fields.vehicle_freight_amount.visible && fields.vehicle_freight_amount.required ? ew.Validators.required(fields.vehicle_freight_amount.caption) : null, ew.Validators.float], fields.vehicle_freight_amount.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Multi-Page
        .setMultiPage(true)

        // Dynamic selection lists
        .setLists({
            "vehicle_type": <?= $Page->vehicle_type->toClientList($Page) ?>,
            "vehicle": <?= $Page->vehicle->toClientList($Page) ?>,
            "_route": <?= $Page->_route->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
            "b_consignor": <?= $Page->b_consignor->toClientList($Page) ?>,
            "b_consignee": <?= $Page->b_consignee->toClientList($Page) ?>,
            "driver": <?= $Page->driver->toClientList($Page) ?>,
            "agent": <?= $Page->agent->toClientList($Page) ?>,
            "freight_type": <?= $Page->freight_type->toClientList($Page) ?>,
            "consignor": <?= $Page->consignor->toClientList($Page) ?>,
            "vehicle_freight_type": <?= $Page->vehicle_freight_type->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_trip_infoadd" id="ft_trip_infoadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_trip_info">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-add-div"><!-- page0 -->
<?php if ($Page->vehicle_type->Visible) { // vehicle_type ?>
    <div id="r_vehicle_type"<?= $Page->vehicle_type->rowAttributes() ?>>
        <label id="elh_t_trip_info_vehicle_type" for="x_vehicle_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->vehicle_type->caption() ?><?= $Page->vehicle_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->vehicle_type->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_type">
    <select
        id="x_vehicle_type"
        name="x_vehicle_type"
        class="form-select ew-select<?= $Page->vehicle_type->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_type->IsNativeSelect) { ?>
        data-select2-id="ft_trip_infoadd_x_vehicle_type"
        <?php } ?>
        data-table="t_trip_info"
        data-field="x_vehicle_type"
        data-page="0"
        data-value-separator="<?= $Page->vehicle_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->vehicle_type->editAttributes() ?>>
        <?= $Page->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
    </select>
    <?= $Page->vehicle_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->vehicle_type->getErrorMessage() ?></div>
<?php if (!$Page->vehicle_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_infoadd", function() {
    var options = { name: "x_vehicle_type", selectId: "ft_trip_infoadd_x_vehicle_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_infoadd.lists.vehicle_type?.lookupOptions.length) {
        options.data = { id: "x_vehicle_type", form: "ft_trip_infoadd" };
    } else {
        options.ajax = { id: "x_vehicle_type", form: "ft_trip_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info.fields.vehicle_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->vehicle->Visible) { // vehicle ?>
    <div id="r_vehicle"<?= $Page->vehicle->rowAttributes() ?>>
        <label id="elh_t_trip_info_vehicle" class="<?= $Page->LeftColumnClass ?>"><?= $Page->vehicle->caption() ?><?= $Page->vehicle->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->vehicle->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle">
<div class="input-group flex-nowrap">
    <select
        id="x_vehicle"
        name="x_vehicle"
        class="form-control ew-select<?= $Page->vehicle->isInvalidClass() ?>"
        data-select2-id="ft_trip_infoadd_x_vehicle"
        data-table="t_trip_info"
        data-field="x_vehicle"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->vehicle->caption())) ?>"
        data-modal-lookup="true"
        data-page="0"
        data-value-separator="<?= $Page->vehicle->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->vehicle->editAttributes() ?>>
        <?= $Page->vehicle->selectOptionListHtml("x_vehicle") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "vehicle_info") && !$Page->vehicle->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_vehicle" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->vehicle->caption() ?>" data-title="<?= $Page->vehicle->caption() ?>" data-ew-action="add-option" data-el="x_vehicle" data-url="<?= GetUrl("vehicleinfoaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->vehicle->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->vehicle->getErrorMessage() ?></div>
<?= $Page->vehicle->Lookup->getParamTag($Page, "p_x_vehicle") ?>
<script>
loadjs.ready("ft_trip_infoadd", function() {
    var options = { name: "x_vehicle", selectId: "ft_trip_infoadd_x_vehicle" };
    if (ft_trip_infoadd.lists.vehicle?.lookupOptions.length) {
        options.data = { id: "x_vehicle", form: "ft_trip_infoadd" };
    } else {
        options.ajax = { id: "x_vehicle", form: "ft_trip_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.vehicle.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_route->Visible) { // route ?>
    <div id="r__route"<?= $Page->_route->rowAttributes() ?>>
        <label id="elh_t_trip_info__route" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_route->caption() ?><?= $Page->_route->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_route->cellAttributes() ?>>
<span id="el_t_trip_info__route">
<div class="input-group flex-nowrap">
    <select
        id="x__route"
        name="x__route"
        class="form-control ew-select<?= $Page->_route->isInvalidClass() ?>"
        data-select2-id="ft_trip_infoadd_x__route"
        data-table="t_trip_info"
        data-field="x__route"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->_route->caption())) ?>"
        data-modal-lookup="true"
        data-page="0"
        data-value-separator="<?= $Page->_route->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_route->getPlaceHolder()) ?>"
        <?= $Page->_route->editAttributes() ?>>
        <?= $Page->_route->selectOptionListHtml("x__route") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "t_route_info") && !$Page->_route->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x__route" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->_route->caption() ?>" data-title="<?= $Page->_route->caption() ?>" data-ew-action="add-option" data-el="x__route" data-url="<?= GetUrl("trouteinfoaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->_route->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_route->getErrorMessage() ?></div>
<?= $Page->_route->Lookup->getParamTag($Page, "p_x__route") ?>
<script>
loadjs.ready("ft_trip_infoadd", function() {
    var options = { name: "x__route", selectId: "ft_trip_infoadd_x__route" };
    if (ft_trip_infoadd.lists._route?.lookupOptions.length) {
        options.data = { id: "x__route", form: "ft_trip_infoadd" };
    } else {
        options.ajax = { id: "x__route", form: "ft_trip_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields._route.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
    <div id="r_driver"<?= $Page->driver->rowAttributes() ?>>
        <label id="elh_t_trip_info_driver" for="x_driver" class="<?= $Page->LeftColumnClass ?>"><?= $Page->driver->caption() ?><?= $Page->driver->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->driver->cellAttributes() ?>>
<span id="el_t_trip_info_driver">
    <select
        id="x_driver"
        name="x_driver"
        class="form-select ew-select<?= $Page->driver->isInvalidClass() ?>"
        <?php if (!$Page->driver->IsNativeSelect) { ?>
        data-select2-id="ft_trip_infoadd_x_driver"
        <?php } ?>
        data-table="t_trip_info"
        data-field="x_driver"
        data-page="0"
        data-value-separator="<?= $Page->driver->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>"
        <?= $Page->driver->editAttributes() ?>>
        <?= $Page->driver->selectOptionListHtml("x_driver") ?>
    </select>
    <?= $Page->driver->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->driver->getErrorMessage() ?></div>
<?= $Page->driver->Lookup->getParamTag($Page, "p_x_driver") ?>
<?php if (!$Page->driver->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_infoadd", function() {
    var options = { name: "x_driver", selectId: "ft_trip_infoadd_x_driver" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_infoadd.lists.driver?.lookupOptions.length) {
        options.data = { id: "x_driver", form: "ft_trip_infoadd" };
    } else {
        options.ajax = { id: "x_driver", form: "ft_trip_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info.fields.driver.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->driver_name->Visible) { // driver_name ?>
    <div id="r_driver_name"<?= $Page->driver_name->rowAttributes() ?>>
        <label id="elh_t_trip_info_driver_name" for="x_driver_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->driver_name->caption() ?><?= $Page->driver_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->driver_name->cellAttributes() ?>>
<span id="el_t_trip_info_driver_name">
<input type="<?= $Page->driver_name->getInputTextType() ?>" name="x_driver_name" id="x_driver_name" data-table="t_trip_info" data-field="x_driver_name" value="<?= $Page->driver_name->EditValue ?>" data-page="0" size="30" maxlength="92" placeholder="<?= HtmlEncode($Page->driver_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->driver_name->formatPattern()) ?>"<?= $Page->driver_name->editAttributes() ?> aria-describedby="x_driver_name_help">
<?= $Page->driver_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->driver_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->consignor->Visible) { // consignor ?>
    <div id="r_consignor"<?= $Page->consignor->rowAttributes() ?>>
        <label id="elh_t_trip_info_consignor" class="<?= $Page->LeftColumnClass ?>"><?= $Page->consignor->caption() ?><?= $Page->consignor->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->consignor->cellAttributes() ?>>
<span id="el_t_trip_info_consignor">
<?php
if (IsRTL()) {
    $Page->consignor->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_consignor" class="ew-auto-suggest">
    <div class="input-group">
        <input type="<?= $Page->consignor->getInputTextType() ?>" class="form-control" name="sv_x_consignor" id="sv_x_consignor" value="<?= RemoveHtml($Page->consignor->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->consignor->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->consignor->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->consignor->formatPattern()) ?>"<?= $Page->consignor->editAttributes() ?> aria-describedby="x_consignor_help">
        <?php if (AllowAdd(CurrentProjectID() . "production_partner") && !$Page->consignor->ReadOnly) { ?>
        <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_consignor" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->consignor->caption() ?>" data-title="<?= $Page->consignor->caption() ?>" data-ew-action="add-option" data-el="x_consignor" data-url="<?= GetUrl("productionpartneraddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
        <?php } ?>
    </div>
</span>
<selection-list hidden class="form-control" data-table="t_trip_info" data-field="x_consignor" data-input="sv_x_consignor" data-page="0" data-value-separator="<?= $Page->consignor->displayValueSeparatorAttribute() ?>" name="x_consignor" id="x_consignor" value="<?= HtmlEncode($Page->consignor->CurrentValue) ?>"></selection-list>
<?= $Page->consignor->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->consignor->getErrorMessage() ?></div>
<script>
loadjs.ready("ft_trip_infoadd", function() {
    ft_trip_infoadd.createAutoSuggest(Object.assign({"id":"x_consignor","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->consignor->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.t_trip_info.fields.consignor.autoSuggestOptions));
});
</script>
<?= $Page->consignor->Lookup->getParamTag($Page, "p_x_consignor") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
    <div id="r_vehicle_freight_comm"<?= $Page->vehicle_freight_comm->rowAttributes() ?>>
        <label id="elh_t_trip_info_vehicle_freight_comm" for="x_vehicle_freight_comm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->vehicle_freight_comm->caption() ?><?= $Page->vehicle_freight_comm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->vehicle_freight_comm->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_comm">
<input type="<?= $Page->vehicle_freight_comm->getInputTextType() ?>" name="x_vehicle_freight_comm" id="x_vehicle_freight_comm" data-table="t_trip_info" data-field="x_vehicle_freight_comm" value="<?= $Page->vehicle_freight_comm->EditValue ?>" data-page="0" size="30" placeholder="<?= HtmlEncode($Page->vehicle_freight_comm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->vehicle_freight_comm->formatPattern()) ?>"<?= $Page->vehicle_freight_comm->editAttributes() ?> aria-describedby="x_vehicle_freight_comm_help">
<?= $Page->vehicle_freight_comm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->vehicle_freight_comm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
    <div id="r_vehicle_freight_type"<?= $Page->vehicle_freight_type->rowAttributes() ?>>
        <label id="elh_t_trip_info_vehicle_freight_type" for="x_vehicle_freight_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->vehicle_freight_type->caption() ?><?= $Page->vehicle_freight_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->vehicle_freight_type->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_type">
    <select
        id="x_vehicle_freight_type"
        name="x_vehicle_freight_type"
        class="form-select ew-select<?= $Page->vehicle_freight_type->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_freight_type->IsNativeSelect) { ?>
        data-select2-id="ft_trip_infoadd_x_vehicle_freight_type"
        <?php } ?>
        data-table="t_trip_info"
        data-field="x_vehicle_freight_type"
        data-page="0"
        data-value-separator="<?= $Page->vehicle_freight_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_freight_type->getPlaceHolder()) ?>"
        <?= $Page->vehicle_freight_type->editAttributes() ?>>
        <?= $Page->vehicle_freight_type->selectOptionListHtml("x_vehicle_freight_type") ?>
    </select>
    <?= $Page->vehicle_freight_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->vehicle_freight_type->getErrorMessage() ?></div>
<?php if (!$Page->vehicle_freight_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_infoadd", function() {
    var options = { name: "x_vehicle_freight_type", selectId: "ft_trip_infoadd_x_vehicle_freight_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_infoadd.lists.vehicle_freight_type?.lookupOptions.length) {
        options.data = { id: "x_vehicle_freight_type", form: "ft_trip_infoadd" };
    } else {
        options.ajax = { id: "x_vehicle_freight_type", form: "ft_trip_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info.fields.vehicle_freight_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
    <div id="r_vehicle_freight_amount"<?= $Page->vehicle_freight_amount->rowAttributes() ?>>
        <label id="elh_t_trip_info_vehicle_freight_amount" for="x_vehicle_freight_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->vehicle_freight_amount->caption() ?><?= $Page->vehicle_freight_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->vehicle_freight_amount->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_amount">
<input type="<?= $Page->vehicle_freight_amount->getInputTextType() ?>" name="x_vehicle_freight_amount" id="x_vehicle_freight_amount" data-table="t_trip_info" data-field="x_vehicle_freight_amount" value="<?= $Page->vehicle_freight_amount->EditValue ?>" data-page="0" size="30" placeholder="<?= HtmlEncode($Page->vehicle_freight_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->vehicle_freight_amount->formatPattern()) ?>"<?= $Page->vehicle_freight_amount->editAttributes() ?> aria-describedby="x_vehicle_freight_amount_help">
<?= $Page->vehicle_freight_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->vehicle_freight_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_TTripInfoAdd"><!-- multi-page accordion -->
<div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_info1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_info1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->reports_to->Visible) { // reports_to ?>
    <div id="r_reports_to"<?= $Page->reports_to->rowAttributes() ?>>
        <label id="elh_t_trip_info_reports_to" for="x_reports_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->reports_to->caption() ?><?= $Page->reports_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->reports_to->cellAttributes() ?>>
<span id="el_t_trip_info_reports_to">
    <select
        id="x_reports_to"
        name="x_reports_to"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="ft_trip_infoadd_x_reports_to"
        <?php } ?>
        data-table="t_trip_info"
        data-field="x_reports_to"
        data-page="1"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to") ?>
    </select>
    <?= $Page->reports_to->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage() ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_infoadd", function() {
    var options = { name: "x_reports_to", selectId: "ft_trip_infoadd_x_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_infoadd.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to", form: "ft_trip_infoadd" };
    } else {
        options.ajax = { id: "x_reports_to", form: "ft_trip_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
    <div id="r_buyer"<?= $Page->buyer->rowAttributes() ?>>
        <label id="elh_t_trip_info_buyer" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer->caption() ?><?= $Page->buyer->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer->cellAttributes() ?>>
<span id="el_t_trip_info_buyer">
<div class="input-group flex-nowrap">
    <select
        id="x_buyer"
        name="x_buyer"
        class="form-control ew-select<?= $Page->buyer->isInvalidClass() ?>"
        data-select2-id="ft_trip_infoadd_x_buyer"
        data-table="t_trip_info"
        data-field="x_buyer"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->buyer->editAttributes() ?>>
        <?= $Page->buyer->selectOptionListHtml("x_buyer") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "buyer") && !$Page->buyer->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_buyer" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->buyer->caption() ?>" data-title="<?= $Page->buyer->caption() ?>" data-ew-action="add-option" data-el="x_buyer" data-url="<?= GetUrl("buyeraddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->buyer->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer->getErrorMessage() ?></div>
<?= $Page->buyer->Lookup->getParamTag($Page, "p_x_buyer") ?>
<script>
loadjs.ready("ft_trip_infoadd", function() {
    var options = { name: "x_buyer", selectId: "ft_trip_infoadd_x_buyer" };
    if (ft_trip_infoadd.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x_buyer", form: "ft_trip_infoadd" };
    } else {
        options.ajax = { id: "x_buyer", form: "ft_trip_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.buyer.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->b_consignor->Visible) { // b_consignor ?>
    <div id="r_b_consignor"<?= $Page->b_consignor->rowAttributes() ?>>
        <label id="elh_t_trip_info_b_consignor" class="<?= $Page->LeftColumnClass ?>"><?= $Page->b_consignor->caption() ?><?= $Page->b_consignor->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->b_consignor->cellAttributes() ?>>
<span id="el_t_trip_info_b_consignor">
    <select
        id="x_b_consignor"
        name="x_b_consignor"
        class="form-control ew-select<?= $Page->b_consignor->isInvalidClass() ?>"
        data-select2-id="ft_trip_infoadd_x_b_consignor"
        data-table="t_trip_info"
        data-field="x_b_consignor"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->b_consignor->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->b_consignor->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->b_consignor->getPlaceHolder()) ?>"
        <?= $Page->b_consignor->editAttributes() ?>>
        <?= $Page->b_consignor->selectOptionListHtml("x_b_consignor") ?>
    </select>
    <?= $Page->b_consignor->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->b_consignor->getErrorMessage() ?></div>
<?= $Page->b_consignor->Lookup->getParamTag($Page, "p_x_b_consignor") ?>
<script>
loadjs.ready("ft_trip_infoadd", function() {
    var options = { name: "x_b_consignor", selectId: "ft_trip_infoadd_x_b_consignor" };
    if (ft_trip_infoadd.lists.b_consignor?.lookupOptions.length) {
        options.data = { id: "x_b_consignor", form: "ft_trip_infoadd" };
    } else {
        options.ajax = { id: "x_b_consignor", form: "ft_trip_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.b_consignor.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->b_consignee->Visible) { // b_consignee ?>
    <div id="r_b_consignee"<?= $Page->b_consignee->rowAttributes() ?>>
        <label id="elh_t_trip_info_b_consignee" class="<?= $Page->LeftColumnClass ?>"><?= $Page->b_consignee->caption() ?><?= $Page->b_consignee->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->b_consignee->cellAttributes() ?>>
<span id="el_t_trip_info_b_consignee">
    <select
        id="x_b_consignee"
        name="x_b_consignee"
        class="form-control ew-select<?= $Page->b_consignee->isInvalidClass() ?>"
        data-select2-id="ft_trip_infoadd_x_b_consignee"
        data-table="t_trip_info"
        data-field="x_b_consignee"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->b_consignee->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->b_consignee->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->b_consignee->getPlaceHolder()) ?>"
        <?= $Page->b_consignee->editAttributes() ?>>
        <?= $Page->b_consignee->selectOptionListHtml("x_b_consignee") ?>
    </select>
    <?= $Page->b_consignee->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->b_consignee->getErrorMessage() ?></div>
<?= $Page->b_consignee->Lookup->getParamTag($Page, "p_x_b_consignee") ?>
<script>
loadjs.ready("ft_trip_infoadd", function() {
    var options = { name: "x_b_consignee", selectId: "ft_trip_infoadd_x_b_consignee" };
    if (ft_trip_infoadd.lists.b_consignee?.lookupOptions.length) {
        options.data = { id: "x_b_consignee", form: "ft_trip_infoadd" };
    } else {
        options.ajax = { id: "x_b_consignee", form: "ft_trip_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.b_consignee.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
    <div id="r_agent"<?= $Page->agent->rowAttributes() ?>>
        <label id="elh_t_trip_info_agent" class="<?= $Page->LeftColumnClass ?>"><?= $Page->agent->caption() ?><?= $Page->agent->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->agent->cellAttributes() ?>>
<span id="el_t_trip_info_agent">
    <select
        id="x_agent"
        name="x_agent"
        class="form-control ew-select<?= $Page->agent->isInvalidClass() ?>"
        data-select2-id="ft_trip_infoadd_x_agent"
        data-table="t_trip_info"
        data-field="x_agent"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->agent->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
        <?= $Page->agent->editAttributes() ?>>
        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
    </select>
    <?= $Page->agent->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->agent->getErrorMessage() ?></div>
<?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
<script>
loadjs.ready("ft_trip_infoadd", function() {
    var options = { name: "x_agent", selectId: "ft_trip_infoadd_x_agent" };
    if (ft_trip_infoadd.lists.agent?.lookupOptions.length) {
        options.data = { id: "x_agent", form: "ft_trip_infoadd" };
    } else {
        options.ajax = { id: "x_agent", form: "ft_trip_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_info.fields.agent.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->comm->Visible) { // comm ?>
    <div id="r_comm"<?= $Page->comm->rowAttributes() ?>>
        <label id="elh_t_trip_info_comm" for="x_comm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->comm->caption() ?><?= $Page->comm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->comm->cellAttributes() ?>>
<span id="el_t_trip_info_comm">
<input type="<?= $Page->comm->getInputTextType() ?>" name="x_comm" id="x_comm" data-table="t_trip_info" data-field="x_comm" value="<?= $Page->comm->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->comm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->comm->formatPattern()) ?>"<?= $Page->comm->editAttributes() ?> aria-describedby="x_comm_help">
<?= $Page->comm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->comm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->material->Visible) { // material ?>
    <div id="r_material"<?= $Page->material->rowAttributes() ?>>
        <label id="elh_t_trip_info_material" for="x_material" class="<?= $Page->LeftColumnClass ?>"><?= $Page->material->caption() ?><?= $Page->material->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->material->cellAttributes() ?>>
<span id="el_t_trip_info_material">
<input type="<?= $Page->material->getInputTextType() ?>" name="x_material" id="x_material" data-table="t_trip_info" data-field="x_material" value="<?= $Page->material->EditValue ?>" data-page="1" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->material->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->material->formatPattern()) ?>"<?= $Page->material->editAttributes() ?> aria-describedby="x_material_help">
<?= $Page->material->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->material->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type"<?= $Page->packing_type->rowAttributes() ?>>
        <label id="elh_t_trip_info_packing_type" for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packing_type->caption() ?><?= $Page->packing_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packing_type->cellAttributes() ?>>
<span id="el_t_trip_info_packing_type">
<input type="<?= $Page->packing_type->getInputTextType() ?>" name="x_packing_type" id="x_packing_type" data-table="t_trip_info" data-field="x_packing_type" value="<?= $Page->packing_type->EditValue ?>" data-page="1" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packing_type->formatPattern()) ?>"<?= $Page->packing_type->editAttributes() ?> aria-describedby="x_packing_type_help">
<?= $Page->packing_type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->m_hsn->Visible) { // m_hsn ?>
    <div id="r_m_hsn"<?= $Page->m_hsn->rowAttributes() ?>>
        <label id="elh_t_trip_info_m_hsn" for="x_m_hsn" class="<?= $Page->LeftColumnClass ?>"><?= $Page->m_hsn->caption() ?><?= $Page->m_hsn->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->m_hsn->cellAttributes() ?>>
<span id="el_t_trip_info_m_hsn">
<input type="<?= $Page->m_hsn->getInputTextType() ?>" name="x_m_hsn" id="x_m_hsn" data-table="t_trip_info" data-field="x_m_hsn" value="<?= $Page->m_hsn->EditValue ?>" data-page="1" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->m_hsn->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->m_hsn->formatPattern()) ?>"<?= $Page->m_hsn->editAttributes() ?> aria-describedby="x_m_hsn_help">
<?= $Page->m_hsn->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->m_hsn->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
    <div id="r__40"<?= $Page->_40->rowAttributes() ?>>
        <label id="elh_t_trip_info__40" for="x__40" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_40->caption() ?><?= $Page->_40->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_40->cellAttributes() ?>>
<span id="el_t_trip_info__40">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="t_trip_info" data-field="x__40" value="<?= $Page->_40->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?> aria-describedby="x__40_help">
<?= $Page->_40->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_t_trip_info_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_t_trip_info_remarks">
<textarea data-table="t_trip_info" data-field="x_remarks" data-page="1" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
<div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_info2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_info2"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->freight_type->Visible) { // freight_type ?>
    <div id="r_freight_type"<?= $Page->freight_type->rowAttributes() ?>>
        <label id="elh_t_trip_info_freight_type" for="x_freight_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->freight_type->caption() ?><?= $Page->freight_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->freight_type->cellAttributes() ?>>
<span id="el_t_trip_info_freight_type">
    <select
        id="x_freight_type"
        name="x_freight_type"
        class="form-select ew-select<?= $Page->freight_type->isInvalidClass() ?>"
        <?php if (!$Page->freight_type->IsNativeSelect) { ?>
        data-select2-id="ft_trip_infoadd_x_freight_type"
        <?php } ?>
        data-table="t_trip_info"
        data-field="x_freight_type"
        data-page="2"
        data-value-separator="<?= $Page->freight_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->freight_type->getPlaceHolder()) ?>"
        <?= $Page->freight_type->editAttributes() ?>>
        <?= $Page->freight_type->selectOptionListHtml("x_freight_type") ?>
    </select>
    <?= $Page->freight_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->freight_type->getErrorMessage() ?></div>
<?php if (!$Page->freight_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_infoadd", function() {
    var options = { name: "x_freight_type", selectId: "ft_trip_infoadd_x_freight_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_infoadd.lists.freight_type?.lookupOptions.length) {
        options.data = { id: "x_freight_type", form: "ft_trip_infoadd" };
    } else {
        options.ajax = { id: "x_freight_type", form: "ft_trip_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_info.fields.freight_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->freight->Visible) { // freight ?>
    <div id="r_freight"<?= $Page->freight->rowAttributes() ?>>
        <label id="elh_t_trip_info_freight" for="x_freight" class="<?= $Page->LeftColumnClass ?>"><?= $Page->freight->caption() ?><?= $Page->freight->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->freight->cellAttributes() ?>>
<span id="el_t_trip_info_freight">
<input type="<?= $Page->freight->getInputTextType() ?>" name="x_freight" id="x_freight" data-table="t_trip_info" data-field="x_freight" value="<?= $Page->freight->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->freight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->freight->formatPattern()) ?>"<?= $Page->freight->editAttributes() ?> aria-describedby="x_freight_help">
<?= $Page->freight->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->freight->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gst_percent->Visible) { // gst_percent ?>
    <div id="r_gst_percent"<?= $Page->gst_percent->rowAttributes() ?>>
        <label id="elh_t_trip_info_gst_percent" for="x_gst_percent" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gst_percent->caption() ?><?= $Page->gst_percent->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gst_percent->cellAttributes() ?>>
<span id="el_t_trip_info_gst_percent">
<input type="<?= $Page->gst_percent->getInputTextType() ?>" name="x_gst_percent" id="x_gst_percent" data-table="t_trip_info" data-field="x_gst_percent" value="<?= $Page->gst_percent->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->gst_percent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gst_percent->formatPattern()) ?>"<?= $Page->gst_percent->editAttributes() ?> aria-describedby="x_gst_percent_help">
<?= $Page->gst_percent->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->gst_percent->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
<div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(3)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_t_trip_info3"><?= $Page->pageCaption(3) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(3)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_t_trip_info3"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->load_date->Visible) { // load_date ?>
    <div id="r_load_date"<?= $Page->load_date->rowAttributes() ?>>
        <label id="elh_t_trip_info_load_date" for="x_load_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->load_date->caption() ?><?= $Page->load_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->load_date->cellAttributes() ?>>
<span id="el_t_trip_info_load_date">
<input type="<?= $Page->load_date->getInputTextType() ?>" name="x_load_date" id="x_load_date" data-table="t_trip_info" data-field="x_load_date" value="<?= $Page->load_date->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->load_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_date->formatPattern()) ?>"<?= $Page->load_date->editAttributes() ?> aria-describedby="x_load_date_help">
<?= $Page->load_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->load_date->getErrorMessage() ?></div>
<?php if (!$Page->load_date->ReadOnly && !$Page->load_date->Disabled && !isset($Page->load_date->EditAttrs["readonly"]) && !isset($Page->load_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_infoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_infoadd", "x_load_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->load_weight->Visible) { // load_weight ?>
    <div id="r_load_weight"<?= $Page->load_weight->rowAttributes() ?>>
        <label id="elh_t_trip_info_load_weight" for="x_load_weight" class="<?= $Page->LeftColumnClass ?>"><?= $Page->load_weight->caption() ?><?= $Page->load_weight->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->load_weight->cellAttributes() ?>>
<span id="el_t_trip_info_load_weight">
<input type="<?= $Page->load_weight->getInputTextType() ?>" name="x_load_weight" id="x_load_weight" data-table="t_trip_info" data-field="x_load_weight" value="<?= $Page->load_weight->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->load_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_weight->formatPattern()) ?>"<?= $Page->load_weight->editAttributes() ?> aria-describedby="x_load_weight_help">
<?= $Page->load_weight->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->load_weight->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->load_km->Visible) { // load_km ?>
    <div id="r_load_km"<?= $Page->load_km->rowAttributes() ?>>
        <label id="elh_t_trip_info_load_km" for="x_load_km" class="<?= $Page->LeftColumnClass ?>"><?= $Page->load_km->caption() ?><?= $Page->load_km->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->load_km->cellAttributes() ?>>
<span id="el_t_trip_info_load_km">
<input type="<?= $Page->load_km->getInputTextType() ?>" name="x_load_km" id="x_load_km" data-table="t_trip_info" data-field="x_load_km" value="<?= $Page->load_km->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->load_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_km->formatPattern()) ?>"<?= $Page->load_km->editAttributes() ?> aria-describedby="x_load_km_help">
<?= $Page->load_km->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->load_km->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php
    if (in_array("t_expenses_o", explode(",", $Page->getCurrentDetailTable())) && $t_expenses_o->DetailAdd) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("t_expenses_o", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "TExpensesOGrid.php" ?>
<?php } ?>
<?php
    if (in_array("t_receipt_d", explode(",", $Page->getCurrentDetailTable())) && $t_receipt_d->DetailAdd) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("t_receipt_d", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "TReceiptDGrid.php" ?>
<?php } ?>
<?php
    if (in_array("t_diesal_expenses", explode(",", $Page->getCurrentDetailTable())) && $t_diesal_expenses->DetailAdd) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("t_diesal_expenses", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "TDiesalExpensesGrid.php" ?>
<?php } ?>
<?php
    if (in_array("t_route_info", explode(",", $Page->getCurrentDetailTable())) && $t_route_info->DetailAdd) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("t_route_info", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "TRouteInfoGrid.php" ?>
<?php } ?>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_trip_infoadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_trip_infoadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_trip_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    		var type = $("#x_vehicle_type").val();
    		if (type == 1)
    		{
    		$("#r_consignor").hide();
    		$("#r_vehicle_freight").hide();
    		$("#r_vehicle_freight_type").hide();
    		$("#r_vehicle_freight_amount").hide();
    		$("#r_vehicle_freight_comm").hide();
    		$("#r_vehicle_freight_final").hide();
    		$("#r_driver").show();
    		} else {
    		$("#r_consignor").show();
    		$("#r_vehicle_freight").show();
    		$("#r_vehicle_freight_type").show();
    		$("#r_vehicle_freight_amount").show();
    		$("#r_vehicle_freight_comm").show();
    		$("#r_vehicle_freight_final").show();
    		$("#r_driver").hide();
    		}
});
</script>
