<?php

namespace PHPMaker2024\fibre;

// Page object
$TTripExpensesReportSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_expenses_report: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ft_trip_expenses_reportsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_trip_expenses_reportsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["trip", [], fields.trip.isInvalid],
            ["driver", [], fields.driver.isInvalid],
            ["vehicle", [], fields.vehicle.isInvalid],
            ["unload_date", [ew.Validators.datetime(fields.unload_date.clientFormatPattern)], fields.unload_date.isInvalid],
            ["y_unload_date", [ew.Validators.between], false],
            ["IN", [ew.Validators.float], fields.IN.isInvalid],
            ["y_IN", [ew.Validators.between], false],
            ["OUT", [ew.Validators.float], fields.OUT.isInvalid],
            ["y_OUT", [ew.Validators.between], false],
            ["Balance", [ew.Validators.float], fields.Balance.isInvalid],
            ["y_Balance", [ew.Validators.between], false],
            ["per_km", [ew.Validators.float], fields.per_km.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "trip": <?= $Page->trip->toClientList($Page) ?>,
            "driver": <?= $Page->driver->toClientList($Page) ?>,
            "vehicle": <?= $Page->vehicle->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_trip_expenses_reportsearch" id="ft_trip_expenses_reportsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_trip_expenses_report">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->trip->Visible) { // trip ?>
    <div id="r_trip" class="row"<?= $Page->trip->rowAttributes() ?>>
        <label for="x_trip" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_trip"><?= $Page->trip->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_trip" id="z_trip" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->trip->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_expenses_report_trip" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->trip->getInputTextType() ?>" name="x_trip" id="x_trip" data-table="t_trip_expenses_report" data-field="x_trip" value="<?= $Page->trip->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->trip->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->trip->formatPattern()) ?>"<?= $Page->trip->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->trip->getErrorMessage(false) ?></div>
<?= $Page->trip->Lookup->getParamTag($Page, "p_x_trip") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
    <div id="r_driver" class="row"<?= $Page->driver->rowAttributes() ?>>
        <label for="x_driver" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_driver"><?= $Page->driver->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_driver" id="z_driver" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->driver->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_expenses_report_driver" class="ew-search-field ew-search-field-single">
    <select
        id="x_driver"
        name="x_driver"
        class="form-select ew-select<?= $Page->driver->isInvalidClass() ?>"
        <?php if (!$Page->driver->IsNativeSelect) { ?>
        data-select2-id="ft_trip_expenses_reportsearch_x_driver"
        <?php } ?>
        data-table="t_trip_expenses_report"
        data-field="x_driver"
        data-value-separator="<?= $Page->driver->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>"
        <?= $Page->driver->editAttributes() ?>>
        <?= $Page->driver->selectOptionListHtml("x_driver") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->driver->getErrorMessage(false) ?></div>
<?= $Page->driver->Lookup->getParamTag($Page, "p_x_driver") ?>
<?php if (!$Page->driver->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_expenses_reportsearch", function() {
    var options = { name: "x_driver", selectId: "ft_trip_expenses_reportsearch_x_driver" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_expenses_reportsearch.lists.driver?.lookupOptions.length) {
        options.data = { id: "x_driver", form: "ft_trip_expenses_reportsearch" };
    } else {
        options.ajax = { id: "x_driver", form: "ft_trip_expenses_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_expenses_report.fields.driver.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->vehicle->Visible) { // vehicle ?>
    <div id="r_vehicle" class="row"<?= $Page->vehicle->rowAttributes() ?>>
        <label for="x_vehicle" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_vehicle"><?= $Page->vehicle->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle" id="z_vehicle" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->vehicle->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_expenses_report_vehicle" class="ew-search-field ew-search-field-single">
    <select
        id="x_vehicle"
        name="x_vehicle"
        class="form-select ew-select<?= $Page->vehicle->isInvalidClass() ?>"
        <?php if (!$Page->vehicle->IsNativeSelect) { ?>
        data-select2-id="ft_trip_expenses_reportsearch_x_vehicle"
        <?php } ?>
        data-table="t_trip_expenses_report"
        data-field="x_vehicle"
        data-value-separator="<?= $Page->vehicle->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle->getPlaceHolder()) ?>"
        <?= $Page->vehicle->editAttributes() ?>>
        <?= $Page->vehicle->selectOptionListHtml("x_vehicle") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle->getErrorMessage(false) ?></div>
<?= $Page->vehicle->Lookup->getParamTag($Page, "p_x_vehicle") ?>
<?php if (!$Page->vehicle->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_trip_expenses_reportsearch", function() {
    var options = { name: "x_vehicle", selectId: "ft_trip_expenses_reportsearch_x_vehicle" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_trip_expenses_reportsearch.lists.vehicle?.lookupOptions.length) {
        options.data = { id: "x_vehicle", form: "ft_trip_expenses_reportsearch" };
    } else {
        options.ajax = { id: "x_vehicle", form: "ft_trip_expenses_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_trip_expenses_report.fields.vehicle.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unload_date->Visible) { // unload_date ?>
    <div id="r_unload_date" class="row"<?= $Page->unload_date->rowAttributes() ?>>
        <label for="x_unload_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_unload_date"><?= $Page->unload_date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unload_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_unload_date" id="z_unload_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->unload_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->unload_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_t_trip_expenses_report_unload_date" class="ew-search-field">
<input type="<?= $Page->unload_date->getInputTextType() ?>" name="x_unload_date" id="x_unload_date" data-table="t_trip_expenses_report" data-field="x_unload_date" value="<?= $Page->unload_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->unload_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_date->formatPattern()) ?>"<?= $Page->unload_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_date->getErrorMessage(false) ?></div>
<?php if (!$Page->unload_date->ReadOnly && !$Page->unload_date->Disabled && !isset($Page->unload_date->EditAttrs["readonly"]) && !isset($Page->unload_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_expenses_reportsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_expenses_reportsearch", "x_unload_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_t_trip_expenses_report_unload_date" class="ew-search-field2 d-none">
<input type="<?= $Page->unload_date->getInputTextType() ?>" name="y_unload_date" id="y_unload_date" data-table="t_trip_expenses_report" data-field="x_unload_date" value="<?= $Page->unload_date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->unload_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_date->formatPattern()) ?>"<?= $Page->unload_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_date->getErrorMessage(false) ?></div>
<?php if (!$Page->unload_date->ReadOnly && !$Page->unload_date->Disabled && !isset($Page->unload_date->EditAttrs["readonly"]) && !isset($Page->unload_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_expenses_reportsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_expenses_reportsearch", "y_unload_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->IN->Visible) { // IN ?>
    <div id="r_IN" class="row"<?= $Page->IN->rowAttributes() ?>>
        <label for="x_IN" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_IN"><?= $Page->IN->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->IN->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_IN" id="z_IN" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->IN->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->IN->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_t_trip_expenses_report_IN" class="ew-search-field">
<input type="<?= $Page->IN->getInputTextType() ?>" name="x_IN" id="x_IN" data-table="t_trip_expenses_report" data-field="x_IN" value="<?= $Page->IN->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->IN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->IN->formatPattern()) ?>"<?= $Page->IN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->IN->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_t_trip_expenses_report_IN" class="ew-search-field2 d-none">
<input type="<?= $Page->IN->getInputTextType() ?>" name="y_IN" id="y_IN" data-table="t_trip_expenses_report" data-field="x_IN" value="<?= $Page->IN->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->IN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->IN->formatPattern()) ?>"<?= $Page->IN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->IN->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->OUT->Visible) { // OUT ?>
    <div id="r_OUT" class="row"<?= $Page->OUT->rowAttributes() ?>>
        <label for="x_OUT" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_OUT"><?= $Page->OUT->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->OUT->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_OUT" id="z_OUT" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->OUT->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->OUT->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_t_trip_expenses_report_OUT" class="ew-search-field">
<input type="<?= $Page->OUT->getInputTextType() ?>" name="x_OUT" id="x_OUT" data-table="t_trip_expenses_report" data-field="x_OUT" value="<?= $Page->OUT->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->OUT->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->OUT->formatPattern()) ?>"<?= $Page->OUT->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->OUT->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_t_trip_expenses_report_OUT" class="ew-search-field2 d-none">
<input type="<?= $Page->OUT->getInputTextType() ?>" name="y_OUT" id="y_OUT" data-table="t_trip_expenses_report" data-field="x_OUT" value="<?= $Page->OUT->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->OUT->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->OUT->formatPattern()) ?>"<?= $Page->OUT->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->OUT->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
    <div id="r_Balance" class="row"<?= $Page->Balance->rowAttributes() ?>>
        <label for="x_Balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_Balance"><?= $Page->Balance->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Balance" id="z_Balance" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Balance->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Balance->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_t_trip_expenses_report_Balance" class="ew-search-field">
<input type="<?= $Page->Balance->getInputTextType() ?>" name="x_Balance" id="x_Balance" data-table="t_trip_expenses_report" data-field="x_Balance" value="<?= $Page->Balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Balance->formatPattern()) ?>"<?= $Page->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Balance->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_t_trip_expenses_report_Balance" class="ew-search-field2 d-none">
<input type="<?= $Page->Balance->getInputTextType() ?>" name="y_Balance" id="y_Balance" data-table="t_trip_expenses_report" data-field="x_Balance" value="<?= $Page->Balance->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Balance->formatPattern()) ?>"<?= $Page->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->per_km->Visible) { // per_km ?>
    <div id="r_per_km" class="row"<?= $Page->per_km->rowAttributes() ?>>
        <label for="x_per_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_per_km"><?= $Page->per_km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_per_km" id="z_per_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->per_km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_expenses_report_per_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->per_km->getInputTextType() ?>" name="x_per_km" id="x_per_km" data-table="t_trip_expenses_report" data-field="x_per_km" value="<?= $Page->per_km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->per_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->per_km->formatPattern()) ?>"<?= $Page->per_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->per_km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_trip_expenses_reportsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_trip_expenses_reportsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ft_trip_expenses_reportsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_trip_expenses_report");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
