<?php

namespace PHPMaker2024\fibre;

// Page object
$TTripExpensesReportList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_expenses_report: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ft_trip_expenses_reportsrch" id="ft_trip_expenses_reportsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="ft_trip_expenses_reportsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_expenses_report: currentTable } });
var currentForm;
var ft_trip_expenses_reportsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_trip_expenses_reportsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["unload_date", [ew.Validators.datetime(fields.unload_date.clientFormatPattern)], fields.unload_date.isInvalid],
            ["y_unload_date", [ew.Validators.between], false],
            ["Balance", [ew.Validators.float], fields.Balance.isInvalid],
            ["y_Balance", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->unload_date->Visible) { // unload_date ?>
<?php
if (!$Page->unload_date->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_unload_date" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->unload_date->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_unload_date" class="ew-search-caption ew-label"><?= $Page->unload_date->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_unload_date" id="z_unload_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->unload_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->unload_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_t_trip_expenses_report_unload_date" class="ew-search-field">
<input type="<?= $Page->unload_date->getInputTextType() ?>" name="x_unload_date" id="x_unload_date" data-table="t_trip_expenses_report" data-field="x_unload_date" value="<?= $Page->unload_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->unload_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_date->formatPattern()) ?>"<?= $Page->unload_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_date->getErrorMessage(false) ?></div>
<?php if (!$Page->unload_date->ReadOnly && !$Page->unload_date->Disabled && !isset($Page->unload_date->EditAttrs["readonly"]) && !isset($Page->unload_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_expenses_reportsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_expenses_reportsrch", "x_unload_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_t_trip_expenses_report_unload_date" class="ew-search-field2 d-none">
<input type="<?= $Page->unload_date->getInputTextType() ?>" name="y_unload_date" id="y_unload_date" data-table="t_trip_expenses_report" data-field="x_unload_date" value="<?= $Page->unload_date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->unload_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_date->formatPattern()) ?>"<?= $Page->unload_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_date->getErrorMessage(false) ?></div>
<?php if (!$Page->unload_date->ReadOnly && !$Page->unload_date->Disabled && !isset($Page->unload_date->EditAttrs["readonly"]) && !isset($Page->unload_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_expenses_reportsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_expenses_reportsrch", "y_unload_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
<?php
if (!$Page->Balance->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Balance" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Balance->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_Balance" class="ew-search-caption ew-label"><?= $Page->Balance->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_Balance" id="z_Balance" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Balance->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Balance->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_t_trip_expenses_report_Balance" class="ew-search-field">
<input type="<?= $Page->Balance->getInputTextType() ?>" name="x_Balance" id="x_Balance" data-table="t_trip_expenses_report" data-field="x_Balance" value="<?= $Page->Balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Balance->formatPattern()) ?>"<?= $Page->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Balance->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_t_trip_expenses_report_Balance" class="ew-search-field2 d-none">
<input type="<?= $Page->Balance->getInputTextType() ?>" name="y_Balance" id="y_Balance" data-table="t_trip_expenses_report" data-field="x_Balance" value="<?= $Page->Balance->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Balance->formatPattern()) ?>"<?= $Page->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Balance->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="ft_trip_expenses_reportsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="ft_trip_expenses_reportsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="ft_trip_expenses_reportsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ft_trip_expenses_reportsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ft_trip_expenses_reportsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ft_trip_expenses_reportsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ft_trip_expenses_reportsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_trip_expenses_report">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_t_trip_expenses_report" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_t_trip_expenses_reportlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->trip->Visible) { // trip ?>
        <th data-name="trip" class="<?= $Page->trip->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_trip" class="t_trip_expenses_report_trip"><?= $Page->renderFieldHeader($Page->trip) ?></div></th>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
        <th data-name="driver" class="<?= $Page->driver->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_driver" class="t_trip_expenses_report_driver"><?= $Page->renderFieldHeader($Page->driver) ?></div></th>
<?php } ?>
<?php if ($Page->vehicle->Visible) { // vehicle ?>
        <th data-name="vehicle" class="<?= $Page->vehicle->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_vehicle" class="t_trip_expenses_report_vehicle"><?= $Page->renderFieldHeader($Page->vehicle) ?></div></th>
<?php } ?>
<?php if ($Page->unload_date->Visible) { // unload_date ?>
        <th data-name="unload_date" class="<?= $Page->unload_date->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_unload_date" class="t_trip_expenses_report_unload_date"><?= $Page->renderFieldHeader($Page->unload_date) ?></div></th>
<?php } ?>
<?php if ($Page->IN->Visible) { // IN ?>
        <th data-name="IN" class="<?= $Page->IN->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_IN" class="t_trip_expenses_report_IN"><?= $Page->renderFieldHeader($Page->IN) ?></div></th>
<?php } ?>
<?php if ($Page->OUT->Visible) { // OUT ?>
        <th data-name="OUT" class="<?= $Page->OUT->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_OUT" class="t_trip_expenses_report_OUT"><?= $Page->renderFieldHeader($Page->OUT) ?></div></th>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
        <th data-name="Balance" class="<?= $Page->Balance->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_Balance" class="t_trip_expenses_report_Balance"><?= $Page->renderFieldHeader($Page->Balance) ?></div></th>
<?php } ?>
<?php if ($Page->per_km->Visible) { // per_km ?>
        <th data-name="per_km" class="<?= $Page->per_km->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_per_km" class="t_trip_expenses_report_per_km"><?= $Page->renderFieldHeader($Page->per_km) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->trip->Visible) { // trip ?>
        <td data-name="trip"<?= $Page->trip->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_expenses_report_trip" class="el_t_trip_expenses_report_trip">
<span<?= $Page->trip->viewAttributes() ?>>
<?php if (!EmptyString($Page->trip->getViewValue()) && $Page->trip->linkAttributes() != "") { ?>
<a<?= $Page->trip->linkAttributes() ?>><?= $Page->trip->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->trip->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->driver->Visible) { // driver ?>
        <td data-name="driver"<?= $Page->driver->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_expenses_report_driver" class="el_t_trip_expenses_report_driver">
<span<?= $Page->driver->viewAttributes() ?>>
<?php if (!EmptyString($Page->driver->getViewValue()) && $Page->driver->linkAttributes() != "") { ?>
<a<?= $Page->driver->linkAttributes() ?>><?= $Page->driver->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->driver->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->vehicle->Visible) { // vehicle ?>
        <td data-name="vehicle"<?= $Page->vehicle->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_expenses_report_vehicle" class="el_t_trip_expenses_report_vehicle">
<span<?= $Page->vehicle->viewAttributes() ?>>
<?php if (!EmptyString($Page->vehicle->getViewValue()) && $Page->vehicle->linkAttributes() != "") { ?>
<a<?= $Page->vehicle->linkAttributes() ?>><?= $Page->vehicle->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->vehicle->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->unload_date->Visible) { // unload_date ?>
        <td data-name="unload_date"<?= $Page->unload_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_expenses_report_unload_date" class="el_t_trip_expenses_report_unload_date">
<span<?= $Page->unload_date->viewAttributes() ?>>
<?= $Page->unload_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->IN->Visible) { // IN ?>
        <td data-name="IN"<?= $Page->IN->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_expenses_report_IN" class="el_t_trip_expenses_report_IN">
<span<?= $Page->IN->viewAttributes() ?>>
<?= $Page->IN->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->OUT->Visible) { // OUT ?>
        <td data-name="OUT"<?= $Page->OUT->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_expenses_report_OUT" class="el_t_trip_expenses_report_OUT">
<span<?= $Page->OUT->viewAttributes() ?>>
<?= $Page->OUT->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Balance->Visible) { // Balance ?>
        <td data-name="Balance"<?= $Page->Balance->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_expenses_report_Balance" class="el_t_trip_expenses_report_Balance">
<span<?= $Page->Balance->viewAttributes() ?>>
<?= $Page->Balance->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->per_km->Visible) { // per_km ?>
        <td data-name="per_km"<?= $Page->per_km->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_trip_expenses_report_per_km" class="el_t_trip_expenses_report_per_km">
<span<?= $Page->per_km->viewAttributes() ?>>
<?= $Page->per_km->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->trip->Visible) { // trip ?>
        <td data-name="trip" class="<?= $Page->trip->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_trip" class="t_trip_expenses_report_trip">
        </span></td>
    <?php } ?>
    <?php if ($Page->driver->Visible) { // driver ?>
        <td data-name="driver" class="<?= $Page->driver->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_driver" class="t_trip_expenses_report_driver">
        </span></td>
    <?php } ?>
    <?php if ($Page->vehicle->Visible) { // vehicle ?>
        <td data-name="vehicle" class="<?= $Page->vehicle->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_vehicle" class="t_trip_expenses_report_vehicle">
        </span></td>
    <?php } ?>
    <?php if ($Page->unload_date->Visible) { // unload_date ?>
        <td data-name="unload_date" class="<?= $Page->unload_date->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_unload_date" class="t_trip_expenses_report_unload_date">
        </span></td>
    <?php } ?>
    <?php if ($Page->IN->Visible) { // IN ?>
        <td data-name="IN" class="<?= $Page->IN->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_IN" class="t_trip_expenses_report_IN">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->IN->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->OUT->Visible) { // OUT ?>
        <td data-name="OUT" class="<?= $Page->OUT->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_OUT" class="t_trip_expenses_report_OUT">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->OUT->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->Balance->Visible) { // Balance ?>
        <td data-name="Balance" class="<?= $Page->Balance->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_Balance" class="t_trip_expenses_report_Balance">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->Balance->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->per_km->Visible) { // per_km ?>
        <td data-name="per_km" class="<?= $Page->per_km->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_per_km" class="t_trip_expenses_report_per_km">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_trip_expenses_report");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
