<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("TTripExpensesDetailedGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var ft_trip_expenses_detailedgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { t_trip_expenses_detailed: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_trip_expenses_detailedgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null, ew.Validators.integer], fields.id.isInvalid],
            ["trip", [fields.trip.visible && fields.trip.required ? ew.Validators.required(fields.trip.caption) : null, ew.Validators.integer], fields.trip.isInvalid],
            ["diesal_by", [fields.diesal_by.visible && fields.diesal_by.required ? ew.Validators.required(fields.diesal_by.caption) : null, ew.Validators.integer], fields.diesal_by.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["ref", [fields.ref.visible && fields.ref.required ? ew.Validators.required(fields.ref.caption) : null], fields.ref.isInvalid],
            ["IN", [fields.IN.visible && fields.IN.required ? ew.Validators.required(fields.IN.caption) : null, ew.Validators.float], fields.IN.isInvalid],
            ["OUT", [fields.OUT.visible && fields.OUT.required ? ew.Validators.required(fields.OUT.caption) : null, ew.Validators.float], fields.OUT.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["id",false],["trip",false],["diesal_by",false],["name",false],["ref",false],["IN",false],["OUT",false],["dated",false],["remarks",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "trip": <?= $Grid->trip->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="ft_trip_expenses_detailedgrid" class="ew-form ew-list-form">
<div id="gmp_t_trip_expenses_detailed" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_t_trip_expenses_detailedgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_t_trip_expenses_detailed_id" class="t_trip_expenses_detailed_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->trip->Visible) { // trip ?>
        <th data-name="trip" class="<?= $Grid->trip->headerCellClass() ?>"><div id="elh_t_trip_expenses_detailed_trip" class="t_trip_expenses_detailed_trip"><?= $Grid->renderFieldHeader($Grid->trip) ?></div></th>
<?php } ?>
<?php if ($Grid->diesal_by->Visible) { // diesal_by ?>
        <th data-name="diesal_by" class="<?= $Grid->diesal_by->headerCellClass() ?>"><div id="elh_t_trip_expenses_detailed_diesal_by" class="t_trip_expenses_detailed_diesal_by"><?= $Grid->renderFieldHeader($Grid->diesal_by) ?></div></th>
<?php } ?>
<?php if ($Grid->name->Visible) { // name ?>
        <th data-name="name" class="<?= $Grid->name->headerCellClass() ?>"><div id="elh_t_trip_expenses_detailed_name" class="t_trip_expenses_detailed_name"><?= $Grid->renderFieldHeader($Grid->name) ?></div></th>
<?php } ?>
<?php if ($Grid->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Grid->ref->headerCellClass() ?>"><div id="elh_t_trip_expenses_detailed_ref" class="t_trip_expenses_detailed_ref"><?= $Grid->renderFieldHeader($Grid->ref) ?></div></th>
<?php } ?>
<?php if ($Grid->IN->Visible) { // IN ?>
        <th data-name="IN" class="<?= $Grid->IN->headerCellClass() ?>"><div id="elh_t_trip_expenses_detailed_IN" class="t_trip_expenses_detailed_IN"><?= $Grid->renderFieldHeader($Grid->IN) ?></div></th>
<?php } ?>
<?php if ($Grid->OUT->Visible) { // OUT ?>
        <th data-name="OUT" class="<?= $Grid->OUT->headerCellClass() ?>"><div id="elh_t_trip_expenses_detailed_OUT" class="t_trip_expenses_detailed_OUT"><?= $Grid->renderFieldHeader($Grid->OUT) ?></div></th>
<?php } ?>
<?php if ($Grid->dated->Visible) { // dated ?>
        <th data-name="dated" class="<?= $Grid->dated->headerCellClass() ?>"><div id="elh_t_trip_expenses_detailed_dated" class="t_trip_expenses_detailed_dated"><?= $Grid->renderFieldHeader($Grid->dated) ?></div></th>
<?php } ?>
<?php if ($Grid->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Grid->remarks->headerCellClass() ?>"><div id="elh_t_trip_expenses_detailed_remarks" class="t_trip_expenses_detailed_remarks"><?= $Grid->renderFieldHeader($Grid->remarks) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_id" class="el_t_trip_expenses_detailed_id">
<input type="<?= $Grid->id->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" data-table="t_trip_expenses_detailed" data-field="x_id" value="<?= $Grid->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->id->formatPattern()) ?>"<?= $Grid->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->id->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_id" class="el_t_trip_expenses_detailed_id">
<input type="<?= $Grid->id->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" data-table="t_trip_expenses_detailed" data-field="x_id" value="<?= $Grid->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->id->formatPattern()) ?>"<?= $Grid->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->id->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_id" class="el_t_trip_expenses_detailed_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_id" data-hidden="1" name="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_id" id="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_id" data-hidden="1" data-old name="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_id" id="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->trip->Visible) { // trip ?>
        <td data-name="trip"<?= $Grid->trip->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->trip->getSessionValue() != "") { ?>
<span<?= $Grid->trip->viewAttributes() ?>>
<?php if (!EmptyString($Grid->trip->ViewValue) && $Grid->trip->linkAttributes() != "") { ?>
<a<?= $Grid->trip->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->trip->getDisplayValue($Grid->trip->ViewValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->trip->getDisplayValue($Grid->trip->ViewValue) ?></span>
<?php } ?>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_trip" name="x<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_trip" class="el_t_trip_expenses_detailed_trip">
    <select
        id="x<?= $Grid->RowIndex ?>_trip"
        name="x<?= $Grid->RowIndex ?>_trip"
        class="form-control ew-select<?= $Grid->trip->isInvalidClass() ?>"
        data-select2-id="ft_trip_expenses_detailedgrid_x<?= $Grid->RowIndex ?>_trip"
        data-table="t_trip_expenses_detailed"
        data-field="x_trip"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->trip->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->trip->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->trip->getPlaceHolder()) ?>"
        <?= $Grid->trip->editAttributes() ?>>
        <?= $Grid->trip->selectOptionListHtml("x{$Grid->RowIndex}_trip") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->trip->getErrorMessage() ?></div>
<?= $Grid->trip->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_trip") ?>
<script>
loadjs.ready("ft_trip_expenses_detailedgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_trip", selectId: "ft_trip_expenses_detailedgrid_x<?= $Grid->RowIndex ?>_trip" };
    if (ft_trip_expenses_detailedgrid.lists.trip?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_trip", form: "ft_trip_expenses_detailedgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_trip", form: "ft_trip_expenses_detailedgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_expenses_detailed.fields.trip.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_trip" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_trip" id="o<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->trip->getSessionValue() != "") { ?>
<span<?= $Grid->trip->viewAttributes() ?>>
<?php if (!EmptyString($Grid->trip->ViewValue) && $Grid->trip->linkAttributes() != "") { ?>
<a<?= $Grid->trip->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->trip->getDisplayValue($Grid->trip->ViewValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->trip->getDisplayValue($Grid->trip->ViewValue) ?></span>
<?php } ?>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_trip" name="x<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_trip" class="el_t_trip_expenses_detailed_trip">
    <select
        id="x<?= $Grid->RowIndex ?>_trip"
        name="x<?= $Grid->RowIndex ?>_trip"
        class="form-control ew-select<?= $Grid->trip->isInvalidClass() ?>"
        data-select2-id="ft_trip_expenses_detailedgrid_x<?= $Grid->RowIndex ?>_trip"
        data-table="t_trip_expenses_detailed"
        data-field="x_trip"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->trip->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->trip->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->trip->getPlaceHolder()) ?>"
        <?= $Grid->trip->editAttributes() ?>>
        <?= $Grid->trip->selectOptionListHtml("x{$Grid->RowIndex}_trip") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->trip->getErrorMessage() ?></div>
<?= $Grid->trip->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_trip") ?>
<script>
loadjs.ready("ft_trip_expenses_detailedgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_trip", selectId: "ft_trip_expenses_detailedgrid_x<?= $Grid->RowIndex ?>_trip" };
    if (ft_trip_expenses_detailedgrid.lists.trip?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_trip", form: "ft_trip_expenses_detailedgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_trip", form: "ft_trip_expenses_detailedgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_expenses_detailed.fields.trip.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_trip" class="el_t_trip_expenses_detailed_trip">
<span<?= $Grid->trip->viewAttributes() ?>>
<?php if (!EmptyString($Grid->trip->getViewValue()) && $Grid->trip->linkAttributes() != "") { ?>
<a<?= $Grid->trip->linkAttributes() ?>><?= $Grid->trip->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->trip->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_trip" data-hidden="1" name="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_trip" id="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->FormValue) ?>">
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_trip" data-hidden="1" data-old name="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_trip" id="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->diesal_by->Visible) { // diesal_by ?>
        <td data-name="diesal_by"<?= $Grid->diesal_by->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_diesal_by" class="el_t_trip_expenses_detailed_diesal_by">
<input type="<?= $Grid->diesal_by->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_diesal_by" id="x<?= $Grid->RowIndex ?>_diesal_by" data-table="t_trip_expenses_detailed" data-field="x_diesal_by" value="<?= $Grid->diesal_by->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->diesal_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->diesal_by->formatPattern()) ?>"<?= $Grid->diesal_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->diesal_by->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_diesal_by" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_diesal_by" id="o<?= $Grid->RowIndex ?>_diesal_by" value="<?= HtmlEncode($Grid->diesal_by->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_diesal_by" class="el_t_trip_expenses_detailed_diesal_by">
<input type="<?= $Grid->diesal_by->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_diesal_by" id="x<?= $Grid->RowIndex ?>_diesal_by" data-table="t_trip_expenses_detailed" data-field="x_diesal_by" value="<?= $Grid->diesal_by->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->diesal_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->diesal_by->formatPattern()) ?>"<?= $Grid->diesal_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->diesal_by->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_diesal_by" class="el_t_trip_expenses_detailed_diesal_by">
<span<?= $Grid->diesal_by->viewAttributes() ?>>
<?= $Grid->diesal_by->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_diesal_by" data-hidden="1" name="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_diesal_by" id="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_diesal_by" value="<?= HtmlEncode($Grid->diesal_by->FormValue) ?>">
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_diesal_by" data-hidden="1" data-old name="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_diesal_by" id="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_diesal_by" value="<?= HtmlEncode($Grid->diesal_by->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->name->Visible) { // name ?>
        <td data-name="name"<?= $Grid->name->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_name" class="el_t_trip_expenses_detailed_name">
<input type="<?= $Grid->name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_name" id="x<?= $Grid->RowIndex ?>_name" data-table="t_trip_expenses_detailed" data-field="x_name" value="<?= $Grid->name->EditValue ?>" size="30" maxlength="110" placeholder="<?= HtmlEncode($Grid->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->name->formatPattern()) ?>"<?= $Grid->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->name->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_name" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_name" id="o<?= $Grid->RowIndex ?>_name" value="<?= HtmlEncode($Grid->name->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_name" class="el_t_trip_expenses_detailed_name">
<input type="<?= $Grid->name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_name" id="x<?= $Grid->RowIndex ?>_name" data-table="t_trip_expenses_detailed" data-field="x_name" value="<?= $Grid->name->EditValue ?>" size="30" maxlength="110" placeholder="<?= HtmlEncode($Grid->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->name->formatPattern()) ?>"<?= $Grid->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->name->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_name" class="el_t_trip_expenses_detailed_name">
<span<?= $Grid->name->viewAttributes() ?>>
<?= $Grid->name->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_name" data-hidden="1" name="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_name" id="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_name" value="<?= HtmlEncode($Grid->name->FormValue) ?>">
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_name" data-hidden="1" data-old name="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_name" id="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_name" value="<?= HtmlEncode($Grid->name->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Grid->ref->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_ref" class="el_t_trip_expenses_detailed_ref">
<input type="<?= $Grid->ref->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ref" id="x<?= $Grid->RowIndex ?>_ref" data-table="t_trip_expenses_detailed" data-field="x_ref" value="<?= $Grid->ref->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Grid->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ref->formatPattern()) ?>"<?= $Grid->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ref->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_ref" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ref" id="o<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_ref" class="el_t_trip_expenses_detailed_ref">
<input type="<?= $Grid->ref->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ref" id="x<?= $Grid->RowIndex ?>_ref" data-table="t_trip_expenses_detailed" data-field="x_ref" value="<?= $Grid->ref->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Grid->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ref->formatPattern()) ?>"<?= $Grid->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ref->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_ref" class="el_t_trip_expenses_detailed_ref">
<span<?= $Grid->ref->viewAttributes() ?>>
<?php if (!EmptyString($Grid->ref->getViewValue()) && $Grid->ref->linkAttributes() != "") { ?>
<a<?= $Grid->ref->linkAttributes() ?>><?= $Grid->ref->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->ref->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_ref" data-hidden="1" name="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_ref" id="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->FormValue) ?>">
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_ref" data-hidden="1" data-old name="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_ref" id="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->IN->Visible) { // IN ?>
        <td data-name="IN"<?= $Grid->IN->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_IN" class="el_t_trip_expenses_detailed_IN">
<input type="<?= $Grid->IN->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_IN" id="x<?= $Grid->RowIndex ?>_IN" data-table="t_trip_expenses_detailed" data-field="x_IN" value="<?= $Grid->IN->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->IN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->IN->formatPattern()) ?>"<?= $Grid->IN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->IN->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_IN" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_IN" id="o<?= $Grid->RowIndex ?>_IN" value="<?= HtmlEncode($Grid->IN->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_IN" class="el_t_trip_expenses_detailed_IN">
<input type="<?= $Grid->IN->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_IN" id="x<?= $Grid->RowIndex ?>_IN" data-table="t_trip_expenses_detailed" data-field="x_IN" value="<?= $Grid->IN->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->IN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->IN->formatPattern()) ?>"<?= $Grid->IN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->IN->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_IN" class="el_t_trip_expenses_detailed_IN">
<span<?= $Grid->IN->viewAttributes() ?>>
<?= $Grid->IN->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_IN" data-hidden="1" name="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_IN" id="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_IN" value="<?= HtmlEncode($Grid->IN->FormValue) ?>">
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_IN" data-hidden="1" data-old name="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_IN" id="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_IN" value="<?= HtmlEncode($Grid->IN->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->OUT->Visible) { // OUT ?>
        <td data-name="OUT"<?= $Grid->OUT->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_OUT" class="el_t_trip_expenses_detailed_OUT">
<input type="<?= $Grid->OUT->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_OUT" id="x<?= $Grid->RowIndex ?>_OUT" data-table="t_trip_expenses_detailed" data-field="x_OUT" value="<?= $Grid->OUT->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->OUT->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->OUT->formatPattern()) ?>"<?= $Grid->OUT->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->OUT->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_OUT" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_OUT" id="o<?= $Grid->RowIndex ?>_OUT" value="<?= HtmlEncode($Grid->OUT->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_OUT" class="el_t_trip_expenses_detailed_OUT">
<input type="<?= $Grid->OUT->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_OUT" id="x<?= $Grid->RowIndex ?>_OUT" data-table="t_trip_expenses_detailed" data-field="x_OUT" value="<?= $Grid->OUT->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->OUT->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->OUT->formatPattern()) ?>"<?= $Grid->OUT->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->OUT->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_OUT" class="el_t_trip_expenses_detailed_OUT">
<span<?= $Grid->OUT->viewAttributes() ?>>
<?= $Grid->OUT->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_OUT" data-hidden="1" name="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_OUT" id="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_OUT" value="<?= HtmlEncode($Grid->OUT->FormValue) ?>">
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_OUT" data-hidden="1" data-old name="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_OUT" id="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_OUT" value="<?= HtmlEncode($Grid->OUT->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->dated->Visible) { // dated ?>
        <td data-name="dated"<?= $Grid->dated->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_dated" class="el_t_trip_expenses_detailed_dated">
<input type="<?= $Grid->dated->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_dated" id="x<?= $Grid->RowIndex ?>_dated" data-table="t_trip_expenses_detailed" data-field="x_dated" value="<?= $Grid->dated->EditValue ?>" placeholder="<?= HtmlEncode($Grid->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->dated->formatPattern()) ?>"<?= $Grid->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->dated->getErrorMessage() ?></div>
<?php if (!$Grid->dated->ReadOnly && !$Grid->dated->Disabled && !isset($Grid->dated->EditAttrs["readonly"]) && !isset($Grid->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_expenses_detailedgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_expenses_detailedgrid", "x<?= $Grid->RowIndex ?>_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_dated" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_dated" id="o<?= $Grid->RowIndex ?>_dated" value="<?= HtmlEncode($Grid->dated->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_dated" class="el_t_trip_expenses_detailed_dated">
<input type="<?= $Grid->dated->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_dated" id="x<?= $Grid->RowIndex ?>_dated" data-table="t_trip_expenses_detailed" data-field="x_dated" value="<?= $Grid->dated->EditValue ?>" placeholder="<?= HtmlEncode($Grid->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->dated->formatPattern()) ?>"<?= $Grid->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->dated->getErrorMessage() ?></div>
<?php if (!$Grid->dated->ReadOnly && !$Grid->dated->Disabled && !isset($Grid->dated->EditAttrs["readonly"]) && !isset($Grid->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_expenses_detailedgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_expenses_detailedgrid", "x<?= $Grid->RowIndex ?>_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_dated" class="el_t_trip_expenses_detailed_dated">
<span<?= $Grid->dated->viewAttributes() ?>>
<?php if (!EmptyString($Grid->dated->getViewValue()) && $Grid->dated->linkAttributes() != "") { ?>
<a<?= $Grid->dated->linkAttributes() ?>><?= $Grid->dated->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->dated->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_dated" data-hidden="1" name="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_dated" id="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_dated" value="<?= HtmlEncode($Grid->dated->FormValue) ?>">
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_dated" data-hidden="1" data-old name="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_dated" id="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_dated" value="<?= HtmlEncode($Grid->dated->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Grid->remarks->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_remarks" class="el_t_trip_expenses_detailed_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="t_trip_expenses_detailed" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_remarks" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_remarks" id="o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_remarks" class="el_t_trip_expenses_detailed_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="t_trip_expenses_detailed" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_trip_expenses_detailed_remarks" class="el_t_trip_expenses_detailed_remarks">
<span<?= $Grid->remarks->viewAttributes() ?>>
<?= $Grid->remarks->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_remarks" data-hidden="1" name="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_remarks" id="ft_trip_expenses_detailedgrid$x<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->FormValue) ?>">
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_remarks" data-hidden="1" data-old name="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_remarks" id="ft_trip_expenses_detailedgrid$o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["ft_trip_expenses_detailedgrid","load"], () => ft_trip_expenses_detailedgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Grid->RowType = RowType::AGGREGATE;
$Grid->resetAttributes();
$Grid->renderRow();
?>
<?php if ($Grid->TotalRecords > 0 && $Grid->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Grid->renderListOptions();

// Render list options (footer, left)
$Grid->ListOptions->render("footer", "left");
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Grid->id->footerCellClass() ?>"><span id="elf_t_trip_expenses_detailed_id" class="t_trip_expenses_detailed_id">
        </span></td>
    <?php } ?>
    <?php if ($Grid->trip->Visible) { // trip ?>
        <td data-name="trip" class="<?= $Grid->trip->footerCellClass() ?>"><span id="elf_t_trip_expenses_detailed_trip" class="t_trip_expenses_detailed_trip">
        </span></td>
    <?php } ?>
    <?php if ($Grid->diesal_by->Visible) { // diesal_by ?>
        <td data-name="diesal_by" class="<?= $Grid->diesal_by->footerCellClass() ?>"><span id="elf_t_trip_expenses_detailed_diesal_by" class="t_trip_expenses_detailed_diesal_by">
        </span></td>
    <?php } ?>
    <?php if ($Grid->name->Visible) { // name ?>
        <td data-name="name" class="<?= $Grid->name->footerCellClass() ?>"><span id="elf_t_trip_expenses_detailed_name" class="t_trip_expenses_detailed_name">
        </span></td>
    <?php } ?>
    <?php if ($Grid->ref->Visible) { // ref ?>
        <td data-name="ref" class="<?= $Grid->ref->footerCellClass() ?>"><span id="elf_t_trip_expenses_detailed_ref" class="t_trip_expenses_detailed_ref">
        </span></td>
    <?php } ?>
    <?php if ($Grid->IN->Visible) { // IN ?>
        <td data-name="IN" class="<?= $Grid->IN->footerCellClass() ?>"><span id="elf_t_trip_expenses_detailed_IN" class="t_trip_expenses_detailed_IN">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->IN->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->OUT->Visible) { // OUT ?>
        <td data-name="OUT" class="<?= $Grid->OUT->footerCellClass() ?>"><span id="elf_t_trip_expenses_detailed_OUT" class="t_trip_expenses_detailed_OUT">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->OUT->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->dated->Visible) { // dated ?>
        <td data-name="dated" class="<?= $Grid->dated->footerCellClass() ?>"><span id="elf_t_trip_expenses_detailed_dated" class="t_trip_expenses_detailed_dated">
        </span></td>
    <?php } ?>
    <?php if ($Grid->remarks->Visible) { // remarks ?>
        <td data-name="remarks" class="<?= $Grid->remarks->footerCellClass() ?>"><span id="elf_t_trip_expenses_detailed_remarks" class="t_trip_expenses_detailed_remarks">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Grid->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ft_trip_expenses_detailedgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_trip_expenses_detailed");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
