<?php

namespace PHPMaker2024\fibre;

// Page object
$TTripBuyerSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_trip_buyer: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ft_trip_buyersearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_trip_buyersearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["route_name", [], fields.route_name.isInvalid],
            ["buyer", [ew.Validators.integer], fields.buyer.isInvalid],
            ["delivery_receipt", [], fields.delivery_receipt.isInvalid],
            ["delivery_docket", [], fields.delivery_docket.isInvalid],
            ["invoice_no", [ew.Validators.integer], fields.invoice_no.isInvalid],
            ["invoice_date", [ew.Validators.datetime(fields.invoice_date.clientFormatPattern)], fields.invoice_date.isInvalid],
            ["y_invoice_date", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_trip_buyersearch" id="ft_trip_buyersearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_trip_buyer">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_buyer_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_buyer_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="t_trip_buyer" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->route_name->Visible) { // route_name ?>
    <div id="r_route_name" class="row"<?= $Page->route_name->rowAttributes() ?>>
        <label for="x_route_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_buyer_route_name"><?= $Page->route_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_route_name" id="z_route_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->route_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_buyer_route_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->route_name->getInputTextType() ?>" name="x_route_name" id="x_route_name" data-table="t_trip_buyer" data-field="x_route_name" value="<?= $Page->route_name->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->route_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->route_name->formatPattern()) ?>"<?= $Page->route_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->route_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
    <div id="r_buyer" class="row"<?= $Page->buyer->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_buyer_buyer"><?= $Page->buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer" id="z_buyer" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_buyer_buyer" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer"
        name="x_buyer"
        class="form-control ew-select<?= $Page->buyer->isInvalidClass() ?>"
        data-select2-id="ft_trip_buyersearch_x_buyer"
        data-table="t_trip_buyer"
        data-field="x_buyer"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>"
        <?= $Page->buyer->editAttributes() ?>>
        <?= $Page->buyer->selectOptionListHtml("x_buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer->getErrorMessage(false) ?></div>
<?= $Page->buyer->Lookup->getParamTag($Page, "p_x_buyer") ?>
<script>
loadjs.ready("ft_trip_buyersearch", function() {
    var options = { name: "x_buyer", selectId: "ft_trip_buyersearch_x_buyer" };
    if (ft_trip_buyersearch.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x_buyer", form: "ft_trip_buyersearch" };
    } else {
        options.ajax = { id: "x_buyer", form: "ft_trip_buyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_trip_buyer.fields.buyer.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delivery_receipt->Visible) { // delivery_receipt ?>
    <div id="r_delivery_receipt" class="row"<?= $Page->delivery_receipt->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_buyer_delivery_receipt"><?= $Page->delivery_receipt->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_delivery_receipt" id="z_delivery_receipt" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delivery_receipt->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_buyer_delivery_receipt" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->delivery_receipt->getInputTextType() ?>" name="x_delivery_receipt" id="x_delivery_receipt" data-table="t_trip_buyer" data-field="x_delivery_receipt" value="<?= $Page->delivery_receipt->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->delivery_receipt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->delivery_receipt->formatPattern()) ?>"<?= $Page->delivery_receipt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->delivery_receipt->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delivery_docket->Visible) { // delivery_docket ?>
    <div id="r_delivery_docket" class="row"<?= $Page->delivery_docket->rowAttributes() ?>>
        <label for="x_delivery_docket" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_buyer_delivery_docket"><?= $Page->delivery_docket->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_delivery_docket" id="z_delivery_docket" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delivery_docket->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_buyer_delivery_docket" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->delivery_docket->getInputTextType() ?>" name="x_delivery_docket" id="x_delivery_docket" data-table="t_trip_buyer" data-field="x_delivery_docket" value="<?= $Page->delivery_docket->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->delivery_docket->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->delivery_docket->formatPattern()) ?>"<?= $Page->delivery_docket->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->delivery_docket->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice_no->Visible) { // invoice_no ?>
    <div id="r_invoice_no" class="row"<?= $Page->invoice_no->rowAttributes() ?>>
        <label for="x_invoice_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_buyer_invoice_no"><?= $Page->invoice_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_invoice_no" id="z_invoice_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_trip_buyer_invoice_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice_no->getInputTextType() ?>" name="x_invoice_no" id="x_invoice_no" data-table="t_trip_buyer" data-field="x_invoice_no" value="<?= $Page->invoice_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->invoice_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_no->formatPattern()) ?>"<?= $Page->invoice_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
    <div id="r_invoice_date" class="row"<?= $Page->invoice_date->rowAttributes() ?>>
        <label for="x_invoice_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_trip_buyer_invoice_date"><?= $Page->invoice_date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_invoice_date" id="z_invoice_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->invoice_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->invoice_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_t_trip_buyer_invoice_date" class="ew-search-field">
<input type="<?= $Page->invoice_date->getInputTextType() ?>" name="x_invoice_date" id="x_invoice_date" data-table="t_trip_buyer" data-field="x_invoice_date" value="<?= $Page->invoice_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->invoice_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_date->formatPattern()) ?>"<?= $Page->invoice_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_date->getErrorMessage(false) ?></div>
<?php if (!$Page->invoice_date->ReadOnly && !$Page->invoice_date->Disabled && !isset($Page->invoice_date->EditAttrs["readonly"]) && !isset($Page->invoice_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_buyersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_buyersearch", "x_invoice_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_t_trip_buyer_invoice_date" class="ew-search-field2 d-none">
<input type="<?= $Page->invoice_date->getInputTextType() ?>" name="y_invoice_date" id="y_invoice_date" data-table="t_trip_buyer" data-field="x_invoice_date" value="<?= $Page->invoice_date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->invoice_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_date->formatPattern()) ?>"<?= $Page->invoice_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_date->getErrorMessage(false) ?></div>
<?php if (!$Page->invoice_date->ReadOnly && !$Page->invoice_date->Disabled && !isset($Page->invoice_date->EditAttrs["readonly"]) && !isset($Page->invoice_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_trip_buyersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_trip_buyersearch", "y_invoice_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_trip_buyersearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_trip_buyersearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ft_trip_buyersearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_trip_buyer");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
