<?php

namespace PHPMaker2024\fibre;

// Page object
$TRouteInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_route_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ft_route_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_route_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["route_name", [], fields.route_name.isInvalid],
            ["r_from", [], fields.r_from.isInvalid],
            ["r_to", [], fields.r_to.isInvalid],
            ["km", [ew.Validators.integer], fields.km.isInvalid],
            ["days", [ew.Validators.float], fields.days.isInvalid],
            ["load_expenses", [ew.Validators.integer], fields.load_expenses.isInvalid],
            ["unload_expenses", [ew.Validators.integer], fields.unload_expenses.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_route_infosearch" id="ft_route_infosearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_route_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_route_info_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_route_info_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="t_route_info" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->route_name->Visible) { // route_name ?>
    <div id="r_route_name" class="row"<?= $Page->route_name->rowAttributes() ?>>
        <label for="x_route_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_route_info_route_name"><?= $Page->route_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_route_name" id="z_route_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->route_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_route_info_route_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->route_name->getInputTextType() ?>" name="x_route_name" id="x_route_name" data-table="t_route_info" data-field="x_route_name" value="<?= $Page->route_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->route_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->route_name->formatPattern()) ?>"<?= $Page->route_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->route_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->r_from->Visible) { // r_from ?>
    <div id="r_r_from" class="row"<?= $Page->r_from->rowAttributes() ?>>
        <label for="x_r_from" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_route_info_r_from"><?= $Page->r_from->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_r_from" id="z_r_from" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->r_from->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_route_info_r_from" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->r_from->getInputTextType() ?>" name="x_r_from" id="x_r_from" data-table="t_route_info" data-field="x_r_from" value="<?= $Page->r_from->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->r_from->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_from->formatPattern()) ?>"<?= $Page->r_from->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->r_from->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->r_to->Visible) { // r_to ?>
    <div id="r_r_to" class="row"<?= $Page->r_to->rowAttributes() ?>>
        <label for="x_r_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_route_info_r_to"><?= $Page->r_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_r_to" id="z_r_to" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->r_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_route_info_r_to" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->r_to->getInputTextType() ?>" name="x_r_to" id="x_r_to" data-table="t_route_info" data-field="x_r_to" value="<?= $Page->r_to->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->r_to->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_to->formatPattern()) ?>"<?= $Page->r_to->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->r_to->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->km->Visible) { // km ?>
    <div id="r_km" class="row"<?= $Page->km->rowAttributes() ?>>
        <label for="x_km" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_route_info_km"><?= $Page->km->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_km" id="z_km" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->km->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_route_info_km" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->km->getInputTextType() ?>" name="x_km" id="x_km" data-table="t_route_info" data-field="x_km" value="<?= $Page->km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->km->formatPattern()) ?>"<?= $Page->km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->km->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->days->Visible) { // days ?>
    <div id="r_days" class="row"<?= $Page->days->rowAttributes() ?>>
        <label for="x_days" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_route_info_days"><?= $Page->days->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_days" id="z_days" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->days->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_route_info_days" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->days->getInputTextType() ?>" name="x_days" id="x_days" data-table="t_route_info" data-field="x_days" value="<?= $Page->days->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->days->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->days->formatPattern()) ?>"<?= $Page->days->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->days->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->load_expenses->Visible) { // load_expenses ?>
    <div id="r_load_expenses" class="row"<?= $Page->load_expenses->rowAttributes() ?>>
        <label for="x_load_expenses" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_route_info_load_expenses"><?= $Page->load_expenses->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_load_expenses" id="z_load_expenses" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->load_expenses->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_route_info_load_expenses" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->load_expenses->getInputTextType() ?>" name="x_load_expenses" id="x_load_expenses" data-table="t_route_info" data-field="x_load_expenses" value="<?= $Page->load_expenses->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->load_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_expenses->formatPattern()) ?>"<?= $Page->load_expenses->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->load_expenses->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unload_expenses->Visible) { // unload_expenses ?>
    <div id="r_unload_expenses" class="row"<?= $Page->unload_expenses->rowAttributes() ?>>
        <label for="x_unload_expenses" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_route_info_unload_expenses"><?= $Page->unload_expenses->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unload_expenses" id="z_unload_expenses" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unload_expenses->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_route_info_unload_expenses" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->unload_expenses->getInputTextType() ?>" name="x_unload_expenses" id="x_unload_expenses" data-table="t_route_info" data-field="x_unload_expenses" value="<?= $Page->unload_expenses->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->unload_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_expenses->formatPattern()) ?>"<?= $Page->unload_expenses->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->unload_expenses->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_route_info_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_route_info_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="ft_route_infosearch_x_status"
        <?php } ?>
        data-table="t_route_info"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_route_infosearch", function() {
    var options = { name: "x_status", selectId: "ft_route_infosearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_route_infosearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "ft_route_infosearch" };
    } else {
        options.ajax = { id: "x_status", form: "ft_route_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_route_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_route_info_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_route_info_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="t_route_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_route_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_route_infosearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_route_infosearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_route_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ft_route_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_route_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
