<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("TRouteInfoGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var ft_route_infogrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { t_route_info: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_route_infogrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["route_name", [fields.route_name.visible && fields.route_name.required ? ew.Validators.required(fields.route_name.caption) : null], fields.route_name.isInvalid],
            ["load_expenses", [fields.load_expenses.visible && fields.load_expenses.required ? ew.Validators.required(fields.load_expenses.caption) : null, ew.Validators.integer], fields.load_expenses.isInvalid],
            ["unload_expenses", [fields.unload_expenses.visible && fields.unload_expenses.required ? ew.Validators.required(fields.unload_expenses.caption) : null, ew.Validators.integer], fields.unload_expenses.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["route_name",false],["load_expenses",false],["unload_expenses",false],["status",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "status": <?= $Grid->status->toClientList($Grid) ?>,
            "operator": <?= $Grid->operator->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="ft_route_infogrid" class="ew-form ew-list-form">
<div id="gmp_t_route_info" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_t_route_infogrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_t_route_info_id" class="t_route_info_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->route_name->Visible) { // route_name ?>
        <th data-name="route_name" class="<?= $Grid->route_name->headerCellClass() ?>"><div id="elh_t_route_info_route_name" class="t_route_info_route_name"><?= $Grid->renderFieldHeader($Grid->route_name) ?></div></th>
<?php } ?>
<?php if ($Grid->load_expenses->Visible) { // load_expenses ?>
        <th data-name="load_expenses" class="<?= $Grid->load_expenses->headerCellClass() ?>"><div id="elh_t_route_info_load_expenses" class="t_route_info_load_expenses"><?= $Grid->renderFieldHeader($Grid->load_expenses) ?></div></th>
<?php } ?>
<?php if ($Grid->unload_expenses->Visible) { // unload_expenses ?>
        <th data-name="unload_expenses" class="<?= $Grid->unload_expenses->headerCellClass() ?>"><div id="elh_t_route_info_unload_expenses" class="t_route_info_unload_expenses"><?= $Grid->renderFieldHeader($Grid->unload_expenses) ?></div></th>
<?php } ?>
<?php if ($Grid->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Grid->status->headerCellClass() ?>"><div id="elh_t_route_info_status" class="t_route_info_status"><?= $Grid->renderFieldHeader($Grid->status) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_t_route_info_operator" class="t_route_info_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_t_route_info_datetime" class="t_route_info_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_id" class="el_t_route_info_id"></span>
<input type="hidden" data-table="t_route_info" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_id" class="el_t_route_info_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="t_route_info" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_id" class="el_t_route_info_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_id" data-hidden="1" name="ft_route_infogrid$x<?= $Grid->RowIndex ?>_id" id="ft_route_infogrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_id" data-hidden="1" data-old name="ft_route_infogrid$o<?= $Grid->RowIndex ?>_id" id="ft_route_infogrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="t_route_info" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->route_name->Visible) { // route_name ?>
        <td data-name="route_name"<?= $Grid->route_name->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_route_name" class="el_t_route_info_route_name">
<input type="<?= $Grid->route_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_route_name" id="x<?= $Grid->RowIndex ?>_route_name" data-table="t_route_info" data-field="x_route_name" value="<?= $Grid->route_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->route_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->route_name->formatPattern()) ?>"<?= $Grid->route_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->route_name->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_route_name" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_route_name" id="o<?= $Grid->RowIndex ?>_route_name" value="<?= HtmlEncode($Grid->route_name->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_route_name" class="el_t_route_info_route_name">
<input type="<?= $Grid->route_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_route_name" id="x<?= $Grid->RowIndex ?>_route_name" data-table="t_route_info" data-field="x_route_name" value="<?= $Grid->route_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->route_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->route_name->formatPattern()) ?>"<?= $Grid->route_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->route_name->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_route_name" class="el_t_route_info_route_name">
<span<?= $Grid->route_name->viewAttributes() ?>>
<?= $Grid->route_name->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_route_name" data-hidden="1" name="ft_route_infogrid$x<?= $Grid->RowIndex ?>_route_name" id="ft_route_infogrid$x<?= $Grid->RowIndex ?>_route_name" value="<?= HtmlEncode($Grid->route_name->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_route_name" data-hidden="1" data-old name="ft_route_infogrid$o<?= $Grid->RowIndex ?>_route_name" id="ft_route_infogrid$o<?= $Grid->RowIndex ?>_route_name" value="<?= HtmlEncode($Grid->route_name->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->load_expenses->Visible) { // load_expenses ?>
        <td data-name="load_expenses"<?= $Grid->load_expenses->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_load_expenses" class="el_t_route_info_load_expenses">
<input type="<?= $Grid->load_expenses->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_load_expenses" id="x<?= $Grid->RowIndex ?>_load_expenses" data-table="t_route_info" data-field="x_load_expenses" value="<?= $Grid->load_expenses->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->load_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->load_expenses->formatPattern()) ?>"<?= $Grid->load_expenses->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->load_expenses->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_load_expenses" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_load_expenses" id="o<?= $Grid->RowIndex ?>_load_expenses" value="<?= HtmlEncode($Grid->load_expenses->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_load_expenses" class="el_t_route_info_load_expenses">
<input type="<?= $Grid->load_expenses->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_load_expenses" id="x<?= $Grid->RowIndex ?>_load_expenses" data-table="t_route_info" data-field="x_load_expenses" value="<?= $Grid->load_expenses->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->load_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->load_expenses->formatPattern()) ?>"<?= $Grid->load_expenses->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->load_expenses->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_load_expenses" class="el_t_route_info_load_expenses">
<span<?= $Grid->load_expenses->viewAttributes() ?>>
<?= $Grid->load_expenses->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_load_expenses" data-hidden="1" name="ft_route_infogrid$x<?= $Grid->RowIndex ?>_load_expenses" id="ft_route_infogrid$x<?= $Grid->RowIndex ?>_load_expenses" value="<?= HtmlEncode($Grid->load_expenses->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_load_expenses" data-hidden="1" data-old name="ft_route_infogrid$o<?= $Grid->RowIndex ?>_load_expenses" id="ft_route_infogrid$o<?= $Grid->RowIndex ?>_load_expenses" value="<?= HtmlEncode($Grid->load_expenses->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->unload_expenses->Visible) { // unload_expenses ?>
        <td data-name="unload_expenses"<?= $Grid->unload_expenses->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_unload_expenses" class="el_t_route_info_unload_expenses">
<input type="<?= $Grid->unload_expenses->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_unload_expenses" id="x<?= $Grid->RowIndex ?>_unload_expenses" data-table="t_route_info" data-field="x_unload_expenses" value="<?= $Grid->unload_expenses->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->unload_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->unload_expenses->formatPattern()) ?>"<?= $Grid->unload_expenses->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->unload_expenses->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_unload_expenses" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_unload_expenses" id="o<?= $Grid->RowIndex ?>_unload_expenses" value="<?= HtmlEncode($Grid->unload_expenses->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_unload_expenses" class="el_t_route_info_unload_expenses">
<input type="<?= $Grid->unload_expenses->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_unload_expenses" id="x<?= $Grid->RowIndex ?>_unload_expenses" data-table="t_route_info" data-field="x_unload_expenses" value="<?= $Grid->unload_expenses->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->unload_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->unload_expenses->formatPattern()) ?>"<?= $Grid->unload_expenses->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->unload_expenses->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_unload_expenses" class="el_t_route_info_unload_expenses">
<span<?= $Grid->unload_expenses->viewAttributes() ?>>
<?= $Grid->unload_expenses->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_unload_expenses" data-hidden="1" name="ft_route_infogrid$x<?= $Grid->RowIndex ?>_unload_expenses" id="ft_route_infogrid$x<?= $Grid->RowIndex ?>_unload_expenses" value="<?= HtmlEncode($Grid->unload_expenses->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_unload_expenses" data-hidden="1" data-old name="ft_route_infogrid$o<?= $Grid->RowIndex ?>_unload_expenses" id="ft_route_infogrid$o<?= $Grid->RowIndex ?>_unload_expenses" value="<?= HtmlEncode($Grid->unload_expenses->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->status->Visible) { // status ?>
        <td data-name="status"<?= $Grid->status->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_status" class="el_t_route_info_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="ft_route_infogrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="t_route_info"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_route_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "ft_route_infogrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_route_infogrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "ft_route_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "ft_route_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_route_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_status" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_status" id="o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_status" class="el_t_route_info_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="ft_route_infogrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="t_route_info"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_route_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "ft_route_infogrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_route_infogrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "ft_route_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "ft_route_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_route_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_status" class="el_t_route_info_status">
<span<?= $Grid->status->viewAttributes() ?>>
<?= $Grid->status->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_status" data-hidden="1" name="ft_route_infogrid$x<?= $Grid->RowIndex ?>_status" id="ft_route_infogrid$x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_status" data-hidden="1" data-old name="ft_route_infogrid$o<?= $Grid->RowIndex ?>_status" id="ft_route_infogrid$o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="t_route_info" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_operator" class="el_t_route_info_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_operator" data-hidden="1" name="ft_route_infogrid$x<?= $Grid->RowIndex ?>_operator" id="ft_route_infogrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_operator" data-hidden="1" data-old name="ft_route_infogrid$o<?= $Grid->RowIndex ?>_operator" id="ft_route_infogrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="t_route_info" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_route_info_datetime" class="el_t_route_info_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_datetime" data-hidden="1" name="ft_route_infogrid$x<?= $Grid->RowIndex ?>_datetime" id="ft_route_infogrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_datetime" data-hidden="1" data-old name="ft_route_infogrid$o<?= $Grid->RowIndex ?>_datetime" id="ft_route_infogrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["ft_route_infogrid","load"], () => ft_route_infogrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ft_route_infogrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_route_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
