<?php

namespace PHPMaker2024\fibre;

// Page object
$TRouteInfoAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_route_info: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ft_route_infoadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_route_infoadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["r_from", [fields.r_from.visible && fields.r_from.required ? ew.Validators.required(fields.r_from.caption) : null], fields.r_from.isInvalid],
            ["r_to", [fields.r_to.visible && fields.r_to.required ? ew.Validators.required(fields.r_to.caption) : null], fields.r_to.isInvalid],
            ["km", [fields.km.visible && fields.km.required ? ew.Validators.required(fields.km.caption) : null, ew.Validators.integer], fields.km.isInvalid],
            ["days", [fields.days.visible && fields.days.required ? ew.Validators.required(fields.days.caption) : null, ew.Validators.float], fields.days.isInvalid],
            ["load_expenses", [fields.load_expenses.visible && fields.load_expenses.required ? ew.Validators.required(fields.load_expenses.caption) : null, ew.Validators.integer], fields.load_expenses.isInvalid],
            ["unload_expenses", [fields.unload_expenses.visible && fields.unload_expenses.required ? ew.Validators.required(fields.unload_expenses.caption) : null, ew.Validators.integer], fields.unload_expenses.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_route_infoadd" id="ft_route_infoadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_route_info">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "t_trip_info") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="t_trip_info">
<input type="hidden" name="fk__route" value="<?= HtmlEncode($Page->id->getSessionValue()) ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->r_from->Visible) { // r_from ?>
    <div id="r_r_from"<?= $Page->r_from->rowAttributes() ?>>
        <label id="elh_t_route_info_r_from" for="x_r_from" class="<?= $Page->LeftColumnClass ?>"><?= $Page->r_from->caption() ?><?= $Page->r_from->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->r_from->cellAttributes() ?>>
<span id="el_t_route_info_r_from">
<input type="<?= $Page->r_from->getInputTextType() ?>" name="x_r_from" id="x_r_from" data-table="t_route_info" data-field="x_r_from" value="<?= $Page->r_from->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->r_from->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_from->formatPattern()) ?>"<?= $Page->r_from->editAttributes() ?> aria-describedby="x_r_from_help">
<?= $Page->r_from->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->r_from->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->r_to->Visible) { // r_to ?>
    <div id="r_r_to"<?= $Page->r_to->rowAttributes() ?>>
        <label id="elh_t_route_info_r_to" for="x_r_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->r_to->caption() ?><?= $Page->r_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->r_to->cellAttributes() ?>>
<span id="el_t_route_info_r_to">
<input type="<?= $Page->r_to->getInputTextType() ?>" name="x_r_to" id="x_r_to" data-table="t_route_info" data-field="x_r_to" value="<?= $Page->r_to->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->r_to->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_to->formatPattern()) ?>"<?= $Page->r_to->editAttributes() ?> aria-describedby="x_r_to_help">
<?= $Page->r_to->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->r_to->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->km->Visible) { // km ?>
    <div id="r_km"<?= $Page->km->rowAttributes() ?>>
        <label id="elh_t_route_info_km" for="x_km" class="<?= $Page->LeftColumnClass ?>"><?= $Page->km->caption() ?><?= $Page->km->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->km->cellAttributes() ?>>
<span id="el_t_route_info_km">
<input type="<?= $Page->km->getInputTextType() ?>" name="x_km" id="x_km" data-table="t_route_info" data-field="x_km" value="<?= $Page->km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->km->formatPattern()) ?>"<?= $Page->km->editAttributes() ?> aria-describedby="x_km_help">
<?= $Page->km->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->km->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->days->Visible) { // days ?>
    <div id="r_days"<?= $Page->days->rowAttributes() ?>>
        <label id="elh_t_route_info_days" for="x_days" class="<?= $Page->LeftColumnClass ?>"><?= $Page->days->caption() ?><?= $Page->days->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->days->cellAttributes() ?>>
<span id="el_t_route_info_days">
<input type="<?= $Page->days->getInputTextType() ?>" name="x_days" id="x_days" data-table="t_route_info" data-field="x_days" value="<?= $Page->days->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->days->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->days->formatPattern()) ?>"<?= $Page->days->editAttributes() ?> aria-describedby="x_days_help">
<?= $Page->days->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->days->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->load_expenses->Visible) { // load_expenses ?>
    <div id="r_load_expenses"<?= $Page->load_expenses->rowAttributes() ?>>
        <label id="elh_t_route_info_load_expenses" for="x_load_expenses" class="<?= $Page->LeftColumnClass ?>"><?= $Page->load_expenses->caption() ?><?= $Page->load_expenses->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->load_expenses->cellAttributes() ?>>
<span id="el_t_route_info_load_expenses">
<input type="<?= $Page->load_expenses->getInputTextType() ?>" name="x_load_expenses" id="x_load_expenses" data-table="t_route_info" data-field="x_load_expenses" value="<?= $Page->load_expenses->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->load_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->load_expenses->formatPattern()) ?>"<?= $Page->load_expenses->editAttributes() ?> aria-describedby="x_load_expenses_help">
<?= $Page->load_expenses->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->load_expenses->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->unload_expenses->Visible) { // unload_expenses ?>
    <div id="r_unload_expenses"<?= $Page->unload_expenses->rowAttributes() ?>>
        <label id="elh_t_route_info_unload_expenses" for="x_unload_expenses" class="<?= $Page->LeftColumnClass ?>"><?= $Page->unload_expenses->caption() ?><?= $Page->unload_expenses->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->unload_expenses->cellAttributes() ?>>
<span id="el_t_route_info_unload_expenses">
<input type="<?= $Page->unload_expenses->getInputTextType() ?>" name="x_unload_expenses" id="x_unload_expenses" data-table="t_route_info" data-field="x_unload_expenses" value="<?= $Page->unload_expenses->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->unload_expenses->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unload_expenses->formatPattern()) ?>"<?= $Page->unload_expenses->editAttributes() ?> aria-describedby="x_unload_expenses_help">
<?= $Page->unload_expenses->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->unload_expenses->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_t_route_info_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_t_route_info_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="ft_route_infoadd_x_status"
        <?php } ?>
        data-table="t_route_info"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_route_infoadd", function() {
    var options = { name: "x_status", selectId: "ft_route_infoadd_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_route_infoadd.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "ft_route_infoadd" };
    } else {
        options.ajax = { id: "x_status", form: "ft_route_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_route_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
    <?php if (strval($Page->id->getSessionValue()) != "") { ?>
    <input type="hidden" name="x_id" id="x_id" value="<?= HtmlEncode(strval($Page->id->getSessionValue())) ?>">
    <?php } ?>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_route_infoadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_route_infoadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_route_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
