<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("TReceiptDGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var ft_receipt_dgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { t_receipt_d: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_receipt_dgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null, ew.Validators.integer], fields.id.isInvalid],
            ["trip", [fields.trip.visible && fields.trip.required ? ew.Validators.required(fields.trip.caption) : null], fields.trip.isInvalid],
            ["r_from", [fields.r_from.visible && fields.r_from.required ? ew.Validators.required(fields.r_from.caption) : null], fields.r_from.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.integer], fields.amount.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["trip",false],["r_from",false],["amount",false],["dated",false],["remarks",false],["uploads",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "trip": <?= $Grid->trip->toClientList($Grid) ?>,
            "r_from": <?= $Grid->r_from->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="ft_receipt_dgrid" class="ew-form ew-list-form">
<div id="gmp_t_receipt_d" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_t_receipt_dgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_t_receipt_d_id" class="t_receipt_d_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->trip->Visible) { // trip ?>
        <th data-name="trip" class="<?= $Grid->trip->headerCellClass() ?>"><div id="elh_t_receipt_d_trip" class="t_receipt_d_trip"><?= $Grid->renderFieldHeader($Grid->trip) ?></div></th>
<?php } ?>
<?php if ($Grid->r_from->Visible) { // r_from ?>
        <th data-name="r_from" class="<?= $Grid->r_from->headerCellClass() ?>"><div id="elh_t_receipt_d_r_from" class="t_receipt_d_r_from"><?= $Grid->renderFieldHeader($Grid->r_from) ?></div></th>
<?php } ?>
<?php if ($Grid->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Grid->amount->headerCellClass() ?>"><div id="elh_t_receipt_d_amount" class="t_receipt_d_amount"><?= $Grid->renderFieldHeader($Grid->amount) ?></div></th>
<?php } ?>
<?php if ($Grid->dated->Visible) { // dated ?>
        <th data-name="dated" class="<?= $Grid->dated->headerCellClass() ?>"><div id="elh_t_receipt_d_dated" class="t_receipt_d_dated"><?= $Grid->renderFieldHeader($Grid->dated) ?></div></th>
<?php } ?>
<?php if ($Grid->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Grid->remarks->headerCellClass() ?>"><div id="elh_t_receipt_d_remarks" class="t_receipt_d_remarks"><?= $Grid->renderFieldHeader($Grid->remarks) ?></div></th>
<?php } ?>
<?php if ($Grid->uploads->Visible) { // uploads ?>
        <th data-name="uploads" class="<?= $Grid->uploads->headerCellClass() ?>"><div id="elh_t_receipt_d_uploads" class="t_receipt_d_uploads"><?= $Grid->renderFieldHeader($Grid->uploads) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_t_receipt_d_operator" class="t_receipt_d_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_t_receipt_d_datetime" class="t_receipt_d_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_id" class="el_t_receipt_d_id"></span>
<input type="hidden" data-table="t_receipt_d" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_id" class="el_t_receipt_d_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="t_receipt_d" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_id" class="el_t_receipt_d_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_receipt_d" data-field="x_id" data-hidden="1" name="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_id" id="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="t_receipt_d" data-field="x_id" data-hidden="1" data-old name="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_id" id="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="t_receipt_d" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->trip->Visible) { // trip ?>
        <td data-name="trip"<?= $Grid->trip->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->trip->getSessionValue() != "") { ?>
<span<?= $Grid->trip->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->trip->getDisplayValue($Grid->trip->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_trip" name="x<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_trip" class="el_t_receipt_d_trip">
<template id="tp_x<?= $Grid->RowIndex ?>_trip">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="t_receipt_d" data-field="x_trip" name="x<?= $Grid->RowIndex ?>_trip" id="x<?= $Grid->RowIndex ?>_trip"<?= $Grid->trip->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_trip" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_trip"
    name="x<?= $Grid->RowIndex ?>_trip"
    value="<?= HtmlEncode($Grid->trip->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x<?= $Grid->RowIndex ?>_trip"
    data-target="dsl_x<?= $Grid->RowIndex ?>_trip"
    data-repeatcolumn="5"
    class="form-control<?= $Grid->trip->isInvalidClass() ?>"
    data-table="t_receipt_d"
    data-field="x_trip"
    data-value-separator="<?= $Grid->trip->displayValueSeparatorAttribute() ?>"
    <?= $Grid->trip->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->trip->getErrorMessage() ?></div>
<?= $Grid->trip->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_trip") ?>
</span>
<?php } ?>
<input type="hidden" data-table="t_receipt_d" data-field="x_trip" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_trip" id="o<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_trip" class="el_t_receipt_d_trip">
<span<?= $Grid->trip->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->trip->getDisplayValue($Grid->trip->EditValue) ?></span></span>
<input type="hidden" data-table="t_receipt_d" data-field="x_trip" data-hidden="1" name="x<?= $Grid->RowIndex ?>_trip" id="x<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_trip" class="el_t_receipt_d_trip">
<span<?= $Grid->trip->viewAttributes() ?>>
<?= $Grid->trip->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_receipt_d" data-field="x_trip" data-hidden="1" name="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_trip" id="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->FormValue) ?>">
<input type="hidden" data-table="t_receipt_d" data-field="x_trip" data-hidden="1" data-old name="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_trip" id="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->r_from->Visible) { // r_from ?>
        <td data-name="r_from"<?= $Grid->r_from->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_r_from" class="el_t_receipt_d_r_from">
<template id="tp_x<?= $Grid->RowIndex ?>_r_from">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="t_receipt_d" data-field="x_r_from" name="x<?= $Grid->RowIndex ?>_r_from" id="x<?= $Grid->RowIndex ?>_r_from"<?= $Grid->r_from->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_r_from" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_r_from"
    name="x<?= $Grid->RowIndex ?>_r_from"
    value="<?= HtmlEncode($Grid->r_from->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x<?= $Grid->RowIndex ?>_r_from"
    data-target="dsl_x<?= $Grid->RowIndex ?>_r_from"
    data-repeatcolumn="5"
    class="form-control<?= $Grid->r_from->isInvalidClass() ?>"
    data-table="t_receipt_d"
    data-field="x_r_from"
    data-value-separator="<?= $Grid->r_from->displayValueSeparatorAttribute() ?>"
    <?= $Grid->r_from->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->r_from->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_receipt_d" data-field="x_r_from" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_r_from" id="o<?= $Grid->RowIndex ?>_r_from" value="<?= HtmlEncode($Grid->r_from->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_r_from" class="el_t_receipt_d_r_from">
<template id="tp_x<?= $Grid->RowIndex ?>_r_from">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="t_receipt_d" data-field="x_r_from" name="x<?= $Grid->RowIndex ?>_r_from" id="x<?= $Grid->RowIndex ?>_r_from"<?= $Grid->r_from->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_r_from" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_r_from"
    name="x<?= $Grid->RowIndex ?>_r_from"
    value="<?= HtmlEncode($Grid->r_from->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x<?= $Grid->RowIndex ?>_r_from"
    data-target="dsl_x<?= $Grid->RowIndex ?>_r_from"
    data-repeatcolumn="5"
    class="form-control<?= $Grid->r_from->isInvalidClass() ?>"
    data-table="t_receipt_d"
    data-field="x_r_from"
    data-value-separator="<?= $Grid->r_from->displayValueSeparatorAttribute() ?>"
    <?= $Grid->r_from->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->r_from->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_r_from" class="el_t_receipt_d_r_from">
<span<?= $Grid->r_from->viewAttributes() ?>>
<?= $Grid->r_from->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_receipt_d" data-field="x_r_from" data-hidden="1" name="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_r_from" id="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_r_from" value="<?= HtmlEncode($Grid->r_from->FormValue) ?>">
<input type="hidden" data-table="t_receipt_d" data-field="x_r_from" data-hidden="1" data-old name="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_r_from" id="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_r_from" value="<?= HtmlEncode($Grid->r_from->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Grid->amount->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_amount" class="el_t_receipt_d_amount">
<input type="<?= $Grid->amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_amount" id="x<?= $Grid->RowIndex ?>_amount" data-table="t_receipt_d" data-field="x_amount" value="<?= $Grid->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->amount->formatPattern()) ?>"<?= $Grid->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->amount->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_receipt_d" data-field="x_amount" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_amount" id="o<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_amount" class="el_t_receipt_d_amount">
<input type="<?= $Grid->amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_amount" id="x<?= $Grid->RowIndex ?>_amount" data-table="t_receipt_d" data-field="x_amount" value="<?= $Grid->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->amount->formatPattern()) ?>"<?= $Grid->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->amount->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_amount" class="el_t_receipt_d_amount">
<span<?= $Grid->amount->viewAttributes() ?>>
<?= $Grid->amount->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_receipt_d" data-field="x_amount" data-hidden="1" name="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_amount" id="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->FormValue) ?>">
<input type="hidden" data-table="t_receipt_d" data-field="x_amount" data-hidden="1" data-old name="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_amount" id="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->dated->Visible) { // dated ?>
        <td data-name="dated"<?= $Grid->dated->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_dated" class="el_t_receipt_d_dated">
<input type="<?= $Grid->dated->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_dated" id="x<?= $Grid->RowIndex ?>_dated" data-table="t_receipt_d" data-field="x_dated" value="<?= $Grid->dated->EditValue ?>" placeholder="<?= HtmlEncode($Grid->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->dated->formatPattern()) ?>"<?= $Grid->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->dated->getErrorMessage() ?></div>
<?php if (!$Grid->dated->ReadOnly && !$Grid->dated->Disabled && !isset($Grid->dated->EditAttrs["readonly"]) && !isset($Grid->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_receipt_dgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_receipt_dgrid", "x<?= $Grid->RowIndex ?>_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="t_receipt_d" data-field="x_dated" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_dated" id="o<?= $Grid->RowIndex ?>_dated" value="<?= HtmlEncode($Grid->dated->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_dated" class="el_t_receipt_d_dated">
<input type="<?= $Grid->dated->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_dated" id="x<?= $Grid->RowIndex ?>_dated" data-table="t_receipt_d" data-field="x_dated" value="<?= $Grid->dated->EditValue ?>" placeholder="<?= HtmlEncode($Grid->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->dated->formatPattern()) ?>"<?= $Grid->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->dated->getErrorMessage() ?></div>
<?php if (!$Grid->dated->ReadOnly && !$Grid->dated->Disabled && !isset($Grid->dated->EditAttrs["readonly"]) && !isset($Grid->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_receipt_dgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_receipt_dgrid", "x<?= $Grid->RowIndex ?>_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_dated" class="el_t_receipt_d_dated">
<span<?= $Grid->dated->viewAttributes() ?>>
<?= $Grid->dated->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_receipt_d" data-field="x_dated" data-hidden="1" name="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_dated" id="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_dated" value="<?= HtmlEncode($Grid->dated->FormValue) ?>">
<input type="hidden" data-table="t_receipt_d" data-field="x_dated" data-hidden="1" data-old name="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_dated" id="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_dated" value="<?= HtmlEncode($Grid->dated->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Grid->remarks->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_remarks" class="el_t_receipt_d_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="t_receipt_d" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_receipt_d" data-field="x_remarks" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_remarks" id="o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_remarks" class="el_t_receipt_d_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="t_receipt_d" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_remarks" class="el_t_receipt_d_remarks">
<span<?= $Grid->remarks->viewAttributes() ?>>
<?= $Grid->remarks->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_receipt_d" data-field="x_remarks" data-hidden="1" name="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_remarks" id="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->FormValue) ?>">
<input type="hidden" data-table="t_receipt_d" data-field="x_remarks" data-hidden="1" data-old name="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_remarks" id="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->uploads->Visible) { // uploads ?>
        <td data-name="uploads"<?= $Grid->uploads->cellAttributes() ?>>
<?php if ($Grid->RowAction == "insert") { // Add record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex ?>_t_receipt_d_uploads" class="el_t_receipt_d_uploads">
<div id="fd_x<?= $Grid->RowIndex ?>_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_uploads"
        name="x<?= $Grid->RowIndex ?>_uploads"
        class="form-control ew-file-input"
        title="<?= $Grid->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_receipt_d"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Grid->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->uploads->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->uploads->ReadOnly || $Grid->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Grid->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_uploads" id= "fn_x<?= $Grid->RowIndex ?>_uploads" value="<?= $Grid->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_uploads" id= "fa_x<?= $Grid->RowIndex ?>_uploads" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex ?>_t_receipt_d_uploads" class="el_t_receipt_d_uploads">
<div id="fd_x<?= $Grid->RowIndex ?>_uploads">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_uploads"
        name="x<?= $Grid->RowIndex ?>_uploads"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_receipt_d"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Grid->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->uploads->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->uploads->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_uploads" id= "fn_x<?= $Grid->RowIndex ?>_uploads" value="<?= $Grid->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_uploads" id= "fa_x<?= $Grid->RowIndex ?>_uploads" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<input type="hidden" data-table="t_receipt_d" data-field="x_uploads" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_uploads" id="o<?= $Grid->RowIndex ?>_uploads" value="<?= HtmlEncode($Grid->uploads->OldValue) ?>">
<?php } elseif ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_uploads" class="el_t_receipt_d_uploads">
<span<?= $Grid->uploads->viewAttributes() ?>>
<?= GetFileViewTag($Grid->uploads, $Grid->uploads->getViewValue(), false) ?>
</span>
</span>
<?php } else  { // Edit record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_uploads" class="el_t_receipt_d_uploads">
<div id="fd_x<?= $Grid->RowIndex ?>_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_uploads"
        name="x<?= $Grid->RowIndex ?>_uploads"
        class="form-control ew-file-input"
        title="<?= $Grid->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_receipt_d"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Grid->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->uploads->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->uploads->ReadOnly || $Grid->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Grid->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_uploads" id= "fn_x<?= $Grid->RowIndex ?>_uploads" value="<?= $Grid->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_uploads" id= "fa_x<?= $Grid->RowIndex ?>_uploads" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_uploads") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_uploads" class="el_t_receipt_d_uploads">
<div id="fd_x<?= $Grid->RowIndex ?>_uploads">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_uploads"
        name="x<?= $Grid->RowIndex ?>_uploads"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_receipt_d"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Grid->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->uploads->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->uploads->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_uploads" id= "fn_x<?= $Grid->RowIndex ?>_uploads" value="<?= $Grid->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_uploads" id= "fa_x<?= $Grid->RowIndex ?>_uploads" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_uploads") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="t_receipt_d" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_operator" class="el_t_receipt_d_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_receipt_d" data-field="x_operator" data-hidden="1" name="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_operator" id="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="t_receipt_d" data-field="x_operator" data-hidden="1" data-old name="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_operator" id="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="t_receipt_d" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_receipt_d_datetime" class="el_t_receipt_d_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_receipt_d" data-field="x_datetime" data-hidden="1" name="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_datetime" id="ft_receipt_dgrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="t_receipt_d" data-field="x_datetime" data-hidden="1" data-old name="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_datetime" id="ft_receipt_dgrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["ft_receipt_dgrid","load"], () => ft_receipt_dgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ft_receipt_dgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_receipt_d");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
