<?php

namespace PHPMaker2024\fibre;

// Page object
$TReceiptBulkAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_receipt_bulk: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ft_receipt_bulkadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_receipt_bulkadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["r_from", [fields.r_from.visible && fields.r_from.required ? ew.Validators.required(fields.r_from.caption) : null], fields.r_from.isInvalid],
            ["r_to", [fields.r_to.visible && fields.r_to.required ? ew.Validators.required(fields.r_to.caption) : null, ew.Validators.integer], fields.r_to.isInvalid],
            ["trip", [fields.trip.visible && fields.trip.required ? ew.Validators.required(fields.trip.caption) : null], fields.trip.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "r_from": <?= $Page->r_from->toClientList($Page) ?>,
            "r_to": <?= $Page->r_to->toClientList($Page) ?>,
            "trip": <?= $Page->trip->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_receipt_bulkadd" id="ft_receipt_bulkadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_receipt_bulk">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->r_from->Visible) { // r_from ?>
    <div id="r_r_from"<?= $Page->r_from->rowAttributes() ?>>
        <label id="elh_t_receipt_bulk_r_from" class="<?= $Page->LeftColumnClass ?>"><?= $Page->r_from->caption() ?><?= $Page->r_from->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->r_from->cellAttributes() ?>>
<span id="el_t_receipt_bulk_r_from">
    <select
        id="x_r_from"
        name="x_r_from"
        class="form-control ew-select<?= $Page->r_from->isInvalidClass() ?>"
        data-select2-id="ft_receipt_bulkadd_x_r_from"
        data-table="t_receipt_bulk"
        data-field="x_r_from"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->r_from->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->r_from->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->r_from->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->r_from->editAttributes() ?>>
        <?= $Page->r_from->selectOptionListHtml("x_r_from") ?>
    </select>
    <?= $Page->r_from->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->r_from->getErrorMessage() ?></div>
<?= $Page->r_from->Lookup->getParamTag($Page, "p_x_r_from") ?>
<script>
loadjs.ready("ft_receipt_bulkadd", function() {
    var options = { name: "x_r_from", selectId: "ft_receipt_bulkadd_x_r_from" };
    if (ft_receipt_bulkadd.lists.r_from?.lookupOptions.length) {
        options.data = { id: "x_r_from", form: "ft_receipt_bulkadd" };
    } else {
        options.ajax = { id: "x_r_from", form: "ft_receipt_bulkadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_receipt_bulk.fields.r_from.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->r_to->Visible) { // r_to ?>
    <div id="r_r_to"<?= $Page->r_to->rowAttributes() ?>>
        <label id="elh_t_receipt_bulk_r_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->r_to->caption() ?><?= $Page->r_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->r_to->cellAttributes() ?>>
<span id="el_t_receipt_bulk_r_to">
    <select
        id="x_r_to"
        name="x_r_to"
        class="form-control ew-select<?= $Page->r_to->isInvalidClass() ?>"
        data-select2-id="ft_receipt_bulkadd_x_r_to"
        data-table="t_receipt_bulk"
        data-field="x_r_to"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->r_to->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->r_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->r_to->getPlaceHolder()) ?>"
        <?= $Page->r_to->editAttributes() ?>>
        <?= $Page->r_to->selectOptionListHtml("x_r_to") ?>
    </select>
    <?= $Page->r_to->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->r_to->getErrorMessage() ?></div>
<?= $Page->r_to->Lookup->getParamTag($Page, "p_x_r_to") ?>
<script>
loadjs.ready("ft_receipt_bulkadd", function() {
    var options = { name: "x_r_to", selectId: "ft_receipt_bulkadd_x_r_to" };
    if (ft_receipt_bulkadd.lists.r_to?.lookupOptions.length) {
        options.data = { id: "x_r_to", form: "ft_receipt_bulkadd" };
    } else {
        options.ajax = { id: "x_r_to", form: "ft_receipt_bulkadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_receipt_bulk.fields.r_to.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->trip->Visible) { // trip ?>
    <div id="r_trip"<?= $Page->trip->rowAttributes() ?>>
        <label id="elh_t_receipt_bulk_trip" class="<?= $Page->LeftColumnClass ?>"><?= $Page->trip->caption() ?><?= $Page->trip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->trip->cellAttributes() ?>>
<span id="el_t_receipt_bulk_trip">
<template id="tp_x_trip">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="t_receipt_bulk" data-field="x_trip" name="x_trip" id="x_trip"<?= $Page->trip->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_trip" class="ew-item-list"></div>
<selection-list hidden
    id="x_trip"
    name="x_trip"
    value="<?= HtmlEncode($Page->trip->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_trip"
    data-target="dsl_x_trip"
    data-repeatcolumn="1"
    class="form-control<?= $Page->trip->isInvalidClass() ?>"
    data-table="t_receipt_bulk"
    data-field="x_trip"
    data-value-separator="<?= $Page->trip->displayValueSeparatorAttribute() ?>"
    <?= $Page->trip->editAttributes() ?>></selection-list>
<?= $Page->trip->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->trip->getErrorMessage() ?></div>
<?= $Page->trip->Lookup->getParamTag($Page, "p_x_trip") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_t_receipt_bulk_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_t_receipt_bulk_amount">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="t_receipt_bulk" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?> aria-describedby="x_amount_help">
<?= $Page->amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_t_receipt_bulk_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_t_receipt_bulk_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="t_receipt_bulk" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_receipt_bulkadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_receipt_bulkadd", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_t_receipt_bulk_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_t_receipt_bulk_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="t_receipt_bulk" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_t_receipt_bulk_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_t_receipt_bulk_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_receipt_bulk"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_receipt_bulkadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_receipt_bulkadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_receipt_bulk");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
