<?php

namespace PHPMaker2024\fibre;

// Page object
$TMaintenanceAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_maintenance: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ft_maintenanceadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_maintenanceadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["vehicle_no", [fields.vehicle_no.visible && fields.vehicle_no.required ? ew.Validators.required(fields.vehicle_no.caption) : null], fields.vehicle_no.isInvalid],
            ["head", [fields.head.visible && fields.head.required ? ew.Validators.required(fields.head.caption) : null], fields.head.isInvalid],
            ["sub_head", [fields.sub_head.visible && fields.sub_head.required ? ew.Validators.required(fields.sub_head.caption) : null], fields.sub_head.isInvalid],
            ["km", [fields.km.visible && fields.km.required ? ew.Validators.required(fields.km.caption) : null, ew.Validators.integer], fields.km.isInvalid],
            ["life_km", [fields.life_km.visible && fields.life_km.required ? ew.Validators.required(fields.life_km.caption) : null, ew.Validators.integer], fields.life_km.isInvalid],
            ["s_no", [fields.s_no.visible && fields.s_no.required ? ew.Validators.required(fields.s_no.caption) : null], fields.s_no.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "vehicle_no": <?= $Page->vehicle_no->toClientList($Page) ?>,
            "head": <?= $Page->head->toClientList($Page) ?>,
            "sub_head": <?= $Page->sub_head->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_maintenanceadd" id="ft_maintenanceadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_maintenance">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->vehicle_no->Visible) { // vehicle_no ?>
    <div id="r_vehicle_no"<?= $Page->vehicle_no->rowAttributes() ?>>
        <label id="elh_t_maintenance_vehicle_no" for="x_vehicle_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->vehicle_no->caption() ?><?= $Page->vehicle_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->vehicle_no->cellAttributes() ?>>
<span id="el_t_maintenance_vehicle_no">
    <select
        id="x_vehicle_no"
        name="x_vehicle_no"
        class="form-select ew-select<?= $Page->vehicle_no->isInvalidClass() ?>"
        <?php if (!$Page->vehicle_no->IsNativeSelect) { ?>
        data-select2-id="ft_maintenanceadd_x_vehicle_no"
        <?php } ?>
        data-table="t_maintenance"
        data-field="x_vehicle_no"
        data-value-separator="<?= $Page->vehicle_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_no->getPlaceHolder()) ?>"
        <?= $Page->vehicle_no->editAttributes() ?>>
        <?= $Page->vehicle_no->selectOptionListHtml("x_vehicle_no") ?>
    </select>
    <?= $Page->vehicle_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->vehicle_no->getErrorMessage() ?></div>
<?= $Page->vehicle_no->Lookup->getParamTag($Page, "p_x_vehicle_no") ?>
<?php if (!$Page->vehicle_no->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_maintenanceadd", function() {
    var options = { name: "x_vehicle_no", selectId: "ft_maintenanceadd_x_vehicle_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_maintenanceadd.lists.vehicle_no?.lookupOptions.length) {
        options.data = { id: "x_vehicle_no", form: "ft_maintenanceadd" };
    } else {
        options.ajax = { id: "x_vehicle_no", form: "ft_maintenanceadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_maintenance.fields.vehicle_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->head->Visible) { // head ?>
    <div id="r_head"<?= $Page->head->rowAttributes() ?>>
        <label id="elh_t_maintenance_head" for="x_head" class="<?= $Page->LeftColumnClass ?>"><?= $Page->head->caption() ?><?= $Page->head->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->head->cellAttributes() ?>>
<span id="el_t_maintenance_head">
<div class="input-group flex-nowrap">
    <select
        id="x_head"
        name="x_head"
        class="form-select ew-select<?= $Page->head->isInvalidClass() ?>"
        <?php if (!$Page->head->IsNativeSelect) { ?>
        data-select2-id="ft_maintenanceadd_x_head"
        <?php } ?>
        data-table="t_maintenance"
        data-field="x_head"
        data-value-separator="<?= $Page->head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->head->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->head->editAttributes() ?>>
        <?= $Page->head->selectOptionListHtml("x_head") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "t_maintenance_info") && !$Page->head->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_head" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->head->caption() ?>" data-title="<?= $Page->head->caption() ?>" data-ew-action="add-option" data-el="x_head" data-url="<?= GetUrl("tmaintenanceinfoaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->head->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->head->getErrorMessage() ?></div>
<?= $Page->head->Lookup->getParamTag($Page, "p_x_head") ?>
<?php if (!$Page->head->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_maintenanceadd", function() {
    var options = { name: "x_head", selectId: "ft_maintenanceadd_x_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_maintenanceadd.lists.head?.lookupOptions.length) {
        options.data = { id: "x_head", form: "ft_maintenanceadd" };
    } else {
        options.ajax = { id: "x_head", form: "ft_maintenanceadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_maintenance.fields.head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sub_head->Visible) { // sub_head ?>
    <div id="r_sub_head"<?= $Page->sub_head->rowAttributes() ?>>
        <label id="elh_t_maintenance_sub_head" for="x_sub_head" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sub_head->caption() ?><?= $Page->sub_head->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sub_head->cellAttributes() ?>>
<span id="el_t_maintenance_sub_head">
<div class="input-group flex-nowrap">
    <select
        id="x_sub_head"
        name="x_sub_head"
        class="form-select ew-select<?= $Page->sub_head->isInvalidClass() ?>"
        <?php if (!$Page->sub_head->IsNativeSelect) { ?>
        data-select2-id="ft_maintenanceadd_x_sub_head"
        <?php } ?>
        data-table="t_maintenance"
        data-field="x_sub_head"
        data-value-separator="<?= $Page->sub_head->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sub_head->getPlaceHolder()) ?>"
        <?= $Page->sub_head->editAttributes() ?>>
        <?= $Page->sub_head->selectOptionListHtml("x_sub_head") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "t_maintenance_info") && !$Page->sub_head->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_sub_head" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->sub_head->caption() ?>" data-title="<?= $Page->sub_head->caption() ?>" data-ew-action="add-option" data-el="x_sub_head" data-url="<?= GetUrl("tmaintenanceinfoaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->sub_head->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sub_head->getErrorMessage() ?></div>
<?= $Page->sub_head->Lookup->getParamTag($Page, "p_x_sub_head") ?>
<?php if (!$Page->sub_head->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_maintenanceadd", function() {
    var options = { name: "x_sub_head", selectId: "ft_maintenanceadd_x_sub_head" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_maintenanceadd.lists.sub_head?.lookupOptions.length) {
        options.data = { id: "x_sub_head", form: "ft_maintenanceadd" };
    } else {
        options.ajax = { id: "x_sub_head", form: "ft_maintenanceadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_maintenance.fields.sub_head.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->km->Visible) { // km ?>
    <div id="r_km"<?= $Page->km->rowAttributes() ?>>
        <label id="elh_t_maintenance_km" for="x_km" class="<?= $Page->LeftColumnClass ?>"><?= $Page->km->caption() ?><?= $Page->km->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->km->cellAttributes() ?>>
<span id="el_t_maintenance_km">
<input type="<?= $Page->km->getInputTextType() ?>" name="x_km" id="x_km" data-table="t_maintenance" data-field="x_km" value="<?= $Page->km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->km->formatPattern()) ?>"<?= $Page->km->editAttributes() ?> aria-describedby="x_km_help">
<?= $Page->km->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->km->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->life_km->Visible) { // life_km ?>
    <div id="r_life_km"<?= $Page->life_km->rowAttributes() ?>>
        <label id="elh_t_maintenance_life_km" for="x_life_km" class="<?= $Page->LeftColumnClass ?>"><?= $Page->life_km->caption() ?><?= $Page->life_km->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->life_km->cellAttributes() ?>>
<span id="el_t_maintenance_life_km">
<input type="<?= $Page->life_km->getInputTextType() ?>" name="x_life_km" id="x_life_km" data-table="t_maintenance" data-field="x_life_km" value="<?= $Page->life_km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->life_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->life_km->formatPattern()) ?>"<?= $Page->life_km->editAttributes() ?> aria-describedby="x_life_km_help">
<?= $Page->life_km->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->life_km->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_no->Visible) { // s_no ?>
    <div id="r_s_no"<?= $Page->s_no->rowAttributes() ?>>
        <label id="elh_t_maintenance_s_no" for="x_s_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_no->caption() ?><?= $Page->s_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_no->cellAttributes() ?>>
<span id="el_t_maintenance_s_no">
<input type="<?= $Page->s_no->getInputTextType() ?>" name="x_s_no" id="x_s_no" data-table="t_maintenance" data-field="x_s_no" value="<?= $Page->s_no->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->s_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->s_no->formatPattern()) ?>"<?= $Page->s_no->editAttributes() ?> aria-describedby="x_s_no_help">
<?= $Page->s_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->s_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_t_maintenance_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_t_maintenance_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="t_maintenance" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_maintenanceadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_maintenanceadd", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_t_maintenance_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_t_maintenance_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="t_maintenance" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_maintenanceadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_maintenanceadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_maintenance");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
