<?php

namespace PHPMaker2024\fibre;

// Page object
$TLedgerSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_ledger: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ft_ledgersearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_ledgersearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["uid", [ew.Validators.integer], fields.uid.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["y_dated", [ew.Validators.between], false],
            ["name", [], fields.name.isInvalid],
            ["Balance", [ew.Validators.float], fields.Balance.isInvalid],
            ["cumulative_sum", [ew.Validators.float], fields.cumulative_sum.isInvalid],
            ["trip", [ew.Validators.integer], fields.trip.isInvalid],
            ["ref", [], fields.ref.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["uploads", [], fields.uploads.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "trip": <?= $Page->trip->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_ledgersearch" id="ft_ledgersearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_ledger">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->uid->Visible) { // uid ?>
    <div id="r_uid" class="row"<?= $Page->uid->rowAttributes() ?>>
        <label for="x_uid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_ledger_uid"><?= $Page->uid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_uid" id="z_uid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->uid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_ledger_uid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->uid->getInputTextType() ?>" name="x_uid" id="x_uid" data-table="t_ledger" data-field="x_uid" value="<?= $Page->uid->EditValue ?>" placeholder="<?= HtmlEncode($Page->uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uid->formatPattern()) ?>"<?= $Page->uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_ledger_dated"><?= $Page->dated->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_dated" id="z_dated" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->dated->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->dated->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_t_ledger_dated" class="ew-search-field">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="t_ledger" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_ledgersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_ledgersearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_t_ledger_dated" class="ew-search-field2 d-none">
<input type="<?= $Page->dated->getInputTextType() ?>" name="y_dated" id="y_dated" data-table="t_ledger" data-field="x_dated" value="<?= $Page->dated->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_ledgersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_ledgersearch", "y_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label for="x_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_ledger_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_ledger_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="t_ledger" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
    <div id="r_Balance" class="row"<?= $Page->Balance->rowAttributes() ?>>
        <label for="x_Balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_ledger_Balance"><?= $Page->Balance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Balance" id="z_Balance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_ledger_Balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Balance->getInputTextType() ?>" name="x_Balance" id="x_Balance" data-table="t_ledger" data-field="x_Balance" value="<?= $Page->Balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Balance->formatPattern()) ?>"<?= $Page->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cumulative_sum->Visible) { // cumulative_sum ?>
    <div id="r_cumulative_sum" class="row"<?= $Page->cumulative_sum->rowAttributes() ?>>
        <label for="x_cumulative_sum" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_ledger_cumulative_sum"><?= $Page->cumulative_sum->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cumulative_sum" id="z_cumulative_sum" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cumulative_sum->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_ledger_cumulative_sum" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cumulative_sum->getInputTextType() ?>" name="x_cumulative_sum" id="x_cumulative_sum" data-table="t_ledger" data-field="x_cumulative_sum" value="<?= $Page->cumulative_sum->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cumulative_sum->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cumulative_sum->formatPattern()) ?>"<?= $Page->cumulative_sum->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cumulative_sum->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->trip->Visible) { // trip ?>
    <div id="r_trip" class="row"<?= $Page->trip->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_ledger_trip"><?= $Page->trip->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_trip" id="z_trip" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->trip->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_ledger_trip" class="ew-search-field ew-search-field-single">
    <select
        id="x_trip"
        name="x_trip"
        class="form-control ew-select<?= $Page->trip->isInvalidClass() ?>"
        data-select2-id="ft_ledgersearch_x_trip"
        data-table="t_ledger"
        data-field="x_trip"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->trip->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->trip->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->trip->getPlaceHolder()) ?>"
        <?= $Page->trip->editAttributes() ?>>
        <?= $Page->trip->selectOptionListHtml("x_trip") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->trip->getErrorMessage(false) ?></div>
<?= $Page->trip->Lookup->getParamTag($Page, "p_x_trip") ?>
<script>
loadjs.ready("ft_ledgersearch", function() {
    var options = { name: "x_trip", selectId: "ft_ledgersearch_x_trip" };
    if (ft_ledgersearch.lists.trip?.lookupOptions.length) {
        options.data = { id: "x_trip", form: "ft_ledgersearch" };
    } else {
        options.ajax = { id: "x_trip", form: "ft_ledgersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_ledger.fields.trip.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref" class="row"<?= $Page->ref->rowAttributes() ?>>
        <label for="x_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_ledger_ref"><?= $Page->ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ref" id="z_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_ledger_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="t_ledger" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_ledger_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_ledger_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="t_ledger" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads" class="row"<?= $Page->uploads->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_ledger_uploads"><?= $Page->uploads->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_uploads" id="z_uploads" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->uploads->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_ledger_uploads" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->uploads->getInputTextType() ?>" name="x_uploads" id="x_uploads" data-table="t_ledger" data-field="x_uploads" value="<?= $Page->uploads->EditValue ?>" maxlength="192" placeholder="<?= HtmlEncode($Page->uploads->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uploads->formatPattern()) ?>"<?= $Page->uploads->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uploads->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_ledgersearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_ledgersearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ft_ledgersearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_ledger");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
