<?php

namespace PHPMaker2024\fibre;

// Page object
$TExpensesOEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="ft_expenses_oedit" id="ft_expenses_oedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_expenses_o: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var ft_expenses_oedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_expenses_oedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["trip", [fields.trip.visible && fields.trip.required ? ew.Validators.required(fields.trip.caption) : null], fields.trip.isInvalid],
            ["r_from", [fields.r_from.visible && fields.r_from.required ? ew.Validators.required(fields.r_from.caption) : null, ew.Validators.integer], fields.r_from.isInvalid],
            ["expense_type", [fields.expense_type.visible && fields.expense_type.required ? ew.Validators.required(fields.expense_type.caption) : null], fields.expense_type.isInvalid],
            ["expense_sub_type", [fields.expense_sub_type.visible && fields.expense_sub_type.required ? ew.Validators.required(fields.expense_sub_type.caption) : null], fields.expense_sub_type.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.integer], fields.amount.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "r_from": <?= $Page->r_from->toClientList($Page) ?>,
            "expense_type": <?= $Page->expense_type->toClientList($Page) ?>,
            "expense_sub_type": <?= $Page->expense_sub_type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_expenses_o">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "t_trip_info") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="t_trip_info">
<input type="hidden" name="fk_id" value="<?= HtmlEncode($Page->trip->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_t_expenses_o_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_t_expenses_o_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="t_expenses_o" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->trip->Visible) { // trip ?>
    <div id="r_trip"<?= $Page->trip->rowAttributes() ?>>
        <label id="elh_t_expenses_o_trip" class="<?= $Page->LeftColumnClass ?>"><?= $Page->trip->caption() ?><?= $Page->trip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->trip->cellAttributes() ?>>
<span id="el_t_expenses_o_trip">
<span<?= $Page->trip->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->trip->getDisplayValue($Page->trip->EditValue) ?></span></span>
<input type="hidden" data-table="t_expenses_o" data-field="x_trip" data-hidden="1" name="x_trip" id="x_trip" value="<?= HtmlEncode($Page->trip->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->r_from->Visible) { // r_from ?>
    <div id="r_r_from"<?= $Page->r_from->rowAttributes() ?>>
        <label id="elh_t_expenses_o_r_from" class="<?= $Page->LeftColumnClass ?>"><?= $Page->r_from->caption() ?><?= $Page->r_from->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->r_from->cellAttributes() ?>>
<span id="el_t_expenses_o_r_from">
    <select
        id="x_r_from"
        name="x_r_from"
        class="form-control ew-select<?= $Page->r_from->isInvalidClass() ?>"
        data-select2-id="ft_expenses_oedit_x_r_from"
        data-table="t_expenses_o"
        data-field="x_r_from"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->r_from->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->r_from->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->r_from->getPlaceHolder()) ?>"
        <?= $Page->r_from->editAttributes() ?>>
        <?= $Page->r_from->selectOptionListHtml("x_r_from") ?>
    </select>
    <?= $Page->r_from->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->r_from->getErrorMessage() ?></div>
<?= $Page->r_from->Lookup->getParamTag($Page, "p_x_r_from") ?>
<script>
loadjs.ready("ft_expenses_oedit", function() {
    var options = { name: "x_r_from", selectId: "ft_expenses_oedit_x_r_from" };
    if (ft_expenses_oedit.lists.r_from?.lookupOptions.length) {
        options.data = { id: "x_r_from", form: "ft_expenses_oedit" };
    } else {
        options.ajax = { id: "x_r_from", form: "ft_expenses_oedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_expenses_o.fields.r_from.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->expense_type->Visible) { // expense_type ?>
    <div id="r_expense_type"<?= $Page->expense_type->rowAttributes() ?>>
        <label id="elh_t_expenses_o_expense_type" for="x_expense_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->expense_type->caption() ?><?= $Page->expense_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->expense_type->cellAttributes() ?>>
<span id="el_t_expenses_o_expense_type">
    <select
        id="x_expense_type"
        name="x_expense_type"
        class="form-select ew-select<?= $Page->expense_type->isInvalidClass() ?>"
        <?php if (!$Page->expense_type->IsNativeSelect) { ?>
        data-select2-id="ft_expenses_oedit_x_expense_type"
        <?php } ?>
        data-table="t_expenses_o"
        data-field="x_expense_type"
        data-value-separator="<?= $Page->expense_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->expense_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->expense_type->editAttributes() ?>>
        <?= $Page->expense_type->selectOptionListHtml("x_expense_type") ?>
    </select>
    <?= $Page->expense_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->expense_type->getErrorMessage() ?></div>
<?= $Page->expense_type->Lookup->getParamTag($Page, "p_x_expense_type") ?>
<?php if (!$Page->expense_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_expenses_oedit", function() {
    var options = { name: "x_expense_type", selectId: "ft_expenses_oedit_x_expense_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_expenses_oedit.lists.expense_type?.lookupOptions.length) {
        options.data = { id: "x_expense_type", form: "ft_expenses_oedit" };
    } else {
        options.ajax = { id: "x_expense_type", form: "ft_expenses_oedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_expenses_o.fields.expense_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->expense_sub_type->Visible) { // expense_sub_type ?>
    <div id="r_expense_sub_type"<?= $Page->expense_sub_type->rowAttributes() ?>>
        <label id="elh_t_expenses_o_expense_sub_type" for="x_expense_sub_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->expense_sub_type->caption() ?><?= $Page->expense_sub_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->expense_sub_type->cellAttributes() ?>>
<span id="el_t_expenses_o_expense_sub_type">
    <select
        id="x_expense_sub_type"
        name="x_expense_sub_type"
        class="form-select ew-select<?= $Page->expense_sub_type->isInvalidClass() ?>"
        <?php if (!$Page->expense_sub_type->IsNativeSelect) { ?>
        data-select2-id="ft_expenses_oedit_x_expense_sub_type"
        <?php } ?>
        data-table="t_expenses_o"
        data-field="x_expense_sub_type"
        data-value-separator="<?= $Page->expense_sub_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->expense_sub_type->getPlaceHolder()) ?>"
        <?= $Page->expense_sub_type->editAttributes() ?>>
        <?= $Page->expense_sub_type->selectOptionListHtml("x_expense_sub_type") ?>
    </select>
    <?= $Page->expense_sub_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->expense_sub_type->getErrorMessage() ?></div>
<?= $Page->expense_sub_type->Lookup->getParamTag($Page, "p_x_expense_sub_type") ?>
<?php if (!$Page->expense_sub_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_expenses_oedit", function() {
    var options = { name: "x_expense_sub_type", selectId: "ft_expenses_oedit_x_expense_sub_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_expenses_oedit.lists.expense_sub_type?.lookupOptions.length) {
        options.data = { id: "x_expense_sub_type", form: "ft_expenses_oedit" };
    } else {
        options.ajax = { id: "x_expense_sub_type", form: "ft_expenses_oedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_expenses_o.fields.expense_sub_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_t_expenses_o_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_t_expenses_o_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="t_expenses_o" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_expenses_oedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_expenses_oedit", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_t_expenses_o_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_t_expenses_o_amount">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="t_expenses_o" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?> aria-describedby="x_amount_help">
<?= $Page->amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_t_expenses_o_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_t_expenses_o_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="t_expenses_o" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_t_expenses_o_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_t_expenses_o_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_expenses_o"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="<?= (Post("fa_x_uploads") == "0") ? "0" : "1" ?>">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_expenses_oedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_expenses_oedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_expenses_o");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
