<?php

namespace PHPMaker2024\fibre;

// Page object
$TExpensesList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_expenses: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "t_trip_expenses_report") {
    if ($Page->MasterRecordExists) {
        include_once "views/TTripExpensesReportMaster.php";
    }
}
?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ft_expensessrch" id="ft_expensessrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="ft_expensessrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_expenses: currentTable } });
var currentForm;
var ft_expensessrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_expensessrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="ft_expensessrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="ft_expensessrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="ft_expensessrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ft_expensessrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ft_expensessrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ft_expensessrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ft_expensessrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_expenses">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "t_trip_expenses_report" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="t_trip_expenses_report">
<input type="hidden" name="fk_trip" value="<?= HtmlEncode($Page->trip->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_t_expenses" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_t_expenseslist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_t_expenses_id" class="t_expenses_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->trip->Visible) { // trip ?>
        <th data-name="trip" class="<?= $Page->trip->headerCellClass() ?>"><div id="elh_t_expenses_trip" class="t_expenses_trip"><?= $Page->renderFieldHeader($Page->trip) ?></div></th>
<?php } ?>
<?php if ($Page->diesal->Visible) { // diesal ?>
        <th data-name="diesal" class="<?= $Page->diesal->headerCellClass() ?>"><div id="elh_t_expenses_diesal" class="t_expenses_diesal"><?= $Page->renderFieldHeader($Page->diesal) ?></div></th>
<?php } ?>
<?php if ($Page->border->Visible) { // border ?>
        <th data-name="border" class="<?= $Page->border->headerCellClass() ?>"><div id="elh_t_expenses_border" class="t_expenses_border"><?= $Page->renderFieldHeader($Page->border) ?></div></th>
<?php } ?>
<?php if ($Page->rto->Visible) { // rto ?>
        <th data-name="rto" class="<?= $Page->rto->headerCellClass() ?>"><div id="elh_t_expenses_rto" class="t_expenses_rto"><?= $Page->renderFieldHeader($Page->rto) ?></div></th>
<?php } ?>
<?php if ($Page->da->Visible) { // da ?>
        <th data-name="da" class="<?= $Page->da->headerCellClass() ?>"><div id="elh_t_expenses_da" class="t_expenses_da"><?= $Page->renderFieldHeader($Page->da) ?></div></th>
<?php } ?>
<?php if ($Page->repairing->Visible) { // repairing ?>
        <th data-name="repairing" class="<?= $Page->repairing->headerCellClass() ?>"><div id="elh_t_expenses_repairing" class="t_expenses_repairing"><?= $Page->renderFieldHeader($Page->repairing) ?></div></th>
<?php } ?>
<?php if ($Page->toll->Visible) { // toll ?>
        <th data-name="toll" class="<?= $Page->toll->headerCellClass() ?>"><div id="elh_t_expenses_toll" class="t_expenses_toll"><?= $Page->renderFieldHeader($Page->toll) ?></div></th>
<?php } ?>
<?php if ($Page->other->Visible) { // other ?>
        <th data-name="other" class="<?= $Page->other->headerCellClass() ?>"><div id="elh_t_expenses_other" class="t_expenses_other"><?= $Page->renderFieldHeader($Page->other) ?></div></th>
<?php } ?>
<?php if ($Page->cash_paid->Visible) { // cash_paid ?>
        <th data-name="cash_paid" class="<?= $Page->cash_paid->headerCellClass() ?>"><div id="elh_t_expenses_cash_paid" class="t_expenses_cash_paid"><?= $Page->renderFieldHeader($Page->cash_paid) ?></div></th>
<?php } ?>
<?php if ($Page->total->Visible) { // total ?>
        <th data-name="total" class="<?= $Page->total->headerCellClass() ?>"><div id="elh_t_expenses_total" class="t_expenses_total"><?= $Page->renderFieldHeader($Page->total) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_t_expenses_remarks" class="t_expenses_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
        <th data-name="dated" class="<?= $Page->dated->headerCellClass() ?>"><div id="elh_t_expenses_dated" class="t_expenses_dated"><?= $Page->renderFieldHeader($Page->dated) ?></div></th>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
        <th data-name="uploads" class="<?= $Page->uploads->headerCellClass() ?>"><div id="elh_t_expenses_uploads" class="t_expenses_uploads"><?= $Page->renderFieldHeader($Page->uploads) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_t_expenses_operator" class="t_expenses_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_t_expenses_datetime" class="t_expenses_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->diesal_lt->Visible) { // diesal_lt ?>
        <th data-name="diesal_lt" class="<?= $Page->diesal_lt->headerCellClass() ?>"><div id="elh_t_expenses_diesal_lt" class="t_expenses_diesal_lt"><?= $Page->renderFieldHeader($Page->diesal_lt) ?></div></th>
<?php } ?>
<?php if ($Page->def->Visible) { // def ?>
        <th data-name="def" class="<?= $Page->def->headerCellClass() ?>"><div id="elh_t_expenses_def" class="t_expenses_def"><?= $Page->renderFieldHeader($Page->def) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_id" class="el_t_expenses_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->trip->Visible) { // trip ?>
        <td data-name="trip"<?= $Page->trip->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_trip" class="el_t_expenses_trip">
<span<?= $Page->trip->viewAttributes() ?>>
<?= $Page->trip->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->diesal->Visible) { // diesal ?>
        <td data-name="diesal"<?= $Page->diesal->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_diesal" class="el_t_expenses_diesal">
<span<?= $Page->diesal->viewAttributes() ?>>
<?= $Page->diesal->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->border->Visible) { // border ?>
        <td data-name="border"<?= $Page->border->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_border" class="el_t_expenses_border">
<span<?= $Page->border->viewAttributes() ?>>
<?= $Page->border->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rto->Visible) { // rto ?>
        <td data-name="rto"<?= $Page->rto->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_rto" class="el_t_expenses_rto">
<span<?= $Page->rto->viewAttributes() ?>>
<?= $Page->rto->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->da->Visible) { // da ?>
        <td data-name="da"<?= $Page->da->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_da" class="el_t_expenses_da">
<span<?= $Page->da->viewAttributes() ?>>
<?= $Page->da->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->repairing->Visible) { // repairing ?>
        <td data-name="repairing"<?= $Page->repairing->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_repairing" class="el_t_expenses_repairing">
<span<?= $Page->repairing->viewAttributes() ?>>
<?= $Page->repairing->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->toll->Visible) { // toll ?>
        <td data-name="toll"<?= $Page->toll->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_toll" class="el_t_expenses_toll">
<span<?= $Page->toll->viewAttributes() ?>>
<?= $Page->toll->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->other->Visible) { // other ?>
        <td data-name="other"<?= $Page->other->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_other" class="el_t_expenses_other">
<span<?= $Page->other->viewAttributes() ?>>
<?= $Page->other->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cash_paid->Visible) { // cash_paid ?>
        <td data-name="cash_paid"<?= $Page->cash_paid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_cash_paid" class="el_t_expenses_cash_paid">
<span<?= $Page->cash_paid->viewAttributes() ?>>
<?= $Page->cash_paid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->total->Visible) { // total ?>
        <td data-name="total"<?= $Page->total->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_total" class="el_t_expenses_total">
<span<?= $Page->total->viewAttributes() ?>>
<?= $Page->total->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_remarks" class="el_t_expenses_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dated->Visible) { // dated ?>
        <td data-name="dated"<?= $Page->dated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_dated" class="el_t_expenses_dated">
<span<?= $Page->dated->viewAttributes() ?>>
<?= $Page->dated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->uploads->Visible) { // uploads ?>
        <td data-name="uploads"<?= $Page->uploads->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_uploads" class="el_t_expenses_uploads">
<span>
<?= GetFileViewTag($Page->uploads, $Page->uploads->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_operator" class="el_t_expenses_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_datetime" class="el_t_expenses_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->diesal_lt->Visible) { // diesal_lt ?>
        <td data-name="diesal_lt"<?= $Page->diesal_lt->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_diesal_lt" class="el_t_expenses_diesal_lt">
<span<?= $Page->diesal_lt->viewAttributes() ?>>
<?= $Page->diesal_lt->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->def->Visible) { // def ?>
        <td data-name="def"<?= $Page->def->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_expenses_def" class="el_t_expenses_def">
<span<?= $Page->def->viewAttributes() ?>>
<?= $Page->def->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_expenses");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
