<?php

namespace PHPMaker2024\fibre;

// Page object
$TExpensesInfoAddopt = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_expenses_info: currentTable } });
var currentPageID = ew.PAGE_ID = "addopt";
var currentForm;
var ft_expenses_infoaddopt;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_expenses_infoaddopt")
        .setPageId("addopt")

        // Add fields
        .setFields([
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["expense", [fields.expense.visible && fields.expense.required ? ew.Validators.required(fields.expense.caption) : null], fields.expense.isInvalid],
            ["image", [fields.image.visible && fields.image.required ? ew.Validators.fileRequired(fields.image.caption) : null], fields.image.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<form name="ft_expenses_infoaddopt" id="ft_expenses_infoaddopt" class="ew-form" action="<?= HtmlEncode(GetUrl(Config("API_URL"))) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="<?= Config("API_ACTION_NAME") ?>" id="<?= Config("API_ACTION_NAME") ?>" value="<?= Config("API_ADD_ACTION") ?>">
<input type="hidden" name="<?= Config("API_OBJECT_NAME") ?>" id="<?= Config("API_OBJECT_NAME") ?>" value="t_expenses_info">
<input type="hidden" name="addopt" id="addopt" value="1">
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_grp"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->grp->cellAttributes() ?>>
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="ft_expenses_infoaddopt_x_grp"
        <?php } ?>
        data-table="t_expenses_info"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_expenses_infoaddopt", function() {
    var options = { name: "x_grp", selectId: "ft_expenses_infoaddopt_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_expenses_infoaddopt.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "ft_expenses_infoaddopt" };
    } else {
        options.ajax = { id: "x_grp", form: "ft_expenses_infoaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_expenses_info.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->expense->Visible) { // expense ?>
    <div id="r_expense"<?= $Page->expense->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_expense"><?= $Page->expense->caption() ?><?= $Page->expense->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->expense->cellAttributes() ?>>
<input type="<?= $Page->expense->getInputTextType() ?>" name="x_expense" id="x_expense" data-table="t_expenses_info" data-field="x_expense" value="<?= $Page->expense->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->expense->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->expense->formatPattern()) ?>"<?= $Page->expense->editAttributes() ?> aria-describedby="x_expense_help">
<?= $Page->expense->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->expense->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image"<?= $Page->image->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label"><?= $Page->image->caption() ?><?= $Page->image->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->image->cellAttributes() ?>>
<div id="fd_x_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_image"
        name="x_image"
        class="form-control ew-file-input"
        title="<?= $Page->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_expenses_info"
        data-field="x_image"
        data-size="16777215"
        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_image_help"
        <?= ($Page->image->ReadOnly || $Page->image->Disabled) ? " disabled" : "" ?>
        <?= $Page->image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->image->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?= $Page->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<table id="ft_x_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_status"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->status->cellAttributes() ?>>
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="ft_expenses_infoaddopt_x_status"
        <?php } ?>
        data-table="t_expenses_info"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_expenses_infoaddopt", function() {
    var options = { name: "x_status", selectId: "ft_expenses_infoaddopt_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_expenses_infoaddopt.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "ft_expenses_infoaddopt" };
    } else {
        options.ajax = { id: "x_status", form: "ft_expenses_infoaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_expenses_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <input type="hidden" data-table="t_expenses_info" data-field="x_operator" data-hidden="1" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <input type="hidden" data-table="t_expenses_info" data-field="x_datetime" data-hidden="1" name="x_datetime" id="x_datetime" value="<?= HtmlEncode($Page->datetime->CurrentValue) ?>">
<?php } ?>
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_expenses_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
