<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("TExpensesGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var ft_expensesgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { t_expenses: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_expensesgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["trip", [fields.trip.visible && fields.trip.required ? ew.Validators.required(fields.trip.caption) : null], fields.trip.isInvalid],
            ["diesal", [fields.diesal.visible && fields.diesal.required ? ew.Validators.required(fields.diesal.caption) : null, ew.Validators.float], fields.diesal.isInvalid],
            ["border", [fields.border.visible && fields.border.required ? ew.Validators.required(fields.border.caption) : null, ew.Validators.float], fields.border.isInvalid],
            ["rto", [fields.rto.visible && fields.rto.required ? ew.Validators.required(fields.rto.caption) : null, ew.Validators.float], fields.rto.isInvalid],
            ["da", [fields.da.visible && fields.da.required ? ew.Validators.required(fields.da.caption) : null, ew.Validators.float], fields.da.isInvalid],
            ["repairing", [fields.repairing.visible && fields.repairing.required ? ew.Validators.required(fields.repairing.caption) : null, ew.Validators.float], fields.repairing.isInvalid],
            ["toll", [fields.toll.visible && fields.toll.required ? ew.Validators.required(fields.toll.caption) : null, ew.Validators.float], fields.toll.isInvalid],
            ["other", [fields.other.visible && fields.other.required ? ew.Validators.required(fields.other.caption) : null, ew.Validators.float], fields.other.isInvalid],
            ["cash_paid", [fields.cash_paid.visible && fields.cash_paid.required ? ew.Validators.required(fields.cash_paid.caption) : null, ew.Validators.float], fields.cash_paid.isInvalid],
            ["total", [fields.total.visible && fields.total.required ? ew.Validators.required(fields.total.caption) : null, ew.Validators.float], fields.total.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["diesal_lt", [fields.diesal_lt.visible && fields.diesal_lt.required ? ew.Validators.required(fields.diesal_lt.caption) : null, ew.Validators.float], fields.diesal_lt.isInvalid],
            ["def", [fields.def.visible && fields.def.required ? ew.Validators.required(fields.def.caption) : null, ew.Validators.float], fields.def.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["trip",false],["diesal",false],["border",false],["rto",false],["da",false],["repairing",false],["toll",false],["other",false],["cash_paid",false],["total",false],["remarks",false],["dated",false],["uploads",false],["diesal_lt",false],["def",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "trip": <?= $Grid->trip->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="ft_expensesgrid" class="ew-form ew-list-form">
<div id="gmp_t_expenses" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_t_expensesgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_t_expenses_id" class="t_expenses_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->trip->Visible) { // trip ?>
        <th data-name="trip" class="<?= $Grid->trip->headerCellClass() ?>"><div id="elh_t_expenses_trip" class="t_expenses_trip"><?= $Grid->renderFieldHeader($Grid->trip) ?></div></th>
<?php } ?>
<?php if ($Grid->diesal->Visible) { // diesal ?>
        <th data-name="diesal" class="<?= $Grid->diesal->headerCellClass() ?>"><div id="elh_t_expenses_diesal" class="t_expenses_diesal"><?= $Grid->renderFieldHeader($Grid->diesal) ?></div></th>
<?php } ?>
<?php if ($Grid->border->Visible) { // border ?>
        <th data-name="border" class="<?= $Grid->border->headerCellClass() ?>"><div id="elh_t_expenses_border" class="t_expenses_border"><?= $Grid->renderFieldHeader($Grid->border) ?></div></th>
<?php } ?>
<?php if ($Grid->rto->Visible) { // rto ?>
        <th data-name="rto" class="<?= $Grid->rto->headerCellClass() ?>"><div id="elh_t_expenses_rto" class="t_expenses_rto"><?= $Grid->renderFieldHeader($Grid->rto) ?></div></th>
<?php } ?>
<?php if ($Grid->da->Visible) { // da ?>
        <th data-name="da" class="<?= $Grid->da->headerCellClass() ?>"><div id="elh_t_expenses_da" class="t_expenses_da"><?= $Grid->renderFieldHeader($Grid->da) ?></div></th>
<?php } ?>
<?php if ($Grid->repairing->Visible) { // repairing ?>
        <th data-name="repairing" class="<?= $Grid->repairing->headerCellClass() ?>"><div id="elh_t_expenses_repairing" class="t_expenses_repairing"><?= $Grid->renderFieldHeader($Grid->repairing) ?></div></th>
<?php } ?>
<?php if ($Grid->toll->Visible) { // toll ?>
        <th data-name="toll" class="<?= $Grid->toll->headerCellClass() ?>"><div id="elh_t_expenses_toll" class="t_expenses_toll"><?= $Grid->renderFieldHeader($Grid->toll) ?></div></th>
<?php } ?>
<?php if ($Grid->other->Visible) { // other ?>
        <th data-name="other" class="<?= $Grid->other->headerCellClass() ?>"><div id="elh_t_expenses_other" class="t_expenses_other"><?= $Grid->renderFieldHeader($Grid->other) ?></div></th>
<?php } ?>
<?php if ($Grid->cash_paid->Visible) { // cash_paid ?>
        <th data-name="cash_paid" class="<?= $Grid->cash_paid->headerCellClass() ?>"><div id="elh_t_expenses_cash_paid" class="t_expenses_cash_paid"><?= $Grid->renderFieldHeader($Grid->cash_paid) ?></div></th>
<?php } ?>
<?php if ($Grid->total->Visible) { // total ?>
        <th data-name="total" class="<?= $Grid->total->headerCellClass() ?>"><div id="elh_t_expenses_total" class="t_expenses_total"><?= $Grid->renderFieldHeader($Grid->total) ?></div></th>
<?php } ?>
<?php if ($Grid->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Grid->remarks->headerCellClass() ?>"><div id="elh_t_expenses_remarks" class="t_expenses_remarks"><?= $Grid->renderFieldHeader($Grid->remarks) ?></div></th>
<?php } ?>
<?php if ($Grid->dated->Visible) { // dated ?>
        <th data-name="dated" class="<?= $Grid->dated->headerCellClass() ?>"><div id="elh_t_expenses_dated" class="t_expenses_dated"><?= $Grid->renderFieldHeader($Grid->dated) ?></div></th>
<?php } ?>
<?php if ($Grid->uploads->Visible) { // uploads ?>
        <th data-name="uploads" class="<?= $Grid->uploads->headerCellClass() ?>"><div id="elh_t_expenses_uploads" class="t_expenses_uploads"><?= $Grid->renderFieldHeader($Grid->uploads) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_t_expenses_operator" class="t_expenses_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_t_expenses_datetime" class="t_expenses_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php if ($Grid->diesal_lt->Visible) { // diesal_lt ?>
        <th data-name="diesal_lt" class="<?= $Grid->diesal_lt->headerCellClass() ?>"><div id="elh_t_expenses_diesal_lt" class="t_expenses_diesal_lt"><?= $Grid->renderFieldHeader($Grid->diesal_lt) ?></div></th>
<?php } ?>
<?php if ($Grid->def->Visible) { // def ?>
        <th data-name="def" class="<?= $Grid->def->headerCellClass() ?>"><div id="elh_t_expenses_def" class="t_expenses_def"><?= $Grid->renderFieldHeader($Grid->def) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_id" class="el_t_expenses_id"></span>
<input type="hidden" data-table="t_expenses" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_id" class="el_t_expenses_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="t_expenses" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_id" class="el_t_expenses_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_id" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_id" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_id" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_id" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="t_expenses" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->trip->Visible) { // trip ?>
        <td data-name="trip"<?= $Grid->trip->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->trip->getSessionValue() != "") { ?>
<span<?= $Grid->trip->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->trip->getDisplayValue($Grid->trip->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_trip" name="x<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_trip" class="el_t_expenses_trip">
    <select
        id="x<?= $Grid->RowIndex ?>_trip"
        name="x<?= $Grid->RowIndex ?>_trip"
        class="form-select ew-select<?= $Grid->trip->isInvalidClass() ?>"
        <?php if (!$Grid->trip->IsNativeSelect) { ?>
        data-select2-id="ft_expensesgrid_x<?= $Grid->RowIndex ?>_trip"
        <?php } ?>
        data-table="t_expenses"
        data-field="x_trip"
        data-value-separator="<?= $Grid->trip->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->trip->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Grid->trip->editAttributes() ?>>
        <?= $Grid->trip->selectOptionListHtml("x{$Grid->RowIndex}_trip") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->trip->getErrorMessage() ?></div>
<?= $Grid->trip->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_trip") ?>
<?php if (!$Grid->trip->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_expensesgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_trip", selectId: "ft_expensesgrid_x<?= $Grid->RowIndex ?>_trip" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_expensesgrid.lists.trip?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_trip", form: "ft_expensesgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_trip", form: "ft_expensesgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_expenses.fields.trip.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_trip" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_trip" id="o<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_trip" class="el_t_expenses_trip">
<span<?= $Grid->trip->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->trip->getDisplayValue($Grid->trip->EditValue) ?></span></span>
<input type="hidden" data-table="t_expenses" data-field="x_trip" data-hidden="1" name="x<?= $Grid->RowIndex ?>_trip" id="x<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_trip" class="el_t_expenses_trip">
<span<?= $Grid->trip->viewAttributes() ?>>
<?= $Grid->trip->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_trip" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_trip" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_trip" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_trip" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_trip" value="<?= HtmlEncode($Grid->trip->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->diesal->Visible) { // diesal ?>
        <td data-name="diesal"<?= $Grid->diesal->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_diesal" class="el_t_expenses_diesal">
<input type="<?= $Grid->diesal->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_diesal" id="x<?= $Grid->RowIndex ?>_diesal" data-table="t_expenses" data-field="x_diesal" value="<?= $Grid->diesal->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->diesal->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->diesal->formatPattern()) ?>"<?= $Grid->diesal->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->diesal->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_diesal" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_diesal" id="o<?= $Grid->RowIndex ?>_diesal" value="<?= HtmlEncode($Grid->diesal->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_diesal" class="el_t_expenses_diesal">
<input type="<?= $Grid->diesal->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_diesal" id="x<?= $Grid->RowIndex ?>_diesal" data-table="t_expenses" data-field="x_diesal" value="<?= $Grid->diesal->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->diesal->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->diesal->formatPattern()) ?>"<?= $Grid->diesal->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->diesal->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_diesal" class="el_t_expenses_diesal">
<span<?= $Grid->diesal->viewAttributes() ?>>
<?= $Grid->diesal->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_diesal" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_diesal" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_diesal" value="<?= HtmlEncode($Grid->diesal->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_diesal" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_diesal" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_diesal" value="<?= HtmlEncode($Grid->diesal->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->border->Visible) { // border ?>
        <td data-name="border"<?= $Grid->border->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_border" class="el_t_expenses_border">
<input type="<?= $Grid->border->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_border" id="x<?= $Grid->RowIndex ?>_border" data-table="t_expenses" data-field="x_border" value="<?= $Grid->border->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->border->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->border->formatPattern()) ?>"<?= $Grid->border->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->border->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_border" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_border" id="o<?= $Grid->RowIndex ?>_border" value="<?= HtmlEncode($Grid->border->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_border" class="el_t_expenses_border">
<input type="<?= $Grid->border->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_border" id="x<?= $Grid->RowIndex ?>_border" data-table="t_expenses" data-field="x_border" value="<?= $Grid->border->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->border->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->border->formatPattern()) ?>"<?= $Grid->border->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->border->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_border" class="el_t_expenses_border">
<span<?= $Grid->border->viewAttributes() ?>>
<?= $Grid->border->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_border" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_border" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_border" value="<?= HtmlEncode($Grid->border->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_border" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_border" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_border" value="<?= HtmlEncode($Grid->border->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->rto->Visible) { // rto ?>
        <td data-name="rto"<?= $Grid->rto->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_rto" class="el_t_expenses_rto">
<input type="<?= $Grid->rto->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_rto" id="x<?= $Grid->RowIndex ?>_rto" data-table="t_expenses" data-field="x_rto" value="<?= $Grid->rto->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->rto->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->rto->formatPattern()) ?>"<?= $Grid->rto->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->rto->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_rto" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_rto" id="o<?= $Grid->RowIndex ?>_rto" value="<?= HtmlEncode($Grid->rto->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_rto" class="el_t_expenses_rto">
<input type="<?= $Grid->rto->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_rto" id="x<?= $Grid->RowIndex ?>_rto" data-table="t_expenses" data-field="x_rto" value="<?= $Grid->rto->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->rto->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->rto->formatPattern()) ?>"<?= $Grid->rto->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->rto->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_rto" class="el_t_expenses_rto">
<span<?= $Grid->rto->viewAttributes() ?>>
<?= $Grid->rto->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_rto" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_rto" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_rto" value="<?= HtmlEncode($Grid->rto->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_rto" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_rto" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_rto" value="<?= HtmlEncode($Grid->rto->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->da->Visible) { // da ?>
        <td data-name="da"<?= $Grid->da->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_da" class="el_t_expenses_da">
<input type="<?= $Grid->da->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_da" id="x<?= $Grid->RowIndex ?>_da" data-table="t_expenses" data-field="x_da" value="<?= $Grid->da->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->da->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->da->formatPattern()) ?>"<?= $Grid->da->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->da->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_da" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_da" id="o<?= $Grid->RowIndex ?>_da" value="<?= HtmlEncode($Grid->da->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_da" class="el_t_expenses_da">
<input type="<?= $Grid->da->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_da" id="x<?= $Grid->RowIndex ?>_da" data-table="t_expenses" data-field="x_da" value="<?= $Grid->da->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->da->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->da->formatPattern()) ?>"<?= $Grid->da->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->da->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_da" class="el_t_expenses_da">
<span<?= $Grid->da->viewAttributes() ?>>
<?= $Grid->da->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_da" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_da" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_da" value="<?= HtmlEncode($Grid->da->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_da" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_da" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_da" value="<?= HtmlEncode($Grid->da->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->repairing->Visible) { // repairing ?>
        <td data-name="repairing"<?= $Grid->repairing->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_repairing" class="el_t_expenses_repairing">
<input type="<?= $Grid->repairing->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_repairing" id="x<?= $Grid->RowIndex ?>_repairing" data-table="t_expenses" data-field="x_repairing" value="<?= $Grid->repairing->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->repairing->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->repairing->formatPattern()) ?>"<?= $Grid->repairing->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->repairing->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_repairing" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_repairing" id="o<?= $Grid->RowIndex ?>_repairing" value="<?= HtmlEncode($Grid->repairing->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_repairing" class="el_t_expenses_repairing">
<input type="<?= $Grid->repairing->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_repairing" id="x<?= $Grid->RowIndex ?>_repairing" data-table="t_expenses" data-field="x_repairing" value="<?= $Grid->repairing->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->repairing->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->repairing->formatPattern()) ?>"<?= $Grid->repairing->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->repairing->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_repairing" class="el_t_expenses_repairing">
<span<?= $Grid->repairing->viewAttributes() ?>>
<?= $Grid->repairing->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_repairing" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_repairing" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_repairing" value="<?= HtmlEncode($Grid->repairing->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_repairing" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_repairing" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_repairing" value="<?= HtmlEncode($Grid->repairing->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->toll->Visible) { // toll ?>
        <td data-name="toll"<?= $Grid->toll->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_toll" class="el_t_expenses_toll">
<input type="<?= $Grid->toll->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_toll" id="x<?= $Grid->RowIndex ?>_toll" data-table="t_expenses" data-field="x_toll" value="<?= $Grid->toll->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->toll->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->toll->formatPattern()) ?>"<?= $Grid->toll->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->toll->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_toll" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_toll" id="o<?= $Grid->RowIndex ?>_toll" value="<?= HtmlEncode($Grid->toll->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_toll" class="el_t_expenses_toll">
<input type="<?= $Grid->toll->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_toll" id="x<?= $Grid->RowIndex ?>_toll" data-table="t_expenses" data-field="x_toll" value="<?= $Grid->toll->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->toll->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->toll->formatPattern()) ?>"<?= $Grid->toll->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->toll->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_toll" class="el_t_expenses_toll">
<span<?= $Grid->toll->viewAttributes() ?>>
<?= $Grid->toll->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_toll" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_toll" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_toll" value="<?= HtmlEncode($Grid->toll->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_toll" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_toll" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_toll" value="<?= HtmlEncode($Grid->toll->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->other->Visible) { // other ?>
        <td data-name="other"<?= $Grid->other->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_other" class="el_t_expenses_other">
<input type="<?= $Grid->other->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_other" id="x<?= $Grid->RowIndex ?>_other" data-table="t_expenses" data-field="x_other" value="<?= $Grid->other->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->other->formatPattern()) ?>"<?= $Grid->other->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->other->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_other" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_other" id="o<?= $Grid->RowIndex ?>_other" value="<?= HtmlEncode($Grid->other->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_other" class="el_t_expenses_other">
<input type="<?= $Grid->other->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_other" id="x<?= $Grid->RowIndex ?>_other" data-table="t_expenses" data-field="x_other" value="<?= $Grid->other->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->other->formatPattern()) ?>"<?= $Grid->other->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->other->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_other" class="el_t_expenses_other">
<span<?= $Grid->other->viewAttributes() ?>>
<?= $Grid->other->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_other" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_other" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_other" value="<?= HtmlEncode($Grid->other->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_other" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_other" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_other" value="<?= HtmlEncode($Grid->other->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->cash_paid->Visible) { // cash_paid ?>
        <td data-name="cash_paid"<?= $Grid->cash_paid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_cash_paid" class="el_t_expenses_cash_paid">
<input type="<?= $Grid->cash_paid->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_cash_paid" id="x<?= $Grid->RowIndex ?>_cash_paid" data-table="t_expenses" data-field="x_cash_paid" value="<?= $Grid->cash_paid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->cash_paid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->cash_paid->formatPattern()) ?>"<?= $Grid->cash_paid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->cash_paid->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_cash_paid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_cash_paid" id="o<?= $Grid->RowIndex ?>_cash_paid" value="<?= HtmlEncode($Grid->cash_paid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_cash_paid" class="el_t_expenses_cash_paid">
<input type="<?= $Grid->cash_paid->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_cash_paid" id="x<?= $Grid->RowIndex ?>_cash_paid" data-table="t_expenses" data-field="x_cash_paid" value="<?= $Grid->cash_paid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->cash_paid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->cash_paid->formatPattern()) ?>"<?= $Grid->cash_paid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->cash_paid->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_cash_paid" class="el_t_expenses_cash_paid">
<span<?= $Grid->cash_paid->viewAttributes() ?>>
<?= $Grid->cash_paid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_cash_paid" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_cash_paid" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_cash_paid" value="<?= HtmlEncode($Grid->cash_paid->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_cash_paid" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_cash_paid" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_cash_paid" value="<?= HtmlEncode($Grid->cash_paid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->total->Visible) { // total ?>
        <td data-name="total"<?= $Grid->total->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_total" class="el_t_expenses_total">
<input type="<?= $Grid->total->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_total" id="x<?= $Grid->RowIndex ?>_total" data-table="t_expenses" data-field="x_total" value="<?= $Grid->total->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->total->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->total->formatPattern()) ?>"<?= $Grid->total->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->total->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_total" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_total" id="o<?= $Grid->RowIndex ?>_total" value="<?= HtmlEncode($Grid->total->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_total" class="el_t_expenses_total">
<input type="<?= $Grid->total->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_total" id="x<?= $Grid->RowIndex ?>_total" data-table="t_expenses" data-field="x_total" value="<?= $Grid->total->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->total->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->total->formatPattern()) ?>"<?= $Grid->total->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->total->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_total" class="el_t_expenses_total">
<span<?= $Grid->total->viewAttributes() ?>>
<?= $Grid->total->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_total" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_total" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_total" value="<?= HtmlEncode($Grid->total->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_total" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_total" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_total" value="<?= HtmlEncode($Grid->total->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Grid->remarks->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_remarks" class="el_t_expenses_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="t_expenses" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_remarks" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_remarks" id="o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_remarks" class="el_t_expenses_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="t_expenses" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_remarks" class="el_t_expenses_remarks">
<span<?= $Grid->remarks->viewAttributes() ?>>
<?= $Grid->remarks->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_remarks" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_remarks" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_remarks" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_remarks" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->dated->Visible) { // dated ?>
        <td data-name="dated"<?= $Grid->dated->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_dated" class="el_t_expenses_dated">
<input type="<?= $Grid->dated->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_dated" id="x<?= $Grid->RowIndex ?>_dated" data-table="t_expenses" data-field="x_dated" value="<?= $Grid->dated->EditValue ?>" placeholder="<?= HtmlEncode($Grid->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->dated->formatPattern()) ?>"<?= $Grid->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->dated->getErrorMessage() ?></div>
<?php if (!$Grid->dated->ReadOnly && !$Grid->dated->Disabled && !isset($Grid->dated->EditAttrs["readonly"]) && !isset($Grid->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_expensesgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_expensesgrid", "x<?= $Grid->RowIndex ?>_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_dated" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_dated" id="o<?= $Grid->RowIndex ?>_dated" value="<?= HtmlEncode($Grid->dated->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_dated" class="el_t_expenses_dated">
<input type="<?= $Grid->dated->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_dated" id="x<?= $Grid->RowIndex ?>_dated" data-table="t_expenses" data-field="x_dated" value="<?= $Grid->dated->EditValue ?>" placeholder="<?= HtmlEncode($Grid->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->dated->formatPattern()) ?>"<?= $Grid->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->dated->getErrorMessage() ?></div>
<?php if (!$Grid->dated->ReadOnly && !$Grid->dated->Disabled && !isset($Grid->dated->EditAttrs["readonly"]) && !isset($Grid->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_expensesgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_expensesgrid", "x<?= $Grid->RowIndex ?>_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_dated" class="el_t_expenses_dated">
<span<?= $Grid->dated->viewAttributes() ?>>
<?= $Grid->dated->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_dated" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_dated" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_dated" value="<?= HtmlEncode($Grid->dated->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_dated" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_dated" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_dated" value="<?= HtmlEncode($Grid->dated->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->uploads->Visible) { // uploads ?>
        <td data-name="uploads"<?= $Grid->uploads->cellAttributes() ?>>
<?php if ($Grid->RowAction == "insert") { // Add record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex ?>_t_expenses_uploads" class="el_t_expenses_uploads">
<div id="fd_x<?= $Grid->RowIndex ?>_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_uploads"
        name="x<?= $Grid->RowIndex ?>_uploads"
        class="form-control ew-file-input"
        title="<?= $Grid->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_expenses"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Grid->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Grid->uploads->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Grid->uploads->ImageCropper ? 0 : 1 ?>"
        multiple
        <?= ($Grid->uploads->ReadOnly || $Grid->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Grid->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <div class="invalid-feedback"><?= $Grid->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_uploads" id= "fn_x<?= $Grid->RowIndex ?>_uploads" value="<?= $Grid->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_uploads" id= "fa_x<?= $Grid->RowIndex ?>_uploads" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex ?>_t_expenses_uploads" class="el_t_expenses_uploads">
<div id="fd_x<?= $Grid->RowIndex ?>_uploads">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_uploads"
        name="x<?= $Grid->RowIndex ?>_uploads"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_expenses"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Grid->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Grid->uploads->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Grid->uploads->ImageCropper ? 0 : 1 ?>"
        multiple
        <?= $Grid->uploads->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_uploads" id= "fn_x<?= $Grid->RowIndex ?>_uploads" value="<?= $Grid->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_uploads" id= "fa_x<?= $Grid->RowIndex ?>_uploads" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_uploads" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_uploads" id="o<?= $Grid->RowIndex ?>_uploads" value="<?= HtmlEncode($Grid->uploads->OldValue) ?>">
<?php } elseif ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_uploads" class="el_t_expenses_uploads">
<span>
<?= GetFileViewTag($Grid->uploads, $Grid->uploads->getViewValue(), false) ?>
</span>
</span>
<?php } else  { // Edit record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_uploads" class="el_t_expenses_uploads">
<div id="fd_x<?= $Grid->RowIndex ?>_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_uploads"
        name="x<?= $Grid->RowIndex ?>_uploads"
        class="form-control ew-file-input"
        title="<?= $Grid->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_expenses"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Grid->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Grid->uploads->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Grid->uploads->ImageCropper ? 0 : 1 ?>"
        multiple
        <?= ($Grid->uploads->ReadOnly || $Grid->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Grid->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <div class="invalid-feedback"><?= $Grid->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_uploads" id= "fn_x<?= $Grid->RowIndex ?>_uploads" value="<?= $Grid->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_uploads" id= "fa_x<?= $Grid->RowIndex ?>_uploads" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_uploads") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_uploads" class="el_t_expenses_uploads">
<div id="fd_x<?= $Grid->RowIndex ?>_uploads">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_uploads"
        name="x<?= $Grid->RowIndex ?>_uploads"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_expenses"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Grid->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Grid->uploads->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Grid->uploads->ImageCropper ? 0 : 1 ?>"
        multiple
        <?= $Grid->uploads->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_uploads" id= "fn_x<?= $Grid->RowIndex ?>_uploads" value="<?= $Grid->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_uploads" id= "fa_x<?= $Grid->RowIndex ?>_uploads" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_uploads") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="t_expenses" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_operator" class="el_t_expenses_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_operator" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_operator" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_operator" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_operator" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="t_expenses" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_datetime" class="el_t_expenses_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_datetime" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_datetime" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_datetime" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_datetime" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->diesal_lt->Visible) { // diesal_lt ?>
        <td data-name="diesal_lt"<?= $Grid->diesal_lt->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_diesal_lt" class="el_t_expenses_diesal_lt">
<input type="<?= $Grid->diesal_lt->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_diesal_lt" id="x<?= $Grid->RowIndex ?>_diesal_lt" data-table="t_expenses" data-field="x_diesal_lt" value="<?= $Grid->diesal_lt->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->diesal_lt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->diesal_lt->formatPattern()) ?>"<?= $Grid->diesal_lt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->diesal_lt->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_diesal_lt" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_diesal_lt" id="o<?= $Grid->RowIndex ?>_diesal_lt" value="<?= HtmlEncode($Grid->diesal_lt->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_diesal_lt" class="el_t_expenses_diesal_lt">
<input type="<?= $Grid->diesal_lt->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_diesal_lt" id="x<?= $Grid->RowIndex ?>_diesal_lt" data-table="t_expenses" data-field="x_diesal_lt" value="<?= $Grid->diesal_lt->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->diesal_lt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->diesal_lt->formatPattern()) ?>"<?= $Grid->diesal_lt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->diesal_lt->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_diesal_lt" class="el_t_expenses_diesal_lt">
<span<?= $Grid->diesal_lt->viewAttributes() ?>>
<?= $Grid->diesal_lt->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_diesal_lt" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_diesal_lt" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_diesal_lt" value="<?= HtmlEncode($Grid->diesal_lt->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_diesal_lt" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_diesal_lt" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_diesal_lt" value="<?= HtmlEncode($Grid->diesal_lt->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->def->Visible) { // def ?>
        <td data-name="def"<?= $Grid->def->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_def" class="el_t_expenses_def">
<input type="<?= $Grid->def->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_def" id="x<?= $Grid->RowIndex ?>_def" data-table="t_expenses" data-field="x_def" value="<?= $Grid->def->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->def->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->def->formatPattern()) ?>"<?= $Grid->def->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->def->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_def" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_def" id="o<?= $Grid->RowIndex ?>_def" value="<?= HtmlEncode($Grid->def->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_def" class="el_t_expenses_def">
<input type="<?= $Grid->def->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_def" id="x<?= $Grid->RowIndex ?>_def" data-table="t_expenses" data-field="x_def" value="<?= $Grid->def->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->def->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->def->formatPattern()) ?>"<?= $Grid->def->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->def->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_t_expenses_def" class="el_t_expenses_def">
<span<?= $Grid->def->viewAttributes() ?>>
<?= $Grid->def->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_def" data-hidden="1" name="ft_expensesgrid$x<?= $Grid->RowIndex ?>_def" id="ft_expensesgrid$x<?= $Grid->RowIndex ?>_def" value="<?= HtmlEncode($Grid->def->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_def" data-hidden="1" data-old name="ft_expensesgrid$o<?= $Grid->RowIndex ?>_def" id="ft_expensesgrid$o<?= $Grid->RowIndex ?>_def" value="<?= HtmlEncode($Grid->def->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["ft_expensesgrid","load"], () => ft_expensesgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ft_expensesgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_expenses");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
