<?php

namespace PHPMaker2024\fibre;

// Page object
$TExpensesAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_expenses: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ft_expensesadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_expensesadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["trip", [fields.trip.visible && fields.trip.required ? ew.Validators.required(fields.trip.caption) : null], fields.trip.isInvalid],
            ["diesal", [fields.diesal.visible && fields.diesal.required ? ew.Validators.required(fields.diesal.caption) : null, ew.Validators.float], fields.diesal.isInvalid],
            ["border", [fields.border.visible && fields.border.required ? ew.Validators.required(fields.border.caption) : null, ew.Validators.float], fields.border.isInvalid],
            ["rto", [fields.rto.visible && fields.rto.required ? ew.Validators.required(fields.rto.caption) : null, ew.Validators.float], fields.rto.isInvalid],
            ["da", [fields.da.visible && fields.da.required ? ew.Validators.required(fields.da.caption) : null, ew.Validators.float], fields.da.isInvalid],
            ["repairing", [fields.repairing.visible && fields.repairing.required ? ew.Validators.required(fields.repairing.caption) : null, ew.Validators.float], fields.repairing.isInvalid],
            ["toll", [fields.toll.visible && fields.toll.required ? ew.Validators.required(fields.toll.caption) : null, ew.Validators.float], fields.toll.isInvalid],
            ["other", [fields.other.visible && fields.other.required ? ew.Validators.required(fields.other.caption) : null, ew.Validators.float], fields.other.isInvalid],
            ["cash_paid", [fields.cash_paid.visible && fields.cash_paid.required ? ew.Validators.required(fields.cash_paid.caption) : null, ew.Validators.float], fields.cash_paid.isInvalid],
            ["total", [fields.total.visible && fields.total.required ? ew.Validators.required(fields.total.caption) : null, ew.Validators.float], fields.total.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["diesal_lt", [fields.diesal_lt.visible && fields.diesal_lt.required ? ew.Validators.required(fields.diesal_lt.caption) : null, ew.Validators.float], fields.diesal_lt.isInvalid],
            ["def", [fields.def.visible && fields.def.required ? ew.Validators.required(fields.def.caption) : null, ew.Validators.float], fields.def.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "trip": <?= $Page->trip->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_expensesadd" id="ft_expensesadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_expenses">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "t_trip_expenses_report") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="t_trip_expenses_report">
<input type="hidden" name="fk_trip" value="<?= HtmlEncode($Page->trip->getSessionValue()) ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->trip->Visible) { // trip ?>
    <div id="r_trip"<?= $Page->trip->rowAttributes() ?>>
        <label id="elh_t_expenses_trip" for="x_trip" class="<?= $Page->LeftColumnClass ?>"><?= $Page->trip->caption() ?><?= $Page->trip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->trip->cellAttributes() ?>>
<?php if ($Page->trip->getSessionValue() != "") { ?>
<span<?= $Page->trip->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->trip->getDisplayValue($Page->trip->ViewValue) ?></span></span>
<input type="hidden" id="x_trip" name="x_trip" value="<?= HtmlEncode($Page->trip->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_t_expenses_trip">
    <select
        id="x_trip"
        name="x_trip"
        class="form-select ew-select<?= $Page->trip->isInvalidClass() ?>"
        <?php if (!$Page->trip->IsNativeSelect) { ?>
        data-select2-id="ft_expensesadd_x_trip"
        <?php } ?>
        data-table="t_expenses"
        data-field="x_trip"
        data-value-separator="<?= $Page->trip->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->trip->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->trip->editAttributes() ?>>
        <?= $Page->trip->selectOptionListHtml("x_trip") ?>
    </select>
    <?= $Page->trip->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->trip->getErrorMessage() ?></div>
<?= $Page->trip->Lookup->getParamTag($Page, "p_x_trip") ?>
<?php if (!$Page->trip->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_expensesadd", function() {
    var options = { name: "x_trip", selectId: "ft_expensesadd_x_trip" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_expensesadd.lists.trip?.lookupOptions.length) {
        options.data = { id: "x_trip", form: "ft_expensesadd" };
    } else {
        options.ajax = { id: "x_trip", form: "ft_expensesadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_expenses.fields.trip.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->diesal->Visible) { // diesal ?>
    <div id="r_diesal"<?= $Page->diesal->rowAttributes() ?>>
        <label id="elh_t_expenses_diesal" for="x_diesal" class="<?= $Page->LeftColumnClass ?>"><?= $Page->diesal->caption() ?><?= $Page->diesal->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->diesal->cellAttributes() ?>>
<span id="el_t_expenses_diesal">
<input type="<?= $Page->diesal->getInputTextType() ?>" name="x_diesal" id="x_diesal" data-table="t_expenses" data-field="x_diesal" value="<?= $Page->diesal->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->diesal->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diesal->formatPattern()) ?>"<?= $Page->diesal->editAttributes() ?> aria-describedby="x_diesal_help">
<?= $Page->diesal->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->diesal->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->border->Visible) { // border ?>
    <div id="r_border"<?= $Page->border->rowAttributes() ?>>
        <label id="elh_t_expenses_border" for="x_border" class="<?= $Page->LeftColumnClass ?>"><?= $Page->border->caption() ?><?= $Page->border->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->border->cellAttributes() ?>>
<span id="el_t_expenses_border">
<input type="<?= $Page->border->getInputTextType() ?>" name="x_border" id="x_border" data-table="t_expenses" data-field="x_border" value="<?= $Page->border->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->border->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->border->formatPattern()) ?>"<?= $Page->border->editAttributes() ?> aria-describedby="x_border_help">
<?= $Page->border->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->border->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rto->Visible) { // rto ?>
    <div id="r_rto"<?= $Page->rto->rowAttributes() ?>>
        <label id="elh_t_expenses_rto" for="x_rto" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rto->caption() ?><?= $Page->rto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rto->cellAttributes() ?>>
<span id="el_t_expenses_rto">
<input type="<?= $Page->rto->getInputTextType() ?>" name="x_rto" id="x_rto" data-table="t_expenses" data-field="x_rto" value="<?= $Page->rto->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->rto->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rto->formatPattern()) ?>"<?= $Page->rto->editAttributes() ?> aria-describedby="x_rto_help">
<?= $Page->rto->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rto->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->da->Visible) { // da ?>
    <div id="r_da"<?= $Page->da->rowAttributes() ?>>
        <label id="elh_t_expenses_da" for="x_da" class="<?= $Page->LeftColumnClass ?>"><?= $Page->da->caption() ?><?= $Page->da->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->da->cellAttributes() ?>>
<span id="el_t_expenses_da">
<input type="<?= $Page->da->getInputTextType() ?>" name="x_da" id="x_da" data-table="t_expenses" data-field="x_da" value="<?= $Page->da->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->da->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->da->formatPattern()) ?>"<?= $Page->da->editAttributes() ?> aria-describedby="x_da_help">
<?= $Page->da->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->da->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->repairing->Visible) { // repairing ?>
    <div id="r_repairing"<?= $Page->repairing->rowAttributes() ?>>
        <label id="elh_t_expenses_repairing" for="x_repairing" class="<?= $Page->LeftColumnClass ?>"><?= $Page->repairing->caption() ?><?= $Page->repairing->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->repairing->cellAttributes() ?>>
<span id="el_t_expenses_repairing">
<input type="<?= $Page->repairing->getInputTextType() ?>" name="x_repairing" id="x_repairing" data-table="t_expenses" data-field="x_repairing" value="<?= $Page->repairing->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->repairing->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->repairing->formatPattern()) ?>"<?= $Page->repairing->editAttributes() ?> aria-describedby="x_repairing_help">
<?= $Page->repairing->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->repairing->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->toll->Visible) { // toll ?>
    <div id="r_toll"<?= $Page->toll->rowAttributes() ?>>
        <label id="elh_t_expenses_toll" for="x_toll" class="<?= $Page->LeftColumnClass ?>"><?= $Page->toll->caption() ?><?= $Page->toll->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->toll->cellAttributes() ?>>
<span id="el_t_expenses_toll">
<input type="<?= $Page->toll->getInputTextType() ?>" name="x_toll" id="x_toll" data-table="t_expenses" data-field="x_toll" value="<?= $Page->toll->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->toll->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->toll->formatPattern()) ?>"<?= $Page->toll->editAttributes() ?> aria-describedby="x_toll_help">
<?= $Page->toll->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->toll->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other->Visible) { // other ?>
    <div id="r_other"<?= $Page->other->rowAttributes() ?>>
        <label id="elh_t_expenses_other" for="x_other" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other->caption() ?><?= $Page->other->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other->cellAttributes() ?>>
<span id="el_t_expenses_other">
<input type="<?= $Page->other->getInputTextType() ?>" name="x_other" id="x_other" data-table="t_expenses" data-field="x_other" value="<?= $Page->other->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other->formatPattern()) ?>"<?= $Page->other->editAttributes() ?> aria-describedby="x_other_help">
<?= $Page->other->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cash_paid->Visible) { // cash_paid ?>
    <div id="r_cash_paid"<?= $Page->cash_paid->rowAttributes() ?>>
        <label id="elh_t_expenses_cash_paid" for="x_cash_paid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cash_paid->caption() ?><?= $Page->cash_paid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cash_paid->cellAttributes() ?>>
<span id="el_t_expenses_cash_paid">
<input type="<?= $Page->cash_paid->getInputTextType() ?>" name="x_cash_paid" id="x_cash_paid" data-table="t_expenses" data-field="x_cash_paid" value="<?= $Page->cash_paid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cash_paid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cash_paid->formatPattern()) ?>"<?= $Page->cash_paid->editAttributes() ?> aria-describedby="x_cash_paid_help">
<?= $Page->cash_paid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cash_paid->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->total->Visible) { // total ?>
    <div id="r_total"<?= $Page->total->rowAttributes() ?>>
        <label id="elh_t_expenses_total" for="x_total" class="<?= $Page->LeftColumnClass ?>"><?= $Page->total->caption() ?><?= $Page->total->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->total->cellAttributes() ?>>
<span id="el_t_expenses_total">
<input type="<?= $Page->total->getInputTextType() ?>" name="x_total" id="x_total" data-table="t_expenses" data-field="x_total" value="<?= $Page->total->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->total->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->total->formatPattern()) ?>"<?= $Page->total->editAttributes() ?> aria-describedby="x_total_help">
<?= $Page->total->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->total->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_t_expenses_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_t_expenses_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="t_expenses" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_t_expenses_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_t_expenses_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="t_expenses" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_expensesadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_expensesadd", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_t_expenses_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_t_expenses_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_expenses"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->uploads->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->diesal_lt->Visible) { // diesal_lt ?>
    <div id="r_diesal_lt"<?= $Page->diesal_lt->rowAttributes() ?>>
        <label id="elh_t_expenses_diesal_lt" for="x_diesal_lt" class="<?= $Page->LeftColumnClass ?>"><?= $Page->diesal_lt->caption() ?><?= $Page->diesal_lt->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->diesal_lt->cellAttributes() ?>>
<span id="el_t_expenses_diesal_lt">
<input type="<?= $Page->diesal_lt->getInputTextType() ?>" name="x_diesal_lt" id="x_diesal_lt" data-table="t_expenses" data-field="x_diesal_lt" value="<?= $Page->diesal_lt->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->diesal_lt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diesal_lt->formatPattern()) ?>"<?= $Page->diesal_lt->editAttributes() ?> aria-describedby="x_diesal_lt_help">
<?= $Page->diesal_lt->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->diesal_lt->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->def->Visible) { // def ?>
    <div id="r_def"<?= $Page->def->rowAttributes() ?>>
        <label id="elh_t_expenses_def" for="x_def" class="<?= $Page->LeftColumnClass ?>"><?= $Page->def->caption() ?><?= $Page->def->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->def->cellAttributes() ?>>
<span id="el_t_expenses_def">
<input type="<?= $Page->def->getInputTextType() ?>" name="x_def" id="x_def" data-table="t_expenses" data-field="x_def" value="<?= $Page->def->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->def->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->def->formatPattern()) ?>"<?= $Page->def->editAttributes() ?> aria-describedby="x_def_help">
<?= $Page->def->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->def->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_expensesadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_expensesadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_expenses");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
