<?php

namespace PHPMaker2024\fibre;

// Page object
$TDriverInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_driver_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ft_driver_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_driver_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["employee_id", [ew.Validators.integer], fields.employee_id.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["licence_no", [], fields.licence_no.isInvalid],
            ["licence_expiry", [ew.Validators.datetime(fields.licence_expiry.clientFormatPattern)], fields.licence_expiry.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["r_text", [], fields.r_text.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_driver_infosearch" id="ft_driver_infosearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_driver_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_driver_info_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_driver_info_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="t_driver_info" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
    <div id="r_employee_id" class="row"<?= $Page->employee_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_driver_info_employee_id"><?= $Page->employee_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_employee_id" id="z_employee_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->employee_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_driver_info_employee_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->employee_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_employee_id" class="ew-auto-suggest">
    <input type="<?= $Page->employee_id->getInputTextType() ?>" class="form-control" name="sv_x_employee_id" id="sv_x_employee_id" value="<?= RemoveHtml($Page->employee_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_id->formatPattern()) ?>"<?= $Page->employee_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="t_driver_info" data-field="x_employee_id" data-input="sv_x_employee_id" data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id" id="x_employee_id" value="<?= HtmlEncode($Page->employee_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("ft_driver_infosearch", function() {
    ft_driver_infosearch.createAutoSuggest(Object.assign({"id":"x_employee_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->employee_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.t_driver_info.fields.employee_id.autoSuggestOptions));
});
</script>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label for="x_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_driver_info_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_driver_info_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="t_driver_info" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->licence_no->Visible) { // licence_no ?>
    <div id="r_licence_no" class="row"<?= $Page->licence_no->rowAttributes() ?>>
        <label for="x_licence_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_driver_info_licence_no"><?= $Page->licence_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_licence_no" id="z_licence_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->licence_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_driver_info_licence_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->licence_no->getInputTextType() ?>" name="x_licence_no" id="x_licence_no" data-table="t_driver_info" data-field="x_licence_no" value="<?= $Page->licence_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->licence_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->licence_no->formatPattern()) ?>"<?= $Page->licence_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->licence_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->licence_expiry->Visible) { // licence_expiry ?>
    <div id="r_licence_expiry" class="row"<?= $Page->licence_expiry->rowAttributes() ?>>
        <label for="x_licence_expiry" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_driver_info_licence_expiry"><?= $Page->licence_expiry->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_licence_expiry" id="z_licence_expiry" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->licence_expiry->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_driver_info_licence_expiry" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->licence_expiry->getInputTextType() ?>" name="x_licence_expiry" id="x_licence_expiry" data-table="t_driver_info" data-field="x_licence_expiry" value="<?= $Page->licence_expiry->EditValue ?>" placeholder="<?= HtmlEncode($Page->licence_expiry->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->licence_expiry->formatPattern()) ?>"<?= $Page->licence_expiry->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->licence_expiry->getErrorMessage(false) ?></div>
<?php if (!$Page->licence_expiry->ReadOnly && !$Page->licence_expiry->Disabled && !isset($Page->licence_expiry->EditAttrs["readonly"]) && !isset($Page->licence_expiry->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_driver_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_driver_infosearch", "x_licence_expiry", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_driver_info_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_driver_info_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="t_driver_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="32" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_driver_info_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_driver_info_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="ft_driver_infosearch_x_status"
        <?php } ?>
        data-table="t_driver_info"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_driver_infosearch", function() {
    var options = { name: "x_status", selectId: "ft_driver_infosearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_driver_infosearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "ft_driver_infosearch" };
    } else {
        options.ajax = { id: "x_status", form: "ft_driver_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_driver_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_driver_info_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_driver_info_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="t_driver_info" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->r_text->Visible) { // r_text ?>
    <div id="r_r_text" class="row"<?= $Page->r_text->rowAttributes() ?>>
        <label for="x_r_text" class="<?= $Page->LeftColumnClass ?>"><span id="elh_t_driver_info_r_text"><?= $Page->r_text->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_r_text" id="z_r_text" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->r_text->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_t_driver_info_r_text" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->r_text->getInputTextType() ?>" name="x_r_text" id="x_r_text" data-table="t_driver_info" data-field="x_r_text" value="<?= $Page->r_text->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->r_text->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_text->formatPattern()) ?>"<?= $Page->r_text->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->r_text->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_driver_infosearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_driver_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ft_driver_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_driver_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
