<?php

namespace PHPMaker2024\fibre;

// Page object
$TDiesalExpensesDAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_diesal_expenses_d: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ft_diesal_expenses_dadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_diesal_expenses_dadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["trip", [fields.trip.visible && fields.trip.required ? ew.Validators.required(fields.trip.caption) : null], fields.trip.isInvalid],
            ["litre", [fields.litre.visible && fields.litre.required ? ew.Validators.required(fields.litre.caption) : null, ew.Validators.integer], fields.litre.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.integer], fields.amount.isInvalid],
            ["km", [fields.km.visible && fields.km.required ? ew.Validators.required(fields.km.caption) : null, ew.Validators.integer], fields.km.isInvalid],
            ["diesal_by", [fields.diesal_by.visible && fields.diesal_by.required ? ew.Validators.required(fields.diesal_by.caption) : null], fields.diesal_by.isInvalid],
            ["remakrs", [fields.remakrs.visible && fields.remakrs.required ? ew.Validators.required(fields.remakrs.caption) : null], fields.remakrs.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "trip": <?= $Page->trip->toClientList($Page) ?>,
            "diesal_by": <?= $Page->diesal_by->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_diesal_expenses_dadd" id="ft_diesal_expenses_dadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_diesal_expenses_d">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->trip->Visible) { // trip ?>
    <div id="r_trip"<?= $Page->trip->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_d_trip" class="<?= $Page->LeftColumnClass ?>"><?= $Page->trip->caption() ?><?= $Page->trip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->trip->cellAttributes() ?>>
<span id="el_t_diesal_expenses_d_trip">
<template id="tp_x_trip">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="t_diesal_expenses_d" data-field="x_trip" name="x_trip" id="x_trip"<?= $Page->trip->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_trip" class="ew-item-list"></div>
<selection-list hidden
    id="x_trip"
    name="x_trip"
    value="<?= HtmlEncode($Page->trip->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_trip"
    data-target="dsl_x_trip"
    data-repeatcolumn="5"
    class="form-control<?= $Page->trip->isInvalidClass() ?>"
    data-table="t_diesal_expenses_d"
    data-field="x_trip"
    data-value-separator="<?= $Page->trip->displayValueSeparatorAttribute() ?>"
    <?= $Page->trip->editAttributes() ?>></selection-list>
<?= $Page->trip->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->trip->getErrorMessage() ?></div>
<?= $Page->trip->Lookup->getParamTag($Page, "p_x_trip") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->litre->Visible) { // litre ?>
    <div id="r_litre"<?= $Page->litre->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_d_litre" for="x_litre" class="<?= $Page->LeftColumnClass ?>"><?= $Page->litre->caption() ?><?= $Page->litre->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->litre->cellAttributes() ?>>
<span id="el_t_diesal_expenses_d_litre">
<input type="<?= $Page->litre->getInputTextType() ?>" name="x_litre" id="x_litre" data-table="t_diesal_expenses_d" data-field="x_litre" value="<?= $Page->litre->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->litre->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->litre->formatPattern()) ?>"<?= $Page->litre->editAttributes() ?> aria-describedby="x_litre_help">
<?= $Page->litre->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->litre->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_d_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_t_diesal_expenses_d_amount">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="t_diesal_expenses_d" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?> aria-describedby="x_amount_help">
<?= $Page->amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->km->Visible) { // km ?>
    <div id="r_km"<?= $Page->km->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_d_km" for="x_km" class="<?= $Page->LeftColumnClass ?>"><?= $Page->km->caption() ?><?= $Page->km->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->km->cellAttributes() ?>>
<span id="el_t_diesal_expenses_d_km">
<input type="<?= $Page->km->getInputTextType() ?>" name="x_km" id="x_km" data-table="t_diesal_expenses_d" data-field="x_km" value="<?= $Page->km->EditValue ?>" placeholder="<?= HtmlEncode($Page->km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->km->formatPattern()) ?>"<?= $Page->km->editAttributes() ?> aria-describedby="x_km_help">
<?= $Page->km->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->km->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->diesal_by->Visible) { // diesal_by ?>
    <div id="r_diesal_by"<?= $Page->diesal_by->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_d_diesal_by" for="x_diesal_by" class="<?= $Page->LeftColumnClass ?>"><?= $Page->diesal_by->caption() ?><?= $Page->diesal_by->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->diesal_by->cellAttributes() ?>>
<span id="el_t_diesal_expenses_d_diesal_by">
    <select
        id="x_diesal_by"
        name="x_diesal_by"
        class="form-select ew-select<?= $Page->diesal_by->isInvalidClass() ?>"
        <?php if (!$Page->diesal_by->IsNativeSelect) { ?>
        data-select2-id="ft_diesal_expenses_dadd_x_diesal_by"
        <?php } ?>
        data-table="t_diesal_expenses_d"
        data-field="x_diesal_by"
        data-value-separator="<?= $Page->diesal_by->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->diesal_by->getPlaceHolder()) ?>"
        <?= $Page->diesal_by->editAttributes() ?>>
        <?= $Page->diesal_by->selectOptionListHtml("x_diesal_by") ?>
    </select>
    <?= $Page->diesal_by->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->diesal_by->getErrorMessage() ?></div>
<?= $Page->diesal_by->Lookup->getParamTag($Page, "p_x_diesal_by") ?>
<?php if (!$Page->diesal_by->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_diesal_expenses_dadd", function() {
    var options = { name: "x_diesal_by", selectId: "ft_diesal_expenses_dadd_x_diesal_by" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_diesal_expenses_dadd.lists.diesal_by?.lookupOptions.length) {
        options.data = { id: "x_diesal_by", form: "ft_diesal_expenses_dadd" };
    } else {
        options.ajax = { id: "x_diesal_by", form: "ft_diesal_expenses_dadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_diesal_expenses_d.fields.diesal_by.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remakrs->Visible) { // remakrs ?>
    <div id="r_remakrs"<?= $Page->remakrs->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_d_remakrs" for="x_remakrs" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remakrs->caption() ?><?= $Page->remakrs->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remakrs->cellAttributes() ?>>
<span id="el_t_diesal_expenses_d_remakrs">
<input type="<?= $Page->remakrs->getInputTextType() ?>" name="x_remakrs" id="x_remakrs" data-table="t_diesal_expenses_d" data-field="x_remakrs" value="<?= $Page->remakrs->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->remakrs->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remakrs->formatPattern()) ?>"<?= $Page->remakrs->editAttributes() ?> aria-describedby="x_remakrs_help">
<?= $Page->remakrs->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remakrs->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_d_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_t_diesal_expenses_d_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_diesal_expenses_d"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_diesal_expenses_dadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_diesal_expenses_dadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_diesal_expenses_d");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
