<?php

namespace PHPMaker2024\fibre;

// Page object
$TDiesalExpensesAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_diesal_expenses: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ft_diesal_expensesadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_diesal_expensesadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["trip", [fields.trip.visible && fields.trip.required ? ew.Validators.required(fields.trip.caption) : null, ew.Validators.integer], fields.trip.isInvalid],
            ["diesal_by", [fields.diesal_by.visible && fields.diesal_by.required ? ew.Validators.required(fields.diesal_by.caption) : null, ew.Validators.integer], fields.diesal_by.isInvalid],
            ["diesalreq", [fields.diesalreq.visible && fields.diesalreq.required ? ew.Validators.required(fields.diesalreq.caption) : null, ew.Validators.float], fields.diesalreq.isInvalid],
            ["diesalpaid", [fields.diesalpaid.visible && fields.diesalpaid.required ? ew.Validators.required(fields.diesalpaid.caption) : null, ew.Validators.float], fields.diesalpaid.isInvalid],
            ["litre", [fields.litre.visible && fields.litre.required ? ew.Validators.required(fields.litre.caption) : null, ew.Validators.float], fields.litre.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["km", [fields.km.visible && fields.km.required ? ew.Validators.required(fields.km.caption) : null, ew.Validators.float], fields.km.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "trip": <?= $Page->trip->toClientList($Page) ?>,
            "diesal_by": <?= $Page->diesal_by->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_diesal_expensesadd" id="ft_diesal_expensesadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_diesal_expenses">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "t_trip_info") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="t_trip_info">
<input type="hidden" name="fk_id" value="<?= HtmlEncode($Page->trip->getSessionValue()) ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->trip->Visible) { // trip ?>
    <div id="r_trip"<?= $Page->trip->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_trip" class="<?= $Page->LeftColumnClass ?>"><?= $Page->trip->caption() ?><?= $Page->trip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->trip->cellAttributes() ?>>
<?php if ($Page->trip->getSessionValue() != "") { ?>
<span<?= $Page->trip->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->trip->getDisplayValue($Page->trip->ViewValue) ?></span></span>
<input type="hidden" id="x_trip" name="x_trip" value="<?= HtmlEncode($Page->trip->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_t_diesal_expenses_trip">
    <select
        id="x_trip"
        name="x_trip"
        class="form-control ew-select<?= $Page->trip->isInvalidClass() ?>"
        data-select2-id="ft_diesal_expensesadd_x_trip"
        data-table="t_diesal_expenses"
        data-field="x_trip"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->trip->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->trip->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->trip->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->trip->editAttributes() ?>>
        <?= $Page->trip->selectOptionListHtml("x_trip") ?>
    </select>
    <?= $Page->trip->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->trip->getErrorMessage() ?></div>
<?= $Page->trip->Lookup->getParamTag($Page, "p_x_trip") ?>
<script>
loadjs.ready("ft_diesal_expensesadd", function() {
    var options = { name: "x_trip", selectId: "ft_diesal_expensesadd_x_trip" };
    if (ft_diesal_expensesadd.lists.trip?.lookupOptions.length) {
        options.data = { id: "x_trip", form: "ft_diesal_expensesadd" };
    } else {
        options.ajax = { id: "x_trip", form: "ft_diesal_expensesadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_diesal_expenses.fields.trip.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->diesal_by->Visible) { // diesal_by ?>
    <div id="r_diesal_by"<?= $Page->diesal_by->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_diesal_by" class="<?= $Page->LeftColumnClass ?>"><?= $Page->diesal_by->caption() ?><?= $Page->diesal_by->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->diesal_by->cellAttributes() ?>>
<span id="el_t_diesal_expenses_diesal_by">
    <select
        id="x_diesal_by"
        name="x_diesal_by"
        class="form-control ew-select<?= $Page->diesal_by->isInvalidClass() ?>"
        data-select2-id="ft_diesal_expensesadd_x_diesal_by"
        data-table="t_diesal_expenses"
        data-field="x_diesal_by"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->diesal_by->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->diesal_by->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->diesal_by->getPlaceHolder()) ?>"
        <?= $Page->diesal_by->editAttributes() ?>>
        <?= $Page->diesal_by->selectOptionListHtml("x_diesal_by") ?>
    </select>
    <?= $Page->diesal_by->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->diesal_by->getErrorMessage() ?></div>
<?= $Page->diesal_by->Lookup->getParamTag($Page, "p_x_diesal_by") ?>
<script>
loadjs.ready("ft_diesal_expensesadd", function() {
    var options = { name: "x_diesal_by", selectId: "ft_diesal_expensesadd_x_diesal_by" };
    if (ft_diesal_expensesadd.lists.diesal_by?.lookupOptions.length) {
        options.data = { id: "x_diesal_by", form: "ft_diesal_expensesadd" };
    } else {
        options.ajax = { id: "x_diesal_by", form: "ft_diesal_expensesadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_diesal_expenses.fields.diesal_by.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->diesalreq->Visible) { // diesalreq ?>
    <div id="r_diesalreq"<?= $Page->diesalreq->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_diesalreq" for="x_diesalreq" class="<?= $Page->LeftColumnClass ?>"><?= $Page->diesalreq->caption() ?><?= $Page->diesalreq->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->diesalreq->cellAttributes() ?>>
<span id="el_t_diesal_expenses_diesalreq">
<input type="<?= $Page->diesalreq->getInputTextType() ?>" name="x_diesalreq" id="x_diesalreq" data-table="t_diesal_expenses" data-field="x_diesalreq" value="<?= $Page->diesalreq->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->diesalreq->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diesalreq->formatPattern()) ?>"<?= $Page->diesalreq->editAttributes() ?> aria-describedby="x_diesalreq_help">
<?= $Page->diesalreq->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->diesalreq->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->diesalpaid->Visible) { // diesalpaid ?>
    <div id="r_diesalpaid"<?= $Page->diesalpaid->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_diesalpaid" for="x_diesalpaid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->diesalpaid->caption() ?><?= $Page->diesalpaid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->diesalpaid->cellAttributes() ?>>
<span id="el_t_diesal_expenses_diesalpaid">
<input type="<?= $Page->diesalpaid->getInputTextType() ?>" name="x_diesalpaid" id="x_diesalpaid" data-table="t_diesal_expenses" data-field="x_diesalpaid" value="<?= $Page->diesalpaid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->diesalpaid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diesalpaid->formatPattern()) ?>"<?= $Page->diesalpaid->editAttributes() ?> aria-describedby="x_diesalpaid_help">
<?= $Page->diesalpaid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->diesalpaid->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->litre->Visible) { // litre ?>
    <div id="r_litre"<?= $Page->litre->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_litre" for="x_litre" class="<?= $Page->LeftColumnClass ?>"><?= $Page->litre->caption() ?><?= $Page->litre->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->litre->cellAttributes() ?>>
<span id="el_t_diesal_expenses_litre">
<input type="<?= $Page->litre->getInputTextType() ?>" name="x_litre" id="x_litre" data-table="t_diesal_expenses" data-field="x_litre" value="<?= $Page->litre->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->litre->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->litre->formatPattern()) ?>"<?= $Page->litre->editAttributes() ?> aria-describedby="x_litre_help">
<?= $Page->litre->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->litre->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_t_diesal_expenses_amount">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="t_diesal_expenses" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?> aria-describedby="x_amount_help">
<?= $Page->amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->km->Visible) { // km ?>
    <div id="r_km"<?= $Page->km->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_km" for="x_km" class="<?= $Page->LeftColumnClass ?>"><?= $Page->km->caption() ?><?= $Page->km->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->km->cellAttributes() ?>>
<span id="el_t_diesal_expenses_km">
<input type="<?= $Page->km->getInputTextType() ?>" name="x_km" id="x_km" data-table="t_diesal_expenses" data-field="x_km" value="<?= $Page->km->EditValue ?>" placeholder="<?= HtmlEncode($Page->km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->km->formatPattern()) ?>"<?= $Page->km->editAttributes() ?> aria-describedby="x_km_help">
<?= $Page->km->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->km->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_t_diesal_expenses_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="t_diesal_expenses" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_diesal_expensesadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_diesal_expensesadd", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_t_diesal_expenses_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="t_diesal_expenses" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_t_diesal_expenses_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_t_diesal_expenses_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="t_diesal_expenses"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_diesal_expensesadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_diesal_expensesadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_diesal_expenses");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
