<?php

namespace PHPMaker2024\fibre;

// Page object
$TDailyKmList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_daily_km: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["vehicle_no", [fields.vehicle_no.visible && fields.vehicle_no.required ? ew.Validators.required(fields.vehicle_no.caption) : null, ew.Validators.integer], fields.vehicle_no.isInvalid],
            ["trip", [fields.trip.visible && fields.trip.required ? ew.Validators.required(fields.trip.caption) : null], fields.trip.isInvalid],
            ["driver", [fields.driver.visible && fields.driver.required ? ew.Validators.required(fields.driver.caption) : null], fields.driver.isInvalid],
            ["old_km", [fields.old_km.visible && fields.old_km.required ? ew.Validators.required(fields.old_km.caption) : null, ew.Validators.float], fields.old_km.isInvalid],
            ["km", [fields.km.visible && fields.km.required ? ew.Validators.required(fields.km.caption) : null, ew.Validators.integer], fields.km.isInvalid],
            ["run", [fields.run.visible && fields.run.required ? ew.Validators.required(fields.run.caption) : null, ew.Validators.float], fields.run.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "vehicle_no": <?= $Page->vehicle_no->toClientList($Page) ?>,
            "trip": <?= $Page->trip->toClientList($Page) ?>,
            "driver": <?= $Page->driver->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ft_daily_kmsrch" id="ft_daily_kmsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="ft_daily_kmsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_daily_km: currentTable } });
var currentForm;
var ft_daily_kmsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ft_daily_kmsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["vehicle_no", [ew.Validators.integer], fields.vehicle_no.isInvalid],
            ["trip", [], fields.trip.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "vehicle_no": <?= $Page->vehicle_no->toClientList($Page) ?>,
            "trip": <?= $Page->trip->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->vehicle_no->Visible) { // vehicle_no ?>
<?php
if (!$Page->vehicle_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_vehicle_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->vehicle_no->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->vehicle_no->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_vehicle_no" id="z_vehicle_no" value="=">
</div>
        </div>
        <div id="el_t_daily_km_vehicle_no" class="ew-search-field">
    <select
        id="x_vehicle_no"
        name="x_vehicle_no"
        class="form-control ew-select<?= $Page->vehicle_no->isInvalidClass() ?>"
        data-select2-id="ft_daily_kmsrch_x_vehicle_no"
        data-table="t_daily_km"
        data-field="x_vehicle_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->vehicle_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->vehicle_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_no->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->vehicle_no->editAttributes() ?>>
        <?= $Page->vehicle_no->selectOptionListHtml("x_vehicle_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle_no->getErrorMessage(false) ?></div>
<?= $Page->vehicle_no->Lookup->getParamTag($Page, "p_x_vehicle_no") ?>
<script>
loadjs.ready("ft_daily_kmsrch", function() {
    var options = { name: "x_vehicle_no", selectId: "ft_daily_kmsrch_x_vehicle_no" };
    if (ft_daily_kmsrch.lists.vehicle_no?.lookupOptions.length) {
        options.data = { id: "x_vehicle_no", form: "ft_daily_kmsrch" };
    } else {
        options.ajax = { id: "x_vehicle_no", form: "ft_daily_kmsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_daily_km.fields.vehicle_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->trip->Visible) { // trip ?>
<?php
if (!$Page->trip->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_trip" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->trip->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_trip" class="ew-search-caption ew-label"><?= $Page->trip->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_trip" id="z_trip" value="=">
</div>
        </div>
        <div id="el_t_daily_km_trip" class="ew-search-field">
    <select
        id="x_trip"
        name="x_trip"
        class="form-select ew-select<?= $Page->trip->isInvalidClass() ?>"
        <?php if (!$Page->trip->IsNativeSelect) { ?>
        data-select2-id="ft_daily_kmsrch_x_trip"
        <?php } ?>
        data-table="t_daily_km"
        data-field="x_trip"
        data-value-separator="<?= $Page->trip->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->trip->getPlaceHolder()) ?>"
        <?= $Page->trip->editAttributes() ?>>
        <?= $Page->trip->selectOptionListHtml("x_trip") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->trip->getErrorMessage(false) ?></div>
<?= $Page->trip->Lookup->getParamTag($Page, "p_x_trip") ?>
<?php if (!$Page->trip->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_daily_kmsrch", function() {
    var options = { name: "x_trip", selectId: "ft_daily_kmsrch_x_trip" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_daily_kmsrch.lists.trip?.lookupOptions.length) {
        options.data = { id: "x_trip", form: "ft_daily_kmsrch" };
    } else {
        options.ajax = { id: "x_trip", form: "ft_daily_kmsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_daily_km.fields.trip.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="ft_daily_kmsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="ft_daily_kmsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="ft_daily_kmsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ft_daily_kmsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ft_daily_kmsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ft_daily_kmsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ft_daily_kmsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_daily_km">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_t_daily_km" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_t_daily_kmlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_t_daily_km_id" class="t_daily_km_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->vehicle_no->Visible) { // vehicle_no ?>
        <th data-name="vehicle_no" class="<?= $Page->vehicle_no->headerCellClass() ?>"><div id="elh_t_daily_km_vehicle_no" class="t_daily_km_vehicle_no"><?= $Page->renderFieldHeader($Page->vehicle_no) ?></div></th>
<?php } ?>
<?php if ($Page->trip->Visible) { // trip ?>
        <th data-name="trip" class="<?= $Page->trip->headerCellClass() ?>"><div id="elh_t_daily_km_trip" class="t_daily_km_trip"><?= $Page->renderFieldHeader($Page->trip) ?></div></th>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
        <th data-name="driver" class="<?= $Page->driver->headerCellClass() ?>"><div id="elh_t_daily_km_driver" class="t_daily_km_driver"><?= $Page->renderFieldHeader($Page->driver) ?></div></th>
<?php } ?>
<?php if ($Page->old_km->Visible) { // old_km ?>
        <th data-name="old_km" class="<?= $Page->old_km->headerCellClass() ?>"><div id="elh_t_daily_km_old_km" class="t_daily_km_old_km"><?= $Page->renderFieldHeader($Page->old_km) ?></div></th>
<?php } ?>
<?php if ($Page->km->Visible) { // km ?>
        <th data-name="km" class="<?= $Page->km->headerCellClass() ?>"><div id="elh_t_daily_km_km" class="t_daily_km_km"><?= $Page->renderFieldHeader($Page->km) ?></div></th>
<?php } ?>
<?php if ($Page->run->Visible) { // run ?>
        <th data-name="run" class="<?= $Page->run->headerCellClass() ?>"><div id="elh_t_daily_km_run" class="t_daily_km_run"><?= $Page->renderFieldHeader($Page->run) ?></div></th>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
        <th data-name="dated" class="<?= $Page->dated->headerCellClass() ?>"><div id="elh_t_daily_km_dated" class="t_daily_km_dated"><?= $Page->renderFieldHeader($Page->dated) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_t_daily_km_remarks" class="t_daily_km_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_t_daily_km_operator" class="t_daily_km_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_t_daily_km_datetime" class="t_daily_km_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_id" class="el_t_daily_km_id"></span>
<input type="hidden" data-table="t_daily_km" data-field="x_id" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_id" id="o<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_id" class="el_t_daily_km_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="t_daily_km" data-field="x_id" data-hidden="1" name="x<?= $Page->RowIndex ?>_id" id="x<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_id" class="el_t_daily_km_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="t_daily_km" data-field="x_id" data-hidden="1" name="x<?= $Page->RowIndex ?>_id" id="x<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->vehicle_no->Visible) { // vehicle_no ?>
        <td data-name="vehicle_no"<?= $Page->vehicle_no->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_vehicle_no" class="el_t_daily_km_vehicle_no">
    <select
        id="x<?= $Page->RowIndex ?>_vehicle_no"
        name="x<?= $Page->RowIndex ?>_vehicle_no"
        class="form-control ew-select<?= $Page->vehicle_no->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_vehicle_no"
        data-table="t_daily_km"
        data-field="x_vehicle_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->vehicle_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->vehicle_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_no->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->vehicle_no->editAttributes() ?>>
        <?= $Page->vehicle_no->selectOptionListHtml("x{$Page->RowIndex}_vehicle_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle_no->getErrorMessage() ?></div>
<?= $Page->vehicle_no->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_vehicle_no") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_vehicle_no", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_vehicle_no" };
    if (<?= $Page->FormName ?>.lists.vehicle_no?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_vehicle_no", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_vehicle_no", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_daily_km.fields.vehicle_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_vehicle_no" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_vehicle_no" id="o<?= $Page->RowIndex ?>_vehicle_no" value="<?= HtmlEncode($Page->vehicle_no->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_vehicle_no" class="el_t_daily_km_vehicle_no">
    <select
        id="x<?= $Page->RowIndex ?>_vehicle_no"
        name="x<?= $Page->RowIndex ?>_vehicle_no"
        class="form-control ew-select<?= $Page->vehicle_no->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_vehicle_no"
        data-table="t_daily_km"
        data-field="x_vehicle_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->vehicle_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->vehicle_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_no->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->vehicle_no->editAttributes() ?>>
        <?= $Page->vehicle_no->selectOptionListHtml("x{$Page->RowIndex}_vehicle_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->vehicle_no->getErrorMessage() ?></div>
<?= $Page->vehicle_no->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_vehicle_no") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_vehicle_no", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_vehicle_no" };
    if (<?= $Page->FormName ?>.lists.vehicle_no?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_vehicle_no", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_vehicle_no", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_daily_km.fields.vehicle_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_vehicle_no" class="el_t_daily_km_vehicle_no">
<span<?= $Page->vehicle_no->viewAttributes() ?>>
<?= $Page->vehicle_no->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->trip->Visible) { // trip ?>
        <td data-name="trip"<?= $Page->trip->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_trip" class="el_t_daily_km_trip">
    <select
        id="x<?= $Page->RowIndex ?>_trip"
        name="x<?= $Page->RowIndex ?>_trip"
        class="form-select ew-select<?= $Page->trip->isInvalidClass() ?>"
        <?php if (!$Page->trip->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_trip"
        <?php } ?>
        data-table="t_daily_km"
        data-field="x_trip"
        data-value-separator="<?= $Page->trip->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->trip->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->trip->editAttributes() ?>>
        <?= $Page->trip->selectOptionListHtml("x{$Page->RowIndex}_trip") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->trip->getErrorMessage() ?></div>
<?= $Page->trip->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_trip") ?>
<?php if (!$Page->trip->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_trip", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_trip" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.trip?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_trip", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_trip", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_daily_km.fields.trip.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_trip" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_trip" id="o<?= $Page->RowIndex ?>_trip" value="<?= HtmlEncode($Page->trip->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_trip" class="el_t_daily_km_trip">
    <select
        id="x<?= $Page->RowIndex ?>_trip"
        name="x<?= $Page->RowIndex ?>_trip"
        class="form-select ew-select<?= $Page->trip->isInvalidClass() ?>"
        <?php if (!$Page->trip->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_trip"
        <?php } ?>
        data-table="t_daily_km"
        data-field="x_trip"
        data-value-separator="<?= $Page->trip->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->trip->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->trip->editAttributes() ?>>
        <?= $Page->trip->selectOptionListHtml("x{$Page->RowIndex}_trip") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->trip->getErrorMessage() ?></div>
<?= $Page->trip->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_trip") ?>
<?php if (!$Page->trip->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_trip", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_trip" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.trip?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_trip", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_trip", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_daily_km.fields.trip.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_trip" class="el_t_daily_km_trip">
<span<?= $Page->trip->viewAttributes() ?>>
<?= $Page->trip->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->driver->Visible) { // driver ?>
        <td data-name="driver"<?= $Page->driver->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_driver" class="el_t_daily_km_driver">
<?php
if (IsRTL()) {
    $Page->driver->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_driver" class="ew-auto-suggest">
    <input type="<?= $Page->driver->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_driver" id="sv_x<?= $Page->RowIndex ?>_driver" value="<?= RemoveHtml($Page->driver->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->driver->formatPattern()) ?>"<?= $Page->driver->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="t_daily_km" data-field="x_driver" data-input="sv_x<?= $Page->RowIndex ?>_driver" data-value-separator="<?= $Page->driver->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_driver" id="x<?= $Page->RowIndex ?>_driver" value="<?= HtmlEncode($Page->driver->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->driver->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_driver","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->driver->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.t_daily_km.fields.driver.autoSuggestOptions));
});
</script>
<?= $Page->driver->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_driver") ?>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_driver" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_driver" id="o<?= $Page->RowIndex ?>_driver" value="<?= HtmlEncode($Page->driver->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_driver" class="el_t_daily_km_driver">
<?php
if (IsRTL()) {
    $Page->driver->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_driver" class="ew-auto-suggest">
    <input type="<?= $Page->driver->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_driver" id="sv_x<?= $Page->RowIndex ?>_driver" value="<?= RemoveHtml($Page->driver->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->driver->formatPattern()) ?>"<?= $Page->driver->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="t_daily_km" data-field="x_driver" data-input="sv_x<?= $Page->RowIndex ?>_driver" data-value-separator="<?= $Page->driver->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_driver" id="x<?= $Page->RowIndex ?>_driver" value="<?= HtmlEncode($Page->driver->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->driver->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_driver","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->driver->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.t_daily_km.fields.driver.autoSuggestOptions));
});
</script>
<?= $Page->driver->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_driver") ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_driver" class="el_t_daily_km_driver">
<span<?= $Page->driver->viewAttributes() ?>>
<?= $Page->driver->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->old_km->Visible) { // old_km ?>
        <td data-name="old_km"<?= $Page->old_km->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_old_km" class="el_t_daily_km_old_km">
<input type="<?= $Page->old_km->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_old_km" id="x<?= $Page->RowIndex ?>_old_km" data-table="t_daily_km" data-field="x_old_km" value="<?= $Page->old_km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->old_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->old_km->formatPattern()) ?>"<?= $Page->old_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->old_km->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_old_km" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_old_km" id="o<?= $Page->RowIndex ?>_old_km" value="<?= HtmlEncode($Page->old_km->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_old_km" class="el_t_daily_km_old_km">
<input type="<?= $Page->old_km->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_old_km" id="x<?= $Page->RowIndex ?>_old_km" data-table="t_daily_km" data-field="x_old_km" value="<?= $Page->old_km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->old_km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->old_km->formatPattern()) ?>"<?= $Page->old_km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->old_km->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_old_km" class="el_t_daily_km_old_km">
<span<?= $Page->old_km->viewAttributes() ?>>
<?= $Page->old_km->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->km->Visible) { // km ?>
        <td data-name="km"<?= $Page->km->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_km" class="el_t_daily_km_km">
<input type="<?= $Page->km->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_km" id="x<?= $Page->RowIndex ?>_km" data-table="t_daily_km" data-field="x_km" value="<?= $Page->km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->km->formatPattern()) ?>"<?= $Page->km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->km->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_km" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_km" id="o<?= $Page->RowIndex ?>_km" value="<?= HtmlEncode($Page->km->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_km" class="el_t_daily_km_km">
<input type="<?= $Page->km->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_km" id="x<?= $Page->RowIndex ?>_km" data-table="t_daily_km" data-field="x_km" value="<?= $Page->km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->km->formatPattern()) ?>"<?= $Page->km->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->km->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_km" class="el_t_daily_km_km">
<span<?= $Page->km->viewAttributes() ?>>
<?= $Page->km->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->run->Visible) { // run ?>
        <td data-name="run"<?= $Page->run->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_run" class="el_t_daily_km_run">
<input type="<?= $Page->run->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_run" id="x<?= $Page->RowIndex ?>_run" data-table="t_daily_km" data-field="x_run" value="<?= $Page->run->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->run->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->run->formatPattern()) ?>"<?= $Page->run->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->run->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_run" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_run" id="o<?= $Page->RowIndex ?>_run" value="<?= HtmlEncode($Page->run->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_run" class="el_t_daily_km_run">
<input type="<?= $Page->run->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_run" id="x<?= $Page->RowIndex ?>_run" data-table="t_daily_km" data-field="x_run" value="<?= $Page->run->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->run->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->run->formatPattern()) ?>"<?= $Page->run->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->run->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_run" class="el_t_daily_km_run">
<span<?= $Page->run->viewAttributes() ?>>
<?= $Page->run->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->dated->Visible) { // dated ?>
        <td data-name="dated"<?= $Page->dated->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_dated" class="el_t_daily_km_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_dated" id="x<?= $Page->RowIndex ?>_dated" data-table="t_daily_km" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_dated" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_dated" id="o<?= $Page->RowIndex ?>_dated" value="<?= HtmlEncode($Page->dated->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_dated" class="el_t_daily_km_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_dated" id="x<?= $Page->RowIndex ?>_dated" data-table="t_daily_km" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_dated" class="el_t_daily_km_dated">
<span<?= $Page->dated->viewAttributes() ?>>
<?= $Page->dated->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_remarks" class="el_t_daily_km_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_remarks" id="x<?= $Page->RowIndex ?>_remarks" data-table="t_daily_km" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_remarks" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_remarks" id="o<?= $Page->RowIndex ?>_remarks" value="<?= HtmlEncode($Page->remarks->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_remarks" class="el_t_daily_km_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_remarks" id="x<?= $Page->RowIndex ?>_remarks" data-table="t_daily_km" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_remarks" class="el_t_daily_km_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="t_daily_km" data-field="x_operator" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_operator" id="o<?= $Page->RowIndex ?>_operator" value="<?= HtmlEncode($Page->operator->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_operator" class="el_t_daily_km_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="t_daily_km" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_datetime" id="o<?= $Page->RowIndex ?>_datetime" value="<?= HtmlEncode($Page->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_t_daily_km_datetime" class="el_t_daily_km_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_daily_km");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
