<?php

namespace PHPMaker2024\fibre;

// Page object
$TDailyKmAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { t_daily_km: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ft_daily_kmadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ft_daily_kmadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["vehicle_no", [fields.vehicle_no.visible && fields.vehicle_no.required ? ew.Validators.required(fields.vehicle_no.caption) : null, ew.Validators.integer], fields.vehicle_no.isInvalid],
            ["trip", [fields.trip.visible && fields.trip.required ? ew.Validators.required(fields.trip.caption) : null], fields.trip.isInvalid],
            ["driver", [fields.driver.visible && fields.driver.required ? ew.Validators.required(fields.driver.caption) : null], fields.driver.isInvalid],
            ["km", [fields.km.visible && fields.km.required ? ew.Validators.required(fields.km.caption) : null, ew.Validators.integer], fields.km.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "vehicle_no": <?= $Page->vehicle_no->toClientList($Page) ?>,
            "trip": <?= $Page->trip->toClientList($Page) ?>,
            "driver": <?= $Page->driver->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ft_daily_kmadd" id="ft_daily_kmadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="t_daily_km">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->vehicle_no->Visible) { // vehicle_no ?>
    <div id="r_vehicle_no"<?= $Page->vehicle_no->rowAttributes() ?>>
        <label id="elh_t_daily_km_vehicle_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->vehicle_no->caption() ?><?= $Page->vehicle_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->vehicle_no->cellAttributes() ?>>
<span id="el_t_daily_km_vehicle_no">
    <select
        id="x_vehicle_no"
        name="x_vehicle_no"
        class="form-control ew-select<?= $Page->vehicle_no->isInvalidClass() ?>"
        data-select2-id="ft_daily_kmadd_x_vehicle_no"
        data-table="t_daily_km"
        data-field="x_vehicle_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->vehicle_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->vehicle_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->vehicle_no->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->vehicle_no->editAttributes() ?>>
        <?= $Page->vehicle_no->selectOptionListHtml("x_vehicle_no") ?>
    </select>
    <?= $Page->vehicle_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->vehicle_no->getErrorMessage() ?></div>
<?= $Page->vehicle_no->Lookup->getParamTag($Page, "p_x_vehicle_no") ?>
<script>
loadjs.ready("ft_daily_kmadd", function() {
    var options = { name: "x_vehicle_no", selectId: "ft_daily_kmadd_x_vehicle_no" };
    if (ft_daily_kmadd.lists.vehicle_no?.lookupOptions.length) {
        options.data = { id: "x_vehicle_no", form: "ft_daily_kmadd" };
    } else {
        options.ajax = { id: "x_vehicle_no", form: "ft_daily_kmadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.t_daily_km.fields.vehicle_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->trip->Visible) { // trip ?>
    <div id="r_trip"<?= $Page->trip->rowAttributes() ?>>
        <label id="elh_t_daily_km_trip" for="x_trip" class="<?= $Page->LeftColumnClass ?>"><?= $Page->trip->caption() ?><?= $Page->trip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->trip->cellAttributes() ?>>
<span id="el_t_daily_km_trip">
    <select
        id="x_trip"
        name="x_trip"
        class="form-select ew-select<?= $Page->trip->isInvalidClass() ?>"
        <?php if (!$Page->trip->IsNativeSelect) { ?>
        data-select2-id="ft_daily_kmadd_x_trip"
        <?php } ?>
        data-table="t_daily_km"
        data-field="x_trip"
        data-value-separator="<?= $Page->trip->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->trip->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->trip->editAttributes() ?>>
        <?= $Page->trip->selectOptionListHtml("x_trip") ?>
    </select>
    <?= $Page->trip->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->trip->getErrorMessage() ?></div>
<?= $Page->trip->Lookup->getParamTag($Page, "p_x_trip") ?>
<?php if (!$Page->trip->IsNativeSelect) { ?>
<script>
loadjs.ready("ft_daily_kmadd", function() {
    var options = { name: "x_trip", selectId: "ft_daily_kmadd_x_trip" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ft_daily_kmadd.lists.trip?.lookupOptions.length) {
        options.data = { id: "x_trip", form: "ft_daily_kmadd" };
    } else {
        options.ajax = { id: "x_trip", form: "ft_daily_kmadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.t_daily_km.fields.trip.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->driver->Visible) { // driver ?>
    <div id="r_driver"<?= $Page->driver->rowAttributes() ?>>
        <label id="elh_t_daily_km_driver" class="<?= $Page->LeftColumnClass ?>"><?= $Page->driver->caption() ?><?= $Page->driver->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->driver->cellAttributes() ?>>
<span id="el_t_daily_km_driver">
<?php
if (IsRTL()) {
    $Page->driver->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_driver" class="ew-auto-suggest">
    <input type="<?= $Page->driver->getInputTextType() ?>" class="form-control" name="sv_x_driver" id="sv_x_driver" value="<?= RemoveHtml($Page->driver->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->driver->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->driver->formatPattern()) ?>"<?= $Page->driver->editAttributes() ?> aria-describedby="x_driver_help">
</span>
<selection-list hidden class="form-control" data-table="t_daily_km" data-field="x_driver" data-input="sv_x_driver" data-value-separator="<?= $Page->driver->displayValueSeparatorAttribute() ?>" name="x_driver" id="x_driver" value="<?= HtmlEncode($Page->driver->CurrentValue) ?>"></selection-list>
<?= $Page->driver->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->driver->getErrorMessage() ?></div>
<script>
loadjs.ready("ft_daily_kmadd", function() {
    ft_daily_kmadd.createAutoSuggest(Object.assign({"id":"x_driver","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->driver->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.t_daily_km.fields.driver.autoSuggestOptions));
});
</script>
<?= $Page->driver->Lookup->getParamTag($Page, "p_x_driver") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->km->Visible) { // km ?>
    <div id="r_km"<?= $Page->km->rowAttributes() ?>>
        <label id="elh_t_daily_km_km" for="x_km" class="<?= $Page->LeftColumnClass ?>"><?= $Page->km->caption() ?><?= $Page->km->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->km->cellAttributes() ?>>
<span id="el_t_daily_km_km">
<input type="<?= $Page->km->getInputTextType() ?>" name="x_km" id="x_km" data-table="t_daily_km" data-field="x_km" value="<?= $Page->km->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->km->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->km->formatPattern()) ?>"<?= $Page->km->editAttributes() ?> aria-describedby="x_km_help">
<?= $Page->km->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->km->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_t_daily_km_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_t_daily_km_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="t_daily_km" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ft_daily_kmadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ft_daily_kmadd", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_t_daily_km_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_t_daily_km_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="t_daily_km" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ft_daily_kmadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ft_daily_kmadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("t_daily_km");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
