<?php

namespace PHPMaker2024\fibre;

// Page object
$SubscriptionsView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fsubscriptionsview" id="fsubscriptionsview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { subscriptions: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fsubscriptionsview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fsubscriptionsview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="subscriptions">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->id->Visible) { // id ?>
    <tr id="r_id"<?= $Page->id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_subscriptions_id"><?= $Page->id->caption() ?></span></td>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el_subscriptions_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->user->Visible) { // user ?>
    <tr id="r_user"<?= $Page->user->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_subscriptions_user"><?= $Page->user->caption() ?></span></td>
        <td data-name="user"<?= $Page->user->cellAttributes() ?>>
<span id="el_subscriptions_user">
<span<?= $Page->user->viewAttributes() ?>>
<?= $Page->user->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->endpoint->Visible) { // endpoint ?>
    <tr id="r_endpoint"<?= $Page->endpoint->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_subscriptions_endpoint"><?= $Page->endpoint->caption() ?></span></td>
        <td data-name="endpoint"<?= $Page->endpoint->cellAttributes() ?>>
<span id="el_subscriptions_endpoint">
<span<?= $Page->endpoint->viewAttributes() ?>>
<?= $Page->endpoint->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->publickey->Visible) { // publickey ?>
    <tr id="r_publickey"<?= $Page->publickey->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_subscriptions_publickey"><?= $Page->publickey->caption() ?></span></td>
        <td data-name="publickey"<?= $Page->publickey->cellAttributes() ?>>
<span id="el_subscriptions_publickey">
<span<?= $Page->publickey->viewAttributes() ?>>
<?= $Page->publickey->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->authenticationtoken->Visible) { // authenticationtoken ?>
    <tr id="r_authenticationtoken"<?= $Page->authenticationtoken->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_subscriptions_authenticationtoken"><?= $Page->authenticationtoken->caption() ?></span></td>
        <td data-name="authenticationtoken"<?= $Page->authenticationtoken->cellAttributes() ?>>
<span id="el_subscriptions_authenticationtoken">
<span<?= $Page->authenticationtoken->viewAttributes() ?>>
<?= $Page->authenticationtoken->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->contentencoding->Visible) { // contentencoding ?>
    <tr id="r_contentencoding"<?= $Page->contentencoding->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_subscriptions_contentencoding"><?= $Page->contentencoding->caption() ?></span></td>
        <td data-name="contentencoding"<?= $Page->contentencoding->cellAttributes() ?>>
<span id="el_subscriptions_contentencoding">
<span<?= $Page->contentencoding->viewAttributes() ?>>
<?= $Page->contentencoding->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
