<?php

namespace PHPMaker2024\fibre;

// Page object
$SubscriptionsAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { subscriptions: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fsubscriptionsadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fsubscriptionsadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["user", [fields.user.visible && fields.user.required ? ew.Validators.required(fields.user.caption) : null], fields.user.isInvalid],
            ["endpoint", [fields.endpoint.visible && fields.endpoint.required ? ew.Validators.required(fields.endpoint.caption) : null], fields.endpoint.isInvalid],
            ["publickey", [fields.publickey.visible && fields.publickey.required ? ew.Validators.required(fields.publickey.caption) : null], fields.publickey.isInvalid],
            ["authenticationtoken", [fields.authenticationtoken.visible && fields.authenticationtoken.required ? ew.Validators.required(fields.authenticationtoken.caption) : null], fields.authenticationtoken.isInvalid],
            ["contentencoding", [fields.contentencoding.visible && fields.contentencoding.required ? ew.Validators.required(fields.contentencoding.caption) : null], fields.contentencoding.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fsubscriptionsadd" id="fsubscriptionsadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="subscriptions">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->user->Visible) { // user ?>
    <div id="r_user"<?= $Page->user->rowAttributes() ?>>
        <label id="elh_subscriptions_user" for="x_user" class="<?= $Page->LeftColumnClass ?>"><?= $Page->user->caption() ?><?= $Page->user->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->user->cellAttributes() ?>>
<span id="el_subscriptions_user">
<input type="<?= $Page->user->getInputTextType() ?>" name="x_user" id="x_user" data-table="subscriptions" data-field="x_user" value="<?= $Page->user->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->user->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user->formatPattern()) ?>"<?= $Page->user->editAttributes() ?> aria-describedby="x_user_help">
<?= $Page->user->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->user->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->endpoint->Visible) { // endpoint ?>
    <div id="r_endpoint"<?= $Page->endpoint->rowAttributes() ?>>
        <label id="elh_subscriptions_endpoint" for="x_endpoint" class="<?= $Page->LeftColumnClass ?>"><?= $Page->endpoint->caption() ?><?= $Page->endpoint->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->endpoint->cellAttributes() ?>>
<span id="el_subscriptions_endpoint">
<textarea data-table="subscriptions" data-field="x_endpoint" name="x_endpoint" id="x_endpoint" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->endpoint->getPlaceHolder()) ?>"<?= $Page->endpoint->editAttributes() ?> aria-describedby="x_endpoint_help"><?= $Page->endpoint->EditValue ?></textarea>
<?= $Page->endpoint->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->endpoint->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->publickey->Visible) { // publickey ?>
    <div id="r_publickey"<?= $Page->publickey->rowAttributes() ?>>
        <label id="elh_subscriptions_publickey" for="x_publickey" class="<?= $Page->LeftColumnClass ?>"><?= $Page->publickey->caption() ?><?= $Page->publickey->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->publickey->cellAttributes() ?>>
<span id="el_subscriptions_publickey">
<input type="<?= $Page->publickey->getInputTextType() ?>" name="x_publickey" id="x_publickey" data-table="subscriptions" data-field="x_publickey" value="<?= $Page->publickey->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->publickey->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->publickey->formatPattern()) ?>"<?= $Page->publickey->editAttributes() ?> aria-describedby="x_publickey_help">
<?= $Page->publickey->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->publickey->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->authenticationtoken->Visible) { // authenticationtoken ?>
    <div id="r_authenticationtoken"<?= $Page->authenticationtoken->rowAttributes() ?>>
        <label id="elh_subscriptions_authenticationtoken" for="x_authenticationtoken" class="<?= $Page->LeftColumnClass ?>"><?= $Page->authenticationtoken->caption() ?><?= $Page->authenticationtoken->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->authenticationtoken->cellAttributes() ?>>
<span id="el_subscriptions_authenticationtoken">
<input type="<?= $Page->authenticationtoken->getInputTextType() ?>" name="x_authenticationtoken" id="x_authenticationtoken" data-table="subscriptions" data-field="x_authenticationtoken" value="<?= $Page->authenticationtoken->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->authenticationtoken->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->authenticationtoken->formatPattern()) ?>"<?= $Page->authenticationtoken->editAttributes() ?> aria-describedby="x_authenticationtoken_help">
<?= $Page->authenticationtoken->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->authenticationtoken->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->contentencoding->Visible) { // contentencoding ?>
    <div id="r_contentencoding"<?= $Page->contentencoding->rowAttributes() ?>>
        <label id="elh_subscriptions_contentencoding" for="x_contentencoding" class="<?= $Page->LeftColumnClass ?>"><?= $Page->contentencoding->caption() ?><?= $Page->contentencoding->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->contentencoding->cellAttributes() ?>>
<span id="el_subscriptions_contentencoding">
<input type="<?= $Page->contentencoding->getInputTextType() ?>" name="x_contentencoding" id="x_contentencoding" data-table="subscriptions" data-field="x_contentencoding" value="<?= $Page->contentencoding->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->contentencoding->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->contentencoding->formatPattern()) ?>"<?= $Page->contentencoding->editAttributes() ?> aria-describedby="x_contentencoding_help">
<?= $Page->contentencoding->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->contentencoding->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fsubscriptionsadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fsubscriptionsadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("subscriptions");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
