<?php

namespace PHPMaker2024\fibre;

// Page object
$StockSetupEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fstock_setupedit" id="fstock_setupedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { stock_setup: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fstock_setupedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fstock_setupedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null, ew.Validators.integer], fields.id.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["date_from", [fields.date_from.visible && fields.date_from.required ? ew.Validators.required(fields.date_from.caption) : null, ew.Validators.datetime(fields.date_from.clientFormatPattern)], fields.date_from.isInvalid],
            ["date_to", [fields.date_to.visible && fields.date_to.required ? ew.Validators.required(fields.date_to.caption) : null, ew.Validators.datetime(fields.date_to.clientFormatPattern)], fields.date_to.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["stock_complete_lot_id", [fields.stock_complete_lot_id.visible && fields.stock_complete_lot_id.required ? ew.Validators.required(fields.stock_complete_lot_id.caption) : null], fields.stock_complete_lot_id.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "rid": <?= $Page->rid->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="stock_setup">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_stock_setup_id" for="x_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_stock_setup_id">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="stock_setup" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?> aria-describedby="x_id_help">
<?= $Page->id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage() ?></div>
<input type="hidden" data-table="stock_setup" data-field="x_id" data-hidden="1" data-old name="o_id" id="o_id" value="<?= HtmlEncode($Page->id->OldValue ?? $Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label id="elh_stock_setup_rid" for="x_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid->cellAttributes() ?>>
<span id="el_stock_setup_rid">
    <select
        id="x_rid"
        name="x_rid"
        class="form-select ew-select<?= $Page->rid->isInvalidClass() ?>"
        <?php if (!$Page->rid->IsNativeSelect) { ?>
        data-select2-id="fstock_setupedit_x_rid"
        <?php } ?>
        data-table="stock_setup"
        data-field="x_rid"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <?= $Page->rid->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage() ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<?php if (!$Page->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_setupedit", function() {
    var options = { name: "x_rid", selectId: "fstock_setupedit_x_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_setupedit.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fstock_setupedit" };
    } else {
        options.ajax = { id: "x_rid", form: "fstock_setupedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_setup.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->date_from->Visible) { // date_from ?>
    <div id="r_date_from"<?= $Page->date_from->rowAttributes() ?>>
        <label id="elh_stock_setup_date_from" for="x_date_from" class="<?= $Page->LeftColumnClass ?>"><?= $Page->date_from->caption() ?><?= $Page->date_from->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->date_from->cellAttributes() ?>>
<span id="el_stock_setup_date_from">
<input type="<?= $Page->date_from->getInputTextType() ?>" name="x_date_from" id="x_date_from" data-table="stock_setup" data-field="x_date_from" value="<?= $Page->date_from->EditValue ?>" placeholder="<?= HtmlEncode($Page->date_from->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->date_from->formatPattern()) ?>"<?= $Page->date_from->editAttributes() ?> aria-describedby="x_date_from_help">
<?= $Page->date_from->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->date_from->getErrorMessage() ?></div>
<?php if (!$Page->date_from->ReadOnly && !$Page->date_from->Disabled && !isset($Page->date_from->EditAttrs["readonly"]) && !isset($Page->date_from->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fstock_setupedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fstock_setupedit", "x_date_from", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->date_to->Visible) { // date_to ?>
    <div id="r_date_to"<?= $Page->date_to->rowAttributes() ?>>
        <label id="elh_stock_setup_date_to" for="x_date_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->date_to->caption() ?><?= $Page->date_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->date_to->cellAttributes() ?>>
<span id="el_stock_setup_date_to">
<input type="<?= $Page->date_to->getInputTextType() ?>" name="x_date_to" id="x_date_to" data-table="stock_setup" data-field="x_date_to" value="<?= $Page->date_to->EditValue ?>" placeholder="<?= HtmlEncode($Page->date_to->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->date_to->formatPattern()) ?>"<?= $Page->date_to->editAttributes() ?> aria-describedby="x_date_to_help">
<?= $Page->date_to->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->date_to->getErrorMessage() ?></div>
<?php if (!$Page->date_to->ReadOnly && !$Page->date_to->Disabled && !isset($Page->date_to->EditAttrs["readonly"]) && !isset($Page->date_to->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fstock_setupedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fstock_setupedit", "x_date_to", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->stock_complete_lot_id->Visible) { // stock_complete_lot_id ?>
    <div id="r_stock_complete_lot_id"<?= $Page->stock_complete_lot_id->rowAttributes() ?>>
        <label id="elh_stock_setup_stock_complete_lot_id" for="x_stock_complete_lot_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->stock_complete_lot_id->caption() ?><?= $Page->stock_complete_lot_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->stock_complete_lot_id->cellAttributes() ?>>
<span id="el_stock_setup_stock_complete_lot_id">
<input type="<?= $Page->stock_complete_lot_id->getInputTextType() ?>" name="x_stock_complete_lot_id" id="x_stock_complete_lot_id" data-table="stock_setup" data-field="x_stock_complete_lot_id" value="<?= $Page->stock_complete_lot_id->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->stock_complete_lot_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->stock_complete_lot_id->formatPattern()) ?>"<?= $Page->stock_complete_lot_id->editAttributes() ?> aria-describedby="x_stock_complete_lot_id_help">
<?= $Page->stock_complete_lot_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->stock_complete_lot_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fstock_setupedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fstock_setupedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("stock_setup");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
