<?php

namespace PHPMaker2024\fibre;

// Page object
$StockProcessingOutsideSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { stock_processing_outside: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fstock_processing_outsidesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fstock_processing_outsidesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["product_n", [], fields.product_n.isInvalid],
            ["rid", [ew.Validators.integer], fields.rid.isInvalid],
            ["code", [], fields.code.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["process_type", [], fields.process_type.isInvalid],
            ["tmp_lot", [], fields.tmp_lot.isInvalid],
            ["packets", [ew.Validators.float], fields.packets.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["godown", [], fields.godown.isInvalid],
            ["godown_n", [], fields.godown_n.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["y_dated", [ew.Validators.between], false],
            ["IN", [ew.Validators.float], fields.IN.isInvalid],
            ["OUT", [ew.Validators.float], fields.OUT.isInvalid],
            ["Balance", [ew.Validators.float], fields.Balance.isInvalid],
            ["Item", [], fields.Item.isInvalid],
            ["new_process", [], fields.new_process.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["type", [], fields.type.isInvalid],
            ["company_id", [ew.Validators.float], fields.company_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "product": <?= $Page->product->toClientList($Page) ?>,
            "process_type": <?= $Page->process_type->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "godown_n": <?= $Page->godown_n->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fstock_processing_outsidesearch" id="fstock_processing_outsidesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="stock_processing_outside">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="stock_processing_outside" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fstock_processing_outsidesearch_x_product"
        <?php } ?>
        data-table="stock_processing_outside"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_processing_outsidesearch", function() {
    var options = { name: "x_product", selectId: "fstock_processing_outsidesearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_processing_outsidesearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fstock_processing_outsidesearch" };
    } else {
        options.ajax = { id: "x_product", form: "fstock_processing_outsidesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_processing_outside.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_n->Visible) { // product_n ?>
    <div id="r_product_n" class="row"<?= $Page->product_n->rowAttributes() ?>>
        <label for="x_product_n" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_product_n"><?= $Page->product_n->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_n" id="z_product_n" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_n->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_product_n" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_n->getInputTextType() ?>" name="x_product_n" id="x_product_n" data-table="stock_processing_outside" data-field="x_product_n" value="<?= $Page->product_n->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->product_n->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_n->formatPattern()) ?>"<?= $Page->product_n->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_n->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label for="x_rid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_rid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rid->getInputTextType() ?>" name="x_rid" id="x_rid" data-table="stock_processing_outside" data-field="x_rid" value="<?= $Page->rid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label for="x_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_code"><?= $Page->code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_code" id="z_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="stock_processing_outside" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="stock_processing_outside" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="309" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_lot_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="stock_processing_outside" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_type->Visible) { // process_type ?>
    <div id="r_process_type" class="row"<?= $Page->process_type->rowAttributes() ?>>
        <label for="x_process_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_process_type"><?= $Page->process_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process_type" id="z_process_type" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_process_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_process_type"
        name="x_process_type"
        class="form-select ew-select<?= $Page->process_type->isInvalidClass() ?>"
        <?php if (!$Page->process_type->IsNativeSelect) { ?>
        data-select2-id="fstock_processing_outsidesearch_x_process_type"
        <?php } ?>
        data-table="stock_processing_outside"
        data-field="x_process_type"
        data-value-separator="<?= $Page->process_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_type->getPlaceHolder()) ?>"
        <?= $Page->process_type->editAttributes() ?>>
        <?= $Page->process_type->selectOptionListHtml("x_process_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_type->getErrorMessage(false) ?></div>
<?= $Page->process_type->Lookup->getParamTag($Page, "p_x_process_type") ?>
<?php if (!$Page->process_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_processing_outsidesearch", function() {
    var options = { name: "x_process_type", selectId: "fstock_processing_outsidesearch_x_process_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_processing_outsidesearch.lists.process_type?.lookupOptions.length) {
        options.data = { id: "x_process_type", form: "fstock_processing_outsidesearch" };
    } else {
        options.ajax = { id: "x_process_type", form: "fstock_processing_outsidesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_processing_outside.fields.process_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tmp_lot->Visible) { // tmp_lot ?>
    <div id="r_tmp_lot" class="row"<?= $Page->tmp_lot->rowAttributes() ?>>
        <label for="x_tmp_lot" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_tmp_lot"><?= $Page->tmp_lot->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tmp_lot->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_tmp_lot" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tmp_lot->getInputTextType() ?>" name="x_tmp_lot" id="x_tmp_lot" data-table="stock_processing_outside" data-field="x_tmp_lot" value="<?= $Page->tmp_lot->EditValue ?>" size="30" maxlength="44" placeholder="<?= HtmlEncode($Page->tmp_lot->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tmp_lot->formatPattern()) ?>"<?= $Page->tmp_lot->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tmp_lot->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_packets"><?= $Page->packets->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packets" id="z_packets" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="stock_processing_outside" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fstock_processing_outsidesearch_x_packing_type"
        <?php } ?>
        data-table="stock_processing_outside"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_processing_outsidesearch", function() {
    var options = { name: "x_packing_type", selectId: "fstock_processing_outsidesearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_processing_outsidesearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fstock_processing_outsidesearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fstock_processing_outsidesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_processing_outside.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label for="x_godown" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_godown" class="ew-search-field ew-search-field-single">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fstock_processing_outsidesearch_x_godown"
        <?php } ?>
        data-table="stock_processing_outside"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_processing_outsidesearch", function() {
    var options = { name: "x_godown", selectId: "fstock_processing_outsidesearch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_processing_outsidesearch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fstock_processing_outsidesearch" };
    } else {
        options.ajax = { id: "x_godown", form: "fstock_processing_outsidesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_processing_outside.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown_n->Visible) { // godown_n ?>
    <div id="r_godown_n" class="row"<?= $Page->godown_n->rowAttributes() ?>>
        <label for="x_godown_n" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_godown_n"><?= $Page->godown_n->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown_n" id="z_godown_n" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown_n->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_godown_n" class="ew-search-field ew-search-field-single">
    <select
        id="x_godown_n"
        name="x_godown_n"
        class="form-select ew-select<?= $Page->godown_n->isInvalidClass() ?>"
        <?php if (!$Page->godown_n->IsNativeSelect) { ?>
        data-select2-id="fstock_processing_outsidesearch_x_godown_n"
        <?php } ?>
        data-table="stock_processing_outside"
        data-field="x_godown_n"
        data-value-separator="<?= $Page->godown_n->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown_n->getPlaceHolder()) ?>"
        <?= $Page->godown_n->editAttributes() ?>>
        <?= $Page->godown_n->selectOptionListHtml("x_godown_n") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown_n->getErrorMessage(false) ?></div>
<?= $Page->godown_n->Lookup->getParamTag($Page, "p_x_godown_n") ?>
<?php if (!$Page->godown_n->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_processing_outsidesearch", function() {
    var options = { name: "x_godown_n", selectId: "fstock_processing_outsidesearch_x_godown_n" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_processing_outsidesearch.lists.godown_n?.lookupOptions.length) {
        options.data = { id: "x_godown_n", form: "fstock_processing_outsidesearch" };
    } else {
        options.ajax = { id: "x_godown_n", form: "fstock_processing_outsidesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_processing_outside.fields.godown_n.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_dated"><?= $Page->dated->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_dated" id="z_dated" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->dated->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->dated->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_stock_processing_outside_dated" class="ew-search-field">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="stock_processing_outside" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fstock_processing_outsidesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fstock_processing_outsidesearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_stock_processing_outside_dated" class="ew-search-field2 d-none">
<input type="<?= $Page->dated->getInputTextType() ?>" name="y_dated" id="y_dated" data-table="stock_processing_outside" data-field="x_dated" value="<?= $Page->dated->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fstock_processing_outsidesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fstock_processing_outsidesearch", "y_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->IN->Visible) { // IN ?>
    <div id="r_IN" class="row"<?= $Page->IN->rowAttributes() ?>>
        <label for="x_IN" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_IN"><?= $Page->IN->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_IN" id="z_IN" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->IN->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_IN" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->IN->getInputTextType() ?>" name="x_IN" id="x_IN" data-table="stock_processing_outside" data-field="x_IN" value="<?= $Page->IN->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->IN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->IN->formatPattern()) ?>"<?= $Page->IN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->IN->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->OUT->Visible) { // OUT ?>
    <div id="r_OUT" class="row"<?= $Page->OUT->rowAttributes() ?>>
        <label for="x_OUT" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_OUT"><?= $Page->OUT->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_OUT" id="z_OUT" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->OUT->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_OUT" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->OUT->getInputTextType() ?>" name="x_OUT" id="x_OUT" data-table="stock_processing_outside" data-field="x_OUT" value="<?= $Page->OUT->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->OUT->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->OUT->formatPattern()) ?>"<?= $Page->OUT->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->OUT->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
    <div id="r_Balance" class="row"<?= $Page->Balance->rowAttributes() ?>>
        <label for="x_Balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_Balance"><?= $Page->Balance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Balance" id="z_Balance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_Balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Balance->getInputTextType() ?>" name="x_Balance" id="x_Balance" data-table="stock_processing_outside" data-field="x_Balance" value="<?= $Page->Balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Balance->formatPattern()) ?>"<?= $Page->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Item->Visible) { // Item ?>
    <div id="r_Item" class="row"<?= $Page->Item->rowAttributes() ?>>
        <label for="x_Item" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_Item"><?= $Page->Item->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Item" id="z_Item" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Item->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_Item" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Item->getInputTextType() ?>" name="x_Item" id="x_Item" data-table="stock_processing_outside" data-field="x_Item" value="<?= $Page->Item->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->Item->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Item->formatPattern()) ?>"<?= $Page->Item->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Item->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->new_process->Visible) { // new_process ?>
    <div id="r_new_process" class="row"<?= $Page->new_process->rowAttributes() ?>>
        <label for="x_new_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_new_process"><?= $Page->new_process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_new_process" id="z_new_process" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->new_process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_new_process" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->new_process->getInputTextType() ?>" name="x_new_process" id="x_new_process" data-table="stock_processing_outside" data-field="x_new_process" value="<?= $Page->new_process->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->new_process->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->new_process->formatPattern()) ?>"<?= $Page->new_process->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->new_process->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="stock_processing_outside" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="35" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type" class="row"<?= $Page->type->rowAttributes() ?>>
        <label for="x_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_type"><?= $Page->type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_type" id="z_type" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->type->getInputTextType() ?>" name="x_type" id="x_type" data-table="stock_processing_outside" data-field="x_type" value="<?= $Page->type->EditValue ?>" size="30" maxlength="22" placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->type->formatPattern()) ?>"<?= $Page->type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_outside_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_outside_company_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->company_id->getInputTextType() ?>" name="x_company_id" id="x_company_id" data-table="stock_processing_outside" data-field="x_company_id" value="<?= $Page->company_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->company_id->formatPattern()) ?>"<?= $Page->company_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fstock_processing_outsidesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fstock_processing_outsidesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fstock_processing_outsidesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("stock_processing_outside");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
