<?php

namespace PHPMaker2024\fibre;

// Page object
$StockProcessingJobSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { stock_processing_job: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fstock_processing_jobsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fstock_processing_jobsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["tmp_lot", [ew.Validators.float], fields.tmp_lot.isInvalid],
            ["gcode", [], fields.gcode.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["IN", [ew.Validators.float], fields.IN.isInvalid],
            ["OUT", [ew.Validators.float], fields.OUT.isInvalid],
            ["Balance", [ew.Validators.float], fields.Balance.isInvalid],
            ["Item", [], fields.Item.isInvalid],
            ["new_process", [], fields.new_process.isInvalid],
            ["avg_yield", [ew.Validators.integer], fields.avg_yield.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["url", [], fields.url.isInvalid],
            ["age", [ew.Validators.integer], fields.age.isInvalid],
            ["type", [], fields.type.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "product": <?= $Page->product->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "Item": <?= $Page->Item->toClientList($Page) ?>,
            "new_process": <?= $Page->new_process->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fstock_processing_jobsearch" id="fstock_processing_jobsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="stock_processing_job">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="stock_processing_job" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fstock_processing_jobsearch_x_product"
        <?php } ?>
        data-table="stock_processing_job"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_processing_jobsearch", function() {
    var options = { name: "x_product", selectId: "fstock_processing_jobsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_processing_jobsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fstock_processing_jobsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fstock_processing_jobsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_processing_job.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="stock_processing_job" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="308" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_lot_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="stock_processing_job" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fstock_processing_jobsearch_x_packing_type"
        <?php } ?>
        data-table="stock_processing_job"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_processing_jobsearch", function() {
    var options = { name: "x_packing_type", selectId: "fstock_processing_jobsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_processing_jobsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fstock_processing_jobsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fstock_processing_jobsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_processing_job.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tmp_lot->Visible) { // tmp_lot ?>
    <div id="r_tmp_lot" class="row"<?= $Page->tmp_lot->rowAttributes() ?>>
        <label for="x_tmp_lot" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_tmp_lot"><?= $Page->tmp_lot->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tmp_lot->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_tmp_lot" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tmp_lot->getInputTextType() ?>" name="x_tmp_lot" id="x_tmp_lot" data-table="stock_processing_job" data-field="x_tmp_lot" value="<?= $Page->tmp_lot->EditValue ?>" size="30" maxlength="44" placeholder="<?= HtmlEncode($Page->tmp_lot->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tmp_lot->formatPattern()) ?>"<?= $Page->tmp_lot->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tmp_lot->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gcode->Visible) { // gcode ?>
    <div id="r_gcode" class="row"<?= $Page->gcode->rowAttributes() ?>>
        <label for="x_gcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_gcode"><?= $Page->gcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_gcode" id="z_gcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_gcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gcode->getInputTextType() ?>" name="x_gcode" id="x_gcode" data-table="stock_processing_job" data-field="x_gcode" value="<?= $Page->gcode->EditValue ?>" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->gcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gcode->formatPattern()) ?>"<?= $Page->gcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_dated"><?= $Page->dated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dated" id="z_dated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_dated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="stock_processing_job" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fstock_processing_jobsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fstock_processing_jobsearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->IN->Visible) { // IN ?>
    <div id="r_IN" class="row"<?= $Page->IN->rowAttributes() ?>>
        <label for="x_IN" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_IN"><?= $Page->IN->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_IN" id="z_IN" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->IN->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_IN" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->IN->getInputTextType() ?>" name="x_IN" id="x_IN" data-table="stock_processing_job" data-field="x_IN" value="<?= $Page->IN->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->IN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->IN->formatPattern()) ?>"<?= $Page->IN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->IN->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->OUT->Visible) { // OUT ?>
    <div id="r_OUT" class="row"<?= $Page->OUT->rowAttributes() ?>>
        <label for="x_OUT" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_OUT"><?= $Page->OUT->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_OUT" id="z_OUT" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->OUT->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_OUT" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->OUT->getInputTextType() ?>" name="x_OUT" id="x_OUT" data-table="stock_processing_job" data-field="x_OUT" value="<?= $Page->OUT->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->OUT->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->OUT->formatPattern()) ?>"<?= $Page->OUT->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->OUT->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
    <div id="r_Balance" class="row"<?= $Page->Balance->rowAttributes() ?>>
        <label for="x_Balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_Balance"><?= $Page->Balance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Balance" id="z_Balance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_Balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Balance->getInputTextType() ?>" name="x_Balance" id="x_Balance" data-table="stock_processing_job" data-field="x_Balance" value="<?= $Page->Balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Balance->formatPattern()) ?>"<?= $Page->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Item->Visible) { // Item ?>
    <div id="r_Item" class="row"<?= $Page->Item->rowAttributes() ?>>
        <label for="x_Item" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_Item"><?= $Page->Item->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Item" id="z_Item" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Item->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_Item" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Item->getInputTextType() ?>" name="x_Item" id="x_Item" data-table="stock_processing_job" data-field="x_Item" value="<?= $Page->Item->EditValue ?>" placeholder="<?= HtmlEncode($Page->Item->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Item->formatPattern()) ?>"<?= $Page->Item->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Item->getErrorMessage(false) ?></div>
<?= $Page->Item->Lookup->getParamTag($Page, "p_x_Item") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->new_process->Visible) { // new_process ?>
    <div id="r_new_process" class="row"<?= $Page->new_process->rowAttributes() ?>>
        <label for="x_new_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_new_process"><?= $Page->new_process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_new_process" id="z_new_process" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->new_process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_new_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_new_process[]"
        name="x_new_process[]"
        class="form-select ew-select<?= $Page->new_process->isInvalidClass() ?>"
        <?php if (!$Page->new_process->IsNativeSelect) { ?>
        data-select2-id="fstock_processing_jobsearch_x_new_process[]"
        <?php } ?>
        data-table="stock_processing_job"
        data-field="x_new_process"
        multiple
        size="1"
        data-value-separator="<?= $Page->new_process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->new_process->getPlaceHolder()) ?>"
        <?= $Page->new_process->editAttributes() ?>>
        <?= $Page->new_process->selectOptionListHtml("x_new_process[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->new_process->getErrorMessage(false) ?></div>
<?= $Page->new_process->Lookup->getParamTag($Page, "p_x_new_process") ?>
<?php if (!$Page->new_process->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_processing_jobsearch", function() {
    var options = { name: "x_new_process[]", selectId: "fstock_processing_jobsearch_x_new_process[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_processing_jobsearch.lists.new_process?.lookupOptions.length) {
        options.data = { id: "x_new_process[]", form: "fstock_processing_jobsearch" };
    } else {
        options.ajax = { id: "x_new_process[]", form: "fstock_processing_jobsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_processing_job.fields.new_process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->avg_yield->Visible) { // avg_yield ?>
    <div id="r_avg_yield" class="row"<?= $Page->avg_yield->rowAttributes() ?>>
        <label for="x_avg_yield" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_avg_yield"><?= $Page->avg_yield->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_avg_yield" id="z_avg_yield" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->avg_yield->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_avg_yield" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->avg_yield->getInputTextType() ?>" name="x_avg_yield" id="x_avg_yield" data-table="stock_processing_job" data-field="x_avg_yield" value="<?= $Page->avg_yield->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->avg_yield->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->avg_yield->formatPattern()) ?>"<?= $Page->avg_yield->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->avg_yield->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="stock_processing_job" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fstock_processing_jobsearch_x_status"
        <?php } ?>
        data-table="stock_processing_job"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_processing_jobsearch", function() {
    var options = { name: "x_status", selectId: "fstock_processing_jobsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_processing_jobsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fstock_processing_jobsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fstock_processing_jobsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_processing_job.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <div id="r_url" class="row"<?= $Page->url->rowAttributes() ?>>
        <label for="x_url" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_url"><?= $Page->url->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_url" id="z_url" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->url->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_url" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->url->getInputTextType() ?>" name="x_url" id="x_url" data-table="stock_processing_job" data-field="x_url" value="<?= $Page->url->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url->formatPattern()) ?>"<?= $Page->url->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->url->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->age->Visible) { // age ?>
    <div id="r_age" class="row"<?= $Page->age->rowAttributes() ?>>
        <label for="x_age" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_age"><?= $Page->age->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_age" id="z_age" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->age->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_age" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->age->getInputTextType() ?>" name="x_age" id="x_age" data-table="stock_processing_job" data-field="x_age" value="<?= $Page->age->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->age->formatPattern()) ?>"<?= $Page->age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->age->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type" class="row"<?= $Page->type->rowAttributes() ?>>
        <label for="x_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_processing_job_type"><?= $Page->type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_type" id="z_type" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_processing_job_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->type->getInputTextType() ?>" name="x_type" id="x_type" data-table="stock_processing_job" data-field="x_type" value="<?= $Page->type->EditValue ?>" size="30" maxlength="22" placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->type->formatPattern()) ?>"<?= $Page->type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fstock_processing_jobsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fstock_processing_jobsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fstock_processing_jobsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("stock_processing_job");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
