<?php

namespace PHPMaker2024\fibre;

// Page object
$StockPreview = &$Page;
?>
<script>
ew.deepAssign(ew.vars, { tables: { stock: <?= JsonEncode($Page->toClientVar()) ?> } });
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php if ($Page->TotalRecords > 0) { ?>
<div class="card ew-grid <?= $Page->TableGridClass ?>"><!-- .card -->
<div class="card-header ew-grid-upper-panel ew-preview-upper-panel"><!-- .card-header -->
<?= $Page->Pager->render() ?>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card-header -->
<div class="card-body ew-preview-middle-panel ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>"><!-- .card-body -->
<table class="<?= $Page->TableClass ?>"><!-- .table -->
    <thead><!-- Table header -->
        <tr class="ew-table-header">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->product->Visible) { // product ?>
    <?php if (!$Page->product->Sortable || !$Page->sortUrl($Page->product)) { ?>
        <th class="<?= $Page->product->headerCellClass() ?>"><?= $Page->product->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->product->headerCellClass() ?>"><div role="button" data-table="stock" data-sort="<?= HtmlEncode($Page->product->Name) ?>" data-sort-type="2" data-sort-order="<?= $Page->product->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->product->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->product->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <?php if (!$Page->product_code->Sortable || !$Page->sortUrl($Page->product_code)) { ?>
        <th class="<?= $Page->product_code->headerCellClass() ?>"><?= $Page->product_code->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->product_code->headerCellClass() ?>"><div role="button" data-table="stock" data-sort="<?= HtmlEncode($Page->product_code->Name) ?>" data-sort-type="2" data-sort-order="<?= $Page->product_code->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->product_code->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->product_code->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <?php if (!$Page->packing_type->Sortable || !$Page->sortUrl($Page->packing_type)) { ?>
        <th class="<?= $Page->packing_type->headerCellClass() ?>"><?= $Page->packing_type->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->packing_type->headerCellClass() ?>"><div role="button" data-table="stock" data-sort="<?= HtmlEncode($Page->packing_type->Name) ?>" data-sort-type="2" data-sort-order="<?= $Page->packing_type->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->packing_type->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->packing_type->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
    <?php if (!$Page->Balance->Sortable || !$Page->sortUrl($Page->Balance)) { ?>
        <th class="<?= $Page->Balance->headerCellClass() ?>"><?= $Page->Balance->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->Balance->headerCellClass() ?>"><div role="button" data-table="stock" data-sort="<?= HtmlEncode($Page->Balance->Name) ?>" data-sort-type="2" data-sort-order="<?= $Page->Balance->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->Balance->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->Balance->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->hold->Visible) { // hold ?>
    <?php if (!$Page->hold->Sortable || !$Page->sortUrl($Page->hold)) { ?>
        <th class="<?= $Page->hold->headerCellClass() ?>"><?= $Page->hold->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->hold->headerCellClass() ?>"><div role="button" data-table="stock" data-sort="<?= HtmlEncode($Page->hold->Name) ?>" data-sort-type="2" data-sort-order="<?= $Page->hold->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->hold->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->hold->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <?php if (!$Page->packets->Sortable || !$Page->sortUrl($Page->packets)) { ?>
        <th class="<?= $Page->packets->headerCellClass() ?>"><?= $Page->packets->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->packets->headerCellClass() ?>"><div role="button" data-table="stock" data-sort="<?= HtmlEncode($Page->packets->Name) ?>" data-sort-type="2" data-sort-order="<?= $Page->packets->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->packets->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->packets->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->avg_quantity->Visible) { // avg_quantity ?>
    <?php if (!$Page->avg_quantity->Sortable || !$Page->sortUrl($Page->avg_quantity)) { ?>
        <th class="<?= $Page->avg_quantity->headerCellClass() ?>"><?= $Page->avg_quantity->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->avg_quantity->headerCellClass() ?>"><div role="button" data-table="stock" data-sort="<?= HtmlEncode($Page->avg_quantity->Name) ?>" data-sort-type="2" data-sort-order="<?= $Page->avg_quantity->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->avg_quantity->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->avg_quantity->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
        </tr>
    </thead>
    <tbody><!-- Table body -->
<?php
$Page->RecordCount = 0;
$Page->RowCount = 0;
while ($Page->fetch()) {
    // Init row class and style
    $Page->RecordCount++;
    $Page->RowCount++;
    $Page->CssStyle = "";
    $Page->loadListRowValues($Page->CurrentRow);
    $Page->aggregateListRowValues(); // Aggregate row values

    // Render row
    $Page->RowType = RowType::PREVIEW; // Preview record
    $Page->resetAttributes();
    $Page->renderListRow();

    // Set up row attributes
    $Page->RowAttrs->merge([
        "data-rowindex" => $Page->RowCount,
        "class" => ($Page->RowCount % 2 != 1) ? "ew-table-alt-row" : "",

        // Add row attributes for expandable row
        "data-widget" => "expandable-table",
        "aria-expanded" => "false",
    ]);

    // Render list options
    $Page->renderListOptions();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
<?php if ($Page->product->Visible) { // product ?>
        <!-- product -->
        <td<?= $Page->product->cellAttributes() ?>>
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
        <!-- product_code -->
        <td<?= $Page->product_code->cellAttributes() ?>>
<span<?= $Page->product_code->viewAttributes() ?>>
<?php if (!EmptyString($Page->product_code->getViewValue()) && $Page->product_code->linkAttributes() != "") { ?>
<a<?= $Page->product_code->linkAttributes() ?>><?= $Page->product_code->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product_code->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <!-- packing_type -->
        <td<?= $Page->packing_type->cellAttributes() ?>>
<span<?= $Page->packing_type->viewAttributes() ?>>
<?= $Page->packing_type->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
        <!-- Balance -->
        <td<?= $Page->Balance->cellAttributes() ?>>
<span<?= $Page->Balance->viewAttributes() ?>>
<?= $Page->Balance->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->hold->Visible) { // hold ?>
        <!-- hold -->
        <td<?= $Page->hold->cellAttributes() ?>>
<span<?= $Page->hold->viewAttributes() ?>>
<?= $Page->hold->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
        <!-- packets -->
        <td<?= $Page->packets->cellAttributes() ?>>
<span<?= $Page->packets->viewAttributes() ?>>
<?= $Page->packets->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->avg_quantity->Visible) { // avg_quantity ?>
        <!-- avg_quantity -->
        <td<?= $Page->avg_quantity->cellAttributes() ?>>
<span<?= $Page->avg_quantity->viewAttributes() ?>>
<?= $Page->avg_quantity->getViewValue() ?></span>
</td>
<?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
} // while
?>
    </tbody>
<?php
    // Render aggregate row
    $Page->RowType = RowType::AGGREGATE; // Aggregate
    $Page->aggregateListRow(); // Prepare aggregate row

    // Render list options
    $Page->renderListOptions();
?>
    <tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
<?php if ($Page->product->Visible) { // product ?>
        <!-- product -->
        <td class="<?= $Page->product->footerCellClass() ?>">
        &nbsp;
        </td>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
        <!-- product_code -->
        <td class="<?= $Page->product_code->footerCellClass() ?>">
        &nbsp;
        </td>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <!-- packing_type -->
        <td class="<?= $Page->packing_type->footerCellClass() ?>">
        &nbsp;
        </td>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
        <!-- Balance -->
        <td class="<?= $Page->Balance->footerCellClass() ?>">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->Balance->ViewValue ?></span>
        </td>
<?php } ?>
<?php if ($Page->hold->Visible) { // hold ?>
        <!-- hold -->
        <td class="<?= $Page->hold->footerCellClass() ?>">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->hold->ViewValue ?></span>
        </td>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
        <!-- packets -->
        <td class="<?= $Page->packets->footerCellClass() ?>">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->packets->ViewValue ?></span>
        </td>
<?php } ?>
<?php if ($Page->avg_quantity->Visible) { // avg_quantity ?>
        <!-- avg_quantity -->
        <td class="<?= $Page->avg_quantity->footerCellClass() ?>">
        &nbsp;
        </td>
<?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
    </tfoot>
</table><!-- /.table -->
</div><!-- /.card-body -->
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?= $Page->Pager->render() ?>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php } else { // No record ?>
<div class="card border-0"><!-- .card -->
<div class="ew-detail-count"><?= $Language->phrase("NoRecord") ?></div>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card -->
<?php } ?>
<?php
foreach ($Page->DetailCounts as $detailTblVar => $detailCount) {
?>
<div class="ew-detail-count d-none" data-table="<?= $detailTblVar ?>" data-count="<?= $detailCount ?>"><?= FormatInteger($detailCount) ?></div>
<?php
}
?>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php
$Page->Recordset?->free();
?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
